/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;

public abstract class ChangesTreeImpl<T>
extends ChangesTree {
    @NotNull
    private final List<T> myChanges = new ArrayList<T>();
    @NotNull
    private final Class<T> myClazz;

    public ChangesTreeImpl(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems, @NotNull Class<T> clazz) {
        super(project, showCheckboxes, highlightProblems);
        this.myClazz = clazz;
    }

    public ChangesTreeImpl(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems, @NotNull Class<T> clazz, @NotNull List<? extends T> changes2) {
        this(project, showCheckboxes, highlightProblems, clazz);
        if (showCheckboxes) {
            this.setIncludedChanges(changes2);
        }
        this.setChangesToDisplay(changes2);
    }

    public void setChangesToDisplay(@NotNull Collection<? extends T> changes2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            return;
        }
        this.myChanges.clear();
        this.myChanges.addAll(changes2);
        this.rebuildTree();
    }

    @NotNull
    protected abstract DefaultTreeModel buildTreeModel(@NotNull List<? extends T> var1);

    @Override
    public void rebuildTree() {
        DefaultTreeModel newModel = this.buildTreeModel(this.myChanges);
        this.updateTreeModel(newModel);
    }

    @NotNull
    public List<T> getChanges() {
        return VcsTreeModelData.all((JTree)((Object)this)).userObjects(this.myClazz);
    }

    @NotNull
    public List<T> getSelectedChanges() {
        return VcsTreeModelData.selected((JTree)((Object)this)).userObjects(this.myClazz);
    }

    @NotNull
    public Collection<T> getIncludedChanges() {
        return VcsTreeModelData.included(this).userObjects(this.myClazz);
    }

    public static class VirtualFiles
    extends ChangesTreeImpl<VirtualFile> {
        public VirtualFiles(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems) {
            super(project, showCheckboxes, highlightProblems, VirtualFile.class);
        }

        public VirtualFiles(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems, @NotNull List<? extends VirtualFile> files2) {
            super(project, showCheckboxes, highlightProblems, VirtualFile.class, files2);
        }

        @Override
        @NotNull
        protected DefaultTreeModel buildTreeModel(@NotNull List<? extends VirtualFile> changes2) {
            return TreeModelBuilder.buildFromVirtualFiles(this.myProject, this.getGrouping(), changes2);
        }
    }

    public static class FilePaths
    extends ChangesTreeImpl<FilePath> {
        public FilePaths(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems) {
            super(project, showCheckboxes, highlightProblems, FilePath.class);
        }

        public FilePaths(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems, @NotNull List<? extends FilePath> paths) {
            super(project, showCheckboxes, highlightProblems, FilePath.class, paths);
        }

        @Override
        @NotNull
        protected DefaultTreeModel buildTreeModel(@NotNull List<? extends FilePath> changes2) {
            return TreeModelBuilder.buildFromFilePaths(this.myProject, this.getGrouping(), changes2);
        }
    }

    public static class Changes
    extends ChangesTreeImpl<Change> {
        public Changes(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems) {
            super(project, showCheckboxes, highlightProblems, Change.class);
        }

        public Changes(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems, @NotNull List<? extends Change> changes2) {
            super(project, showCheckboxes, highlightProblems, Change.class, changes2);
        }

        @Override
        @NotNull
        protected DefaultTreeModel buildTreeModel(@NotNull List<? extends Change> changes2) {
            return TreeModelBuilder.buildFromChanges(this.myProject, this.getGrouping(), changes2, null);
        }
    }
}

