/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangesTreeList<T>
extends ChangesTree {
    @NotNull
    private final List<T> myRawChanges = new ArrayList<T>();
    @Nullable
    private ChangeNodeDecorator myChangeDecorator;

    public ChangesTreeList(@NotNull Project project, @NotNull Collection<T> initiallyIncluded, boolean showCheckboxes, boolean highlightProblems, @Nullable Runnable inclusionListener, @Nullable ChangeNodeDecorator decorator) {
        super(project, showCheckboxes, highlightProblems);
        this.setIncludedChanges(initiallyIncluded);
        this.setInclusionListener(inclusionListener);
        this.myChangeDecorator = decorator;
    }

    public ChangesTreeList(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems) {
        super(project, showCheckboxes, highlightProblems);
    }

    public void setChangeDecorator(@Nullable ChangeNodeDecorator changeDecorator) {
        this.myChangeDecorator = changeDecorator;
        this.rebuildTree();
    }

    @Deprecated
    public void setScrollPaneBorder(Border border) {
    }

    public void setChangesToDisplay(List<? extends T> changes2) {
        this.setChangesToDisplay(changes2, null);
    }

    public void setChangesToDisplay(List<? extends T> changes2, @Nullable VirtualFile toSelect2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            return;
        }
        this.myRawChanges.clear();
        this.myRawChanges.addAll(changes2);
        this.rebuildTree();
        if (toSelect2 != null) {
            this.selectFile(toSelect2);
        }
    }

    protected abstract DefaultTreeModel buildTreeModel(List<T> var1, ChangeNodeDecorator var2);

    @Override
    public void rebuildTree() {
        DefaultTreeModel newModel = this.buildTreeModel(this.myRawChanges, this.myChangeDecorator);
        this.updateTreeModel(newModel);
    }

    @NotNull
    public List<T> getChanges() {
        return this.getSelectedObjects(this.getRoot());
    }

    @NotNull
    public List<T> getSelectedChanges() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return Collections.emptyList();
        }
        LinkedHashSet changes2 = ContainerUtil.newLinkedHashSet();
        for (TreePath path : paths) {
            changes2.addAll(this.getSelectedObjects((ChangesBrowserNode)path.getLastPathComponent()));
        }
        return ContainerUtil.newArrayList((Iterable)changes2);
    }

    @NotNull
    private List<T> getSelectedChangesOrAllIfNone() {
        List<T> changes2 = this.getSelectedChanges();
        if (!changes2.isEmpty()) {
            return changes2;
        }
        return this.getChanges();
    }

    protected abstract List<T> getSelectedObjects(ChangesBrowserNode<?> var1);

    @Nullable
    protected abstract T getLeadSelectedObject(ChangesBrowserNode<?> var1);

    @Nullable
    public T getHighestLeadSelection() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        return this.getLeadSelectedObject((ChangesBrowserNode)path.getLastPathComponent());
    }

    @Nullable
    public T getLeadSelection() {
        TreePath path = this.getSelectionPath();
        return (T)(path == null ? null : ContainerUtil.getFirstItem(this.getSelectedObjects((ChangesBrowserNode)path.getLastPathComponent())));
    }

    @NotNull
    public Collection<T> getIncludedChanges() {
        Set<Object> includedSet = this.getIncludedSet();
        return ContainerUtil.filter(this.getChanges(), includedSet::contains);
    }

    public void select(@NotNull Collection<T> changes2) {
        this.setSelectedChanges(changes2);
    }

    public void setAlwaysExpandList(boolean alwaysExpandList) {
        this.setKeepTreeState(!alwaysExpandList);
    }
}

