/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.ide.HelpIdProvider;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.CommitExecutorBase;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.CommitSessionContextAware;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.RefreshablePanel;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffTool;
import com.intellij.openapi.vcs.changes.ui.ChangeInfoCalculator;
import com.intellij.openapi.vcs.changes.ui.CommitDialogChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.CommitLegendPanel;
import com.intellij.openapi.vcs.changes.ui.CommitMessageProvider;
import com.intellij.openapi.vcs.changes.ui.CommitOptionsPanel;
import com.intellij.openapi.vcs.changes.ui.DialogCommitWorkflow;
import com.intellij.openapi.vcs.changes.ui.EditChangelistSupport;
import com.intellij.openapi.vcs.changes.ui.SessionDialog;
import com.intellij.openapi.vcs.changes.ui.SingleChangeListCommitter;
import com.intellij.openapi.vcs.checkin.BaseCheckinHandlerFactory;
import com.intellij.openapi.vcs.checkin.BeforeCheckinDialogHandler;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinMetaHandler;
import com.intellij.openapi.vcs.impl.CheckinHandlersManager;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vcs.ui.Refreshable;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.SplitterWithSecondHideable;
import com.intellij.ui.components.JBBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitChangeListDialog
extends DialogWrapper
implements CheckinProjectPanel,
DataProvider {
    private static final Logger LOG = Logger.getInstance(CommitChangeListDialog.class);
    public static final String DIALOG_TITLE = VcsBundle.message((String)"commit.dialog.title", (Object[])new Object[0]);
    private static final String HELP_ID = "reference.dialogs.vcs.commit";
    private static final int LAYOUT_VERSION = 2;
    private static final String SPLITTER_PROPORTION_OPTION = "CommitChangeListDialog.SPLITTER_PROPORTION_2";
    private static final String DETAILS_SPLITTER_PROPORTION_OPTION = "CommitChangeListDialog.DETAILS_SPLITTER_PROPORTION_2";
    private static final String DETAILS_SHOW_OPTION = "CommitChangeListDialog.DETAILS_SHOW_OPTION_";
    private static final float SPLITTER_PROPORTION_OPTION_DEFAULT = 0.5f;
    private static final float DETAILS_SPLITTER_PROPORTION_OPTION_DEFAULT = 0.6f;
    private static final boolean DETAILS_SHOW_OPTION_DEFAULT = true;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsConfiguration myVcsConfiguration;
    private final boolean myShowVcsCommit;
    @NotNull
    private final DialogCommitWorkflow myWorkflow;
    @Nullable
    private final CommitResultHandler myResultHandler;
    @NotNull
    private final Set<? extends AbstractVcs<?>> myAffectedVcses;
    @NotNull
    private final List<? extends CommitExecutor> myExecutors;
    @NotNull
    private final List<CheckinHandler> myHandlers = ContainerUtil.newArrayList();
    @NotNull
    private final String myCommitActionName;
    @NotNull
    private final Map<String, String> myListComments = ContainerUtil.newHashMap();
    @NotNull
    private final List<CommitExecutorAction> myExecutorActions;
    @NotNull
    private final CommitOptionsPanel myCommitOptions;
    @NotNull
    private final ChangeInfoCalculator myChangesInfoCalculator;
    @NotNull
    private final CommitDialogChangesBrowser myBrowser;
    @NotNull
    private final JComponent myBrowserBottomPanel = JBBox.createHorizontalBox();
    @NotNull
    private final MyChangeProcessor myDiffDetails;
    @NotNull
    private final CommitMessage myCommitMessageArea;
    @NotNull
    private final CommitLegendPanel myLegend;
    @NotNull
    private final Splitter mySplitter;
    @NotNull
    private final SplitterWithSecondHideable myDetailsSplitter;
    @NotNull
    private final JBLabel myWarningLabel;
    @Nullable
    private final String myHelpId;
    @Nullable
    private final CommitAction myCommitAction;
    @NotNull
    private final Alarm myOKButtonUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    @NotNull
    private final Runnable myUpdateButtonsRunnable = () -> {
        this.updateButtons();
        this.updateLegend();
    };
    private boolean myDisposed = false;
    private boolean myUpdateDisabled = false;
    private String myLastKnownComment = "";
    private String myLastSelectedListName;

    public static boolean commitChanges(@NotNull Project project, @NotNull Collection<? extends Change> changes2, @Nullable LocalChangeList initialSelection, @Nullable CommitExecutor executor, @Nullable String comment) {
        return CommitChangeListDialog.commitChanges(project, changes2, changes2, initialSelection, executor, comment);
    }

    public static boolean commitChanges(@NotNull Project project, @NotNull Collection<? extends Change> changes2, @NotNull Collection<?> included, @Nullable LocalChangeList initialSelection, @Nullable CommitExecutor executor, @Nullable String comment) {
        if (executor == null) {
            return CommitChangeListDialog.commitChanges(project, ContainerUtil.newArrayList(changes2), included, initialSelection, CommitChangeListDialog.collectExecutors(project, changes2), true, null, comment, null, true);
        }
        return CommitChangeListDialog.commitChanges(project, ContainerUtil.newArrayList(changes2), included, initialSelection, Collections.singletonList(executor), false, null, comment, null, true);
    }

    public static boolean commitChanges(@NotNull Project project, @NotNull Collection<? extends Change> changes2, @Nullable LocalChangeList initialSelection, @NotNull List<? extends CommitExecutor> executors, boolean showVcsCommit, @Nullable String comment, @Nullable CommitResultHandler customResultHandler) {
        return CommitChangeListDialog.commitChanges(project, ContainerUtil.newArrayList(changes2), initialSelection, executors, showVcsCommit, comment, customResultHandler, true);
    }

    public static boolean commitChanges(@NotNull Project project, @NotNull List<Change> changes2, @Nullable LocalChangeList initialSelection, @NotNull List<? extends CommitExecutor> executors, boolean showVcsCommit, @Nullable String comment, @Nullable CommitResultHandler customResultHandler, boolean cancelIfNoChanges) {
        return CommitChangeListDialog.commitChanges(project, changes2, changes2, initialSelection, executors, showVcsCommit, null, comment, customResultHandler, cancelIfNoChanges);
    }

    public static boolean commitChanges(@NotNull Project project, @NotNull List<Change> changes2, @NotNull Collection<?> included, @Nullable LocalChangeList initialSelection, @NotNull List<? extends CommitExecutor> executors, boolean showVcsCommit, @Nullable AbstractVcs forceCommitInVcs, @Nullable String comment, @Nullable CommitResultHandler customResultHandler, boolean cancelIfNoChanges) {
        ChangeListManager manager = ChangeListManager.getInstance((Project)project);
        LocalChangeList defaultList = manager.getDefaultChangeList();
        List changeLists = manager.getChangeListsCopy();
        HashSet<AbstractVcs> affectedVcses = new HashSet<AbstractVcs>();
        if (forceCommitInVcs != null) {
            affectedVcses.add(forceCommitInVcs);
        }
        for (LocalChangeList list2 : changeLists) {
            affectedVcses.addAll(ChangesUtil.getAffectedVcses((Collection)list2.getChanges(), (Project)project));
        }
        if (showVcsCommit) {
            List<VirtualFile> unversionedFiles = ChangeListManagerImpl.getInstanceImpl(project).getUnversionedFiles();
            affectedVcses.addAll(ChangesUtil.getAffectedVcsesForFiles(unversionedFiles, (Project)project));
        }
        if (cancelIfNoChanges && affectedVcses.isEmpty()) {
            Messages.showInfoMessage((Project)project, (String)VcsBundle.message((String)"commit.dialog.no.changes.detected.text", (Object[])new Object[0]), (String)VcsBundle.message((String)"commit.dialog.no.changes.detected.title", (Object[])new Object[0]));
            return false;
        }
        for (BaseCheckinHandlerFactory factory : CommitChangeListDialog.getCheckInFactories(project)) {
            BeforeCheckinDialogHandler handler2 = factory.createSystemReadyHandler(project);
            if (handler2 == null || handler2.beforeCommitDialogShown(project, changes2, executors, showVcsCommit)) continue;
            return false;
        }
        boolean isDefaultChangeListFullyIncluded = ContainerUtil.newHashSet(changes2).containsAll(defaultList.getChanges());
        DialogCommitWorkflow workflow = new DialogCommitWorkflow(project, included, initialSelection, executors, showVcsCommit, forceCommitInVcs, affectedVcses, isDefaultChangeListFullyIncluded, comment, customResultHandler);
        return workflow.showDialog();
    }

    @NotNull
    private static List<BaseCheckinHandlerFactory> getCheckInFactories(@NotNull Project project) {
        return CheckinHandlersManager.getInstance().getRegisteredCheckinHandlerFactories(ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss());
    }

    @NotNull
    public static List<CommitExecutor> collectExecutors(@NotNull Project project, @NotNull Collection<? extends Change> changes2) {
        ArrayList result2 = ContainerUtil.newArrayList();
        for (AbstractVcs vcs : ChangesUtil.getAffectedVcses(changes2, (Project)project)) {
            result2.addAll(vcs.getCommitExecutors());
        }
        result2.addAll(ChangeListManager.getInstance((Project)project).getRegisteredExecutors());
        return result2;
    }

    CommitChangeListDialog(@NotNull DialogCommitWorkflow workflow) {
        super(workflow.getProject(), true, Registry.is((String)"ide.perProjectModality") ? DialogWrapper.IdeModalityType.PROJECT : DialogWrapper.IdeModalityType.IDE);
        this.myWorkflow = workflow;
        this.myProject = this.myWorkflow.getProject();
        this.myVcsConfiguration = (VcsConfiguration)ObjectUtils.notNull((Object)VcsConfiguration.getInstance((Project)this.myProject));
        this.myShowVcsCommit = this.myWorkflow.isDefaultCommitEnabled();
        this.myAffectedVcses = this.myWorkflow.getAffectedVcses();
        this.myExecutors = this.myWorkflow.getExecutors();
        this.myResultHandler = this.myWorkflow.getResultHandler();
        if (!this.myShowVcsCommit && ContainerUtil.isEmpty(this.myExecutors)) {
            throw new IllegalArgumentException("nothing found to execute commit with");
        }
        this.myHandlers.addAll(CommitChangeListDialog.createCheckinHandlers(this.myProject, this, this.getCommitContext()));
        this.setTitle(this.myShowVcsCommit ? DIALOG_TITLE : CommitChangeListDialog.getExecutorPresentableText(this.myExecutors.get(0)));
        this.myCommitActionName = CommitChangeListDialog.getCommitActionName(this.myAffectedVcses);
        this.myExecutorActions = this.createExecutorActions(this.myExecutors);
        if (this.myShowVcsCommit) {
            this.myCommitAction = new CommitAction(this.myCommitActionName);
            this.myCommitAction.setOptions(this.myExecutorActions);
        } else {
            this.myCommitAction = null;
            this.myExecutorActions.get(0).putValue("DefaultAction", Boolean.TRUE);
        }
        this.myHelpId = this.myShowVcsCommit ? HELP_ID : CommitChangeListDialog.getHelpId(this.myExecutors);
        this.myDiffDetails = new MyChangeProcessor(this.myProject, this.myWorkflow.isPartialCommitEnabled());
        this.myCommitMessageArea = new CommitMessage(this.myProject, true, true, this.myShowVcsCommit);
        this.myBrowser = this.myWorkflow.createBrowser();
        this.myChangesInfoCalculator = new ChangeInfoCalculator();
        this.myLegend = new CommitLegendPanel(this.myChangesInfoCalculator);
        this.mySplitter = new Splitter(true);
        this.myCommitOptions = new CommitOptionsPanel(this, this.myHandlers, this.myShowVcsCommit ? this.myAffectedVcses : Collections.emptySet(), this.myWorkflow.getAdditionalDataConsumer());
        this.myWarningLabel = new JBLabel();
        JPanel mainPanel = new JPanel((LayoutManager)((Object)new MyOptionsLayout((JComponent)this.mySplitter, this.myCommitOptions, JBUI.scale((int)150), JBUI.scale((int)400))));
        mainPanel.add((Component)this.mySplitter);
        mainPanel.add((Component)((Object)this.myCommitOptions));
        BorderLayoutPanel rootPane = JBUI.Panels.simplePanel((Component)mainPanel).addToBottom((Component)this.myWarningLabel);
        this.myDetailsSplitter = this.createDetailsSplitter((JPanel)rootPane);
    }

    protected void init() {
        this.beforeInit();
        super.init();
        this.afterInit();
    }

    private void beforeInit() {
        this.myBrowserBottomPanel.add((Component)this.myLegend.getComponent());
        BorderLayoutPanel topPanel = JBUI.Panels.simplePanel().addToCenter((Component)this.myBrowser).addToBottom((Component)this.myBrowserBottomPanel);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setFirstComponent((JComponent)topPanel);
        this.mySplitter.setSecondComponent((JComponent)this.myCommitMessageArea);
        this.mySplitter.setProportion(PropertiesComponent.getInstance().getFloat(SPLITTER_PROPORTION_OPTION, 0.5f));
        if (!this.myVcsConfiguration.CLEAR_INITIAL_COMMIT_MESSAGE) {
            this.initComment(this.myWorkflow.getInitialCommitMessage());
        }
        this.restoreState();
        this.myWarningLabel.setForeground((Color)JBColor.RED);
        this.myWarningLabel.setBorder((Border)JBUI.Borders.empty((int)5, (int)5, (int)0, (int)5));
        this.updateWarning();
    }

    private void afterInit() {
        this.updateButtons();
        this.updateLegend();
        this.updateOnListSelection();
        this.myCommitMessageArea.requestFocusInMessage();
        for (EditChangelistSupport support : (EditChangelistSupport[])EditChangelistSupport.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            support.installSearch(this.myCommitMessageArea.getEditorField(), this.myCommitMessageArea.getEditorField());
        }
        this.showDetailsIfSaved();
    }

    @NotNull
    private SplitterWithSecondHideable createDetailsSplitter(@NotNull JPanel rootPane) {
        SplitterWithSecondHideable.OnOffListener<Integer> listener2 = new SplitterWithSecondHideable.OnOffListener<Integer>(){

            @Override
            public void on(Integer integer) {
                if (integer == 0) {
                    return;
                }
                CommitChangeListDialog.this.myDiffDetails.refresh(false);
                CommitChangeListDialog.this.mySplitter.skipNextLayout();
                CommitChangeListDialog.this.myDetailsSplitter.getComponent().skipNextLayout();
                Dimension dialogSize = CommitChangeListDialog.this.getSize();
                CommitChangeListDialog.this.setSize(dialogSize.width, dialogSize.height + integer);
                CommitChangeListDialog.this.repaint();
            }

            @Override
            public void off(Integer integer) {
                if (integer == 0) {
                    return;
                }
                CommitChangeListDialog.this.myDiffDetails.clear();
                CommitChangeListDialog.this.mySplitter.skipNextLayout();
                CommitChangeListDialog.this.myDetailsSplitter.getComponent().skipNextLayout();
                Dimension dialogSize = CommitChangeListDialog.this.getSize();
                CommitChangeListDialog.this.setSize(dialogSize.width, dialogSize.height - integer);
                CommitChangeListDialog.this.repaint();
            }
        };
        return new SplitterWithSecondHideable(true, "Diff", rootPane, listener2){

            @Override
            protected RefreshablePanel createDetails() {
                BorderLayoutPanel panel2 = JBUI.Panels.simplePanel((Component)CommitChangeListDialog.this.myDiffDetails.getComponent());
                return new RefreshablePanel((JPanel)panel2){
                    final /* synthetic */ JPanel val$panel;
                    {
                        this.val$panel = jPanel;
                    }

                    @Override
                    public void refresh() {
                    }

                    @Override
                    public JPanel getPanel() {
                        return this.val$panel;
                    }
                };
            }

            @Override
            protected float getSplitterInitialProportion() {
                float value = PropertiesComponent.getInstance().getFloat(CommitChangeListDialog.DETAILS_SPLITTER_PROPORTION_OPTION, 0.6f);
                return (double)value <= 0.05 || (double)value >= 0.95 ? 0.6f : value;
            }
        };
    }

    @NotNull
    public static List<CheckinHandler> createCheckinHandlers(@NotNull Project project, @NotNull CheckinProjectPanel checkinPanel, @NotNull CommitContext commitContext) {
        ArrayList<CheckinHandler> handlers = new ArrayList<CheckinHandler>();
        for (BaseCheckinHandlerFactory factory : CommitChangeListDialog.getCheckInFactories(project)) {
            CheckinHandler handler2 = factory.createHandler(checkinPanel, commitContext);
            if (CheckinHandler.DUMMY.equals(handler2)) continue;
            handlers.add(handler2);
        }
        return handlers;
    }

    @NotNull
    private List<CommitExecutorAction> createExecutorActions(@NotNull List<? extends CommitExecutor> executors) {
        if (executors.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        if (this.myShowVcsCommit && UISettings.getShadowInstance().getAllowMergeButtons()) {
            ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("Vcs.CommitExecutor.Actions");
            result2.addAll(ContainerUtil.map((Object[])group.getChildren(null), x$0 -> new CommitExecutorAction((AnAction)x$0)));
            result2.addAll(ContainerUtil.map((Collection)ContainerUtil.filter(executors, CommitExecutor::useDefaultAction), x$0 -> new CommitExecutorAction((CommitExecutor)x$0)));
        } else {
            result2.addAll(ContainerUtil.map(executors, x$0 -> new CommitExecutorAction((CommitExecutor)x$0)));
        }
        return result2;
    }

    @Nullable
    private static String getHelpId(@NotNull List<? extends CommitExecutor> executors) {
        return StreamEx.of(executors).select(HelpIdProvider.class).map(HelpIdProvider::getHelpId).nonNull().findFirst().orElse(null);
    }

    private void initComment(@Nullable String comment) {
        LocalChangeList list2 = this.myBrowser.getSelectedChangeList();
        this.myLastSelectedListName = list2.getName();
        if (comment == null) {
            comment = this.getCommentFromChangelist(list2);
            if (StringUtil.isEmptyOrSpaces((String)comment)) {
                this.myLastKnownComment = this.myVcsConfiguration.LAST_COMMIT_MESSAGE;
                comment = (String)ObjectUtils.chooseNotNull((Object)this.getInitialMessageFromVcs(), (Object)this.myVcsConfiguration.LAST_COMMIT_MESSAGE);
            }
        } else {
            this.myLastKnownComment = comment;
        }
        this.myCommitMessageArea.setText(comment);
    }

    private void showDetailsIfSaved() {
        boolean showDetails = PropertiesComponent.getInstance().getBoolean(DETAILS_SHOW_OPTION, true);
        if (showDetails) {
            this.myDetailsSplitter.initOn();
        }
        this.changeDetails(false);
    }

    private void updateOnListSelection() {
        if (!this.myVcsConfiguration.CLEAR_INITIAL_COMMIT_MESSAGE) {
            this.updateComment();
        }
        this.myCommitMessageArea.setChangeList((ChangeList)this.myBrowser.getSelectedChangeList());
        this.myCommitOptions.onChangeListSelected(this.myBrowser.getSelectedChangeList(), ChangeListManagerImpl.getInstanceImpl(this.myProject).getUnversionedFiles());
    }

    private void updateWarning() {
        if (this.myWarningLabel != null) {
            Object[] messages;
            this.myWarningLabel.setVisible(false);
            VcsException updateException = ChangeListManagerImpl.getInstanceImpl(this.myProject).getUpdateException();
            if (updateException != null && !ArrayUtil.isEmpty((Object[])(messages = updateException.getMessages()))) {
                String message = "Warning: not all local changes may be shown due to an error: " + (String)messages[0];
                String htmlMessage = SwingHelper.buildHtml(UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont()), UIUtil.getHtmlBody((String)StringUtil.escapeXmlEntities((String)message)));
                this.myWarningLabel.setText(htmlMessage);
                this.myWarningLabel.setVisible(true);
            }
        }
    }

    @Nullable
    protected String getHelpId() {
        return this.myHelpId;
    }

    @NotNull
    protected Action getOKAction() {
        return this.myCommitAction != null ? this.myCommitAction : (Action)this.myExecutorActions.get(0);
    }

    @NotNull
    protected Action[] createActions() {
        ArrayList result2 = ContainerUtil.newArrayList();
        if (this.myCommitAction != null) {
            result2.add(this.myCommitAction);
        } else {
            result2.addAll(this.myExecutorActions);
        }
        result2.add(this.getCancelAction());
        if (this.myHelpId != null) {
            result2.add(this.getHelpAction());
        }
        return result2.toArray(new Action[0]);
    }

    private void executeDefaultCommitSession(@Nullable CommitExecutor executor) {
        if (!this.myWorkflow.prepareCommit(this.myBrowser.getIncludedUnversionedFiles(), this.myBrowser)) {
            return;
        }
        if (!this.saveDialogState()) {
            return;
        }
        this.saveComments(true);
        this.ensureDataIsActual(() -> {
            try {
                DefaultListCleaner defaultListCleaner = new DefaultListCleaner();
                CheckinHandler.ReturnResult result2 = this.performBeforeCommitChecks(executor);
                if (result2 == CheckinHandler.ReturnResult.COMMIT) {
                    this.close(0);
                    this.myWorkflow.doCommit(this.myBrowser.getSelectedChangeList(), this.getIncludedChanges(), this.getCommitMessage(), this.myHandlers);
                    defaultListCleaner.clean();
                }
            }
            catch (InputException ex) {
                ex.show();
            }
        });
    }

    public void execute(@NotNull CommitExecutor commitExecutor) {
        CommitSession session2 = commitExecutor.createCommitSession();
        if (session2 == CommitSession.VCS_COMMIT) {
            this.executeDefaultCommitSession(commitExecutor);
            return;
        }
        if (!this.myWorkflow.canExecute(commitExecutor, this.getIncludedChanges())) {
            return;
        }
        if (!this.saveDialogState()) {
            return;
        }
        this.saveComments(true);
        if (session2 instanceof CommitSessionContextAware) {
            ((CommitSessionContextAware)session2).setContext(this.getCommitContext());
        }
        this.ensureDataIsActual(() -> {
            SessionDialog sessionDialog;
            JComponent configurationUI = SessionDialog.createConfigurationUI(session2, this.getIncludedChanges(), this.getCommitMessage());
            if (configurationUI != null && !(sessionDialog = new SessionDialog(CommitChangeListDialog.getExecutorPresentableText(commitExecutor), this.getProject(), session2, this.getIncludedChanges(), this.getCommitMessage(), configurationUI)).showAndGet()) {
                session2.executionCanceled();
                return;
            }
            DefaultListCleaner defaultListCleaner = new DefaultListCleaner();
            CheckinHandler.ReturnResult result2 = this.performBeforeCommitChecks(commitExecutor);
            if (result2 == CheckinHandler.ReturnResult.COMMIT) {
                boolean success2 = false;
                try {
                    boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> session2.execute(this.getIncludedChanges(), this.getCommitMessage()), commitExecutor.getActionText(), true, this.getProject());
                    if (completed) {
                        LOG.debug("Commit successful");
                        this.myHandlers.forEach(CheckinHandler::checkinSuccessful);
                        success2 = true;
                        defaultListCleaner.clean();
                        this.close(0);
                    } else {
                        LOG.debug("Commit canceled");
                        session2.executionCanceled();
                    }
                }
                catch (Throwable e) {
                    Messages.showErrorDialog((String)VcsBundle.message((String)"error.executing.commit", (Object[])new Object[]{commitExecutor.getActionText(), e.getLocalizedMessage()}), (String)commitExecutor.getActionText());
                    this.myHandlers.forEach(handler2 -> handler2.checkinFailed(Collections.singletonList(new VcsException(e))));
                }
                finally {
                    if (this.myResultHandler != null) {
                        if (success2) {
                            this.myResultHandler.onSuccess(this.getCommitMessage());
                        } else {
                            this.myResultHandler.onFailure();
                        }
                    }
                }
            }
        });
    }

    @Nullable
    private String getInitialMessageFromVcs() {
        Ref result2 = new Ref();
        ChangesUtil.processChangesByVcs((Project)this.myProject, this.getIncludedChanges(), (vcs, changes2) -> {
            CheckinEnvironment checkinEnvironment;
            if (result2.isNull() && (checkinEnvironment = vcs.getCheckinEnvironment()) != null) {
                FilePath[] paths = ChangesUtil.getPaths((Collection)changes2).toArray(new FilePath[0]);
                result2.set((Object)checkinEnvironment.getDefaultMessageFor(paths));
            }
        });
        return (String)result2.get();
    }

    private void saveCommentIntoChangeList() {
        if (this.myLastSelectedListName != null) {
            this.myListComments.put(this.myLastSelectedListName, this.myCommitMessageArea.getComment());
        }
    }

    private void updateComment() {
        LocalChangeList list2 = this.myBrowser.getSelectedChangeList();
        if (!list2.getName().equals(this.myLastSelectedListName)) {
            this.saveCommentIntoChangeList();
            this.myLastSelectedListName = list2.getName();
            this.myCommitMessageArea.setText((String)ObjectUtils.chooseNotNull((Object)this.getCommentFromChangelist(list2), (Object)this.myLastKnownComment));
        }
    }

    @Nullable
    private String getCommentFromChangelist(@NotNull LocalChangeList list2) {
        for (CommitMessageProvider provider : CommitMessageProvider.EXTENSION_POINT_NAME.getExtensionList()) {
            String message = provider.getCommitMessage(list2, this.getProject());
            if (message == null) continue;
            return message;
        }
        String changeListComment = list2.getComment();
        if (!StringUtil.isEmptyOrSpaces((String)changeListComment)) {
            return changeListComment;
        }
        if (!list2.hasDefaultName()) {
            return list2.getName();
        }
        return null;
    }

    public void dispose() {
        this.myDisposed = true;
        Disposer.dispose((Disposable)this.myCommitOptions);
        Disposer.dispose((Disposable)this.myBrowser);
        Disposer.dispose((Disposable)this.myCommitMessageArea);
        Disposer.dispose((Disposable)this.myOKButtonUpdateAlarm);
        super.dispose();
        Disposer.dispose((Disposable)this.myDiffDetails);
        PropertiesComponent.getInstance().setValue(SPLITTER_PROPORTION_OPTION, this.mySplitter.getProportion(), 0.5f);
        float usedProportion = this.myDetailsSplitter.getUsedProportion();
        if (usedProportion > 0.0f) {
            PropertiesComponent.getInstance().setValue(DETAILS_SPLITTER_PROPORTION_OPTION, usedProportion, 0.6f);
        }
        PropertiesComponent.getInstance().setValue(DETAILS_SHOW_OPTION, this.myDetailsSplitter.isOn(), true);
    }

    @NotNull
    public String getCommitActionName() {
        return this.myCommitActionName;
    }

    @NotNull
    private static String getCommitActionName(@NotNull Collection<? extends AbstractVcs<?>> affectedVcses) {
        Set names = ContainerUtil.map2SetNotNull(affectedVcses, vcs -> {
            CheckinEnvironment checkinEnvironment = vcs.getCheckinEnvironment();
            return checkinEnvironment != null ? checkinEnvironment.getCheckinOperationName() : null;
        });
        if (names.size() == 1) {
            return (String)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((Collection)names));
        }
        return VcsBundle.getString((String)"commit.dialog.default.commit.operation.name");
    }

    private boolean checkComment() {
        if (this.myVcsConfiguration.FORCE_NON_EMPTY_COMMENT && this.getCommitMessage().isEmpty()) {
            int requestForCheckin = Messages.showYesNoDialog((String)VcsBundle.message((String)"confirmation.text.check.in.with.empty.comment", (Object[])new Object[0]), (String)VcsBundle.message((String)"confirmation.title.check.in.with.empty.comment", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
            return requestForCheckin == 0;
        }
        return true;
    }

    private void stopUpdate() {
        this.myUpdateDisabled = true;
    }

    private void restartUpdate() {
        this.myUpdateDisabled = false;
        this.myUpdateButtonsRunnable.run();
    }

    @NotNull
    private CheckinHandler.ReturnResult performBeforeCommitChecks(@Nullable CommitExecutor executor) {
        this.stopUpdate();
        Ref compoundResultRef = Ref.create();
        Runnable proceedRunnable = () -> {
            FileDocumentManager.getInstance().saveAllDocuments();
            compoundResultRef.set((Object)this.runBeforeCheckinHandlers(executor));
        };
        Runnable runnable2 = this.wrapIntoCheckinMetaHandlers(proceedRunnable);
        this.myWorkflow.doRunBeforeCommitChecks(this.myBrowser.getSelectedChangeList(), runnable2);
        return (CheckinHandler.ReturnResult)ObjectUtils.notNull((Object)compoundResultRef.get(), (Object)CheckinHandler.ReturnResult.CANCEL);
    }

    @NotNull
    private CheckinHandler.ReturnResult runBeforeCheckinHandlers(@Nullable CommitExecutor executor) {
        for (CheckinHandler handler2 : this.myHandlers) {
            if (!handler2.acceptExecutor(executor)) continue;
            LOG.debug("CheckinHandler.beforeCheckin: " + handler2);
            CheckinHandler.ReturnResult result2 = handler2.beforeCheckin(executor, this.myWorkflow.getAdditionalDataConsumer());
            if (result2 == CheckinHandler.ReturnResult.COMMIT) continue;
            if (result2 == CheckinHandler.ReturnResult.CANCEL) {
                this.restartUpdate();
                return CheckinHandler.ReturnResult.CANCEL;
            }
            if (result2 != CheckinHandler.ReturnResult.CLOSE_WINDOW) continue;
            LocalChangeList changeList = this.myBrowser.getSelectedChangeList();
            SingleChangeListCommitter.moveToFailedList(this.myProject, (ChangeList)changeList, this.getCommitMessage(), this.getIncludedChanges(), VcsBundle.message((String)"commit.dialog.rejected.commit.template", (Object[])new Object[]{changeList.getName()}));
            this.doCancelAction();
            return CheckinHandler.ReturnResult.CLOSE_WINDOW;
        }
        return CheckinHandler.ReturnResult.COMMIT;
    }

    private Runnable wrapIntoCheckinMetaHandlers(Runnable runnable2) {
        for (CheckinHandler handler2 : this.myHandlers) {
            if (!(handler2 instanceof CheckinMetaHandler)) continue;
            CheckinMetaHandler metaHandler = (CheckinMetaHandler)handler2;
            Runnable previousRunnable = runnable2;
            runnable2 = () -> {
                LOG.debug("CheckinMetaHandler.runCheckinHandlers: " + handler2);
                metaHandler.runCheckinHandlers(previousRunnable);
            };
        }
        return runnable2;
    }

    private boolean saveDialogState() {
        if (!this.checkComment()) {
            return false;
        }
        this.saveCommentIntoChangeList();
        this.myVcsConfiguration.saveCommitMessage(this.getCommitMessage());
        try {
            this.saveState();
            return true;
        }
        catch (InputException ex) {
            ex.show();
            return false;
        }
    }

    private void saveComments(boolean isOk) {
        if (isOk) {
            int selectedSize = this.getIncludedChanges().size();
            int totalSize = this.myBrowser.getSelectedChangeList().getChanges().size();
            if (totalSize > selectedSize) {
                this.myListComments.remove(this.myLastSelectedListName);
            }
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        this.myListComments.forEach((changeListName, comment) -> changeListManager.editComment(changeListName, comment));
    }

    public void doCancelAction() {
        this.myCommitOptions.saveChangeListComponentsState();
        this.saveCommentIntoChangeList();
        this.saveComments(false);
        LineStatusTrackerManager.getInstanceImpl(this.myProject).resetExcludedFromCommitMarkers();
        super.doCancelAction();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.myDetailsSplitter.getComponent();
    }

    @Deprecated
    @NotNull
    public Set<? extends AbstractVcs> getAffectedVcses() {
        return this.myShowVcsCommit ? this.myAffectedVcses : Collections.emptySet();
    }

    @NotNull
    public List<? extends CommitExecutor> getExecutors() {
        return this.myExecutors;
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        return ContainerUtil.map2SetNotNull(this.getDisplayedPaths(), filePath -> vcsManager.getVcsRootFor(filePath));
    }

    @NotNull
    public JComponent getComponent() {
        return this.mySplitter;
    }

    public boolean hasDiffs() {
        return !this.getIncludedChanges().isEmpty() || !this.myBrowser.getIncludedUnversionedFiles().isEmpty();
    }

    @NotNull
    public Collection<VirtualFile> getVirtualFiles() {
        return ContainerUtil.mapNotNull(this.getIncludedPaths(), filePath -> filePath.getVirtualFile());
    }

    @NotNull
    public Collection<Change> getSelectedChanges() {
        return ContainerUtil.newArrayList(this.getIncludedChanges());
    }

    @NotNull
    public Collection<File> getFiles() {
        return ContainerUtil.map(this.getIncludedPaths(), filePath -> filePath.getIOFile());
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public boolean vcsIsAffected(String name) {
        return ProjectLevelVcsManager.getInstance((Project)this.myProject).checkVcsIsActive(name) && ContainerUtil.exists(this.myAffectedVcses, vcs -> Comparing.equal((String)vcs.getName(), (String)name));
    }

    public void setCommitMessage(@Nullable String commitMessage2) {
        this.myLastKnownComment = commitMessage2;
        this.myCommitMessageArea.setText(commitMessage2);
        this.myCommitMessageArea.requestFocusInMessage();
    }

    @NotNull
    public String getCommitMessage() {
        return this.myCommitMessageArea.getComment();
    }

    public void refresh() {
        ChangeListManager.getInstance((Project)this.myProject).invokeAfterUpdate(() -> {
            this.myBrowser.updateDisplayedChangeLists();
            this.myCommitOptions.refresh();
        }, InvokeAfterUpdateMode.SILENT, "commit dialog", ModalityState.current());
    }

    public void saveState() {
        this.myCommitOptions.saveState();
    }

    public void restoreState() {
        this.myCommitOptions.restoreState();
    }

    @NotNull
    public List<RefreshableOnComponent> getAdditionalComponents() {
        return this.myCommitOptions.getAdditionalComponents();
    }

    private void updateButtons() {
        if (this.myDisposed || this.myUpdateDisabled) {
            return;
        }
        boolean enabled = this.hasDiffs();
        if (this.myCommitAction != null) {
            this.myCommitAction.setEnabled(enabled);
        }
        this.myExecutorActions.forEach(action -> action.updateEnabled(enabled));
        this.myOKButtonUpdateAlarm.cancelAllRequests();
        this.myOKButtonUpdateAlarm.addRequest(this.myUpdateButtonsRunnable, 300, ModalityState.stateForComponent((Component)this.myBrowser));
    }

    private void updateLegend() {
        if (this.myDisposed || this.myUpdateDisabled) {
            return;
        }
        this.myChangesInfoCalculator.update(this.myBrowser.getDisplayedChanges(), this.getIncludedChanges(), this.myBrowser.getDisplayedUnversionedFiles().size(), this.myBrowser.getIncludedUnversionedFiles().size());
        this.myLegend.update();
    }

    @NotNull
    private List<Change> getIncludedChanges() {
        return this.myBrowser.getIncludedChanges();
    }

    @NotNull
    private List<FilePath> getIncludedPaths() {
        ArrayList<FilePath> paths = new ArrayList<FilePath>();
        for (Change change : this.myBrowser.getIncludedChanges()) {
            paths.add(ChangesUtil.getFilePath((Change)change));
        }
        for (VirtualFile file2 : this.myBrowser.getIncludedUnversionedFiles()) {
            paths.add(VcsUtil.getFilePath((VirtualFile)file2));
        }
        return paths;
    }

    @NotNull
    private List<FilePath> getDisplayedPaths() {
        ArrayList<FilePath> paths = new ArrayList<FilePath>();
        for (Change change : this.myBrowser.getDisplayedChanges()) {
            paths.add(ChangesUtil.getFilePath((Change)change));
        }
        for (VirtualFile file2 : this.myBrowser.getDisplayedUnversionedFiles()) {
            paths.add(VcsUtil.getFilePath((VirtualFile)file2));
        }
        return paths;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "CommitChangelistDialog2";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCommitMessageArea.getEditorField();
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (Refreshable.PANEL_KEY.is(dataId)) {
            return this;
        }
        return this.myBrowser.getData(dataId);
    }

    @NotNull
    private CommitContext getCommitContext() {
        return this.myWorkflow.getCommitContext();
    }

    @NotNull
    public CommitDialogChangesBrowser getBrowser() {
        return this.myBrowser;
    }

    @NotNull
    CommitMessage getCommitMessageComponent() {
        return this.myCommitMessageArea;
    }

    @NotNull
    JComponent getBrowserBottomPanel() {
        return this.myBrowserBottomPanel;
    }

    void inclusionChanged() {
        this.myHandlers.forEach(CheckinHandler::includedChangesChanged);
        this.updateButtons();
    }

    void selectedChangeListChanged() {
        this.updateOnListSelection();
        this.updateWarning();
    }

    @NotNull
    static String getExecutorPresentableText(@NotNull CommitExecutor executor) {
        return CommitChangeListDialog.trimEllipsis(UIUtil.removeMnemonic((String)executor.getActionText()));
    }

    @NotNull
    static String trimEllipsis(@NotNull String title) {
        return StringUtil.trimEnd((String)StringUtil.trimEnd((String)title, (String)"..."), (String)"\u2026");
    }

    private void ensureDataIsActual(@NotNull Runnable runnable2) {
        ChangeListManager.getInstance((Project)this.myProject).invokeAfterUpdate(() -> {
            this.myBrowser.updateDisplayedChangeLists();
            runnable2.run();
        }, InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE, "Refreshing changelists...", ModalityState.current());
    }

    void changeDetails(boolean fromModelRefresh) {
        SwingUtilities.invokeLater(() -> {
            if (this.myDetailsSplitter.isOn()) {
                this.myDiffDetails.refresh(fromModelRefresh);
            }
        });
    }

    private static class MyOptionsLayout
    extends AbstractLayoutManager {
        @NotNull
        private final JComponent myPanel;
        @NotNull
        private final CommitOptionsPanel myOptions;
        private final int myMinOptionsWidth;
        private final int myMaxOptionsWidth;

        MyOptionsLayout(@NotNull JComponent panel2, @NotNull CommitOptionsPanel options, int minOptionsWidth, int maxOptionsWidth) {
            this.myPanel = panel2;
            this.myOptions = options;
            this.myMinOptionsWidth = minOptionsWidth;
            this.myMaxOptionsWidth = maxOptionsWidth;
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension size1 = this.myPanel.getPreferredSize();
            Dimension size2 = this.myOptions.getPreferredSize();
            return new Dimension(size1.width + size2.width, Math.max(size1.height, size2.height));
        }

        public void layoutContainer(@NotNull Container parent) {
            Rectangle bounds2 = parent.getBounds();
            int preferredWidth = this.myOptions.getPreferredSize().width;
            int optionsWidth = this.myOptions.isEmpty() ? 0 : Math.max(Math.min(this.myMaxOptionsWidth, preferredWidth), this.myMinOptionsWidth);
            this.myPanel.setBounds(new Rectangle(0, 0, bounds2.width - optionsWidth, bounds2.height));
            this.myOptions.setBounds(new Rectangle(bounds2.width - optionsWidth, 0, optionsWidth, bounds2.height));
        }
    }

    private class MyChangeProcessor
    extends ChangeViewDiffRequestProcessor {
        MyChangeProcessor(Project project, boolean enablePartialCommit) {
            super(project, "CommitDialog");
            this.putContextUserData(DiffUserDataKeysEx.SHOW_READ_ONLY_LOCK, true);
            this.putContextUserData(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, enablePartialCommit);
            this.putContextUserData(DiffUserDataKeysEx.LAST_REVISION_WITH_LOCAL, true);
        }

        @Override
        @NotNull
        protected List<ChangeViewDiffRequestProcessor.Wrapper> getSelectedChanges() {
            return this.wrap(CommitChangeListDialog.this.myBrowser.getSelectedChanges(), CommitChangeListDialog.this.myBrowser.getSelectedUnversionedFiles());
        }

        @Override
        @NotNull
        protected List<ChangeViewDiffRequestProcessor.Wrapper> getAllChanges() {
            return this.wrap(CommitChangeListDialog.this.myBrowser.getDisplayedChanges(), CommitChangeListDialog.this.myBrowser.getDisplayedUnversionedFiles());
        }

        @Override
        protected void selectChange(@NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
            CommitChangeListDialog.this.myBrowser.selectEntries(Collections.singletonList(change.getUserObject()));
        }

        @NotNull
        private List<ChangeViewDiffRequestProcessor.Wrapper> wrap(@NotNull Collection<? extends Change> changes2, @NotNull Collection<? extends VirtualFile> unversioned) {
            return ContainerUtil.concat((List)ContainerUtil.map(changes2, ChangeViewDiffRequestProcessor.ChangeWrapper::new), (List)ContainerUtil.map(unversioned, ChangeViewDiffRequestProcessor.UnversionedFileWrapper::new));
        }

        @Override
        protected void onAfterNavigate() {
            CommitChangeListDialog.this.doCancelAction();
        }
    }

    private class CommitExecutorAction
    extends AbstractAction {
        @Nullable
        private final CommitExecutor myCommitExecutor;

        CommitExecutorAction(AnAction anAction) {
            this.putValue("AnAction", anAction);
            this.myCommitExecutor = null;
        }

        CommitExecutorAction(CommitExecutor commitExecutor) {
            super(commitExecutor.getActionText());
            this.myCommitExecutor = commitExecutor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.myCommitExecutor != null) {
                CommitChangeListDialog.this.execute(this.myCommitExecutor);
            }
        }

        public void updateEnabled(boolean hasDiffs) {
            if (this.myCommitExecutor != null) {
                this.setEnabled(hasDiffs || this.myCommitExecutor instanceof CommitExecutorBase && !((CommitExecutorBase)this.myCommitExecutor).areChangesRequired());
            }
        }
    }

    private class DefaultListCleaner {
        private final boolean myToClean;

        private DefaultListCleaner() {
            int selectedSize = CommitChangeListDialog.this.getIncludedChanges().size();
            LocalChangeList selectedList = CommitChangeListDialog.this.myBrowser.getSelectedChangeList();
            int totalSize = selectedList.getChanges().size();
            this.myToClean = totalSize == selectedSize && selectedList.hasDefaultName();
        }

        void clean() {
            if (this.myToClean) {
                ChangeListManager.getInstance((Project)CommitChangeListDialog.this.myProject).editComment(LocalChangeList.DEFAULT_NAME, "");
            }
        }
    }

    private class CommitAction
    extends AbstractAction
    implements OptionAction {
        @NotNull
        private Action[] myOptions;

        private CommitAction(String okActionText) {
            super(okActionText);
            this.myOptions = new Action[0];
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommitChangeListDialog.this.executeDefaultCommitSession(null);
        }

        @NotNull
        public Action[] getOptions() {
            return this.myOptions;
        }

        public void setOptions(@NotNull List<? extends Action> actions) {
            this.myOptions = actions.toArray(new Action[0]);
        }
    }
}

