/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.CommitDialogChangesBrowser;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.branch.BranchData;
import com.intellij.vcs.branch.BranchStateProvider;
import com.intellij.vcs.branch.LinkedBranchData;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0002J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0016\u0010\u0016\u001a\u00020\u00122\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u0017H\u0002J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00122\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u0017H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J$\u0010\u001b\u001a\u00020\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001dH\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/vcs/changes/ui/CurrentBranchComponent;", "Lcom/intellij/ui/components/JBLabel;", "project", "Lcom/intellij/openapi/project/Project;", "browser", "Lcom/intellij/openapi/vcs/changes/ui/CommitDialogChangesBrowser;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/changes/ui/CommitDialogChangesBrowser;)V", "branches", "", "Lcom/intellij/vcs/branch/BranchData;", "getBrowser", "()Lcom/intellij/openapi/vcs/changes/ui/CommitDialogChangesBrowser;", "isGroupedByRepository", "", "()Z", "getProject", "()Lcom/intellij/openapi/project/Project;", "getMultiTooltip", "", "branch", "getPreferredSize", "Ljava/awt/Dimension;", "getText", "", "getTooltip", "refresh", "", "setData", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "unversioned", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.platform.vcs.impl"})
public final class CurrentBranchComponent
extends JBLabel {
    private Set<? extends BranchData> branches;
    @NotNull
    private final Project project;
    @NotNull
    private final CommitDialogChangesBrowser browser;
    private static final JBColor BACKGROUND_BASE_COLOR;
    @JvmField
    @NotNull
    public static final JBColor TEXT_COLOR;
    public static final Companion Companion;

    private final boolean isGroupedByRepository() {
        ChangesGroupingSupport groupingSupport = this.browser.getViewer().getGroupingSupport();
        return groupingSupport.isAvailable("repository") && groupingSupport.get("repository");
    }

    @Nullable
    public Dimension getPreferredSize() {
        return this.isVisible() ? super.getPreferredSize() : (Dimension)JBUI.emptySize();
    }

    private final void refresh() {
        this.setVisible(!this.isGroupedByRepository());
        if (this.isVisible()) {
            this.setData((Iterable<? extends Change>)this.browser.getDisplayedChanges(), (Iterable<? extends VirtualFile>)this.browser.getDisplayedUnversionedFiles());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setData(Iterable<? extends Change> changes2, Iterable<? extends VirtualFile> unversioned) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Iterable<? extends Change> $receiver$iv;
        Iterable<? extends Change> iterable = $receiver$iv = changes2;
        Iterable<Object> destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv2;
        Iterator iterator = $receiver$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            BranchData branchData;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            Change it = (Change)element$iv$iv;
            boolean bl = false;
            if (Companion.getCurrentBranch(this.project, it) == null) continue;
            BranchData it$iv$iv = branchData;
            destination$iv$iv.add(it$iv$iv);
        }
        Set fromChanges = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable<? extends VirtualFile> $receiver$iv2 = unversioned;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        void $receiver$iv$iv$iv2 = $receiver$iv$iv;
        Iterator iterator2 = $receiver$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            BranchData branchData;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (Companion.getCurrentBranch(this.project, it) == null) continue;
            BranchData it$iv$iv = branchData;
            destination$iv$iv2.add(it$iv$iv);
        }
        Set fromUnversioned = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        this.branches = SetsKt.plus((Set)fromChanges, (Iterable)fromUnversioned);
        this.setText(this.getText((Collection<? extends BranchData>)this.branches));
        this.setToolTipText(this.getTooltip((Collection<? extends BranchData>)this.branches));
    }

    private final String getText(Collection<? extends BranchData> branches) {
        String string;
        Iterable $receiver$iv = branches;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $receiver$iv) {
            BranchData it = (BranchData)e$iv;
            boolean bl = false;
            String key$iv = it.getBranchName();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List distinct = list$iv;
        switch (distinct.size()) {
            case 0: {
                string = "";
                break;
            }
            case 1: {
                string = Companion.getPresentableText((BranchData)CollectionsKt.first((List)distinct));
                break;
            }
            default: {
                string = Companion.getPresentableText((BranchData)CollectionsKt.first((List)distinct)) + ",...";
            }
        }
        return string;
    }

    private final String getTooltip(Collection<? extends BranchData> branches) {
        String string;
        Iterable $receiver$iv = branches;
        HashSet<Pair> set$iv = new HashSet<Pair>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $receiver$iv) {
            BranchData it = (BranchData)e$iv;
            boolean bl = false;
            String string2 = it.getBranchName();
            BranchData branchData = it;
            if (!(branchData instanceof LinkedBranchData)) {
                branchData = null;
            }
            LinkedBranchData linkedBranchData = (LinkedBranchData)branchData;
            Pair key$iv = TuplesKt.to((Object)string2, (Object)(linkedBranchData != null ? linkedBranchData.getLinkedBranchName() : null));
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List distinct = list$iv;
        switch (distinct.size()) {
            case 0: {
                string = null;
                break;
            }
            case 1: {
                string = Companion.getSingleTooltip((BranchData)CollectionsKt.first((List)distinct));
                break;
            }
            default: {
                string = CollectionsKt.joinToString$default((Iterable)branches, (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<BranchData, String>(this){
                    final /* synthetic */ CurrentBranchComponent this$0;

                    @NotNull
                    public final String invoke(@NotNull BranchData it) {
                        return CurrentBranchComponent.access$getMultiTooltip(this.this$0, it);
                    }
                    {
                        this.this$0 = currentBranchComponent;
                        super(1);
                    }
                }), (int)30, null);
            }
        }
        return string;
    }

    private final String getMultiTooltip(BranchData branch) {
        String string;
        block4: {
            block2: {
                block3: {
                    String string2;
                    if (!(branch instanceof LinkedBranchData) || ((LinkedBranchData)branch).getBranchName() == null) break block2;
                    string = ((LinkedBranchData)branch).getLinkedBranchName();
                    if (string == null) break block3;
                    String it = string2 = string;
                    boolean bl = false;
                    string = ' ' + UIUtil.rightArrow() + ' ' + it;
                    if (string != null) break block4;
                }
                string = " (no tracking branch)";
                break block4;
            }
            string = "";
        }
        String linkedBranchPart = string;
        return "<tr><td>" + branch.getPresentableRootName() + ":</td><td>" + Companion.getPresentableText(branch) + linkedBranchPart + "</td></tr>";
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CommitDialogChangesBrowser getBrowser() {
        return this.browser;
    }

    public CurrentBranchComponent(@NotNull Project project, @NotNull CommitDialogChangesBrowser browser2) {
        Set set2;
        this.project = project;
        this.browser = browser2;
        CurrentBranchComponent currentBranchComponent = this;
        currentBranchComponent.branches = set2 = SetsKt.emptySet();
        this.setIcon(AllIcons.Vcs.Branch);
        this.setForeground((Color)TEXT_COLOR);
        this.browser.getViewer().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public final void propertyChange(PropertyChangeEvent e) {
                if (Intrinsics.areEqual((Object)e.getPropertyName(), (Object)"model")) {
                    this.refresh();
                }
            }
        });
    }

    static {
        Companion = new Companion(null);
        BACKGROUND_BASE_COLOR = JBColor.namedColor((String)"VersionControl.RefLabel.backgroundBase", (Color)((Color)new JBColor(Color.BLACK, Color.WHITE)));
        TEXT_COLOR = JBColor.namedColor((String)"VersionControl.RefLabel.foreground", (Color)((Color)new JBColor(new Color(0x7A7A7A), new Color(0x909090))));
    }

    public static final /* synthetic */ String access$getMultiTooltip(CurrentBranchComponent $this, BranchData branch) {
        return $this.getMultiTooltip(branch);
    }

    @JvmStatic
    @NotNull
    public static final Color getBranchPresentationBackground(@NotNull Color background) {
        return Companion.getBranchPresentationBackground(background);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0007J\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eJ2\u0010\u0018\u001a$\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001a0\u001a \u001b*\u0010\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001a0\u001a0\u001c0\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u000eJ\u0018\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/CurrentBranchComponent$Companion;", "", "()V", "BACKGROUND_BALANCE", "", "getBACKGROUND_BALANCE", "()D", "BACKGROUND_BASE_COLOR", "Lcom/intellij/ui/JBColor;", "TEXT_COLOR", "getBranchPresentationBackground", "Ljava/awt/Color;", "background", "getCurrentBranch", "Lcom/intellij/vcs/branch/BranchData;", "project", "Lcom/intellij/openapi/project/Project;", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getPresentableText", "", "branch", "getProviders", "", "Lcom/intellij/vcs/branch/BranchStateProvider;", "kotlin.jvm.PlatformType", "", "getSingleTooltip", "namedDouble", "name", "default", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private final double getBACKGROUND_BALANCE() {
            return Companion.namedDouble("VersionControl.RefLabel.backgroundBrightness", 0.08);
        }

        private final double namedDouble(String name, double d) {
            double d2;
            Object value = UIManager.get(name);
            Object object = value;
            if (object instanceof Double) {
                d2 = ((Number)value).doubleValue();
            } else if (object instanceof Integer) {
                d2 = ((Number)value).intValue();
            } else if (object instanceof String) {
                Double d3 = StringsKt.toDoubleOrNull((String)((String)value));
                d2 = d3 != null ? d3 : d;
            } else {
                d2 = d;
            }
            return d2;
        }

        @Nullable
        public final BranchData getCurrentBranch(@NotNull Project project, @NotNull Change change) {
            return (BranchData)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.getProviders(project)), (Function1)((Function1)new Function1<BranchStateProvider, BranchData>(change){
                final /* synthetic */ Change $change;

                @Nullable
                public final BranchData invoke(BranchStateProvider it) {
                    return it.getCurrentBranch(ChangesUtil.getFilePath((Change)this.$change));
                }
                {
                    this.$change = change;
                    super(1);
                }
            })));
        }

        @Nullable
        public final BranchData getCurrentBranch(@NotNull Project project, @NotNull VirtualFile file2) {
            return (BranchData)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.getProviders(project)), (Function1)((Function1)new Function1<BranchStateProvider, BranchData>(file2){
                final /* synthetic */ VirtualFile $file;

                @Nullable
                public final BranchData invoke(BranchStateProvider it) {
                    return it.getCurrentBranch(VcsUtil.getFilePath((VirtualFile)this.$file));
                }
                {
                    this.$file = virtualFile;
                    super(1);
                }
            })));
        }

        @NotNull
        public final String getPresentableText(@NotNull BranchData branch) {
            String string;
            if (branch instanceof LinkedBranchData) {
                string = ((LinkedBranchData)branch).getBranchName();
                if (string == null) {
                    string = "!";
                }
            } else {
                String string2 = branch.getBranchName();
                string = string2;
                if (string == null) {
                    string = "";
                }
            }
            return string;
        }

        @Nullable
        public final String getSingleTooltip(@NotNull BranchData branch) {
            String string;
            block4: {
                block2: {
                    block3: {
                        String string2;
                        if (!(branch instanceof LinkedBranchData) || ((LinkedBranchData)branch).getBranchName() == null) break block2;
                        string = ((LinkedBranchData)branch).getLinkedBranchName();
                        if (string == null) break block3;
                        String it = string2 = string;
                        boolean bl = false;
                        string = ((LinkedBranchData)branch).getBranchName() + ' ' + UIUtil.rightArrow() + ' ' + it;
                        if (string != null) break block4;
                    }
                    string = "No tracking branch";
                    break block4;
                }
                string = null;
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public final Color getBranchPresentationBackground(@NotNull Color background) {
            return ColorUtil.mix((Color)background, (Color)((Color)BACKGROUND_BASE_COLOR), (double)this.getBACKGROUND_BALANCE());
        }

        private final List<BranchStateProvider> getProviders(Project project) {
            return BranchStateProvider.EP_NAME.getExtensionList((AreaInstance)project);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

