/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.ui.AbstractCommitter;
import com.intellij.openapi.vcs.changes.ui.DefaultCommitResultHandler;
import com.intellij.openapi.vcs.changes.ui.DefaultCommitResultHandlerKt;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0006H\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/DefaultCommitResultHandler;", "Lcom/intellij/openapi/vcs/changes/CommitResultHandler;", "committer", "Lcom/intellij/openapi/vcs/changes/ui/AbstractCommitter;", "(Lcom/intellij/openapi/vcs/changes/ui/AbstractCommitter;)V", "getCommitSummary", "", "getFileSummaryReport", "onFailure", "", "onSuccess", "commitMessage", "reportResult", "intellij.platform.vcs.impl"})
public final class DefaultCommitResultHandler
implements CommitResultHandler {
    private final AbstractCommitter committer;

    public void onSuccess(@NotNull String commitMessage2) {
        this.reportResult();
    }

    public void onFailure() {
        this.reportResult();
    }

    private final void reportResult() {
        List<VcsException> allExceptions = this.committer.getExceptions();
        List<VcsException> errors = AbstractCommitter.Companion.collectErrors(allExceptions);
        int errorsSize = errors.size();
        int warningsSize = allExceptions.size() - errorsSize;
        VcsNotifier notifier = VcsNotifier.getInstance(this.committer.getProject());
        String message = this.getCommitSummary();
        if (errorsSize > 0) {
            String title = StringUtil.pluralize((String)VcsBundle.message((String)"message.text.commit.failed.with.error", (Object[])new Object[0]), (int)errorsSize);
            notifier.notifyError(title, message);
        } else if (warningsSize > 0) {
            String title = StringUtil.pluralize((String)VcsBundle.message((String)"message.text.commit.finished.with.warning", (Object[])new Object[0]), (int)warningsSize);
            notifier.notifyImportantWarning(title, message);
        } else {
            notifier.notifySuccess(message);
        }
    }

    private final String getCommitSummary() {
        List<VcsException> exceptions;
        Set<String> feedback;
        StringBuilder stringBuilder;
        StringBuilder $receiver = stringBuilder = new StringBuilder(this.getFileSummaryReport());
        boolean bl = false;
        String commitMessage2 = this.committer.getCommitMessage();
        if (!StringUtil.isEmpty((String)commitMessage2)) {
            $receiver.append(": ").append(DefaultCommitResultHandlerKt.access$escape(commitMessage2));
        }
        if (!(feedback = this.committer.getFeedback()).isEmpty()) {
            $receiver.append("<br/>");
            $receiver.append(StringUtil.join((Collection)feedback, (String)"<br/>"));
        }
        if (!DefaultCommitResultHandlerKt.access$hasOnlyWarnings(exceptions = this.committer.getExceptions())) {
            $receiver.append("<br/>");
            $receiver.append(StringUtil.join((Collection)exceptions, (Function)getCommitSummary.1.1.INSTANCE, (String)"<br/>"));
        }
        return stringBuilder.toString();
    }

    private final String getFileSummaryReport() {
        int failed = this.committer.getFailedToCommitChanges().size();
        int committed = this.committer.getChanges().size() - failed;
        String fileSummary = "" + committed + ' ' + StringUtil.pluralize((String)"file", (int)committed) + " committed";
        if (failed > 0) {
            fileSummary = fileSummary + ", " + failed + ' ' + StringUtil.pluralize((String)"file", (int)failed) + " failed to commit";
        }
        return fileSummary;
    }

    public DefaultCommitResultHandler(@NotNull AbstractCommitter committer) {
        this.committer = committer;
    }
}

