/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalChangesBrowser
extends ChangesBrowserBase
implements Disposable {
    @NotNull
    private final ToggleChangeDiffAction myToggleChangeDiffAction = new ToggleChangeDiffAction();
    @Nullable
    private Set<String> myChangeListNames;

    public LocalChangesBrowser(@NotNull Project project) {
        super(project, true, true);
        ChangeListManager.getInstance((Project)this.myProject).addChangeListListener((ChangeListListener)new MyChangeListListener(), (Disposable)this);
        this.init();
        this.myViewer.setInclusionHashingStrategy((TObjectHashingStrategy<Object>)ChangeListChange.HASHING_STRATEGY);
        this.myViewer.rebuildTree();
    }

    public void dispose() {
    }

    @Override
    @NotNull
    protected List<AnAction> createDiffActions() {
        return ContainerUtil.append(super.createDiffActions(), (Object[])new AnAction[]{this.myToggleChangeDiffAction});
    }

    @Override
    @NotNull
    protected DefaultTreeModel buildTreeModel() {
        List lists = ChangeListManager.getInstance((Project)this.myProject).getChangeLists();
        if (this.myChangeListNames != null) {
            lists = ContainerUtil.filter((Collection)lists, list2 -> this.myChangeListNames.contains(list2.getName()));
        }
        return TreeModelBuilder.buildFromChangeLists(this.myProject, this.getGrouping(), lists, Registry.is((String)"vcs.skip.single.default.changelist"));
    }

    public void setIncludedChanges(@NotNull Collection<? extends Change> changes2) {
        ArrayList<? extends Change> changesToInclude = new ArrayList<Change>(changes2);
        HashSet<Change> otherChanges = new HashSet<Change>();
        for (Change change : changes2) {
            if (change instanceof ChangeListChange) continue;
            otherChanges.add(change);
        }
        if (!otherChanges.isEmpty()) {
            for (Change change : this.getAllChanges()) {
                if (!(change instanceof ChangeListChange) || !otherChanges.contains(change)) continue;
                changesToInclude.add((Change)change);
            }
        }
        this.myViewer.setIncludedChanges(changesToInclude);
    }

    public List<Change> getAllChanges() {
        return VcsTreeModelData.all((JTree)((Object)this.myViewer)).userObjects(Change.class);
    }

    public List<Change> getSelectedChanges() {
        return VcsTreeModelData.selected((JTree)((Object)this.myViewer)).userObjects(Change.class);
    }

    public List<Change> getIncludedChanges() {
        return VcsTreeModelData.included(this.myViewer).userObjects(Change.class);
    }

    public void setToggleActionTitle(@Nullable String title) {
        this.myToggleChangeDiffAction.getTemplatePresentation().setText(title);
    }

    public void setChangeLists(@Nullable List<? extends LocalChangeList> changeLists) {
        this.myChangeListNames = changeLists != null ? ContainerUtil.map2Set(changeLists, LocalChangeList::getName) : null;
        this.myViewer.rebuildTree();
    }

    private class MyChangeListListener
    extends ChangeListAdapter {
        @NotNull
        private final MergingUpdateQueue myUpdateQueue;

        private MyChangeListListener() {
            this.myUpdateQueue = new MergingUpdateQueue("LocalChangesViewer", 300, true, (JComponent)LocalChangesBrowser.this, (Disposable)LocalChangesBrowser.this);
        }

        private void doUpdate() {
            this.myUpdateQueue.queue(new Update("update"){

                public void run() {
                    LocalChangesBrowser.this.myViewer.rebuildTree();
                }
            });
        }

        public void changeListsChanged() {
            this.doUpdate();
        }
    }

    private class ToggleChangeDiffAction
    extends CheckboxAction
    implements DumbAware {
        ToggleChangeDiffAction() {
            super("&Include");
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Change change = (Change)e.getData(VcsDataKeys.CURRENT_CHANGE);
            if (change == null) {
                return false;
            }
            return LocalChangesBrowser.this.myViewer.isIncluded(change);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Change change = (Change)e.getData(VcsDataKeys.CURRENT_CHANGE);
            if (change == null) {
                return;
            }
            if (state) {
                LocalChangesBrowser.this.myViewer.includeChange(change);
            } else {
                LocalChangesBrowser.this.myViewer.excludeChange(change);
            }
        }
    }
}

