/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diff.DiffDialogHints;
import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffContext;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeList;
import com.intellij.openapi.vcs.changes.ui.RemoteStatusChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public abstract class OldChangesBrowserBase
extends JPanel
implements TypeSafeDataProvider,
Disposable {
    protected final ChangesTreeList<Change> myViewer;
    protected final JScrollPane myViewerScrollPane;
    protected ChangeList mySelectedChangeList;
    protected List<Change> myChangesToDisplay;
    protected final Project myProject;
    private final boolean myCapableOfExcludingChanges;
    private DefaultActionGroup myToolBarGroup;
    private AnAction myDiffAction;
    private final VirtualFile myToSelect;
    @NotNull
    private final DeleteProvider myDeleteProvider = new VirtualFileDeleteProvider();

    public void setChangesToDisplay(List<Change> changes2) {
        this.myChangesToDisplay = changes2;
        this.myViewer.setChangesToDisplay(changes2);
    }

    public void setDecorator(ChangeNodeDecorator decorator) {
        this.myViewer.setChangeDecorator(decorator);
    }

    protected OldChangesBrowserBase(@NotNull Project project, @NotNull List<Change> changes2, boolean capableOfExcludingChanges, boolean highlightProblems, @Nullable Runnable inclusionListener, @NotNull ChangesBrowser.MyUseCase useCase, @Nullable VirtualFile toSelect2) {
        super(new BorderLayout());
        this.setFocusable(false);
        this.myProject = project;
        this.myCapableOfExcludingChanges = capableOfExcludingChanges;
        this.myToSelect = toSelect2;
        RemoteStatusChangeNodeDecorator decorator = ChangesBrowser.MyUseCase.LOCAL_CHANGES.equals((Object)useCase) ? RemoteRevisionsCache.getInstance(this.myProject).getChangesNodeDecorator() : null;
        this.myViewer = new ChangesTreeList<Change>(this.myProject, changes2, capableOfExcludingChanges, highlightProblems, inclusionListener, (ChangeNodeDecorator)decorator){

            @Override
            protected DefaultTreeModel buildTreeModel(List<Change> changes2, ChangeNodeDecorator changeNodeDecorator) {
                return OldChangesBrowserBase.this.buildTreeModel(changes2, changeNodeDecorator, this.isShowFlatten());
            }

            @Override
            protected List<Change> getSelectedObjects(ChangesBrowserNode<?> node) {
                return OldChangesBrowserBase.this.getSelectedObjects(node);
            }

            @Override
            @Nullable
            protected Change getLeadSelectedObject(ChangesBrowserNode<?> node) {
                return OldChangesBrowserBase.this.getLeadSelectedObject(node);
            }

            @Override
            public void setScrollPaneBorder(Border border) {
                OldChangesBrowserBase.this.myViewerScrollPane.setBorder(border);
            }
        };
        this.myViewerScrollPane = ScrollPaneFactory.createScrollPane(this.myViewer);
    }

    protected void init() {
        this.add((Component)this.myViewerScrollPane, "Center");
        this.add((Component)this.createToolbar(), "North");
        this.myViewer.installPopupHandler((ActionGroup)this.myToolBarGroup);
        this.myViewer.setDoubleClickHandler(() -> this.showDiff());
    }

    @NotNull
    protected DefaultTreeModel buildTreeModel(List<Change> changes2, ChangeNodeDecorator changeNodeDecorator, boolean showFlatten) {
        return TreeModelBuilder.buildFromChanges(this.myProject, this.myViewer.getGrouping(), changes2, changeNodeDecorator);
    }

    @NotNull
    protected List<Change> getSelectedObjects(@NotNull ChangesBrowserNode<?> node) {
        return node.getAllChangesUnder();
    }

    @Nullable
    protected Change getLeadSelectedObject(@NotNull ChangesBrowserNode<?> node) {
        Object o = node.getUserObject();
        if (o instanceof Change) {
            return (Change)o;
        }
        return null;
    }

    public void dispose() {
    }

    public void addToolbarAction(AnAction action) {
        this.myToolBarGroup.add(action);
    }

    public ChangesTreeList<Change> getViewer() {
        return this.myViewer;
    }

    @NotNull
    public JScrollPane getViewerScrollPane() {
        return this.myViewerScrollPane;
    }

    public void calcData(@NotNull DataKey key, @NotNull DataSink sink) {
        if (key == VcsDataKeys.CHANGES) {
            List<Change> list2 = this.getSelectedChanges();
            if (list2.isEmpty()) {
                list2 = this.myViewer.getChanges();
            }
            sink.put(VcsDataKeys.CHANGES, (Object)list2.toArray(new Change[0]));
        } else if (key == VcsDataKeys.CHANGES_SELECTION) {
            sink.put(VcsDataKeys.CHANGES_SELECTION, this.getChangesSelection());
        } else if (key == VcsDataKeys.CHANGE_LISTS) {
            sink.put(VcsDataKeys.CHANGE_LISTS, (Object)this.getSelectedChangeLists());
        } else if (key == VcsDataKeys.CHANGE_LEAD_SELECTION) {
            Change[] changeArray;
            Change highestSelection = this.myViewer.getHighestLeadSelection();
            if (highestSelection == null) {
                changeArray = new Change[]{};
            } else {
                Change[] changeArray2 = new Change[1];
                changeArray = changeArray2;
                changeArray2[0] = highestSelection;
            }
            sink.put(VcsDataKeys.CHANGE_LEAD_SELECTION, (Object)changeArray);
        } else if (key == CommonDataKeys.VIRTUAL_FILE_ARRAY) {
            sink.put(CommonDataKeys.VIRTUAL_FILE_ARRAY, this.getSelectedFiles().toArray(VirtualFile[]::new));
        } else if (key == CommonDataKeys.NAVIGATABLE_ARRAY) {
            sink.put(CommonDataKeys.NAVIGATABLE_ARRAY, (Object)ChangesUtil.getNavigatableArray((Project)this.myProject, this.getNavigatableFiles()));
        } else if (VcsDataKeys.IO_FILE_ARRAY.equals(key)) {
            sink.put(VcsDataKeys.IO_FILE_ARRAY, (Object)this.getSelectedIoFiles());
        } else if (VcsDataKeys.SELECTED_CHANGES_IN_DETAILS.equals(key)) {
            List<Change> selectedChanges = this.getSelectedChanges();
            sink.put(VcsDataKeys.SELECTED_CHANGES_IN_DETAILS, (Object)selectedChanges.toArray(new Change[0]));
        } else if (ChangesListView.UNVERSIONED_FILES_DATA_KEY.equals((Object)key)) {
            sink.put(ChangesListView.UNVERSIONED_FILES_DATA_KEY, ChangesListView.getVirtualFiles(this.myViewer.getSelectionPaths(), ChangesBrowserNode.UNVERSIONED_FILES_TAG));
        } else if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.equals(key)) {
            sink.put(PlatformDataKeys.DELETE_ELEMENT_PROVIDER, (Object)this.myDeleteProvider);
        } else {
            sink.put(key, this.myViewer.getData(key.getName()));
        }
    }

    public void select(List<Change> changes2) {
        this.myViewer.select(changes2);
    }

    protected void showDiffForChanges(Change[] changesArray, int indexInSelection) {
        ShowDiffContext context = new ShowDiffContext(OldChangesBrowserBase.isInFrame() ? DiffDialogHints.FRAME : DiffDialogHints.MODAL);
        context.addActions(this.createDiffActions());
        this.updateDiffContext(context);
        ShowDiffAction.showDiffForChange(this.myProject, Arrays.asList(changesArray), indexInSelection, context);
    }

    protected void updateDiffContext(@NotNull ShowDiffContext context) {
    }

    private boolean canShowDiff() {
        return ShowDiffAction.canShowDiff(this.myProject, this.getChangesSelection().getList());
    }

    private void showDiff() {
        ListSelection<Change> selection = this.getChangesSelection();
        List changes2 = selection.getList();
        Change[] changesArray = changes2.toArray(new Change[0]);
        this.showDiffForChanges(changesArray, selection.getSelectedIndex());
        this.afterDiffRefresh();
    }

    @NotNull
    private ListSelection<Change> getChangesSelection() {
        List<Change> allChanges;
        Change leadSelection = this.myViewer.getLeadSelection();
        List<Change> changes2 = this.getSelectedChanges();
        if (changes2.size() < 2 && ((allChanges = this.myViewer.getChanges()).size() > 1 || changes2.isEmpty())) {
            changes2 = allChanges;
        }
        if (leadSelection != null && !changes2.contains(leadSelection)) {
            return ListSelection.createSingleton((Object)leadSelection);
        }
        return ListSelection.create(changes2, (Object)leadSelection);
    }

    protected void afterDiffRefresh() {
    }

    private static boolean isInFrame() {
        return ModalityState.current().equals(ModalityState.NON_MODAL);
    }

    private List<AnAction> createDiffActions() {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        if (this.myCapableOfExcludingChanges) {
            actions.add((AnAction)new ToggleChangeAction());
        }
        return actions;
    }

    public void rebuildList() {
        this.myViewer.setChangesToDisplay(this.getCurrentDisplayedChanges(), this.myToSelect);
    }

    public void setAlwayExpandList(boolean value) {
        this.myViewer.setAlwaysExpandList(value);
    }

    @NotNull
    private JComponent createToolbar() {
        DefaultActionGroup toolbarGroups = new DefaultActionGroup();
        this.myToolBarGroup = new DefaultActionGroup();
        toolbarGroups.add((AnAction)this.myToolBarGroup);
        this.buildToolBar(this.myToolBarGroup);
        toolbarGroups.addSeparator();
        DefaultActionGroup treeActionsGroup = new DefaultActionGroup();
        toolbarGroups.add((AnAction)treeActionsGroup);
        for (AnAction action : this.myViewer.getTreeActions()) {
            treeActionsGroup.add(action);
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ChangesBrowser", (ActionGroup)toolbarGroups, true);
        toolbar.setTargetComponent((JComponent)this);
        return toolbar.getComponent();
    }

    protected void buildToolBar(DefaultActionGroup toolBarGroup) {
        this.myDiffAction = new DumbAwareAction(){

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setEnabled(OldChangesBrowserBase.this.canShowDiff() || e.getInputEvent() instanceof KeyEvent);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                OldChangesBrowserBase.this.showDiff();
            }
        };
        ActionUtil.copyFrom((AnAction)this.myDiffAction, (String)"Diff.ShowDiff");
        this.myDiffAction.registerCustomShortcutSet(this.myViewer, null);
        toolBarGroup.add(this.myDiffAction);
    }

    @NotNull
    private List<Change> getCurrentDisplayedChanges() {
        if (this.myChangesToDisplay != null) {
            return this.myChangesToDisplay;
        }
        return this.mySelectedChangeList != null ? ContainerUtil.newArrayList((Iterable)this.mySelectedChangeList.getChanges()) : Collections.emptyList();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myViewer.getPreferredFocusedComponent();
    }

    private ChangeList[] getSelectedChangeLists() {
        if (this.mySelectedChangeList != null) {
            return new ChangeList[]{this.mySelectedChangeList};
        }
        return null;
    }

    private File[] getSelectedIoFiles() {
        List<Change> changes2 = this.getSelectedChanges();
        ArrayList<File> files2 = new ArrayList<File>();
        for (Change change : changes2) {
            ContentRevision afterRevision = change.getAfterRevision();
            if (afterRevision == null) continue;
            FilePath file2 = afterRevision.getFile();
            File ioFile = file2.getIOFile();
            files2.add(ioFile);
        }
        return files2.toArray(new File[0]);
    }

    @NotNull
    public List<Change> getSelectedChanges() {
        return this.myViewer.getSelectedChanges();
    }

    @NotNull
    private Stream<VirtualFile> getSelectedFiles() {
        return Stream.concat(ChangesUtil.getAfterRevisionsFiles(this.getSelectedChanges().stream()), ChangesListView.getVirtualFiles(this.myViewer.getSelectionPaths(), null)).distinct();
    }

    @NotNull
    private Stream<VirtualFile> getNavigatableFiles() {
        return Stream.concat(ChangesUtil.getFiles(this.getSelectedChanges().stream()), ChangesListView.getVirtualFiles(this.myViewer.getSelectionPaths(), null)).distinct();
    }

    public AnAction getDiffAction() {
        return this.myDiffAction;
    }

    private class ToggleChangeAction
    extends CheckboxAction {
        ToggleChangeAction() {
            super(VcsBundle.message((String)"commit.dialog.include.action.name", (Object[])new Object[0]));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Change change = (Change)e.getData(VcsDataKeys.CURRENT_CHANGE);
            if (change == null) {
                return false;
            }
            return OldChangesBrowserBase.this.myViewer.isIncluded(change);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Change change = (Change)e.getData(VcsDataKeys.CURRENT_CHANGE);
            if (change == null) {
                return;
            }
            if (state) {
                OldChangesBrowserBase.this.myViewer.includeChange(change);
            } else {
                OldChangesBrowserBase.this.myViewer.excludeChange(change);
            }
        }
    }
}

