/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.ex.ExclusionState;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PartiallyExcludedFilesStateHolder<T>
implements Disposable {
    @NotNull
    protected final MergingUpdateQueue myUpdateQueue = new MergingUpdateQueue(PartiallyExcludedFilesStateHolder.class.getName(), 300, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this);
    private final Set<T> myIncludedElements = new THashSet();
    private final Map<T, ExclusionState> myTrackerExclusionStates = new HashMap<T, ExclusionState>();
    @NotNull
    private String myChangelistId;

    public PartiallyExcludedFilesStateHolder(@NotNull Project project, @NotNull String changelistId) {
        this.myChangelistId = changelistId;
        MyTrackerListener trackerListener = new MyTrackerListener();
        MyTrackerManagerListener trackerManagerListener = new MyTrackerManagerListener(trackerListener, this);
        trackerManagerListener.install(project);
    }

    public void dispose() {
    }

    @NotNull
    protected abstract Stream<? extends T> getTrackableElementsStream();

    @Nullable
    protected abstract T findElementFor(@NotNull PartialLocalLineStatusTracker var1);

    @Nullable
    protected abstract PartialLocalLineStatusTracker findTrackerFor(@NotNull T var1);

    @NotNull
    private Stream<Pair<T, PartialLocalLineStatusTracker>> getTrackersStream() {
        return this.getTrackableElementsStream().map(element -> {
            PartialLocalLineStatusTracker tracker = this.findTrackerFor(element);
            if (tracker != null) {
                return Pair.create((Object)element, (Object)tracker);
            }
            return null;
        }).filter(Objects::nonNull);
    }

    public void setChangelistId(@NotNull String changelistId) {
        this.myChangelistId = changelistId;
        this.updateExclusionStates();
    }

    public void updateExclusionStates() {
        this.myTrackerExclusionStates.clear();
        this.getTrackersStream().forEach(pair -> {
            Object element = pair.first;
            PartialLocalLineStatusTracker tracker = (PartialLocalLineStatusTracker)pair.second;
            ExclusionState state = tracker.getExcludedFromCommitState(this.myChangelistId);
            if (state != ExclusionState.NO_CHANGES) {
                this.myTrackerExclusionStates.put(element, state);
            }
        });
    }

    @NotNull
    public ExclusionState getExclusionState(@NotNull T element) {
        ExclusionState exclusionState = this.myTrackerExclusionStates.get(element);
        if (exclusionState != null) {
            return exclusionState;
        }
        return this.myIncludedElements.contains(element) ? ExclusionState.ALL_INCLUDED : ExclusionState.ALL_EXCLUDED;
    }

    private void scheduleExclusionStatesUpdate() {
        this.myUpdateQueue.queue(new Update("updateExcludedFromCommit"){

            public void run() {
                PartiallyExcludedFilesStateHolder.this.updateExclusionStates();
            }
        });
    }

    public boolean isIncluded(@NotNull T element) {
        ExclusionState trackerState = this.getExclusionState(element);
        return trackerState != ExclusionState.ALL_EXCLUDED;
    }

    @NotNull
    public Set<T> getIncludedSet() {
        HashSet<T> set2 = new HashSet<T>(this.myIncludedElements);
        for (Map.Entry<T, ExclusionState> entry : this.myTrackerExclusionStates.entrySet()) {
            T element = entry.getKey();
            ExclusionState trackerState = entry.getValue();
            if (trackerState == ExclusionState.ALL_EXCLUDED) {
                set2.remove(element);
                continue;
            }
            set2.add(element);
        }
        return set2;
    }

    public void setIncludedElements(@NotNull Collection<? extends T> elements) {
        HashSet set2 = new HashSet(elements);
        this.getTrackersStream().forEach(pair -> {
            Object element = pair.first;
            PartialLocalLineStatusTracker tracker = (PartialLocalLineStatusTracker)pair.second;
            tracker.setExcludedFromCommit(!set2.contains(element));
        });
        this.myIncludedElements.clear();
        this.myIncludedElements.addAll(elements);
        this.updateExclusionStates();
    }

    public void includeElements(@NotNull Collection<? extends T> elements) {
        for (T element : elements) {
            PartialLocalLineStatusTracker tracker = this.findTrackerFor(element);
            if (tracker == null) continue;
            tracker.setExcludedFromCommit(false);
        }
        this.myIncludedElements.addAll(elements);
        this.updateExclusionStates();
    }

    public void excludeElements(@NotNull Collection<? extends T> elements) {
        for (T element : elements) {
            PartialLocalLineStatusTracker tracker = this.findTrackerFor(element);
            if (tracker == null) continue;
            tracker.setExcludedFromCommit(true);
        }
        this.myIncludedElements.removeAll(elements);
        this.updateExclusionStates();
    }

    public void toggleElements(@NotNull Collection<? extends T> elements) {
        boolean hasExcluded = false;
        for (T element : elements) {
            ExclusionState exclusionState = this.getExclusionState(element);
            if (exclusionState == ExclusionState.ALL_INCLUDED) continue;
            hasExcluded = true;
            break;
        }
        if (hasExcluded) {
            this.includeElements(elements);
        } else {
            this.excludeElements(elements);
        }
    }

    private class MyTrackerManagerListener
    extends LineStatusTrackerManager.ListenerAdapter {
        @NotNull
        private final PartialLocalLineStatusTracker.Listener myTrackerListener;
        @NotNull
        private final Disposable myDisposable;

        MyTrackerManagerListener(@NotNull PartialLocalLineStatusTracker.Listener listener2, Disposable disposable) {
            this.myTrackerListener = listener2;
            this.myDisposable = disposable;
        }

        public void install(@NotNull Project project) {
            LineStatusTrackerManager.getInstanceImpl(project).addTrackerListener(this, this.myDisposable);
            for (LineStatusTracker<?> tracker : LineStatusTrackerManager.getInstanceImpl(project).getTrackers()) {
                if (!(tracker instanceof PartialLocalLineStatusTracker)) continue;
                PartialLocalLineStatusTracker partialTracker = (PartialLocalLineStatusTracker)tracker;
                partialTracker.addListener(this.myTrackerListener, this.myDisposable);
            }
        }

        @Override
        public void onTrackerAdded(@NotNull LineStatusTracker<?> tracker) {
            if (tracker instanceof PartialLocalLineStatusTracker) {
                PartialLocalLineStatusTracker partialTracker = (PartialLocalLineStatusTracker)tracker;
                Object element = PartiallyExcludedFilesStateHolder.this.findElementFor(partialTracker);
                if (element != null) {
                    partialTracker.setExcludedFromCommit(!PartiallyExcludedFilesStateHolder.this.myIncludedElements.contains(element));
                }
                partialTracker.addListener(this.myTrackerListener, this.myDisposable);
            }
        }

        @Override
        public void onTrackerRemoved(@NotNull LineStatusTracker<?> tracker) {
            PartialLocalLineStatusTracker partialTracker;
            Object element;
            if (tracker instanceof PartialLocalLineStatusTracker && (element = PartiallyExcludedFilesStateHolder.this.findElementFor(partialTracker = (PartialLocalLineStatusTracker)tracker)) != null) {
                PartiallyExcludedFilesStateHolder.this.myTrackerExclusionStates.remove(element);
                ExclusionState exclusionState = partialTracker.getExcludedFromCommitState(PartiallyExcludedFilesStateHolder.this.myChangelistId);
                if (exclusionState != ExclusionState.NO_CHANGES) {
                    if (exclusionState != ExclusionState.ALL_EXCLUDED) {
                        PartiallyExcludedFilesStateHolder.this.myIncludedElements.add(element);
                    } else {
                        PartiallyExcludedFilesStateHolder.this.myIncludedElements.remove(element);
                    }
                }
                PartiallyExcludedFilesStateHolder.this.scheduleExclusionStatesUpdate();
            }
        }
    }

    private class MyTrackerListener
    extends PartialLocalLineStatusTracker.ListenerAdapter {
        private MyTrackerListener() {
        }

        @Override
        public void onExcludedFromCommitChange(@NotNull PartialLocalLineStatusTracker tracker) {
            PartiallyExcludedFilesStateHolder.this.scheduleExclusionStatesUpdate();
        }

        @Override
        public void onChangeListMarkerChange(@NotNull PartialLocalLineStatusTracker tracker) {
            PartiallyExcludedFilesStateHolder.this.scheduleExclusionStatesUpdate();
        }
    }
}

