/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.actions.DeleteAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ui.AbstractSelectFilesDialog;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectFilesDialog
extends AbstractSelectFilesDialog {
    @NotNull
    private final VirtualFileList myFileList;
    private final boolean myDeletableFiles;

    @Deprecated
    protected SelectFilesDialog(Project project, @NotNull List<? extends VirtualFile> files2, @Nullable String prompt, @Nullable VcsShowConfirmationOption confirmationOption, boolean selectableFiles, boolean showDoNotAskOption, boolean deletableFiles) {
        this(project, files2, prompt, (VcsShowConfirmationOption)(showDoNotAskOption ? confirmationOption : null), selectableFiles, deletableFiles);
    }

    protected SelectFilesDialog(Project project, @NotNull List<? extends VirtualFile> files2, @Nullable String prompt, @Nullable VcsShowConfirmationOption confirmationOption, boolean selectableFiles, boolean deletableFiles) {
        super(project, false, confirmationOption, prompt);
        this.myDeletableFiles = deletableFiles;
        this.myFileList = new VirtualFileList(project, selectableFiles, deletableFiles, files2);
    }

    @Deprecated
    @NotNull
    public static SelectFilesDialog init(Project project, @NotNull List<? extends VirtualFile> originalFiles, @Nullable String prompt, @Nullable VcsShowConfirmationOption confirmationOption, boolean selectableFiles, boolean showDoNotAskOption, boolean deletableFiles) {
        return SelectFilesDialog.init(project, originalFiles, prompt, (VcsShowConfirmationOption)(showDoNotAskOption ? confirmationOption : null), selectableFiles, deletableFiles);
    }

    @NotNull
    public static SelectFilesDialog init(Project project, @NotNull List<? extends VirtualFile> originalFiles, @Nullable String prompt, @Nullable VcsShowConfirmationOption confirmationOption, boolean selectableFiles, boolean deletableFiles) {
        SelectFilesDialog dialog2 = new SelectFilesDialog(project, originalFiles, prompt, confirmationOption, selectableFiles, deletableFiles);
        dialog2.init();
        return dialog2;
    }

    @NotNull
    public static SelectFilesDialog init(Project project, @NotNull List<? extends VirtualFile> originalFiles, @Nullable String prompt, @Nullable VcsShowConfirmationOption confirmationOption, boolean selectableFiles, boolean deletableFiles, @NotNull String okActionName, @NotNull String cancelActionName) {
        SelectFilesDialog dlg = SelectFilesDialog.init(project, originalFiles, prompt, confirmationOption, selectableFiles, deletableFiles);
        dlg.setOKButtonText(okActionName);
        dlg.setCancelButtonText(cancelActionName);
        return dlg;
    }

    public Collection<VirtualFile> getSelectedFiles() {
        return this.myFileList.getIncludedChanges();
    }

    public void setSelectedFiles(@NotNull Collection<VirtualFile> selected) {
        this.myFileList.setIncludedChanges(selected);
        this.myFileList.rebuildTree();
    }

    @Override
    @NotNull
    protected ChangesTree getFileList() {
        return this.myFileList;
    }

    @Override
    @NotNull
    protected DefaultActionGroup createToolbarActions() {
        DefaultActionGroup defaultGroup = super.createToolbarActions();
        if (this.myDeletableFiles) {
            DeleteAction deleteAction = new DeleteAction(null, null, IconUtil.getRemoveIcon()){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    super.actionPerformed(e);
                    SelectFilesDialog.this.myFileList.refresh();
                }
            };
            EmptyAction.setupAction((AnAction)deleteAction, (String)"$Delete", (JComponent)((Object)this.getFileList()));
            defaultGroup.add((AnAction)deleteAction);
        }
        return defaultGroup;
    }

    public static class VirtualFileList
    extends ChangesTreeImpl.VirtualFiles {
        @Nullable
        private final DeleteProvider myDeleteProvider;

        public VirtualFileList(Project project, boolean selectableFiles, boolean deletableFiles, @NotNull List<? extends VirtualFile> files2) {
            super(project, selectableFiles, true, files2);
            this.myDeleteProvider = deletableFiles ? new VirtualFileDeleteProvider() : null;
        }

        @Override
        @Nullable
        public Object getData(@NotNull String dataId) {
            if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) && this.myDeleteProvider != null) {
                return this.myDeleteProvider;
            }
            if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
                return this.getSelectedChanges().toArray(VirtualFile.EMPTY_ARRAY);
            }
            return super.getData(dataId);
        }

        public void refresh() {
            this.setChangesToDisplay(ContainerUtil.filter(this.getChanges(), VirtualFile::isValid));
        }
    }
}

