/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeActionsToolbarPanel
extends JPanel {
    public TreeActionsToolbarPanel(@NotNull ActionToolbar toolbar, @NotNull ChangesTree tree) {
        this(toolbar.getComponent(), tree);
        toolbar.setTargetComponent((JComponent)((Object)tree));
    }

    public TreeActionsToolbarPanel(@NotNull ActionToolbar toolbar, @NotNull ActionGroup group, @Nullable JComponent targetComponent) {
        this(toolbar.getComponent(), group, targetComponent);
        if (targetComponent != null) {
            toolbar.setTargetComponent(targetComponent);
        }
    }

    public TreeActionsToolbarPanel(@NotNull Component toolbarComponent, @NotNull ChangesTree tree) {
        this(toolbarComponent, (ActionGroup)new DefaultActionGroup(TreeActionsToolbarPanel.createTreeActions(tree)), (JComponent)((Object)tree));
    }

    public TreeActionsToolbarPanel(@NotNull Component toolbarComponent, @NotNull ActionGroup group, @Nullable JComponent targetComponent) {
        super(new BorderLayout());
        ActionToolbar additionalToolbar = ActionManager.getInstance().createActionToolbar("TreeActionsToolbar", group, true);
        additionalToolbar.setTargetComponent((JComponent)ObjectUtils.notNull((Object)targetComponent, (Object)this));
        additionalToolbar.setReservePlaceAutoPopupIcon(false);
        this.add(toolbarComponent, "Center");
        this.add((Component)additionalToolbar.getComponent(), "East");
    }

    @NotNull
    public static List<AnAction> createTreeActions(@NotNull ChangesTree tree) {
        return Arrays.asList(tree.createExpandAllAction(true), tree.createCollapseAllAction(true));
    }
}

