/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.ui.BaseChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangeListRemoteState;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserIgnoredFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserModuleNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserSpecificFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserUnversionedFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.RemoteStatusChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.openapi.vcs.changes.ui.VirtualFileHierarchicalComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeModelBuilder {
    public static final Key<Function<StaticFilePath, ChangesBrowserNode<?>>> PATH_NODE_BUILDER = Key.create((String)"ChangesTree.PathNodeBuilder");
    public static final NotNullLazyKey<Map<String, ChangesBrowserNode<?>>, ChangesBrowserNode<?>> DIRECTORY_CACHE = NotNullLazyKey.create((String)"ChangesTree.DirectoryCache", node -> ContainerUtil.newHashMap());
    private static final Key<ChangesGroupingPolicy> GROUPING_POLICY = Key.create((String)"ChangesTree.GroupingPolicy");
    public static final Key<Boolean> IS_CACHING_ROOT = Key.create((String)"ChangesTree.IsCachingRoot");
    protected final Project myProject;
    @NotNull
    protected final DefaultTreeModel myModel;
    @NotNull
    protected final ChangesBrowserNode myRoot;
    @NotNull
    private final ChangesGroupingPolicyFactory myGroupingPolicyFactory;
    private static final Comparator<ChangesBrowserNode> BROWSER_NODE_COMPARATOR = (node1, node2) -> {
        Class<?> clazz2;
        int sortWeightDiff = Comparing.compare((int)node1.getSortWeight(), (int)node2.getSortWeight());
        if (sortWeightDiff != 0) {
            return sortWeightDiff;
        }
        Class<?> clazz1 = node1.getClass();
        if (!clazz1.equals(clazz2 = node2.getClass())) {
            return Comparing.compare((Comparable)((Object)clazz1.getName()), (Comparable)((Object)clazz2.getName()));
        }
        if (node1 instanceof Comparable) {
            return ((Comparable)((Object)node1)).compareTo(node2);
        }
        return node1.compareUserObjects(node2.getUserObject());
    };
    protected static final Comparator<FilePath> PATH_COMPARATOR = Comparator.comparingInt(path -> path.getPath().length());
    protected static final Comparator<Change> CHANGE_COMPARATOR = Comparator.comparing(ChangesUtil::getFilePath, PATH_COMPARATOR);

    @Deprecated
    public TreeModelBuilder(@NotNull Project project, boolean showFlatten) {
        this(project, ChangesGroupingSupport.getFactory(project, showFlatten ? "none" : "directory"));
    }

    public TreeModelBuilder(Project project, @NotNull ChangesGroupingPolicyFactory grouping2) {
        this.myProject = project != null && !project.isDefault() ? project : null;
        this.myRoot = ChangesBrowserNode.createRoot();
        this.myModel = new DefaultTreeModel(this.myRoot);
        this.myGroupingPolicyFactory = grouping2;
    }

    @NotNull
    public static DefaultTreeModel buildEmpty() {
        return new DefaultTreeModel(ChangesBrowserNode.createRoot());
    }

    @Deprecated
    @NotNull
    public static DefaultTreeModel buildFromChanges(@NotNull Project project, boolean showFlatten, @NotNull Collection<? extends Change> changes2, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        return new TreeModelBuilder(project, showFlatten).setChanges(changes2, changeNodeDecorator).build();
    }

    @NotNull
    public static DefaultTreeModel buildFromChanges(@Nullable Project project, @NotNull ChangesGroupingPolicyFactory grouping2, @NotNull Collection<? extends Change> changes2, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        return new TreeModelBuilder(project, grouping2).setChanges(changes2, changeNodeDecorator).build();
    }

    @NotNull
    public static DefaultTreeModel buildFromFilePaths(@Nullable Project project, @NotNull ChangesGroupingPolicyFactory grouping2, @NotNull Collection<? extends FilePath> filePaths) {
        return new TreeModelBuilder(project, grouping2).setFilePaths(filePaths).build();
    }

    @NotNull
    public static DefaultTreeModel buildFromChangeLists(@NotNull Project project, @NotNull ChangesGroupingPolicyFactory grouping2, @NotNull Collection<? extends ChangeList> changeLists) {
        return TreeModelBuilder.buildFromChangeLists(project, grouping2, changeLists, false);
    }

    @NotNull
    public static DefaultTreeModel buildFromChangeLists(@NotNull Project project, @NotNull ChangesGroupingPolicyFactory grouping2, @NotNull Collection<? extends ChangeList> changeLists, boolean skipSingleDefaultChangelist) {
        return new TreeModelBuilder(project, grouping2).setChangeLists(changeLists, skipSingleDefaultChangelist).build();
    }

    @NotNull
    public static DefaultTreeModel buildFromVirtualFiles(@Nullable Project project, @NotNull ChangesGroupingPolicyFactory grouping2, @NotNull Collection<? extends VirtualFile> virtualFiles) {
        return new TreeModelBuilder(project, grouping2).setVirtualFiles(virtualFiles, null).build();
    }

    @NotNull
    public TreeModelBuilder setChanges(@NotNull Collection<? extends Change> changes2, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        return this.setChanges(changes2, changeNodeDecorator, null);
    }

    @NotNull
    public TreeModelBuilder setChanges(@NotNull Collection<? extends Change> changes2, @Nullable ChangeNodeDecorator changeNodeDecorator, @Nullable Object tag) {
        ChangesBrowserNode parentNode = this.createTagNode(tag);
        List sortedChanges = ContainerUtil.sorted(changes2, CHANGE_COMPARATOR);
        for (Change change : sortedChanges) {
            this.insertChangeNode(change, parentNode, this.createChangeNode(change, changeNodeDecorator));
        }
        return this;
    }

    @NotNull
    public TreeModelBuilder setUnversioned(@Nullable List<VirtualFile> unversionedFiles) {
        assert (this.myProject != null);
        if (ContainerUtil.isEmpty(unversionedFiles)) {
            return this;
        }
        ChangesBrowserUnversionedFilesNode node = new ChangesBrowserUnversionedFilesNode(this.myProject, unversionedFiles);
        return this.insertSpecificNodeToModel(unversionedFiles, node);
    }

    @NotNull
    public TreeModelBuilder setIgnored(@Nullable List<VirtualFile> ignoredFiles, boolean updatingMode) {
        assert (this.myProject != null);
        if (ContainerUtil.isEmpty(ignoredFiles)) {
            return this;
        }
        ChangesBrowserIgnoredFilesNode node = new ChangesBrowserIgnoredFilesNode(this.myProject, ignoredFiles, updatingMode);
        return this.insertSpecificNodeToModel(ignoredFiles, node);
    }

    @NotNull
    private TreeModelBuilder insertSpecificNodeToModel(@NotNull List<? extends VirtualFile> specificFiles, @NotNull ChangesBrowserSpecificFilesNode node) {
        this.myModel.insertNodeInto(node, this.myRoot, this.myRoot.getChildCount());
        if (!node.isManyFiles()) {
            node.markAsHelperNode();
            this.insertFilesIntoNode(specificFiles, node);
        }
        return this;
    }

    @NotNull
    public TreeModelBuilder setChangeLists(@NotNull Collection<? extends ChangeList> changeLists, boolean skipSingleDefaultChangeList) {
        assert (this.myProject != null);
        RemoteRevisionsCache revisionsCache = RemoteRevisionsCache.getInstance(this.myProject);
        boolean skipChangeListNode = skipSingleDefaultChangeList && TreeModelBuilder.isSingleBlankChangeList(changeLists);
        for (ChangeList changeList : changeLists) {
            ChangesBrowserNode changesParent;
            List changes2 = ContainerUtil.sorted((Collection)changeList.getChanges(), CHANGE_COMPARATOR);
            ChangeListRemoteState listRemoteState = new ChangeListRemoteState(changes2.size());
            if (!skipChangeListNode) {
                ChangesBrowserChangeListNode listNode = new ChangesBrowserChangeListNode(this.myProject, changeList, listRemoteState);
                listNode.markAsHelperNode();
                this.myModel.insertNodeInto(listNode, this.myRoot, 0);
                changesParent = listNode;
            } else {
                changesParent = this.myRoot;
            }
            for (int i = 0; i < changes2.size(); ++i) {
                Change change = (Change)changes2.get(i);
                RemoteStatusChangeNodeDecorator decorator = new RemoteStatusChangeNodeDecorator(revisionsCache, listRemoteState, i);
                this.insertChangeNode(change, changesParent, this.createChangeNode(change, decorator));
            }
        }
        return this;
    }

    private static boolean isSingleBlankChangeList(Collection<? extends ChangeList> lists) {
        if (lists.size() != 1) {
            return false;
        }
        ChangeList single = lists.iterator().next();
        if (!(single instanceof LocalChangeList)) {
            return false;
        }
        return ((LocalChangeList)single).isBlank();
    }

    protected ChangesBrowserNode createChangeNode(Change change, ChangeNodeDecorator decorator) {
        return new ChangesBrowserChangeNode(this.myProject, change, decorator);
    }

    @NotNull
    public TreeModelBuilder setLockedFolders(@Nullable List<? extends VirtualFile> lockedFolders) {
        assert (this.myProject != null);
        if (ContainerUtil.isEmpty(lockedFolders)) {
            return this;
        }
        this.insertFilesIntoNode(lockedFolders, ChangesBrowserNode.createLockedFolders(this.myProject));
        return this;
    }

    @NotNull
    public TreeModelBuilder setModifiedWithoutEditing(@NotNull List<? extends VirtualFile> modifiedWithoutEditing) {
        return this.setVirtualFiles(modifiedWithoutEditing, ChangesBrowserNode.MODIFIED_WITHOUT_EDITING_TAG);
    }

    @NotNull
    private TreeModelBuilder setVirtualFiles(@Nullable Collection<? extends VirtualFile> files2, @Nullable Object tag) {
        if (ContainerUtil.isEmpty(files2)) {
            return this;
        }
        this.insertFilesIntoNode(files2, this.createTagNode(tag));
        return this;
    }

    @NotNull
    protected ChangesBrowserNode createTagNode(@Nullable Object tag) {
        if (tag == null) {
            return this.myRoot;
        }
        ChangesBrowserNode subtreeRoot = ChangesBrowserNode.createObject(tag);
        subtreeRoot.markAsHelperNode();
        this.myModel.insertNodeInto(subtreeRoot, this.myRoot, this.myRoot.getChildCount());
        return subtreeRoot;
    }

    private void insertFilesIntoNode(@NotNull Collection<? extends VirtualFile> files2, @NotNull ChangesBrowserNode subtreeRoot) {
        List sortedFiles = ContainerUtil.sorted(files2, (Comparator)VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile file2 : sortedFiles) {
            this.insertChangeNode(file2, subtreeRoot, ChangesBrowserNode.createFile(this.myProject, file2));
        }
    }

    @NotNull
    public TreeModelBuilder setLocallyDeletedPaths(@Nullable Collection<? extends LocallyDeletedChange> locallyDeletedChanges) {
        if (ContainerUtil.isEmpty(locallyDeletedChanges)) {
            return this;
        }
        ChangesBrowserNode subtreeRoot = this.createTagNode(ChangesBrowserNode.LOCALLY_DELETED_NODE_TAG);
        for (LocallyDeletedChange change : ContainerUtil.sorted(locallyDeletedChanges, Comparator.comparing(LocallyDeletedChange::getPath, PATH_COMPARATOR))) {
            this.insertChangeNode(change, subtreeRoot, ChangesBrowserNode.createLocallyDeleted(change));
        }
        return this;
    }

    @NotNull
    public TreeModelBuilder setFilePaths(@NotNull Collection<? extends FilePath> filePaths) {
        return this.setFilePaths(filePaths, this.myRoot);
    }

    @NotNull
    private TreeModelBuilder setFilePaths(@NotNull Collection<? extends FilePath> filePaths, @NotNull ChangesBrowserNode subtreeRoot) {
        for (FilePath file2 : ContainerUtil.sorted(filePaths, PATH_COMPARATOR)) {
            assert (file2 != null);
            this.insertChangeNode(file2, subtreeRoot, ChangesBrowserNode.createFilePath(file2));
        }
        return this;
    }

    @NotNull
    public TreeModelBuilder setSwitchedRoots(@Nullable Map<VirtualFile, String> switchedRoots) {
        if (ContainerUtil.isEmpty(switchedRoots)) {
            return this;
        }
        ChangesBrowserNode rootsHeadNode = this.createTagNode(ChangesBrowserNode.SWITCHED_ROOTS_TAG);
        rootsHeadNode.setAttributes(SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        List files2 = ContainerUtil.sorted(switchedRoots.keySet(), (Comparator)VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile vf : files2) {
            CurrentContentRevision cr = new CurrentContentRevision(VcsUtil.getFilePath((VirtualFile)vf));
            Change change = new Change((ContentRevision)cr, (ContentRevision)cr, FileStatus.NOT_CHANGED);
            final String branchName = switchedRoots.get(vf);
            this.insertChangeNode(vf, rootsHeadNode, this.createChangeNode(change, new ChangeNodeDecorator(){

                @Override
                public void decorate(Change change1, SimpleColoredComponent component, boolean isShowFlatten) {
                }

                @Override
                public void preDecorate(Change change1, ChangesBrowserNodeRenderer renderer2, boolean showFlatten) {
                    renderer2.append("[" + branchName + "] ", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
                }
            }));
        }
        return this;
    }

    @NotNull
    public TreeModelBuilder setSwitchedFiles(@NotNull MultiMap<String, VirtualFile> switchedFiles) {
        if (switchedFiles.isEmpty()) {
            return this;
        }
        ChangesBrowserNode subtreeRoot = this.createTagNode(ChangesBrowserNode.SWITCHED_FILES_TAG);
        for (String branchName : switchedFiles.keySet()) {
            List switchedFileList = ContainerUtil.sorted((Collection)switchedFiles.get((Object)branchName), (Comparator)VirtualFileHierarchicalComparator.getInstance());
            if (switchedFileList.size() <= 0) continue;
            ChangesBrowserNode branchNode = ChangesBrowserNode.createObject(branchName);
            branchNode.markAsHelperNode();
            this.myModel.insertNodeInto(branchNode, subtreeRoot, subtreeRoot.getChildCount());
            for (VirtualFile file2 : switchedFileList) {
                this.insertChangeNode(file2, branchNode, ChangesBrowserNode.createFile(this.myProject, file2));
            }
        }
        return this;
    }

    @NotNull
    public TreeModelBuilder setLogicallyLockedFiles(@Nullable Map<VirtualFile, LogicalLock> logicallyLockedFiles) {
        if (ContainerUtil.isEmpty(logicallyLockedFiles)) {
            return this;
        }
        ChangesBrowserNode subtreeRoot = this.createTagNode(ChangesBrowserNode.LOGICALLY_LOCKED_TAG);
        List keys = ContainerUtil.sorted(logicallyLockedFiles.keySet(), (Comparator)VirtualFileHierarchicalComparator.getInstance());
        for (VirtualFile file2 : keys) {
            LogicalLock lock = logicallyLockedFiles.get(file2);
            this.insertChangeNode(file2, subtreeRoot, ChangesBrowserNode.createLogicallyLocked(this.myProject, file2, lock));
        }
        return this;
    }

    protected void insertChangeNode(@NotNull Object change, @NotNull ChangesBrowserNode subtreeRoot, @NotNull ChangesBrowserNode node) {
        this.insertChangeNode(change, subtreeRoot, node, TreeModelBuilder::createPathNode);
    }

    protected void insertChangeNode(@NotNull Object change, @NotNull ChangesBrowserNode subtreeRoot, @NotNull ChangesBrowserNode node, @NotNull Function<StaticFilePath, ChangesBrowserNode<?>> nodeBuilder) {
        PATH_NODE_BUILDER.set((UserDataHolder)subtreeRoot, nodeBuilder);
        if (!GROUPING_POLICY.isIn((UserDataHolder)subtreeRoot)) {
            GROUPING_POLICY.set((UserDataHolder)subtreeRoot, (Object)this.myGroupingPolicyFactory.createGroupingPolicy(this.myModel));
        }
        StaticFilePath pathKey = TreeModelBuilder.getKey(change);
        ChangesBrowserNode parentNode = (ChangesBrowserNode)ReadAction.compute(() -> (ChangesBrowserNode)ObjectUtils.notNull((Object)((ChangesGroupingPolicy)GROUPING_POLICY.getRequired((UserDataHolder)subtreeRoot)).getParentNodeFor(pathKey, subtreeRoot), (Object)subtreeRoot));
        ChangesBrowserNode<?> cachingRoot = BaseChangesGroupingPolicy.getCachingRoot(parentNode, subtreeRoot);
        this.myModel.insertNodeInto(node, parentNode, this.myModel.getChildCount(parentNode));
        if (pathKey.isDirectory()) {
            ((Map)DIRECTORY_CACHE.getValue(cachingRoot)).put(pathKey.getKey(), node);
        }
    }

    @NotNull
    public DefaultTreeModel build() {
        TreeModelBuilder.collapseDirectories(this.myModel, this.myRoot);
        this.sortNodes();
        return this.myModel;
    }

    private void sortNodes() {
        TreeUtil.sort((DefaultTreeModel)this.myModel, BROWSER_NODE_COMPARATOR);
        this.myModel.nodeStructureChanged((TreeNode)this.myModel.getRoot());
    }

    private static void collapseDirectories(@NotNull DefaultTreeModel model, @NotNull ChangesBrowserNode node) {
        ChangesBrowserNode child2;
        ChangesBrowserNode collapsed;
        ChangesBrowserNode collapsedNode = node;
        while (collapsedNode.getChildCount() == 1 && (collapsed = TreeModelBuilder.collapseParentWithOnlyChild(collapsedNode, child2 = (ChangesBrowserNode)collapsedNode.getChildAt(0))) != null) {
            collapsedNode = collapsed;
        }
        if (collapsedNode != node) {
            TreeNode parent = node.getParent();
            int idx = ((DefaultMutableTreeNode)parent).getIndex(node);
            model.removeNodeFromParent(node);
            model.insertNodeInto(collapsedNode, (MutableTreeNode)parent, idx);
            node = collapsedNode;
        }
        Enumeration<TreeNode> children2 = node.children();
        while (children2.hasMoreElements()) {
            ChangesBrowserNode child3 = (ChangesBrowserNode)children2.nextElement();
            TreeModelBuilder.collapseDirectories(model, child3);
        }
    }

    @Nullable
    private static ChangesBrowserNode collapseParentWithOnlyChild(@NotNull ChangesBrowserNode parent, @NotNull ChangesBrowserNode child2) {
        if (child2.isLeaf()) {
            return null;
        }
        Object parentUserObject = parent.getUserObject();
        Object childUserObject = child2.getUserObject();
        if (parentUserObject instanceof FilePath && childUserObject instanceof FilePath) {
            return child2;
        }
        if (parent instanceof ChangesBrowserModuleNode && childUserObject instanceof FilePath) {
            FilePath childPath;
            FilePath parentPath = ((ChangesBrowserModuleNode)parent).getModuleRoot();
            if (!parentPath.equals(childPath = (FilePath)childUserObject)) {
                return null;
            }
            parent.remove(0);
            Enumeration<TreeNode> children2 = child2.children();
            for (ChangesBrowserNode childNode : ContainerUtil.toList(children2)) {
                parent.add(childNode);
            }
            return parent;
        }
        return null;
    }

    @NotNull
    private static StaticFilePath getKey(@NotNull Object o) {
        if (o instanceof Change) {
            return TreeModelBuilder.staticFrom(ChangesUtil.getFilePath((Change)((Change)o)));
        }
        if (o instanceof VirtualFile) {
            return TreeModelBuilder.staticFrom((VirtualFile)o);
        }
        if (o instanceof FilePath) {
            return TreeModelBuilder.staticFrom((FilePath)o);
        }
        if (o instanceof LocallyDeletedChange) {
            return TreeModelBuilder.staticFrom(((LocallyDeletedChange)o).getPath());
        }
        throw new IllegalArgumentException("Unknown type - " + o.getClass());
    }

    @NotNull
    public static StaticFilePath staticFrom(@NotNull FilePath fp) {
        return new StaticFilePath(fp.isDirectory(), fp.getPath(), fp.getVirtualFile());
    }

    @NotNull
    public static StaticFilePath staticFrom(@NotNull VirtualFile vf) {
        return new StaticFilePath(vf.isDirectory(), vf.getPath(), vf);
    }

    @NotNull
    public static FilePath getPathForObject(@NotNull Object o) {
        if (o instanceof Change) {
            return ChangesUtil.getFilePath((Change)((Change)o));
        }
        if (o instanceof VirtualFile) {
            return VcsUtil.getFilePath((VirtualFile)((VirtualFile)o));
        }
        if (o instanceof FilePath) {
            return (FilePath)o;
        }
        if (o instanceof LocallyDeletedChange) {
            return ((LocallyDeletedChange)o).getPath();
        }
        throw new IllegalArgumentException("Unknown type - " + o.getClass());
    }

    @NotNull
    private static ChangesBrowserNode createPathNode(@NotNull StaticFilePath path) {
        FilePath filePath = VcsUtil.getFilePath((String)path.getPath(), (boolean)path.isDirectory());
        return ChangesBrowserNode.createFilePath(filePath);
    }

    public boolean isEmpty() {
        return this.myModel.getChildCount(this.myRoot) == 0;
    }

    @Deprecated
    @NotNull
    public DefaultTreeModel buildModel(@NotNull List<? extends Change> changes2, @Nullable ChangeNodeDecorator changeNodeDecorator) {
        return this.setChanges(changes2, changeNodeDecorator).build();
    }
}

