/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsTreeModelData {
    @NotNull
    public static VcsTreeModelData all(@NotNull JTree tree) {
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        ChangesBrowserNode root = (ChangesBrowserNode)tree.getModel().getRoot();
        return new AllUnderData(root);
    }

    @NotNull
    public static VcsTreeModelData selected(@NotNull JTree tree) {
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        return new SelectedData(tree);
    }

    @NotNull
    public static VcsTreeModelData exactlySelected(@NotNull JTree tree) {
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        return new ExactlySelectedData(tree);
    }

    @NotNull
    public static VcsTreeModelData included(@NotNull ChangesTree tree) {
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        ChangesBrowserNode root = (ChangesBrowserNode)tree.getModel().getRoot();
        return new IncludedUnderData(tree, root);
    }

    @NotNull
    public static VcsTreeModelData children(@NotNull ChangesBrowserNode<?> node) {
        return new AllUnderData(node);
    }

    @NotNull
    public static VcsTreeModelData allUnderTag(@NotNull JTree tree, @NotNull Object tag) {
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        ChangesBrowserNode<?> tagNode = VcsTreeModelData.findTagNode(tree, tag);
        if (tagNode == null) {
            return new EmptyData();
        }
        return new AllUnderData(tagNode);
    }

    @NotNull
    public static VcsTreeModelData selectedUnderTag(@NotNull JTree tree, @NotNull Object tag) {
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        return new SelectedTagData(tree, tag);
    }

    @NotNull
    public static VcsTreeModelData includedUnderTag(@NotNull ChangesTree tree, @NotNull Object tag) {
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        ChangesBrowserNode<?> tagNode = VcsTreeModelData.findTagNode((JTree)((Object)tree), tag);
        if (tagNode == null) {
            return new EmptyData();
        }
        return new IncludedUnderData(tree, tagNode);
    }

    @NotNull
    public abstract Stream<ChangesBrowserNode> rawNodesStream();

    @NotNull
    public Stream<ChangesBrowserNode> nodesStream() {
        return this.rawNodesStream().filter(ChangesBrowserNode::isMeaningfulNode);
    }

    @NotNull
    public Stream<Object> rawUserObjectsStream() {
        return this.rawUserObjectsStream(Object.class);
    }

    @NotNull
    public <U> Stream<U> rawUserObjectsStream(@NotNull Class<U> clazz) {
        return this.rawNodesStream().map(ChangesBrowserNode::getUserObject).filter(clazz::isInstance);
    }

    @NotNull
    public Stream<Object> userObjectsStream() {
        return this.userObjectsStream(Object.class);
    }

    @NotNull
    public <U> Stream<U> userObjectsStream(@NotNull Class<U> clazz) {
        return this.nodesStream().map(ChangesBrowserNode::getUserObject).filter(clazz::isInstance);
    }

    @NotNull
    public List<Object> userObjects() {
        return this.userObjectsStream().collect(Collectors.toList());
    }

    @NotNull
    public <U> List<U> userObjects(@NotNull Class<U> clazz) {
        return this.userObjectsStream(clazz).collect(Collectors.toList());
    }

    @NotNull
    public static ListSelection<Object> getListSelectionOrAll(@NotNull JTree tree) {
        List<Object> allEntries;
        List<Object> entries2 = VcsTreeModelData.selected(tree).userObjects();
        Object selection = ContainerUtil.getFirstItem(entries2);
        if (entries2.size() < 2 && ((allEntries = VcsTreeModelData.all(tree).userObjects()).size() > 1 || entries2.isEmpty())) {
            entries2 = allEntries;
        }
        int index = ContainerUtil.indexOfIdentity(entries2, (Object)selection);
        return ListSelection.createAt(entries2, (int)index);
    }

    @Nullable
    public static Object getData(@Nullable Project project, @NotNull JTree tree, @NotNull String dataId) {
        if (VcsDataKeys.CHANGES.is(dataId)) {
            Change[] changes2 = (Change[])VcsTreeModelData.mapToChange(VcsTreeModelData.selected(tree)).toArray(Change[]::new);
            if (changes2.length != 0) {
                return changes2;
            }
            return VcsTreeModelData.mapToChange(VcsTreeModelData.all(tree)).toArray(Change[]::new);
        }
        if (VcsDataKeys.SELECTED_CHANGES.is(dataId) || VcsDataKeys.SELECTED_CHANGES_IN_DETAILS.is(dataId)) {
            return VcsTreeModelData.mapToChange(VcsTreeModelData.selected(tree)).toArray(Change[]::new);
        }
        if (VcsDataKeys.CHANGES_SELECTION.is(dataId)) {
            return VcsTreeModelData.getListSelectionOrAll(tree).map(entry -> (Change)ObjectUtils.tryCast((Object)entry, Change.class));
        }
        if (VcsDataKeys.CHANGE_LEAD_SELECTION.is(dataId)) {
            return VcsTreeModelData.mapToChange(VcsTreeModelData.exactlySelected(tree)).limit(1L).toArray(Change[]::new);
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            return VcsTreeModelData.mapToVirtualFile(VcsTreeModelData.selected(tree)).toArray(VirtualFile[]::new);
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            if (project == null) {
                return null;
            }
            return ChangesUtil.getNavigatableArray((Project)project, VcsTreeModelData.mapToNavigatableFile(VcsTreeModelData.selected(tree)));
        }
        if (VcsDataKeys.IO_FILE_ARRAY.is(dataId)) {
            return VcsTreeModelData.mapToIoFile(VcsTreeModelData.selected(tree)).toArray(File[]::new);
        }
        return null;
    }

    @NotNull
    private static Stream<Change> mapToChange(@NotNull VcsTreeModelData data) {
        return data.userObjectsStream().filter(it -> it instanceof Change).map(entry -> (Change)entry);
    }

    @NotNull
    private static Stream<VirtualFile> mapToNavigatableFile(@NotNull VcsTreeModelData data) {
        return data.userObjectsStream().flatMap(entry -> {
            if (entry instanceof Change) {
                return ChangesUtil.getPathsCaseSensitive((Change)((Change)entry)).map(FilePath::getVirtualFile);
            }
            if (entry instanceof VirtualFile) {
                return Stream.of((VirtualFile)entry);
            }
            return Stream.empty();
        }).filter(Objects::nonNull);
    }

    @NotNull
    private static Stream<VirtualFile> mapToVirtualFile(@NotNull VcsTreeModelData data) {
        return data.userObjectsStream().map(entry -> {
            if (entry instanceof Change) {
                FilePath path = ChangesUtil.getAfterPath((Change)((Change)entry));
                return path != null ? path.getVirtualFile() : null;
            }
            if (entry instanceof VirtualFile) {
                return (VirtualFile)entry;
            }
            return null;
        }).filter(Objects::nonNull);
    }

    @NotNull
    private static Stream<File> mapToIoFile(@NotNull VcsTreeModelData data) {
        return data.userObjectsStream().map(entry -> {
            if (entry instanceof Change) {
                FilePath path = ChangesUtil.getAfterPath((Change)((Change)entry));
                return path != null ? path.getIOFile() : null;
            }
            return null;
        }).filter(Objects::nonNull);
    }

    @Nullable
    private static ChangesBrowserNode<?> findTagNode(@NotNull JTree tree, @NotNull Object tag) {
        ChangesBrowserNode root = (ChangesBrowserNode)tree.getModel().getRoot();
        Iterator iterator = ContainerUtil.iterate(root.children());
        return (ChangesBrowserNode)ContainerUtil.find((Iterator)iterator, node -> tag.equals(node.getUserObject()));
    }

    private static class IncludedUnderData
    extends VcsTreeModelData {
        @NotNull
        private final ChangesTree myTree;
        @NotNull
        private final ChangesBrowserNode<?> myNode;

        IncludedUnderData(@NotNull ChangesTree tree, @NotNull ChangesBrowserNode<?> node) {
            this.myTree = tree;
            this.myNode = node;
        }

        @Override
        @NotNull
        public Stream<ChangesBrowserNode> rawNodesStream() {
            Set<Object> included = this.myTree.getIncludedSet();
            return this.myNode.getNodesUnderStream().filter(node -> included.contains(node.getUserObject()));
        }
    }

    private static class SelectedTagData
    extends VcsTreeModelData {
        @NotNull
        private final JTree myTree;
        @NotNull
        private final Object myTag;

        SelectedTagData(@NotNull JTree tree, @NotNull Object tag) {
            this.myTree = tree;
            this.myTag = tag;
        }

        @Override
        @NotNull
        public Stream<ChangesBrowserNode> rawNodesStream() {
            ChangesBrowserNode tagNode = VcsTreeModelData.findTagNode(this.myTree, this.myTag);
            if (tagNode == null) {
                return Stream.empty();
            }
            TreePath[] paths = this.myTree.getSelectionPaths();
            if (paths == null) {
                return Stream.empty();
            }
            return Stream.of(paths).filter(path -> path.getPathCount() <= 1 || path.getPathComponent(1) == tagNode).map(path -> (ChangesBrowserNode)path.getLastPathComponent()).flatMap(ChangesBrowserNode::getNodesUnderStream).distinct();
        }
    }

    private static class ExactlySelectedData
    extends VcsTreeModelData {
        @NotNull
        private final JTree myTree;

        ExactlySelectedData(@NotNull JTree tree) {
            this.myTree = tree;
        }

        @Override
        @NotNull
        public Stream<ChangesBrowserNode> rawNodesStream() {
            TreePath[] paths = this.myTree.getSelectionPaths();
            if (paths == null) {
                return Stream.empty();
            }
            return Stream.of(paths).map(path -> (ChangesBrowserNode)path.getLastPathComponent());
        }
    }

    private static class SelectedData
    extends VcsTreeModelData {
        @NotNull
        private final JTree myTree;

        SelectedData(@NotNull JTree tree) {
            this.myTree = tree;
        }

        @Override
        @NotNull
        public Stream<ChangesBrowserNode> rawNodesStream() {
            TreePath[] paths = this.myTree.getSelectionPaths();
            if (paths == null) {
                return Stream.empty();
            }
            return Stream.of(paths).map(path -> (ChangesBrowserNode)path.getLastPathComponent()).flatMap(ChangesBrowserNode::getNodesUnderStream).distinct();
        }
    }

    private static class AllUnderData
    extends VcsTreeModelData {
        @NotNull
        private final ChangesBrowserNode<?> myNode;

        AllUnderData(@NotNull ChangesBrowserNode<?> node) {
            this.myNode = node;
        }

        @Override
        @NotNull
        public Stream<ChangesBrowserNode> rawNodesStream() {
            return this.myNode.getNodesUnderStream();
        }
    }

    private static class EmptyData
    extends VcsTreeModelData {
        EmptyData() {
        }

        @Override
        @NotNull
        public Stream<ChangesBrowserNode> rawNodesStream() {
            return Stream.empty();
        }
    }
}

