/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.OutOfSourcesChecker;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;

public class CheckinHandlerUtil {
    public static List<VirtualFile> filterOutGeneratedAndExcludedFiles(@NotNull Collection<? extends VirtualFile> files2, @NotNull Project project) {
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(files2.size());
        for (VirtualFile virtualFile : files2) {
            if (fileIndex.isExcluded(virtualFile) || GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)virtualFile, (Project)project)) continue;
            result2.add(virtualFile);
        }
        return result2;
    }

    public static PsiFile[] getPsiFiles(Project project, Collection<? extends VirtualFile> selectedFiles) {
        ArrayList<PsiFile> result2 = new ArrayList<PsiFile>();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        IProjectStore projectStore = ProjectKt.getStateStore(project);
        for (VirtualFile virtualFile : selectedFiles) {
            PsiFile psiFile;
            if (!virtualFile.isValid() || projectStore.isProjectFile(virtualFile) || !CheckinHandlerUtil.isFileUnderSourceRoot(project, virtualFile) || CheckinHandlerUtil.isOutOfSources(project, virtualFile) || (psiFile = psiManager.findFile(virtualFile)) == null) continue;
            result2.add(psiFile);
        }
        return PsiUtilCore.toPsiFileArray(result2);
    }

    private static boolean isFileUnderSourceRoot(@NotNull Project project, @NotNull VirtualFile file2) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return index.isInContent(file2) && !index.isInLibrarySource(file2);
    }

    private static boolean isOutOfSources(@NotNull Project project, @NotNull VirtualFile file2) {
        for (OutOfSourcesChecker checker : (OutOfSourcesChecker[])OutOfSourcesChecker.EP_NAME.getExtensions()) {
            if (checker.getFileType() != file2.getFileType() || !checker.isOutOfSources(project, file2)) continue;
            return true;
        }
        return false;
    }

    public static void disableWhenDumb(@NotNull Project project, @NotNull JCheckBox checkBox2, @NotNull String tooltip) {
        boolean dumb = DumbService.isDumb((Project)project);
        checkBox2.setEnabled(!dumb);
        checkBox2.setToolTipText(dumb ? tooltip : "");
    }
}

