/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ui.BooleanCommitOption;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.checkin.CheckinHandlerUtil;
import com.intellij.openapi.vcs.checkin.CheckinMetaHandler;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;

public class CodeCleanupCheckinHandlerFactory
extends CheckinHandlerFactory {
    @NotNull
    public CheckinHandler createHandler(@NotNull CheckinProjectPanel panel2, @NotNull CommitContext commitContext) {
        return new CleanupCodeCheckinHandler(panel2);
    }

    private static class CleanupCodeCheckinHandler
    extends CheckinHandler
    implements CheckinMetaHandler {
        private final CheckinProjectPanel myPanel;
        private final Project myProject;

        CleanupCodeCheckinHandler(CheckinProjectPanel panel2) {
            this.myProject = panel2.getProject();
            this.myPanel = panel2;
        }

        public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
            return new BooleanCommitOption(this.myPanel, VcsBundle.message((String)"before.checkin.cleanup.code", (Object[])new Object[0]), true, (Function0<Boolean>)((Function0)() -> this.getSettings().CHECK_CODE_CLEANUP_BEFORE_PROJECT_COMMIT), value -> {
                this.getSettings().CHECK_CODE_CLEANUP_BEFORE_PROJECT_COMMIT = value;
            });
        }

        public void runCheckinHandlers(@NotNull Runnable runnable2) {
            if (this.getSettings().CHECK_CODE_CLEANUP_BEFORE_PROJECT_COMMIT && !DumbService.isDumb((Project)this.myProject)) {
                List<VirtualFile> filesToProcess = CheckinHandlerUtil.filterOutGeneratedAndExcludedFiles(this.myPanel.getVirtualFiles(), this.myProject);
                GlobalInspectionContextBase.modalCodeCleanup(this.myProject, new AnalysisScope(this.myProject, filesToProcess), runnable2);
            } else {
                runnable2.run();
            }
        }

        @NotNull
        private VcsConfiguration getSettings() {
            return VcsConfiguration.getInstance((Project)this.myProject);
        }
    }
}

