/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.checkin.UnresolvedMergeCheckProvider;
import com.intellij.util.PairConsumer;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnresolvedMergeCheckFactory
extends CheckinHandlerFactory {
    @NotNull
    public CheckinHandler createHandler(final @NotNull CheckinProjectPanel panel2, final @NotNull CommitContext commitContext) {
        return new CheckinHandler(){

            public CheckinHandler.ReturnResult beforeCheckin(@Nullable CommitExecutor executor, PairConsumer<Object, Object> additionalDataConsumer) {
                for (UnresolvedMergeCheckProvider extension : (UnresolvedMergeCheckProvider[])UnresolvedMergeCheckProvider.EP_NAME.getExtensions()) {
                    CheckinHandler.ReturnResult result2 = extension.checkUnresolvedConflicts(panel2, commitContext, executor);
                    if (result2 == null) continue;
                    return result2;
                }
                return UnresolvedMergeCheckFactory.performDefaultCheck(panel2);
            }
        };
    }

    @NotNull
    private static CheckinHandler.ReturnResult performDefaultCheck(@NotNull CheckinProjectPanel panel2) {
        int answer;
        if (UnresolvedMergeCheckFactory.containsUnresolvedConflicts(panel2) && (answer = Messages.showYesNoDialog((Component)panel2.getComponent(), (String)"Are you sure you want to commit changes with unresolved conflicts?", (String)"Unresolved Conflicts", (Icon)Messages.getWarningIcon())) != 0) {
            return CheckinHandler.ReturnResult.CANCEL;
        }
        return CheckinHandler.ReturnResult.COMMIT;
    }

    private static boolean containsUnresolvedConflicts(@NotNull CheckinProjectPanel panel2) {
        for (Change change : panel2.getSelectedChanges()) {
            FileStatus status = change.getFileStatus();
            if (!status.equals(FileStatus.MERGE) && !status.equals(FileStatus.MERGED_WITH_BOTH_CONFLICTS) && !status.equals(FileStatus.MERGED_WITH_CONFLICTS) && !status.equals(FileStatus.MERGED_WITH_PROPERTY_CONFLICTS)) continue;
            return true;
        }
        return false;
    }
}

