/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ComputableActionGroup;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.checkout.CheckoutAction;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class CheckoutActionGroup
extends ComputableActionGroup.Simple {
    protected final String myIdPrefix;

    public CheckoutActionGroup() {
        this("Vcs.Checkout");
    }

    public CheckoutActionGroup(String idPrefix) {
        this.myIdPrefix = idPrefix;
    }

    @Override
    @NotNull
    protected AnAction[] computeChildren(@NotNull ActionManager manager) {
        return this.getActions();
    }

    @NotNull
    public AnAction[] getActions() {
        CheckoutProvider[] providers = (CheckoutProvider[])CheckoutProvider.EXTENSION_POINT_NAME.getExtensions();
        if (providers.length == 0) {
            return EMPTY_ARRAY;
        }
        Arrays.sort(providers, new CheckoutProvider.CheckoutProviderComparator());
        AnAction[] children2 = new AnAction[providers.length];
        for (int i = 0; i < providers.length; ++i) {
            CheckoutProvider provider = providers[i];
            children2[i] = this.createAction(provider);
        }
        return children2;
    }

    @NotNull
    protected AnAction createAction(CheckoutProvider provider) {
        return new CheckoutAction(provider, this.myIdPrefix);
    }
}

