/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ex.DocumentTrackerKt;
import com.intellij.openapi.vcs.ex.LineTracker;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\u0018\u0000 H2\u00020\u0001:\tGHIJKLMNOB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0017\u0010\u001e\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0 H\u0086\bJ\u001f\u0010\u001e\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0 H\u0086\bJ\u000e\u0010#\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"J\u000e\u0010$\u001a\u00020%2\u0006\u0010!\u001a\u00020\"J\"\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00170)J\u0006\u0010*\u001a\u00020\u0017J \u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/H\u0002J&\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u00020%2\u0006\u00103\u001a\u00020%2\f\u00104\u001a\b\u0012\u0004\u0012\u0002050\rH\u0002JK\u00106\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00170)2'\u00107\u001a#\u0012\u0004\u0012\u00020\u000e\u0012\u0013\u0012\u00110/\u00a2\u0006\f\b9\u0012\b\b:\u0012\u0004\b\b(;\u0012\u0004\u0012\u00020\u001d08J\u001f\u0010<\u001a\u0002H=\"\u0004\b\u0000\u0010=2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H=0 \u00a2\u0006\u0002\u0010>J\u0018\u0010?\u001a\u00020\u001d2\u0006\u0010@\u001a\u00020\u00172\b\b\u0002\u0010A\u001a\u00020\u0017J$\u0010B\u001a\u00020\u00172\u0006\u00102\u001a\u00020%2\u0006\u00103\u001a\u00020%2\f\u00104\u001a\b\u0012\u0004\u0012\u0002050\rJ\u0014\u0010B\u001a\u00020\u00172\f\u00104\u001a\b\u0012\u0004\u0012\u0002050\rJ\u000e\u0010C\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"J\u0018\u0010C\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010D\u001a\u00020%H\u0002J\u0006\u0010E\u001a\u00020\u001dJ\u0010\u0010E\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0002J\u001f\u0010F\u001a\u0002H=\"\u0004\b\u0000\u0010=2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H=0 \u00a2\u0006\u0002\u0010>R\u0018\u0010\b\u001a\u00060\tR\u00020\u0000X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker;", "Lcom/intellij/openapi/Disposable;", "document1", "Lcom/intellij/openapi/editor/Document;", "document2", "handler", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;)V", "LOCK", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Lock;", "getLOCK$intellij_platform_diff_impl", "()Lcom/intellij/openapi/vcs/ex/DocumentTracker$Lock;", "blocks", "", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "getBlocks", "()Ljava/util/List;", "getDocument1", "()Lcom/intellij/openapi/editor/Document;", "getDocument2", "freezeHelper", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$FreezeHelper;", "isDisposed", "", "isLockHeldByCurrentThread", "()Z", "tracker", "Lcom/intellij/openapi/vcs/ex/LineTracker;", "dispose", "", "doFrozen", "task", "Lkotlin/Function0;", "side", "Lcom/intellij/diff/util/Side;", "freeze", "getContent", "", "getContentWithPartiallyAppliedBlocks", "", "condition", "Lkotlin/Function1;", "isFrozen", "isValidLineRange", "lineOffsets", "Lcom/intellij/diff/tools/util/text/LineOffsets;", "start", "", "end", "isValidState", "content1", "content2", "lineRanges", "Lcom/intellij/diff/util/Range;", "partiallyApplyBlocks", "consumer", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "shift", "readLock", "T", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "refreshDirty", "fastRefresh", "forceInFrozen", "setFrozenState", "unfreeze", "oldText", "updateFrozenContentIfNeeded", "writeLock", "Block", "Companion", "FreezeData", "FreezeHelper", "Handler", "Lock", "MyApplicationListener", "MyDocumentBulkUpdateListener", "MyDocumentListener", "intellij.platform.diff.impl"})
public final class DocumentTracker
implements Disposable {
    private final Handler handler;
    @NotNull
    private final Lock LOCK = new Lock();
    @NotNull
    private final Document document1;
    @NotNull
    private final Document document2;
    private final LineTracker tracker;
    private final FreezeHelper freezeHelper = new FreezeHelper();
    private boolean isDisposed;
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public final Lock getLOCK$intellij_platform_diff_impl() {
        return this.LOCK;
    }

    @NotNull
    public final Document getDocument1() {
        return this.document1;
    }

    @NotNull
    public final Document getDocument2() {
        return this.document2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        Lock this_$iv = this.LOCK;
        boolean $i$f$write$intellij_platform_diff_impl = false;
        java.util.concurrent.locks.Lock lock = this_$iv.myLock;
        lock.lock();
        try {
            boolean bl = false;
            this.tracker.destroy();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    public final List<Block> getBlocks() {
        return this.tracker.getBlocks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T readLock(@NotNull Function0<? extends T> task2) {
        Object object;
        Lock this_$iv = this.LOCK;
        boolean $i$f$read$intellij_platform_diff_impl = false;
        java.util.concurrent.locks.Lock lock = this_$iv.myLock;
        lock.lock();
        try {
            object = task2.invoke();
        }
        finally {
            lock.unlock();
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T writeLock(@NotNull Function0<? extends T> task2) {
        Object object;
        Lock this_$iv = this.LOCK;
        boolean $i$f$write$intellij_platform_diff_impl = false;
        java.util.concurrent.locks.Lock lock = this_$iv.myLock;
        lock.lock();
        try {
            object = task2.invoke();
        }
        finally {
            lock.unlock();
        }
        return (T)object;
    }

    public final boolean isLockHeldByCurrentThread() {
        return this.LOCK.isHeldByCurrentThread$intellij_platform_diff_impl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isFrozen() {
        Lock this_$iv = this.LOCK;
        boolean $i$f$read$intellij_platform_diff_impl = false;
        java.util.concurrent.locks.Lock lock = this_$iv.myLock;
        lock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.freezeHelper.isFrozen();
            return bl2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void freeze(@NotNull Side side) {
        Lock this_$iv = this.LOCK;
        boolean $i$f$write$intellij_platform_diff_impl = false;
        java.util.concurrent.locks.Lock lock = this_$iv.myLock;
        lock.lock();
        try {
            boolean bl = false;
            this.freezeHelper.freeze(side);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unfreeze(@NotNull Side side) {
        Lock this_$iv = this.LOCK;
        boolean $i$f$write$intellij_platform_diff_impl = false;
        java.util.concurrent.locks.Lock lock = this_$iv.myLock;
        lock.lock();
        try {
            boolean bl = false;
            this.freezeHelper.unfreeze(side);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void doFrozen(@NotNull Function0<Unit> task2) {
        void this_$iv;
        int $i$f$doFrozen = 0;
        DocumentTracker documentTracker = this;
        Side side$iv = Side.LEFT;
        boolean $i$f$doFrozen2 = false;
        this_$iv.freeze(side$iv);
        try {
            void this_$iv2;
            boolean bl = false;
            DocumentTracker documentTracker2 = this;
            Side side$iv2 = Side.RIGHT;
            boolean $i$f$doFrozen3 = false;
            this_$iv2.freeze(side$iv2);
            try {
                boolean bl2 = false;
                task2.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                this_$iv2.unfreeze(side$iv2);
                InlineMarker.finallyEnd((int)1);
            }
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this_$iv.unfreeze(side$iv);
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doFrozen(@NotNull Side side, @NotNull Function0<Unit> task2) {
        int $i$f$doFrozen = 0;
        this.freeze(side);
        try {
            task2.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.unfreeze(side);
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final CharSequence getContent(@NotNull Side side) {
        Lock this_$iv = this.LOCK;
        boolean $i$f$read$intellij_platform_diff_impl = false;
        java.util.concurrent.locks.Lock lock = this_$iv.myLock;
        lock.lock();
        try {
            boolean bl = false;
            CharSequence frozenContent = this.freezeHelper.getFrozenContent(side);
            if (frozenContent != null) {
                CharSequence charSequence = frozenContent;
                return charSequence;
            }
            CharSequence charSequence = RangesBuilder.get(side, this.document1, this.document2).getImmutableCharSequence();
            return charSequence;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refreshDirty(boolean fastRefresh, boolean forceInFrozen) {
        if (this.isDisposed) {
            return;
        }
        if (!forceInFrozen && this.freezeHelper.isFrozen()) {
            return;
        }
        Lock this_$iv = this.LOCK;
        boolean $i$f$write$intellij_platform_diff_impl = false;
        java.util.concurrent.locks.Lock lock = this_$iv.myLock;
        lock.lock();
        try {
            boolean bl = false;
            if (!this.getBlocks().isEmpty() && StringUtil.equals((CharSequence)this.document1.getImmutableCharSequence(), (CharSequence)this.document2.getImmutableCharSequence())) {
                this.tracker.setRanges(CollectionsKt.emptyList(), false);
                return;
            }
            this.tracker.refreshDirty(this.document1.getImmutableCharSequence(), this.document2.getImmutableCharSequence(), RangesBuilder.getLineOffsets(this.document1), RangesBuilder.getLineOffsets(this.document2), fastRefresh);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public static /* synthetic */ void refreshDirty$default(DocumentTracker documentTracker, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = false;
        }
        documentTracker.refreshDirty(bl, bl2);
    }

    private final void unfreeze(Side side, CharSequence oldText) {
        Iterator<Range> iterator;
        boolean bl = this.LOCK.isHeldByCurrentThread$intellij_platform_diff_impl();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (this.isDisposed) {
            return;
        }
        Document newText = RangesBuilder.get(side, this.document1, this.document2);
        int shift = 0;
        FairDiffIterable iterable = RangesBuilder.compareLines(oldText, newText.getImmutableCharSequence(), RangesBuilder.getLineOffsets(oldText), RangesBuilder.getLineOffsets(newText));
        Iterator<Range> iterator2 = iterator = iterable.changes();
        while (iterator2.hasNext()) {
            Range range2 = iterator2.next();
            int beforeLength = range2.end1 - range2.start1;
            int afterLength = range2.end2 - range2.start2;
            this.tracker.rangeChanged(side, range2.start1 + shift, beforeLength, afterLength);
            shift += afterLength - beforeLength;
        }
    }

    public final void updateFrozenContentIfNeeded() {
        this.updateFrozenContentIfNeeded(Side.LEFT);
        this.updateFrozenContentIfNeeded(Side.RIGHT);
        this.refreshDirty(false, true);
    }

    private final void updateFrozenContentIfNeeded(Side side) {
        boolean bl = this.LOCK.isHeldByCurrentThread$intellij_platform_diff_impl();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (!this.freezeHelper.isFrozen(side)) {
            return;
        }
        CharSequence charSequence = this.freezeHelper.getFrozenContent(side);
        if (charSequence == null) {
            Intrinsics.throwNpe();
        }
        this.unfreeze(side, charSequence);
        this.freezeHelper.setFrozenContent(side, RangesBuilder.get(side, this.document1, this.document2).getImmutableCharSequence());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void partiallyApplyBlocks(@NotNull Side side, @NotNull Function1<? super Block, Boolean> condition, @NotNull Function2<? super Block, ? super Integer, Unit> consumer) {
        if (this.isDisposed) {
            return;
        }
        Side otherSide = side.other();
        Document document = RangesBuilder.get(side, this.document1, this.document2);
        Document otherDocument = RangesBuilder.get(otherSide, this.document1, this.document2);
        DocumentTracker this_$iv = this;
        boolean $i$f$doFrozen = false;
        this_$iv.freeze(side);
        try {
            Object object;
            boolean bl = false;
            Lock this_$iv2 = this.LOCK;
            boolean $i$f$write$intellij_platform_diff_impl = false;
            java.util.concurrent.locks.Lock lock = this_$iv2.myLock;
            lock.lock();
            try {
                boolean bl2 = false;
                this.updateFrozenContentIfNeeded();
                object = this.tracker.partiallyApplyBlocks(side, condition);
            }
            finally {
                lock.unlock();
            }
            List<Block> appliedBlocks = object;
            int shift = 0;
            for (Block block : appliedBlocks) {
                DiffUtil.applyModification(document, RangesBuilder.start(block.getRange(), side) + shift, RangesBuilder.end(block.getRange(), side) + shift, otherDocument, RangesBuilder.start(block.getRange(), otherSide), RangesBuilder.end(block.getRange(), otherSide));
                consumer.invoke((Object)block, (Object)shift);
                shift += DocumentTrackerKt.access$getRangeDelta(block.getRange(), side);
            }
            Lock this_$iv3 = this.LOCK;
            boolean $i$f$write$intellij_platform_diff_impl2 = false;
            object = this_$iv3.myLock;
            object.lock();
            try {
                boolean bl3 = false;
                this.freezeHelper.setFrozenContent(side, document.getImmutableCharSequence());
                Unit unit = Unit.INSTANCE;
            }
            finally {
                object.unlock();
            }
        }
        finally {
            this_$iv.unfreeze(side);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final String getContentWithPartiallyAppliedBlocks(@NotNull Side side, @NotNull Function1<? super Block, Boolean> condition) {
        Iterable $receiver$iv;
        List list2;
        Iterable $receiver$iv$iv;
        Collection destination$iv$iv;
        Side otherSide = side.other();
        Lock this_$iv = this.LOCK;
        boolean $i$f$write$intellij_platform_diff_impl = false;
        java.util.concurrent.locks.Lock lock = this_$iv.myLock;
        lock.lock();
        try {
            void $receiver$iv2;
            boolean bl = false;
            this.updateFrozenContentIfNeeded();
            Iterable iterable = this.tracker.getBlocks();
            Function1<? super Block, Boolean> predicate$iv = condition;
            void var11_12 = $receiver$iv2;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                if (!((Boolean)predicate$iv.invoke(element$iv$iv)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        finally {
            lock.unlock();
        }
        List affectedBlocks = list2;
        CharSequence content = this.getContent(side);
        CharSequence otherContent = this.getContent(otherSide);
        LineOffsets lineOffsets = RangesBuilder.getLineOffsets(content);
        LineOffsets otherLineOffsets = RangesBuilder.getLineOffsets(otherContent);
        $receiver$iv$iv = $receiver$iv = (Iterable)affectedBlocks;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Block $i$f$filterTo = (Block)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Range range2 = new Range(RangesBuilder.start(it.getRange(), side), RangesBuilder.end(it.getRange(), side), RangesBuilder.start(it.getRange(), otherSide), RangesBuilder.end(it.getRange(), otherSide));
            collection.add(range2);
        }
        List ranges = (List)destination$iv$iv;
        return DiffUtil.applyModification(content, lineOffsets, otherContent, otherLineOffsets, ranges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setFrozenState(@NotNull CharSequence content1, @NotNull CharSequence content2, @NotNull List<? extends Range> lineRanges) {
        boolean bl;
        boolean bl2 = bl = this.freezeHelper.isFrozen(Side.LEFT) && this.freezeHelper.isFrozen(Side.RIGHT);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (this.isDisposed) {
            return false;
        }
        Lock this_$iv = this.LOCK;
        boolean $i$f$write$intellij_platform_diff_impl = false;
        java.util.concurrent.locks.Lock lock = this_$iv.myLock;
        lock.lock();
        try {
            boolean bl3 = false;
            if (!this.isValidState(content1, content2, lineRanges)) {
                boolean bl4 = false;
                return bl4;
            }
            this.freezeHelper.setFrozenContent(Side.LEFT, content1);
            this.freezeHelper.setFrozenContent(Side.RIGHT, content2);
            this.tracker.setRanges(lineRanges, true);
            boolean bl5 = true;
            return bl5;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setFrozenState(@NotNull List<? extends Range> lineRanges) {
        boolean bl;
        if (this.isDisposed) {
            return false;
        }
        boolean bl2 = bl = this.freezeHelper.isFrozen(Side.LEFT) && this.freezeHelper.isFrozen(Side.RIGHT);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Lock this_$iv = this.LOCK;
        boolean $i$f$write$intellij_platform_diff_impl = false;
        java.util.concurrent.locks.Lock lock = this_$iv.myLock;
        lock.lock();
        try {
            boolean bl3 = false;
            CharSequence content1 = this.getContent(Side.LEFT);
            CharSequence content2 = this.getContent(Side.RIGHT);
            if (!this.isValidState(content1, content2, lineRanges)) {
                boolean bl4 = false;
                return bl4;
            }
            this.tracker.setRanges(lineRanges, true);
            boolean bl5 = true;
            return bl5;
        }
        finally {
            lock.unlock();
        }
    }

    private final boolean isValidState(CharSequence content1, CharSequence content2, List<? extends Range> lineRanges) {
        Object it;
        boolean bl;
        LineOffsets lineOffset2;
        LineOffsets lineOffset1;
        block5: {
            lineOffset1 = RangesBuilder.getLineOffsets(content1);
            lineOffset2 = RangesBuilder.getLineOffsets(content2);
            Iterable $receiver$iv = lineRanges;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    it = (Range)element$iv;
                    boolean bl2 = false;
                    if (!(!this.isValidLineRange(lineOffset1, ((Range)it).start1, ((Range)it).end1) || !this.isValidLineRange(lineOffset2, ((Range)it).start2, ((Range)it).end2))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        DiffIterable iterable = DiffIterableUtil.create(lineRanges, lineOffset1.getLineCount(), lineOffset2.getLineCount());
        Object object = it = iterable.unchanged();
        while (object.hasNext()) {
            List<String> lines2;
            Range range2 = (Range)object.next();
            List<String> lines1 = DiffUtil.getLines(content1, lineOffset1, range2.start1, range2.end1);
            if (!(Intrinsics.areEqual(lines1, lines2 = DiffUtil.getLines(content2, lineOffset2, range2.start2, range2.end2)) ^ true)) continue;
            return false;
        }
        return true;
    }

    private final boolean isValidLineRange(LineOffsets lineOffsets, int start2, int end) {
        return start2 >= 0 && start2 <= end && end <= lineOffsets.getLineCount();
    }

    public DocumentTracker(@NotNull Document document1, @NotNull Document document2, @NotNull Handler handler2) {
        boolean bl = Intrinsics.areEqual((Object)document1, (Object)document2) ^ true;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.document1 = document1;
        this.document2 = document2;
        this.handler = handler2;
        List changes2 = CollectionsKt.toList(RangesBuilder.compareLines(document1.getImmutableCharSequence(), document2.getImmutableCharSequence(), RangesBuilder.getLineOffsets(document1), RangesBuilder.getLineOffsets(document2)).iterateChanges());
        this.tracker = new LineTracker(this.handler, changes2);
        Application application = ApplicationManager.getApplication();
        application.addApplicationListener((ApplicationListener)new MyApplicationListener(), (Disposable)this);
        application.getMessageBus().connect((Disposable)this).subscribe(DocumentBulkUpdateListener.TOPIC, (Object)new MyDocumentBulkUpdateListener());
        document1.addDocumentListener((DocumentListener)new MyDocumentListener(Side.LEFT), (Disposable)this);
        document2.addDocumentListener((DocumentListener)new MyDocumentListener(Side.RIGHT), (Disposable)this);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(DocumentTracker.class);
    }

    public static final /* synthetic */ void access$setDisposed$p(DocumentTracker $this, boolean bl) {
        $this.isDisposed = bl;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$MyDocumentBulkUpdateListener;", "Lcom/intellij/openapi/editor/ex/DocumentBulkUpdateListener;", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker;)V", "updateFinished", "", "doc", "Lcom/intellij/openapi/editor/Document;", "updateStarted", "intellij.platform.diff.impl"})
    private final class MyDocumentBulkUpdateListener
    implements DocumentBulkUpdateListener {
        @Override
        public void updateStarted(@NotNull Document doc) {
            if (Intrinsics.areEqual((Object)DocumentTracker.this.getDocument1(), (Object)doc)) {
                DocumentTracker.this.freeze(Side.LEFT);
            }
            if (Intrinsics.areEqual((Object)DocumentTracker.this.getDocument2(), (Object)doc)) {
                DocumentTracker.this.freeze(Side.RIGHT);
            }
        }

        @Override
        public void updateFinished(@NotNull Document doc) {
            if (Intrinsics.areEqual((Object)DocumentTracker.this.getDocument1(), (Object)doc)) {
                DocumentTracker.this.unfreeze(Side.LEFT);
            }
            if (Intrinsics.areEqual((Object)DocumentTracker.this.getDocument2(), (Object)doc)) {
                DocumentTracker.this.unfreeze(Side.RIGHT);
            }
        }

        public MyDocumentBulkUpdateListener() {
            Document document = DocumentTracker.this.getDocument1();
            if (document == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.DocumentEx");
            }
            if (((DocumentEx)document).isInBulkUpdate()) {
                DocumentTracker.this.freeze(Side.LEFT);
            }
            Document document2 = DocumentTracker.this.getDocument2();
            if (document2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.DocumentEx");
            }
            if (((DocumentEx)document2).isInBulkUpdate()) {
                DocumentTracker.this.freeze(Side.RIGHT);
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$MyApplicationListener;", "Lcom/intellij/openapi/application/ApplicationListener;", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker;)V", "afterWriteActionFinished", "", "action", "", "intellij.platform.diff.impl"})
    private final class MyApplicationListener
    implements ApplicationListener {
        public void afterWriteActionFinished(@NotNull Object action) {
            DocumentTracker.refreshDirty$default(DocumentTracker.this, true, false, 2, null);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J:\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$MyDocumentListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "side", "Lcom/intellij/diff/util/Side;", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker;Lcom/intellij/diff/util/Side;)V", "document", "Lcom/intellij/openapi/editor/Document;", "line1", "", "line2", "getSide", "()Lcom/intellij/diff/util/Side;", "beforeDocumentChange", "", "e", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "documentChanged", "getAffectedRange", "Lkotlin/Triple;", "oldLine2", "newLine2", "isNewlineAfter", "", "isNewlineBefore", "intellij.platform.diff.impl"})
    private final class MyDocumentListener
    implements DocumentListener {
        private final Document document;
        private int line1;
        private int line2;
        @NotNull
        private final Side side;

        public void beforeDocumentChange(@NotNull DocumentEvent e) {
            if (DocumentTracker.this.isDisposed || DocumentTracker.this.freezeHelper.isFrozen(this.side)) {
                return;
            }
            this.line1 = this.document.getLineNumber(e.getOffset());
            this.line2 = e.getOldLength() == 0 ? this.line1 + 1 : this.document.getLineNumber(e.getOffset() + e.getOldLength()) + 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void documentChanged(@NotNull DocumentEvent e) {
            if (DocumentTracker.this.isDisposed || DocumentTracker.this.freezeHelper.isFrozen(this.side)) {
                return;
            }
            int newLine2 = 0;
            newLine2 = e.getNewLength() == 0 ? this.line1 + 1 : this.document.getLineNumber(e.getOffset() + e.getNewLength()) + 1;
            Triple<Integer, Integer, Integer> triple = this.getAffectedRange(this.line1, this.line2, newLine2, e);
            int n = ((Number)triple.component1()).intValue();
            int n2 = ((Number)triple.component2()).intValue();
            int beforeLength = ((Number)triple.component3()).intValue();
            Lock this_$iv = DocumentTracker.this.getLOCK$intellij_platform_diff_impl();
            boolean $i$f$write$intellij_platform_diff_impl = false;
            java.util.concurrent.locks.Lock lock = this_$iv.myLock;
            lock.lock();
            try {
                void afterLength;
                void startLine;
                boolean bl = false;
                DocumentTracker.this.tracker.rangeChanged(this.side, (int)startLine, beforeLength, (int)afterLength);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        private final Triple<Integer, Integer, Integer> getAffectedRange(int line1, int oldLine2, int newLine2, DocumentEvent e) {
            int afterLength = newLine2 - line1;
            int beforeLength = oldLine2 - line1;
            if (e.getOldLength() == 0 && e.getNewLength() != 0) {
                if (StringUtil.endsWithChar((CharSequence)e.getNewFragment(), (char)'\n') && this.isNewlineBefore(e)) {
                    return new Triple((Object)line1, (Object)(afterLength - 1), (Object)(beforeLength - 1));
                }
                if (StringUtil.startsWithChar((CharSequence)e.getNewFragment(), (char)'\n') && this.isNewlineAfter(e)) {
                    return new Triple((Object)(line1 + 1), (Object)(afterLength - 1), (Object)(beforeLength - 1));
                }
            }
            if (e.getOldLength() != 0 && e.getNewLength() == 0) {
                if (StringUtil.endsWithChar((CharSequence)e.getOldFragment(), (char)'\n') && this.isNewlineBefore(e)) {
                    return new Triple((Object)line1, (Object)(afterLength - 1), (Object)(beforeLength - 1));
                }
                if (StringUtil.startsWithChar((CharSequence)e.getOldFragment(), (char)'\n') && this.isNewlineAfter(e)) {
                    return new Triple((Object)(line1 + 1), (Object)(afterLength - 1), (Object)(beforeLength - 1));
                }
            }
            return new Triple((Object)line1, (Object)afterLength, (Object)beforeLength);
        }

        private final boolean isNewlineBefore(DocumentEvent e) {
            if (e.getOffset() == 0) {
                return true;
            }
            return e.getDocument().getImmutableCharSequence().charAt(e.getOffset() - 1) == '\n';
        }

        private final boolean isNewlineAfter(DocumentEvent e) {
            if (e.getOffset() + e.getNewLength() == e.getDocument().getImmutableCharSequence().length()) {
                return true;
            }
            return e.getDocument().getImmutableCharSequence().charAt(e.getOffset() + e.getNewLength()) == '\n';
        }

        @NotNull
        public final Side getSide() {
            return this.side;
        }

        public MyDocumentListener(Side side) {
            this.side = side;
            this.document = RangesBuilder.get(this.side, DocumentTracker.this.getDocument1(), DocumentTracker.this.getDocument2());
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0002J\u0016\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\fJ\u000e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$FreezeHelper;", "", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker;)V", "data1", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$FreezeData;", "data2", "freeze", "", "side", "Lcom/intellij/diff/util/Side;", "getData", "getFrozenContent", "", "isFrozen", "", "setData", "data", "setFrozenContent", "newContent", "unfreeze", "intellij.platform.diff.impl"})
    private final class FreezeHelper {
        private FreezeData data1;
        private FreezeData data2;

        public final boolean isFrozen(@NotNull Side side) {
            return this.getData(side) != null;
        }

        public final boolean isFrozen() {
            return this.isFrozen(Side.LEFT) || this.isFrozen(Side.RIGHT);
        }

        public final void freeze(@NotNull Side side) {
            boolean wasFrozen = this.isFrozen();
            FreezeData data = this.getData(side);
            if (data == null) {
                data = new FreezeData(RangesBuilder.get(side, DocumentTracker.this.getDocument1(), DocumentTracker.this.getDocument2()));
                this.setData(side, data);
                FreezeData freezeData = data;
                int n = freezeData.getCounter();
                freezeData.setCounter(n + 1);
                if (wasFrozen) {
                    DocumentTracker.this.handler.onFreeze();
                }
                DocumentTracker.this.handler.onFreeze(side);
            } else {
                FreezeData freezeData = data;
                int n = freezeData.getCounter();
                freezeData.setCounter(n + 1);
            }
        }

        public final void unfreeze(@NotNull Side side) {
            FreezeData data = this.getData(side);
            if (data == null || data.getCounter() == 0) {
                FreezeData freezeData = this.data1;
                FreezeData freezeData2 = this.data2;
                LOG.error("DocumentTracker is not freezed: " + side + ", " + (freezeData != null ? freezeData.getCounter() : -1) + ", " + (freezeData2 != null ? freezeData2.getCounter() : -1));
                return;
            }
            FreezeData freezeData = data;
            int n = freezeData.getCounter();
            freezeData.setCounter(n + -1);
            if (data.getCounter() == 0) {
                DocumentTracker.this.unfreeze(side, data.getTextBeforeFreeze());
                this.setData(side, null);
                DocumentTracker.refreshDirty$default(DocumentTracker.this, false, false, 2, null);
                DocumentTracker.this.handler.onUnfreeze(side);
                if (!this.isFrozen()) {
                    DocumentTracker.this.handler.onUnfreeze();
                }
            }
        }

        private final FreezeData getData(Side side) {
            return RangesBuilder.get(side, this.data1, this.data2);
        }

        private final void setData(Side side, FreezeData data) {
            if (side.isLeft()) {
                this.data1 = data;
            } else {
                this.data2 = data;
            }
        }

        @Nullable
        public final CharSequence getFrozenContent(@NotNull Side side) {
            FreezeData freezeData = this.getData(side);
            return freezeData != null ? freezeData.getTextBeforeFreeze() : null;
        }

        public final void setFrozenContent(@NotNull Side side, @NotNull CharSequence newContent) {
            FreezeData freezeData = this.getData(side);
            if (freezeData == null) {
                Intrinsics.throwNpe();
            }
            this.setData(side, new FreezeData(freezeData, newContent));
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$FreezeData;", "", "document", "Lcom/intellij/openapi/editor/Document;", "(Lcom/intellij/openapi/editor/Document;)V", "data", "textBeforeFreeze", "", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$FreezeData;Ljava/lang/CharSequence;)V", "counter", "", "(Ljava/lang/CharSequence;I)V", "getCounter", "()I", "setCounter", "(I)V", "getTextBeforeFreeze", "()Ljava/lang/CharSequence;", "intellij.platform.diff.impl"})
    private static final class FreezeData {
        @NotNull
        private final CharSequence textBeforeFreeze;
        private int counter;

        @NotNull
        public final CharSequence getTextBeforeFreeze() {
            return this.textBeforeFreeze;
        }

        public final int getCounter() {
            return this.counter;
        }

        public final void setCounter(int n) {
            this.counter = n;
        }

        public FreezeData(@NotNull CharSequence textBeforeFreeze, int counter) {
            this.textBeforeFreeze = textBeforeFreeze;
            this.counter = counter;
        }

        public FreezeData(@NotNull Document document) {
            this(document.getImmutableCharSequence(), 0);
        }

        public FreezeData(@NotNull FreezeData data, @NotNull CharSequence textBeforeFreeze) {
            this(textBeforeFreeze, data.counter);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\fH\u0080\b\u00a2\u0006\u0004\b\r\u0010\u000eJ$\u0010\u000f\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\fH\u0080\b\u00a2\u0006\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$Lock;", "", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker;)V", "isHeldByCurrentThread", "", "isHeldByCurrentThread$intellij_platform_diff_impl", "()Z", "myLock", "Ljava/util/concurrent/locks/ReentrantLock;", "read", "T", "task", "Lkotlin/Function0;", "read$intellij_platform_diff_impl", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "write", "write$intellij_platform_diff_impl", "intellij.platform.diff.impl"})
    public final class Lock {
        private final ReentrantLock myLock = new ReentrantLock();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T read$intellij_platform_diff_impl(@NotNull Function0<? extends T> task2) {
            Object object;
            int $i$f$read$intellij_platform_diff_impl = 0;
            java.util.concurrent.locks.Lock lock = this.myLock;
            lock.lock();
            try {
                object = task2.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                lock.unlock();
                InlineMarker.finallyEnd((int)1);
            }
            return (T)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T write$intellij_platform_diff_impl(@NotNull Function0<? extends T> task2) {
            Object object;
            int $i$f$write$intellij_platform_diff_impl = 0;
            java.util.concurrent.locks.Lock lock = this.myLock;
            lock.lock();
            try {
                object = task2.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                lock.unlock();
                InlineMarker.finallyEnd((int)1);
            }
            return (T)object;
        }

        public final boolean isHeldByCurrentThread$intellij_platform_diff_impl() {
            return this.myLock.isHeldByCurrentThread();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0004\u001a\u00020\u0003H\u0016J\b\u0010\u0005\u001a\u00020\u0003H\u0016J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0016J\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u001e\u0010\u000e\u001a\u00020\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u000b\u001a\u00020\nH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "", "afterBulkRangeChange", "", "afterRangeChange", "onFreeze", "side", "Lcom/intellij/diff/util/Side;", "onRangeRefreshed", "before", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "after", "", "onRangeShifted", "onRangesChanged", "onRangesMerged", "", "range1", "range2", "merged", "onUnfreeze", "intellij.platform.diff.impl"})
    public static interface Handler {
        public void onRangeRefreshed(@NotNull Block var1, @NotNull List<Block> var2);

        public void onRangesChanged(@NotNull List<Block> var1, @NotNull Block var2);

        public void onRangeShifted(@NotNull Block var1, @NotNull Block var2);

        public boolean onRangesMerged(@NotNull Block var1, @NotNull Block var2, @NotNull Block var3);

        public void afterRangeChange();

        public void afterBulkRangeChange();

        public void onFreeze(@NotNull Side var1);

        public void onUnfreeze(@NotNull Side var1);

        public void onFreeze();

        public void onUnfreeze();

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static void onRangeRefreshed(Handler $this, @NotNull Block before, @NotNull List<Block> after) {
            }

            public static void onRangesChanged(Handler $this, @NotNull List<Block> before, @NotNull Block after) {
            }

            public static void onRangeShifted(Handler $this, @NotNull Block before, @NotNull Block after) {
            }

            public static boolean onRangesMerged(Handler $this, @NotNull Block range1, @NotNull Block range2, @NotNull Block merged) {
                return true;
            }

            public static void afterRangeChange(Handler $this) {
            }

            public static void afterBulkRangeChange(Handler $this) {
            }

            public static void onFreeze(Handler $this, @NotNull Side side) {
            }

            public static void onUnfreeze(Handler $this, @NotNull Side side) {
            }

            public static void onFreeze(Handler $this) {
            }

            public static void onUnfreeze(Handler $this) {
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "", "range", "Lcom/intellij/diff/util/Range;", "isDirty", "", "isTooBig", "(Lcom/intellij/diff/util/Range;ZZ)V", "data", "getData", "()Ljava/lang/Object;", "setData", "(Ljava/lang/Object;)V", "isDirty$intellij_platform_diff_impl", "()Z", "isTooBig$intellij_platform_diff_impl", "getRange", "()Lcom/intellij/diff/util/Range;", "intellij.platform.diff.impl"})
    public static final class Block {
        @Nullable
        private Object data;
        @NotNull
        private final Range range;
        private final boolean isDirty;
        private final boolean isTooBig;

        @Nullable
        public final Object getData() {
            return this.data;
        }

        public final void setData(@Nullable Object object) {
            this.data = object;
        }

        @NotNull
        public final Range getRange() {
            return this.range;
        }

        public final boolean isDirty$intellij_platform_diff_impl() {
            return this.isDirty;
        }

        public final boolean isTooBig$intellij_platform_diff_impl() {
            return this.isTooBig;
        }

        public Block(@NotNull Range range2, boolean isDirty, boolean isTooBig) {
            this.range = range2;
            this.isDirty = isDirty;
            this.isTooBig = isTooBig;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

