/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.LineStatusTrackerI;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;

public abstract class LineStatusActionBase
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (project == null || editor == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        LineStatusTracker<?> tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(editor.getDocument());
        if (!(tracker != null && tracker.isValid() && tracker.isAvailableAt(editor) && this.isEnabled(tracker, editor))) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (!LineStatusActionBase.isSomeChangeSelected(editor, tracker)) {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        Editor editor = (Editor)e.getRequiredData(CommonDataKeys.EDITOR);
        LineStatusTracker<?> tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(editor.getDocument());
        assert (tracker != null);
        this.doAction(tracker, editor);
    }

    private static boolean isSomeChangeSelected(@NotNull Editor editor, @NotNull LineStatusTrackerI<?> tracker) {
        return DiffUtil.isSomeRangeSelected(editor, (Condition<? super BitSet>)((Condition)lines2 -> !ContainerUtil.isEmpty(tracker.getRangesForLines((BitSet)lines2))));
    }

    protected boolean isEnabled(@NotNull LineStatusTrackerI<?> tracker, @NotNull Editor editor) {
        return true;
    }

    protected abstract void doAction(@NotNull LineStatusTrackerI<?> var1, @NotNull Editor var2);
}

