/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.IntPair;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LineStatusMarkerRenderer {
    private static final Logger LOG = Logger.getInstance(LineStatusMarkerRenderer.class);
    @NotNull
    protected final LineStatusTrackerBase<?> myTracker;
    private final MarkupEditorFilter myEditorFilter;
    @NotNull
    private final MergingUpdateQueue myUpdateQueue;
    private boolean myDisposed = false;
    @NotNull
    private final RangeHighlighter myHighlighter;
    @NotNull
    private final List<RangeHighlighter> myTooltipHighlighters = new ArrayList<RangeHighlighter>();

    public LineStatusMarkerRenderer(@NotNull LineStatusTrackerBase<?> tracker) {
        this.myTracker = tracker;
        this.myEditorFilter = this.getEditorFilter();
        Document document = this.myTracker.getDocument();
        MarkupModel markupModel = DocumentMarkupModel.forDocument(document, this.myTracker.getProject(), true);
        this.myHighlighter = markupModel.addRangeHighlighter(0, document.getTextLength(), 5999, null, HighlighterTargetArea.LINES_IN_RANGE);
        this.myHighlighter.setGreedyToLeft(true);
        this.myHighlighter.setGreedyToRight(true);
        this.myHighlighter.setLineMarkerRenderer((LineMarkerRenderer)new MyActiveGutterRenderer());
        if (this.myEditorFilter != null) {
            this.myHighlighter.setEditorFilter(this.myEditorFilter);
        }
        this.myUpdateQueue = new MergingUpdateQueue("LineStatusMarkerRenderer", 100, true, MergingUpdateQueue.ANY_COMPONENT, this.myTracker.getDisposable());
        Disposer.register((Disposable)this.myTracker.getDisposable(), (Disposable)new Disposable(){

            public void dispose() {
                LineStatusMarkerRenderer.this.myDisposed = true;
                LineStatusMarkerRenderer.this.destroyHighlighters();
            }
        });
        this.scheduleUpdate();
    }

    public void scheduleUpdate() {
        this.myUpdateQueue.queue(new Update("update"){

            public void run() {
                LineStatusMarkerRenderer.this.updateHighlighters();
            }
        });
    }

    private void updateHighlighters() {
        if (this.myDisposed) {
            return;
        }
        for (RangeHighlighter highlighter : this.myTooltipHighlighters) {
            LineStatusMarkerRenderer.disposeHighlighter(highlighter);
        }
        this.myTooltipHighlighters.clear();
        List<?> ranges = this.myTracker.getRanges();
        if (ranges != null) {
            MarkupModel markupModel = DocumentMarkupModel.forDocument(this.myTracker.getDocument(), this.myTracker.getProject(), true);
            for (Range range2 : ranges) {
                RangeHighlighter highlighter = LineStatusMarkerRenderer.createTooltipRangeHighlighter(range2, markupModel);
                if (this.myEditorFilter != null) {
                    highlighter.setEditorFilter(this.myEditorFilter);
                }
                this.myTooltipHighlighters.add(highlighter);
            }
        }
    }

    private void destroyHighlighters() {
        LineStatusMarkerRenderer.disposeHighlighter(this.myHighlighter);
        for (RangeHighlighter highlighter : this.myTooltipHighlighters) {
            LineStatusMarkerRenderer.disposeHighlighter(highlighter);
        }
        this.myTooltipHighlighters.clear();
    }

    private static void disposeHighlighter(@NotNull RangeHighlighter highlighter) {
        try {
            highlighter.dispose();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private boolean canDoAction(@NotNull Editor editor, @NotNull MouseEvent e) {
        List<? extends Range> ranges = this.getSelectedRanges(editor, e.getY());
        return !ranges.isEmpty() && this.canDoAction(editor, ranges, e);
    }

    private void doAction(@NotNull Editor editor, @NotNull MouseEvent e) {
        List<? extends Range> ranges = this.getSelectedRanges(editor, e.getY());
        if (!ranges.isEmpty()) {
            this.doAction(editor, ranges, e);
        }
    }

    @NotNull
    protected List<? extends Range> getSelectedRanges(@NotNull Editor editor, int y) {
        List<?> ranges = this.myTracker.getRanges();
        if (ranges == null) {
            return Collections.emptyList();
        }
        int lineHeight = editor.getLineHeight();
        int visibleLineCount = ((EditorImpl)editor).getVisibleLineCount();
        boolean lastLineSelected = editor.yToVisualLine(y) == visibleLineCount - 1;
        int triangleGap = lineHeight / 3;
        Rectangle clip = new Rectangle(0, y - lineHeight, editor.getComponent().getWidth(), lineHeight * 2);
        List<ChangesBlock> blocks = this.createMerger(editor).run(ranges, clip);
        ArrayList<Range> result2 = new ArrayList<Range>();
        for (ChangesBlock block : blocks) {
            ChangedLines firstChange = block.changes.get(0);
            ChangedLines lastChange = block.changes.get(block.changes.size() - 1);
            int line1 = firstChange.line1;
            int line2 = lastChange.line2;
            int startY = editor.visualLineToY(line1);
            int endY = editor.visualLineToY(line2);
            if (firstChange.line1 == firstChange.line2) {
                startY -= triangleGap;
            }
            if (lastChange.line1 == lastChange.line2) {
                endY += triangleGap;
            }
            if (startY <= y && endY > y) {
                result2.addAll(block.ranges);
                continue;
            }
            if (!lastLineSelected || line2 != visibleLineCount) continue;
            result2.addAll(block.ranges);
        }
        return result2;
    }

    protected boolean canDoAction(@NotNull Editor editor, @NotNull List<? extends Range> ranges, @NotNull MouseEvent e) {
        return false;
    }

    protected void doAction(@NotNull Editor editor, @NotNull List<? extends Range> ranges, @NotNull MouseEvent e) {
    }

    @NotNull
    protected VisibleRangeMerger createMerger(@NotNull Editor editor) {
        return new VisibleRangeMerger(editor);
    }

    @Nullable
    protected MarkupEditorFilter getEditorFilter() {
        return null;
    }

    protected int getFramingBorderSize() {
        return 0;
    }

    @NotNull
    public static RangeHighlighter createTooltipRangeHighlighter(@NotNull Range range2, @NotNull MarkupModel markupModel) {
        TextRange textRange = DiffUtil.getLinesRange(markupModel.getDocument(), range2.getLine1(), range2.getLine2(), false);
        TextAttributes attributes = LineStatusMarkerRenderer.getTextAttributes(range2);
        RangeHighlighter highlighter = markupModel.addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), 5999, attributes, HighlighterTargetArea.LINES_IN_RANGE);
        highlighter.setThinErrorStripeMark(true);
        highlighter.setGreedyToLeft(true);
        highlighter.setGreedyToRight(true);
        return highlighter;
    }

    @NotNull
    private static TextAttributes getTextAttributes(final @NotNull Range range2) {
        return new TextAttributes(){

            public Color getErrorStripeColor() {
                return LineStatusMarkerRenderer.getErrorStripeColor(range2, null);
            }
        };
    }

    private Rectangle calcBounds(Editor editor, int lineNum, Rectangle bounds2) {
        List<?> ranges = this.myTracker.getRanges();
        if (ranges == null) {
            return null;
        }
        List<ChangesBlock> blocks = this.createMerger(editor).run(ranges, bounds2);
        if (blocks.isEmpty()) {
            return null;
        }
        int visibleLineCount = ((EditorImpl)editor).getVisibleLineCount();
        boolean lastLineSelected = lineNum == visibleLineCount - 1;
        ChangesBlock lineBlock = null;
        for (ChangesBlock block : blocks) {
            int endLine;
            ChangedLines firstChange = block.changes.get(0);
            ChangedLines lastChange = block.changes.get(block.changes.size() - 1);
            int line1 = firstChange.line1;
            int line2 = lastChange.line2;
            int n = endLine = line1 == line2 ? line2 + 1 : line2;
            if (line1 <= lineNum && endLine > lineNum) {
                lineBlock = block;
                break;
            }
            if (lastLineSelected && line2 == visibleLineCount) {
                lineBlock = block;
                break;
            }
            if (line1 <= lineNum) continue;
            break;
        }
        if (lineBlock == null) {
            return null;
        }
        List<ChangedLines> changes2 = lineBlock.changes;
        int startLine = changes2.get((int)0).line1;
        int endLine = changes2.get((int)(changes2.size() - 1)).line2;
        IntPair area = LineStatusMarkerRenderer.getGutterArea(editor);
        int y = editor.visualLineToY(startLine);
        int endY = editor.visualLineToY(endLine);
        return new Rectangle(area.val1, y, area.val2 - area.val1, endY - y);
    }

    protected void paint(@NotNull Editor editor, @NotNull Graphics g) {
        List<?> ranges = this.myTracker.getRanges();
        if (ranges == null) {
            return;
        }
        int framingBorder = this.getFramingBorderSize();
        List<ChangesBlock> blocks = this.createMerger(editor).run(ranges, g.getClipBounds());
        for (ChangesBlock block : blocks) {
            LineStatusMarkerRenderer.paintChangedLines((Graphics2D)g, editor, block.changes, framingBorder);
        }
    }

    private static void paintChangedLines(@NotNull Graphics2D g, @NotNull Editor editor, @NotNull List<ChangedLines> block, int framingBorder) {
        int end;
        int start2;
        EditorImpl editorImpl = (EditorImpl)editor;
        Color borderColor = LineStatusMarkerRenderer.getGutterBorderColor(editor);
        Color gutterBackgroundColor = ((EditorEx)editor).getGutterComponentEx().getBackground();
        int line1 = block.get((int)0).line1;
        int line2 = block.get((int)(block.size() - 1)).line2;
        IntPair area = LineStatusMarkerRenderer.getGutterArea(editor);
        int x = area.val1;
        int endX = area.val2;
        int y = editorImpl.visualLineToY(line1);
        int endY = editorImpl.visualLineToY(line2);
        if (framingBorder > 0 && y != endY) {
            g.setColor(gutterBackgroundColor);
            g.fillRect(x - framingBorder, y - framingBorder, endX - x + framingBorder, endY - y + framingBorder * 2);
        }
        for (ChangedLines change : block) {
            if (change.line1 == change.line2 || change.isIgnored) continue;
            start2 = editorImpl.visualLineToY(change.line1);
            end = editorImpl.visualLineToY(change.line2);
            Color gutterColor = LineStatusMarkerRenderer.getGutterColor(change.type, editor);
            LineStatusMarkerRenderer.paintRect(g, gutterColor, null, x, start2, endX, end);
        }
        if (borderColor == null) {
            for (ChangedLines change : block) {
                if (change.line1 == change.line2 || !change.isIgnored) continue;
                start2 = editorImpl.visualLineToY(change.line1);
                end = editorImpl.visualLineToY(change.line2);
                Color ignoredBorderColor = LineStatusMarkerRenderer.getIgnoredGutterBorderColor(change.type, editor);
                LineStatusMarkerRenderer.paintRect(g, null, ignoredBorderColor, x, start2, endX, end);
            }
        } else {
            LineStatusMarkerRenderer.paintRect(g, null, borderColor, x, y, endX, endY);
        }
        for (ChangedLines change : block) {
            if (change.line1 != change.line2) continue;
            start2 = editorImpl.visualLineToY(change.line1);
            if (!change.isIgnored) {
                Color gutterColor = LineStatusMarkerRenderer.getGutterColor(change.type, editor);
                LineStatusMarkerRenderer.paintTriangle(g, editor, gutterColor, borderColor, x, endX, start2);
                continue;
            }
            Color ignoredBorderColor = LineStatusMarkerRenderer.getIgnoredGutterBorderColor(change.type, editor);
            LineStatusMarkerRenderer.paintTriangle(g, editor, null, ignoredBorderColor, x, endX, start2);
        }
    }

    public static void paintRange(@NotNull Graphics g, @NotNull Editor editor, @NotNull Range range2, int framingBorder) {
        List<ChangesBlock> blocks = new VisibleRangeMerger(editor).run(Collections.singletonList(range2), g.getClipBounds());
        for (ChangesBlock block : blocks) {
            LineStatusMarkerRenderer.paintChangedLines((Graphics2D)g, editor, block.changes, framingBorder);
        }
    }

    public static void paintSimpleRange(Graphics g, Editor editor, int line1, int line2, @Nullable Color color) {
        IntPair horizontalArea = LineStatusMarkerRenderer.getGutterArea(editor);
        int x = horizontalArea.val1;
        int endX = horizontalArea.val2;
        int y = DiffDrawUtil.lineToY(editor, line1);
        int endY = DiffDrawUtil.lineToY(editor, line2);
        Color borderColor = LineStatusMarkerRenderer.getGutterBorderColor(editor);
        if (endY != y) {
            LineStatusMarkerRenderer.paintRect((Graphics2D)g, color, borderColor, x, y, endX, endY);
        } else {
            LineStatusMarkerRenderer.paintTriangle((Graphics2D)g, editor, color, borderColor, x, endX, y);
        }
    }

    @NotNull
    private static IntPair getGutterArea(@NotNull Editor editor) {
        EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
        int x = gutter.getLineMarkerFreePaintersAreaOffset() + 1;
        int endX = gutter.getWhitespaceSeparatorOffset();
        return new IntPair(x, endX);
    }

    public static boolean isInsideMarkerArea(@NotNull MouseEvent e) {
        EditorGutterComponentEx gutter = (EditorGutterComponentEx)e.getComponent();
        return e.getX() > gutter.getLineMarkerFreePaintersAreaOffset();
    }

    private static void paintRect(@NotNull Graphics2D g, @Nullable Color color, @Nullable Color borderColor, int x1, int y1, int x2, int y2) {
        if (color != null) {
            g.setColor(color);
            g.fillRect(x1, y1, x2 - x1, y2 - y1);
        }
        if (borderColor != null) {
            Stroke oldStroke = g.getStroke();
            g.setStroke(new BasicStroke(JBUI.scale((int)1)));
            g.setColor(borderColor);
            UIUtil.drawLine((Graphics)g, (int)x1, (int)y1, (int)(x2 - 1), (int)y1);
            UIUtil.drawLine((Graphics)g, (int)x1, (int)y1, (int)x1, (int)(y2 - 1));
            UIUtil.drawLine((Graphics)g, (int)x1, (int)(y2 - 1), (int)(x2 - 1), (int)(y2 - 1));
            g.setStroke(oldStroke);
        }
    }

    private static void paintTriangle(@NotNull Graphics2D g, @NotNull Editor editor, @Nullable Color color, @Nullable Color borderColor, int x1, int x2, int y) {
        float editorScale = editor instanceof EditorImpl ? ((EditorImpl)editor).getScale() : 1.0f;
        int size = (int)JBUI.scale((float)(4.0f * editorScale));
        int[] xPoints = new int[]{x1, x1, x2};
        int[] yPoints = new int[]{y - size, y + size, y};
        if (color != null) {
            g.setColor(color);
            g.fillPolygon(xPoints, yPoints, xPoints.length);
        }
        if (borderColor != null) {
            Stroke oldStroke = g.getStroke();
            g.setStroke(new BasicStroke(JBUI.scale((int)1)));
            g.setColor(borderColor);
            g.drawPolygon(xPoints, yPoints, xPoints.length);
            g.setStroke(oldStroke);
        }
    }

    @Nullable
    private static Color getGutterColor(byte type, @Nullable Editor editor) {
        EditorColorsScheme scheme2 = LineStatusMarkerRenderer.getColorScheme(editor);
        switch (type) {
            case 2: {
                return scheme2.getColor(EditorColors.ADDED_LINES_COLOR);
            }
            case 3: {
                return scheme2.getColor(EditorColors.DELETED_LINES_COLOR);
            }
            case 1: {
                return scheme2.getColor(EditorColors.MODIFIED_LINES_COLOR);
            }
            case 0: {
                return scheme2.getColor(EditorColors.WHITESPACES_MODIFIED_LINES_COLOR);
            }
        }
        assert (false);
        return null;
    }

    @Nullable
    private static Color getErrorStripeColor(@NotNull Range range2, @Nullable Editor editor) {
        EditorColorsScheme scheme2 = LineStatusMarkerRenderer.getColorScheme(editor);
        switch (range2.getType()) {
            case 2: {
                return scheme2.getAttributes(DiffColors.DIFF_INSERTED).getErrorStripeColor();
            }
            case 3: {
                return scheme2.getAttributes(DiffColors.DIFF_DELETED).getErrorStripeColor();
            }
            case 1: {
                return scheme2.getAttributes(DiffColors.DIFF_MODIFIED).getErrorStripeColor();
            }
        }
        assert (false);
        return null;
    }

    @Nullable
    private static Color getIgnoredGutterBorderColor(byte type, @Nullable Editor editor) {
        Color borderColor = LineStatusMarkerRenderer.getGutterBorderColor(editor);
        if (borderColor != null) {
            return borderColor;
        }
        EditorColorsScheme scheme2 = LineStatusMarkerRenderer.getColorScheme(editor);
        switch (type) {
            case 2: {
                return scheme2.getColor(EditorColors.IGNORED_ADDED_LINES_BORDER_COLOR);
            }
            case 3: {
                return scheme2.getColor(EditorColors.IGNORED_DELETED_LINES_BORDER_COLOR);
            }
            case 0: 
            case 1: {
                return scheme2.getColor(EditorColors.IGNORED_MODIFIED_LINES_BORDER_COLOR);
            }
        }
        assert (false);
        return null;
    }

    @Nullable
    private static Color getGutterBorderColor(@Nullable Editor editor) {
        return LineStatusMarkerRenderer.getColorScheme(editor).getColor(EditorColors.BORDER_LINES_COLOR);
    }

    @NotNull
    private static EditorColorsScheme getColorScheme(@Nullable Editor editor) {
        return editor != null ? editor.getColorsScheme() : EditorColorsManager.getInstance().getGlobalScheme();
    }

    private class MyActiveGutterRenderer
    implements ActiveGutterRenderer {
        private MyActiveGutterRenderer() {
        }

        public void paint(Editor editor, Graphics g, Rectangle r) {
            LineStatusMarkerRenderer.this.paint(editor, g);
        }

        public boolean canDoAction(@NotNull Editor editor, @NotNull MouseEvent e) {
            return LineStatusMarkerRenderer.this.canDoAction(editor, e);
        }

        public void doAction(@NotNull Editor editor, @NotNull MouseEvent e) {
            LineStatusMarkerRenderer.this.doAction(editor, e);
        }

        @Nullable
        public Rectangle calcBounds(@NotNull Editor editor, int lineNum, @NotNull Rectangle preferredBounds) {
            return LineStatusMarkerRenderer.this.calcBounds(editor, lineNum, preferredBounds);
        }

        @NotNull
        public String getAccessibleName() {
            return "VCS marker: changed line";
        }
    }

    private static class ChangedLines {
        public final int line1;
        public final int line2;
        public final byte type;
        private final boolean isIgnored;

        ChangedLines(int line1, int line2, byte type, boolean isIgnored) {
            this.line1 = line1;
            this.line2 = line2;
            this.type = type;
            this.isIgnored = isIgnored;
        }
    }

    private static class ChangesBlock {
        @NotNull
        public final List<ChangedLines> changes = new ArrayList<ChangedLines>();
        @NotNull
        public final List<Range> ranges = new ArrayList<Range>();

        private ChangesBlock() {
        }
    }

    protected static class VisibleRangeMerger {
        @NotNull
        private final Editor myEditor;
        @NotNull
        private ChangesBlock myBlock = new ChangesBlock();
        @NotNull
        private final List<ChangesBlock> myResult = new ArrayList<ChangesBlock>();

        public VisibleRangeMerger(@NotNull Editor editor) {
            this.myEditor = editor;
        }

        protected boolean isIgnored(@NotNull Range range2) {
            return false;
        }

        @NotNull
        public List<ChangesBlock> run(@NotNull List<? extends Range> ranges, @NotNull Rectangle clip) {
            int visibleLineStart = DiffDrawUtil.yToLine(this.myEditor, clip.y);
            int visibleLineEnd = DiffDrawUtil.yToLine(this.myEditor, clip.y + clip.height) + 1;
            for (Range range2 : ranges) {
                int line1 = range2.getLine1();
                int line2 = range2.getLine2();
                if (line2 < visibleLineStart) continue;
                if (line1 > visibleLineEnd) break;
                boolean isIgnored = this.isIgnored(range2);
                List<Range.InnerRange> innerRanges = range2.getInnerRanges();
                if (innerRanges == null || isIgnored) {
                    this.processLine(range2, line1, line2, range2.getType(), isIgnored);
                    continue;
                }
                for (Range.InnerRange innerRange : innerRanges) {
                    int innerLine1 = line1 + innerRange.getLine1();
                    int innerLine2 = line1 + innerRange.getLine2();
                    byte innerType = innerRange.getType();
                    this.processLine(range2, innerLine1, innerLine2, innerType, isIgnored);
                }
            }
            this.finishBlock();
            return this.myResult;
        }

        private void processLine(@NotNull Range range2, int start2, int end, byte type, boolean isIgnored) {
            boolean startHasFolding;
            int visualStart;
            EditorImpl editorImpl = (EditorImpl)this.myEditor;
            Document document = this.myEditor.getDocument();
            int lineCount = DiffUtil.getLineCount(document);
            if (start2 < lineCount) {
                int startOffset = document.getLineStartOffset(start2);
                visualStart = editorImpl.offsetToVisualLine(startOffset);
                startHasFolding = startOffset > 0 && this.myEditor.getFoldingModel().isOffsetCollapsed(startOffset - 1);
            } else {
                LOG.assertTrue(start2 == lineCount);
                int lastVisualLine = editorImpl.offsetToVisualLine(document.getTextLength());
                visualStart = lastVisualLine + start2 - lineCount + 1;
                startHasFolding = false;
            }
            if (start2 == end) {
                if (startHasFolding) {
                    this.appendChange(range2, new ChangedLines(visualStart, visualStart + 1, 1, isIgnored));
                } else {
                    this.appendChange(range2, new ChangedLines(visualStart, visualStart, type, isIgnored));
                }
            } else {
                boolean endHasFolding;
                int visualEnd;
                if (end < lineCount) {
                    int endOffset = document.getLineEndOffset(end - 1);
                    visualEnd = editorImpl.offsetToVisualLine(endOffset) + 1;
                    endHasFolding = this.myEditor.getFoldingModel().isOffsetCollapsed(endOffset);
                } else {
                    LOG.assertTrue(end == lineCount);
                    int lastVisualLine = editorImpl.offsetToVisualLine(document.getTextLength());
                    visualEnd = lastVisualLine + end - lineCount + 1;
                    endHasFolding = false;
                }
                if (type == 0 || type == 1) {
                    this.appendChange(range2, new ChangedLines(visualStart, visualEnd, type, isIgnored));
                } else {
                    if (startHasFolding && visualEnd - visualStart > 1) {
                        this.appendChange(range2, new ChangedLines(visualStart, visualStart + 1, 1, isIgnored));
                        startHasFolding = false;
                        ++visualStart;
                    }
                    if (endHasFolding && visualEnd - visualStart > 1) {
                        this.appendChange(range2, new ChangedLines(visualStart, visualEnd - 1, type, isIgnored));
                        this.appendChange(range2, new ChangedLines(visualEnd - 1, visualEnd, 1, isIgnored));
                    } else {
                        byte bodyType = startHasFolding || endHasFolding ? (byte)1 : type;
                        this.appendChange(range2, new ChangedLines(visualStart, visualEnd, bodyType, isIgnored));
                    }
                }
            }
        }

        private void appendChange(@NotNull Range range2, @NotNull ChangedLines newChange) {
            ChangedLines lastItem = (ChangedLines)ContainerUtil.getLastItem(this.myBlock.changes);
            if (lastItem != null && lastItem.line2 < newChange.line1) {
                this.finishBlock();
            }
            List<ChangedLines> changes2 = this.myBlock.changes;
            List<Range> ranges = this.myBlock.ranges;
            if (ContainerUtil.getLastItem(ranges) != range2) {
                ranges.add(range2);
            }
            if (changes2.isEmpty()) {
                changes2.add(newChange);
                return;
            }
            ChangedLines lastChange = changes2.remove(changes2.size() - 1);
            if (lastChange.line1 == lastChange.line2 && newChange.line1 == newChange.line2) {
                assert (lastChange.line1 == newChange.line1);
                byte type = lastChange.type == newChange.type ? lastChange.type : (byte)1;
                boolean isIgnored = lastChange.isIgnored && newChange.isIgnored;
                changes2.add(new ChangedLines(lastChange.line1, lastChange.line2, type, isIgnored));
            } else if (lastChange.line1 == lastChange.line2 && newChange.type == 0 || newChange.line1 == newChange.line2 && lastChange.type == 0) {
                changes2.add(lastChange);
                changes2.add(newChange);
            } else if (lastChange.type == newChange.type && lastChange.isIgnored == newChange.isIgnored) {
                int union1 = Math.min(lastChange.line1, newChange.line1);
                int union2 = Math.max(lastChange.line2, newChange.line2);
                changes2.add(new ChangedLines(union1, union2, lastChange.type, lastChange.isIgnored));
            } else {
                int intersection1 = Math.max(lastChange.line1, newChange.line1);
                int intersection2 = Math.min(lastChange.line2, newChange.line2);
                if (lastChange.line1 != intersection1) {
                    changes2.add(new ChangedLines(lastChange.line1, intersection1, lastChange.type, lastChange.isIgnored));
                }
                if (intersection1 != intersection2) {
                    byte type = lastChange.type == newChange.type ? lastChange.type : (byte)1;
                    boolean isIgnored = lastChange.isIgnored && newChange.isIgnored;
                    changes2.add(new ChangedLines(intersection1, intersection2, type, isIgnored));
                }
                if (newChange.line2 != intersection2) {
                    changes2.add(new ChangedLines(intersection2, newChange.line2, newChange.type, newChange.isIgnored));
                }
            }
        }

        private void finishBlock() {
            if (this.myBlock.changes.isEmpty()) {
                return;
            }
            this.myResult.add(this.myBlock);
            this.myBlock = new ChangesBlock();
        }
    }
}

