/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopupRenderer;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.LocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RollbackLineStatusAction;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0002/0B%\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001d\u001a\u00020\u001eH\u0014J\u0018\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0014J\r\u0010#\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b$J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020&H\u0014J\u0018\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010,\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(H\u0016J\r\u0010-\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b.R$\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\u0016X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00061"}, d2={"Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "R", "Lcom/intellij/openapi/vcs/ex/Range;", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase;", "Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "mode", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$Mode;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$Mode;)V", "value", "getMode", "()Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$Mode;", "setMode", "(Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$Mode;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "renderer", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$LocalLineStatusMarkerRenderer;", "getRenderer", "()Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$LocalLineStatusMarkerRenderer;", "vcsDirtyScopeManager", "Lcom/intellij/openapi/vcs/changes/VcsDirtyScopeManager;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "fireFileUnchanged", "", "fireLinesUnchanged", "startLine", "", "endLine", "freeze", "freeze$intellij_platform_vcs_impl", "isAvailableAt", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "isDetectWhitespaceChangedLines", "scrollAndShowHint", "range", "showHint", "unfreeze", "unfreeze$intellij_platform_vcs_impl", "LocalLineStatusMarkerRenderer", "Mode", "intellij.platform.vcs.impl"})
public abstract class LocalLineStatusTracker<R extends Range>
extends LineStatusTrackerBase<R>
implements LineStatusTracker<R> {
    private final VcsDirtyScopeManager vcsDirtyScopeManager;
    @NotNull
    private Mode mode;
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile virtualFile;

    @Override
    @NotNull
    protected abstract LocalLineStatusMarkerRenderer getRenderer();

    @NotNull
    public final Mode getMode() {
        return this.mode;
    }

    public final void setMode(@NotNull Mode value) {
        if (value == this.mode) {
            return;
        }
        this.mode = value;
        this.updateInnerRanges();
    }

    @Override
    public boolean isAvailableAt(@NotNull Editor editor) {
        return this.mode != Mode.SILENT && editor.getSettings().isLineMarkerAreaShown() && !DiffUtil.isDiffEditor(editor);
    }

    @Override
    protected boolean isDetectWhitespaceChangedLines() {
        return this.mode == Mode.SMART;
    }

    @Override
    protected void fireFileUnchanged() {
        if (GeneralSettings.getInstance().isSaveOnFrameDeactivation()) {
            TransactionGuard.getInstance().submitTransactionLater((Disposable)this.getProject(), new Runnable(this){
                final /* synthetic */ LocalLineStatusTracker this$0;

                public final void run() {
                    FileDocumentManager.getInstance().saveDocument(this.this$0.getDocument());
                    boolean isEmpty2 = (Boolean)this.this$0.getDocumentTracker().readLock((Function0)new Function0<Boolean>(this){
                        final /* synthetic */ fireFileUnchanged.1 this$0;

                        public final boolean invoke() {
                            return this.this$0.this$0.getBlocks().isEmpty();
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    });
                    if (isEmpty2) {
                        LocalLineStatusTracker.access$getVcsDirtyScopeManager$p(this.this$0).fileDirty(this.this$0.getVirtualFile());
                    }
                }
                {
                    this.this$0 = localLineStatusTracker;
                }
            });
        }
    }

    @Override
    protected void fireLinesUnchanged(int startLine, int endLine) {
        if (this.getDocument().getTextLength() == 0) {
            return;
        }
        if (startLine == endLine) {
            return;
        }
        Document document = this.getDocument();
        if (document == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.impl.DocumentImpl");
        }
        ((DocumentImpl)document).clearLineModificationFlags(startLine, endLine);
    }

    @Override
    public void scrollAndShowHint(@NotNull Range range2, @NotNull Editor editor) {
        this.getRenderer().scrollAndShow(editor, range2);
    }

    @Override
    public void showHint(@NotNull Range range2, @NotNull Editor editor) {
        this.getRenderer().showAfterScroll(editor, range2);
    }

    public final void freeze$intellij_platform_vcs_impl() {
        this.getDocumentTracker().freeze(Side.LEFT);
        this.getDocumentTracker().freeze(Side.RIGHT);
    }

    public final void unfreeze$intellij_platform_vcs_impl() {
        this.getDocumentTracker().unfreeze(Side.LEFT);
        this.getDocumentTracker().unfreeze(Side.RIGHT);
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    public LocalLineStatusTracker(@NotNull Project project, @NotNull Document document, @NotNull VirtualFile virtualFile, @NotNull Mode mode) {
        super(project, document);
        this.project = project;
        this.virtualFile = virtualFile;
        this.vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.getProject());
        this.mode = mode;
    }

    public static final /* synthetic */ VcsDirtyScopeManager access$getVcsDirtyScopeManager$p(LocalLineStatusTracker $this) {
        return $this.vcsDirtyScopeManager;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$Mode;", "", "(Ljava/lang/String;I)V", "DEFAULT", "SMART", "SILENT", "intellij.platform.vcs.impl"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode DEFAULT;
        public static final /* enum */ Mode SMART;
        public static final /* enum */ Mode SILENT;
        private static final /* synthetic */ Mode[] $VALUES;

        static {
            Mode[] modeArray = new Mode[3];
            Mode[] modeArray2 = modeArray;
            modeArray[0] = DEFAULT = new Mode();
            modeArray[1] = SMART = new Mode();
            modeArray[2] = SILENT = new Mode();
            $VALUES = modeArray;
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String string) {
            return Enum.valueOf(Mode.class, string);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0014\u0018\u00002\u00020\u0001:\u0001\u001dB\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J(\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014R\u0018\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$LocalLineStatusMarkerRenderer;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer;", "tracker", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "(Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;)V", "getTracker", "()Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "canDoAction", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "ranges", "", "Lcom/intellij/openapi/vcs/ex/Range;", "e", "Ljava/awt/event/MouseEvent;", "createToolbarActions", "Lcom/intellij/openapi/actionSystem/AnAction;", "range", "mousePosition", "Ljava/awt/Point;", "getEditorFilter", "Lcom/intellij/openapi/editor/markup/MarkupEditorFilter;", "getFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "paint", "", "g", "Ljava/awt/Graphics;", "RollbackLineStatusRangeAction", "intellij.platform.vcs.impl"})
    protected static class LocalLineStatusMarkerRenderer
    extends LineStatusMarkerPopupRenderer {
        @NotNull
        private final LocalLineStatusTracker<?> tracker;

        @Override
        @Nullable
        protected MarkupEditorFilter getEditorFilter() {
            return MarkupEditorFilterFactory.createIsNotDiffFilter();
        }

        @Override
        protected boolean canDoAction(@NotNull Editor editor, @NotNull List<? extends Range> ranges, @NotNull MouseEvent e) {
            if (this.getTracker().getMode() == Mode.SILENT) {
                return false;
            }
            return super.canDoAction(editor, ranges, e);
        }

        @Override
        protected void paint(@NotNull Editor editor, @NotNull Graphics g) {
            if (this.getTracker().getMode() == Mode.SILENT) {
                return;
            }
            super.paint(editor, g);
        }

        @Override
        @NotNull
        protected List<AnAction> createToolbarActions(@NotNull Editor editor, @NotNull Range range2, @Nullable Point mousePosition) {
            ArrayList<Object> actions = new ArrayList<Object>();
            actions.add((Object)new LineStatusMarkerPopupRenderer.ShowPrevChangeMarkerAction(editor, range2));
            actions.add((Object)new LineStatusMarkerPopupRenderer.ShowNextChangeMarkerAction(editor, range2));
            actions.add((Object)new RollbackLineStatusRangeAction(editor, range2));
            actions.add((Object)new LineStatusMarkerPopupRenderer.ShowLineStatusRangeDiffAction(editor, range2));
            actions.add((Object)new LineStatusMarkerPopupRenderer.CopyLineStatusRangeAction(editor, range2));
            actions.add((Object)new LineStatusMarkerPopupRenderer.ToggleByWordDiffAction(editor, range2, mousePosition));
            return actions;
        }

        @Override
        @NotNull
        protected FileType getFileType() {
            return this.getTracker().getVirtualFile().getFileType();
        }

        @NotNull
        public LocalLineStatusTracker<?> getTracker() {
            return this.tracker;
        }

        public LocalLineStatusMarkerRenderer(@NotNull LocalLineStatusTracker<?> tracker) {
            super((LineStatusTrackerBase)tracker);
            this.tracker = tracker;
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$LocalLineStatusMarkerRenderer$RollbackLineStatusRangeAction;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer$RangeMarkerAction;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "(Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$LocalLineStatusMarkerRenderer;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/vcs/ex/Range;)V", "actionPerformed", "", "isEnabled", "", "intellij.platform.vcs.impl"})
        private final class RollbackLineStatusRangeAction
        extends LineStatusMarkerPopupRenderer.RangeMarkerAction {
            @Override
            protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range2) {
                return true;
            }

            @Override
            protected void actionPerformed(@NotNull Editor editor, @NotNull Range range2) {
                RollbackLineStatusAction.rollback((LineStatusTrackerBase)LocalLineStatusMarkerRenderer.this.getTracker(), range2, editor);
            }

            public RollbackLineStatusRangeAction(@NotNull Editor editor, Range range2) {
                super(editor, range2, "Vcs.RollbackChangedLines");
            }
        }
    }
}

