/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.MoveChangesToAnotherListAction;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import com.intellij.openapi.vcs.ex.LineStatusActionBase;
import com.intellij.openapi.vcs.ex.LineStatusTrackerI;
import com.intellij.openapi.vcs.ex.LocalRange;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveChangesLineStatusAction
extends LineStatusActionBase {
    @Override
    protected boolean isEnabled(@NotNull LineStatusTrackerI<?> tracker, @NotNull Editor editor) {
        return tracker instanceof PartialLocalLineStatusTracker;
    }

    @Override
    protected void doAction(@NotNull LineStatusTrackerI<?> tracker, @NotNull Editor editor) {
        MoveChangesLineStatusAction.moveToAnotherChangelist((PartialLocalLineStatusTracker)tracker, editor);
    }

    public static void moveToAnotherChangelist(@NotNull PartialLocalLineStatusTracker tracker, @NotNull Editor editor) {
        MoveChangesLineStatusAction.moveToAnotherChangelist(tracker, DiffUtil.getSelectedLines(editor));
    }

    public static void moveToAnotherChangelist(@NotNull PartialLocalLineStatusTracker tracker, @NotNull BitSet selectedLines) {
        Project project = tracker.getProject();
        List<LocalRange> ranges = tracker.getRangesForLines(selectedLines);
        if (ranges == null || ranges.isEmpty()) {
            return;
        }
        LocalChangeList targetList = MoveChangesLineStatusAction.askTargetChangelist(project, ranges, tracker);
        if (targetList == null) {
            return;
        }
        tracker.moveToChangelist(selectedLines, targetList);
    }

    public static void moveToAnotherChangelist(@NotNull PartialLocalLineStatusTracker tracker, @NotNull LocalRange range2) {
        Project project = tracker.getProject();
        LocalChangeList targetList = MoveChangesLineStatusAction.askTargetChangelist(project, Collections.singletonList(range2), tracker);
        if (targetList == null) {
            return;
        }
        tracker.moveToChangelist(range2, targetList);
    }

    @Nullable
    private static LocalChangeList askTargetChangelist(@NotNull Project project, @NotNull List<LocalRange> selectedRanges, @NotNull PartialLocalLineStatusTracker tracker) {
        Set selectedListIds = ContainerUtil.map2Set(selectedRanges, range2 -> range2.getChangelistId());
        HashSet<String> remainingTrackerListIds = new HashSet<String>(tracker.getAffectedChangeListsIds());
        remainingTrackerListIds.removeAll(selectedListIds);
        ChangeListManager clm = ChangeListManager.getInstance((Project)project);
        List allChangelists = clm.getChangeListsCopy();
        List nonAffectedLists = ContainerUtil.filter((Collection)allChangelists, list2 -> !selectedListIds.contains(list2.getId()));
        List remainingTrackerLists = ContainerUtil.filter((Collection)allChangelists, list2 -> remainingTrackerListIds.contains(list2.getId()));
        List suggestedLists = nonAffectedLists.isEmpty() ? Collections.singletonList(clm.getDefaultChangeList()) : nonAffectedLists;
        List preferedLists = remainingTrackerLists.isEmpty() ? nonAffectedLists : remainingTrackerLists;
        ChangeList defaultSelection2 = MoveChangesToAnotherListAction.guessPreferredList(preferedLists);
        ChangeListChooser chooser = new ChangeListChooser(project, suggestedLists, defaultSelection2, ActionsBundle.message((String)"action.Vcs.MoveChangedLinesToChangelist.text", (Object[])new Object[0]), null);
        chooser.show();
        return chooser.getSelectedList();
    }
}

