/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.ide.CopyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.history.FileHistoryPanelImpl;
import com.intellij.openapi.vcs.history.TreeNodeOnVcsRevision;
import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.HtmlPanel;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DetailsPanel
extends HtmlPanel
implements DataProvider,
CopyProvider {
    @NotNull
    private final Project myProject;
    @NotNull
    private final StatusText myStatusText;
    @Nullable
    private List<? extends TreeNodeOnVcsRevision> mySelection;

    DetailsPanel(@NotNull Project project) {
        this.myProject = project;
        this.myStatusText = new StatusText(){

            protected boolean isStatusVisible() {
                return DetailsPanel.this.mySelection == null || DetailsPanel.this.mySelection.isEmpty();
            }
        };
        this.myStatusText.setText("Commit message");
        this.myStatusText.attachTo((Component)this);
        this.setPreferredSize((Dimension)new JBDimension(150, 100));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.myStatusText.paint((Component)this, g);
    }

    public void update(@NotNull List<? extends TreeNodeOnVcsRevision> selection) {
        this.mySelection = selection;
        this.update();
    }

    @Override
    @NotNull
    protected String getBody() {
        if (this.mySelection == null || this.mySelection.isEmpty()) {
            return "";
        }
        boolean addRevisionInfo = this.mySelection.size() > 1;
        StringBuilder html = new StringBuilder();
        for (TreeNodeOnVcsRevision treeNodeOnVcsRevision : this.mySelection) {
            String message = treeNodeOnVcsRevision.getRevision().getCommitMessage();
            if (StringUtil.isEmpty((String)message)) continue;
            if (html.length() > 0) {
                html.append("<br/><br/>");
            }
            if (addRevisionInfo) {
                String revisionInfo = FileHistoryPanelImpl.getPresentableText(treeNodeOnVcsRevision.getRevision(), false);
                html.append("<font color=\"").append(ColorUtil.toHtmlColor((Color)JBColor.gray).substring(2)).append("\">").append(FontUtil.getHtmlWithFonts(revisionInfo)).append("</font><br/>");
            }
            html.append(FontUtil.getHtmlWithFonts(IssueLinkHtmlRenderer.formatTextWithLinks(this.myProject, message)));
        }
        return html.toString();
    }

    @Override
    public Color getBackground() {
        return UIUtil.getEditorPaneBackground();
    }

    public void performCopy(@NotNull DataContext dataContext) {
        String selectedText = this.getSelectedText();
        if (selectedText == null || selectedText.isEmpty()) {
            selectedText = StringUtil.removeHtmlTags((String)this.getText());
        }
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(selectedText));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        return true;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        return true;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this;
        }
        return null;
    }
}

