/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.history.FileHistoryRefresherI;
import com.intellij.openapi.vcs.history.FileHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsCachingHistory;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.vcs.history.VcsHistoryProviderEx;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistoryRefresher
implements FileHistoryRefresherI {
    @NotNull
    private static final ExecutorService ourExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"File History Refresh");
    @NotNull
    private final FileHistorySessionPartner mySessionPartner;
    @NotNull
    private final VcsHistoryProvider myVcsHistoryProvider;
    @NotNull
    private final FilePath myPath;
    @NotNull
    private final AbstractVcs myVcs;
    @Nullable
    private final VcsRevisionNumber myStartingRevisionNumber;
    private boolean myFirstTime = true;

    public FileHistoryRefresher(@NotNull VcsHistoryProvider vcsHistoryProvider, @NotNull FilePath path, @NotNull AbstractVcs vcs) {
        this(vcsHistoryProvider, path, null, vcs);
    }

    public FileHistoryRefresher(@NotNull VcsHistoryProviderEx vcsHistoryProvider, @NotNull FilePath path, @Nullable VcsRevisionNumber startingRevisionNumber, @NotNull AbstractVcs vcs) {
        this((VcsHistoryProvider)vcsHistoryProvider, path, startingRevisionNumber, vcs);
    }

    private FileHistoryRefresher(@NotNull VcsHistoryProvider vcsHistoryProvider, @NotNull FilePath path, @Nullable VcsRevisionNumber startingRevisionNumber, @NotNull AbstractVcs vcs) {
        this.myVcsHistoryProvider = vcsHistoryProvider;
        this.myPath = path;
        this.myVcs = vcs;
        this.myStartingRevisionNumber = startingRevisionNumber;
        this.mySessionPartner = new FileHistorySessionPartner(vcsHistoryProvider, path, startingRevisionNumber, vcs, this);
        RefreshRequest request = new RefreshRequest(20000, this.mySessionPartner);
        request.schedule();
    }

    @NotNull
    public static FileHistoryRefresherI findOrCreate(@NotNull VcsHistoryProvider vcsHistoryProvider, @NotNull FilePath path, @NotNull AbstractVcs vcs) {
        FileHistoryRefresherI refresher = FileHistorySessionPartner.findExistingHistoryRefresher(vcs.getProject(), path, null);
        return refresher == null ? new FileHistoryRefresher(vcsHistoryProvider, path, vcs) : refresher;
    }

    @NotNull
    public static FileHistoryRefresherI findOrCreate(@NotNull VcsHistoryProviderEx vcsHistoryProvider, @NotNull FilePath path, @NotNull AbstractVcs vcs, @Nullable VcsRevisionNumber startingRevisionNumber) {
        FileHistoryRefresherI refresher = FileHistorySessionPartner.findExistingHistoryRefresher(vcs.getProject(), path, startingRevisionNumber);
        return refresher == null ? new FileHistoryRefresher(vcsHistoryProvider, path, startingRevisionNumber, vcs) : refresher;
    }

    @Override
    public void selectContent() {
        this.mySessionPartner.createOrSelectContent();
    }

    @Override
    public boolean isInRefresh() {
        return VcsCachingHistory.getHistoryLock(this.myVcs, VcsBackgroundableActions.CREATE_HISTORY_SESSION, this.myPath, this.myStartingRevisionNumber).isLocked();
    }

    @Override
    public void refresh(boolean canUseCache) {
        this.mySessionPartner.beforeRefresh();
        if (this.myVcsHistoryProvider instanceof VcsHistoryProviderEx && this.myStartingRevisionNumber != null) {
            VcsCachingHistory.collectInBackground(this.myVcs, this.myPath, this.myStartingRevisionNumber, this.mySessionPartner);
        } else {
            boolean collectedFromCache = false;
            if (this.myFirstTime) {
                collectedFromCache = VcsCachingHistory.collectFromCache(this.myVcs, this.myPath, this.mySessionPartner);
            }
            if (!collectedFromCache) {
                VcsCachingHistory.collectInBackground(this.myVcs, this.myPath, this.mySessionPartner, canUseCache);
            }
        }
        this.myFirstTime = false;
    }

    private class RefreshRequest
    implements Runnable {
        @NotNull
        private final Alarm myUpdateAlarm;
        private final int myDelayMillis;
        @Nullable
        Future<?> myLastTask;

        RefreshRequest(@NotNull int delayMillis, Disposable parent) {
            this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, parent);
            this.myDelayMillis = delayMillis;
        }

        @Override
        public void run() {
            if (this.myLastTask != null) {
                this.myLastTask.cancel(false);
            }
            if (FileHistoryRefresher.this.myVcs.getProject().isDisposed()) {
                return;
            }
            this.myUpdateAlarm.cancelAllRequests();
            if (this.myUpdateAlarm.isDisposed()) {
                return;
            }
            this.schedule();
            if (!ApplicationManager.getApplication().isActive()) {
                return;
            }
            this.myLastTask = ourExecutor.submit(() -> {
                if (!this.myUpdateAlarm.isDisposed() && FileHistoryRefresher.this.mySessionPartner.shouldBeRefreshed()) {
                    ApplicationManager.getApplication().invokeLater(() -> FileHistoryRefresher.this.refresh(true));
                }
            });
        }

        public void schedule() {
            this.myUpdateAlarm.addRequest((Runnable)this, this.myDelayMillis);
        }
    }
}

