/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import org.jetbrains.annotations.NotNull;

public class LimitHistoryCheck {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myFilePath;
    private int myLimit;
    private int myCount;
    private boolean myWarningShown;

    public LimitHistoryCheck(@NotNull Project project, @NotNull String filePath) {
        this.myProject = project;
        this.myFilePath = filePath;
        this.myWarningShown = false;
        this.init();
    }

    private void init() {
        VcsConfiguration configuration2 = VcsConfiguration.getInstance((Project)this.myProject);
        this.myLimit = configuration2.LIMIT_HISTORY ? configuration2.MAXIMUM_HISTORY_ROWS : -1;
        this.myCount = 0;
    }

    public void checkNumber() {
        if (this.myLimit <= 0) {
            return;
        }
        ++this.myCount;
        if (this.isOver()) {
            if (!this.myWarningShown) {
                VcsBalloonProblemNotifier.showOverChangesView(this.myProject, "File History: only " + this.myLimit + " revisions were loaded for " + this.myFilePath + "\nTo change the history limit, go to Settings | Version Control.", MessageType.WARNING, new NamedRunnable[0]);
                this.myWarningShown = true;
            }
            throw new VcsFileHistoryLimitReachedException();
        }
    }

    public void reset() {
        this.init();
    }

    public boolean isOver() {
        return this.isOver(this.myCount);
    }

    public boolean isOver(int count) {
        return this.myLimit > 0 && this.myLimit < count;
    }

    public static class VcsFileHistoryLimitReachedException
    extends RuntimeException {
    }
}

