/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.ui.dualView.DualTreeElement;
import com.intellij.util.TreeItem;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TreeNodeOnVcsRevision
extends DefaultMutableTreeNode
implements DualTreeElement {
    @NotNull
    private final VcsFileRevision myRevision;

    TreeNodeOnVcsRevision(@Nullable VcsFileRevision revision, @NotNull List<TreeItem<VcsFileRevision>> roots) {
        this.myRevision = revision == null ? VcsFileRevision.NULL : revision;
        for (TreeItem<VcsFileRevision> root : roots) {
            this.add(new TreeNodeOnVcsRevision((VcsFileRevision)root.getData(), root.getChildren()));
        }
    }

    @NotNull
    public VcsFileRevision getRevision() {
        return this.myRevision;
    }

    public boolean shouldBeInTheFlatView() {
        return this.myRevision != VcsFileRevision.NULL;
    }

    @Override
    public String toString() {
        return this.myRevision.getRevisionNumber().asString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeNodeOnVcsRevision that = (TreeNodeOnVcsRevision)o;
        return this.myRevision.getRevisionNumber().equals(that.myRevision.getRevisionNumber());
    }

    public int hashCode() {
        return this.myRevision.getRevisionNumber().hashCode();
    }
}

