/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.CollectingHistorySessionConsumer;
import com.intellij.openapi.vcs.history.LimitHistoryCheck;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsCacheableHistorySessionFactory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsHistorySessionConsumer;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.history.VcsHistoryProviderEx;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsCachingHistory {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsHistoryCache myVcsHistoryCache;
    @NotNull
    private final VcsHistoryProvider myHistoryProvider;
    @NotNull
    private final VcsType myType;
    private final DiffProvider myDiffProvider;

    private VcsCachingHistory(@NotNull AbstractVcs vcs, @NotNull VcsHistoryProvider historyProvider, DiffProvider diffProvider) {
        this.myProject = vcs.getProject();
        this.myVcsHistoryCache = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsHistoryCache();
        this.myHistoryProvider = historyProvider;
        this.myType = vcs.getType();
        this.myDiffProvider = diffProvider;
    }

    private void reportHistoryInBackground(final @NotNull FilePath filePath, final @Nullable VcsRevisionNumber startRevisionNumber, final @NotNull VcsKey vcsKey, final @NotNull BackgroundableActionLock lock, final @NotNull VcsHistorySessionConsumer partner, final boolean canUseCache) {
        if (lock.isLocked()) {
            return;
        }
        lock.lock();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, VcsBundle.message((String)"loading.file.history.progress", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setText(VcsUtil.getPathForProgressPresentation((File)filePath.getIOFile()));
                indicator.setIndeterminate(true);
                VcsCachingHistory.this.reportHistory(filePath, startRevisionNumber, vcsKey, partner, canUseCache);
            }

            public void onFinished() {
                lock.unlock();
            }
        });
    }

    private void reportHistory(@NotNull FilePath filePath, @Nullable VcsRevisionNumber startRevisionNumber, @NotNull VcsKey vcsKey, @NotNull VcsHistorySessionConsumer partner, boolean canUseCache) {
        try {
            if (startRevisionNumber == null) {
                partner = this.wrapPartnerToCachingPartner(vcsKey, filePath, partner);
            }
            VcsAbstractHistorySession cachedSession = null;
            VcsCacheableHistorySessionFactory<Serializable, VcsAbstractHistorySession> cacheableFactory = this.getCacheableFactory();
            if (canUseCache && cacheableFactory != null) {
                cachedSession = this.getSessionFromCacheWithLastRevisionCheck(filePath, vcsKey, cacheableFactory);
            }
            if (cachedSession != null) {
                partner.reportCreatedEmptySession(cachedSession);
            } else if (this.myHistoryProvider instanceof VcsHistoryProviderEx) {
                ((VcsHistoryProviderEx)this.myHistoryProvider).reportAppendableHistory(filePath, startRevisionNumber, (VcsAppendableHistorySessionPartner)partner);
            } else {
                this.myHistoryProvider.reportAppendableHistory(filePath, (VcsAppendableHistorySessionPartner)partner);
            }
            partner.finished();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (LimitHistoryCheck.VcsFileHistoryLimitReachedException ignored) {
            partner.finished();
        }
        catch (VcsException e) {
            partner.reportException(e);
        }
        catch (Throwable t) {
            partner.reportException(new VcsException(t));
        }
    }

    @Nullable
    private VcsCacheableHistorySessionFactory<Serializable, VcsAbstractHistorySession> getCacheableFactory() {
        if (!(this.myHistoryProvider instanceof VcsCacheableHistorySessionFactory)) {
            return null;
        }
        return (VcsCacheableHistorySessionFactory)this.myHistoryProvider;
    }

    @NotNull
    private VcsHistoryCache getHistoryCache() {
        return this.myVcsHistoryCache;
    }

    @NotNull
    private VcsHistorySessionConsumer wrapPartnerToCachingPartner(@NotNull VcsKey vcsKey, @NotNull FilePath filePath, @NotNull VcsHistorySessionConsumer partner) {
        VcsCacheableHistorySessionFactory<Serializable, VcsAbstractHistorySession> cacheableFactory = this.getCacheableFactory();
        if (cacheableFactory != null) {
            return new HistoryPartnerProxy(partner, session2 -> {
                if (session2 == null) {
                    return;
                }
                FilePath correctedPath = cacheableFactory.getUsedFilePath(session2);
                this.myVcsHistoryCache.put(filePath, correctedPath, vcsKey, (VcsAbstractHistorySession)session2.copy(), cacheableFactory, true);
            });
        }
        return partner;
    }

    @Nullable
    private VcsAbstractHistorySession getSessionFromCacheWithLastRevisionCheck(@NotNull FilePath filePath, @NotNull VcsKey vcsKey, @NotNull VcsCacheableHistorySessionFactory<Serializable, VcsAbstractHistorySession> cacheableFactory) {
        VcsAbstractHistorySession cached;
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText2("Checking last revision");
        }
        if ((cached = this.myVcsHistoryCache.getFull(filePath, vcsKey, cacheableFactory)) == null || cached.getRevisionList().isEmpty()) {
            return null;
        }
        FilePath correctedFilePath = cacheableFactory.getUsedFilePath(cached);
        FilePath path = correctedFilePath != null ? correctedFilePath : filePath;
        VcsRevisionNumber currentRevision = null;
        if (VcsType.distributed.equals((Object)this.myType)) {
            currentRevision = cached.calcCurrentRevisionNumber();
        } else {
            ItemLatestState lastRevision = this.myDiffProvider.getLastRevision(path);
            if (lastRevision != null && !lastRevision.isDefaultHead() && lastRevision.isItemExists()) {
                currentRevision = lastRevision.getNumber();
            }
        }
        VcsRevisionNumber firstCachedRevision = ((VcsFileRevision)cached.getRevisionList().get(0)).getRevisionNumber();
        if (currentRevision != null && firstCachedRevision.equals(currentRevision)) {
            return cached;
        }
        return null;
    }

    public static List<VcsFileRevision> collect(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, @Nullable VcsRevisionNumber revision) throws VcsException {
        VcsCachingHistory history = new VcsCachingHistory(vcs, (VcsHistoryProvider)ObjectUtils.notNull((Object)vcs.getVcsHistoryProvider()), vcs.getDiffProvider());
        CollectingHistorySessionConsumer partner = new CollectingHistorySessionConsumer();
        history.reportHistory(filePath, revision, vcs.getKeyInstanceMethod(), (VcsHistorySessionConsumer)partner, true);
        partner.check();
        return partner.getSession().getRevisionList();
    }

    public static void collectInBackground(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, @NotNull VcsBackgroundableActions actionKey, @NotNull Consumer<? super VcsHistorySession> consumer) {
        VcsCachingHistory history = new VcsCachingHistory(vcs, (VcsHistoryProvider)ObjectUtils.notNull((Object)vcs.getVcsHistoryProvider()), vcs.getDiffProvider());
        CollectingHistoryPartner partner = new CollectingHistoryPartner(vcs.getProject(), filePath, consumer);
        BackgroundableActionLock lock = VcsCachingHistory.getHistoryLock(vcs, actionKey, filePath, null);
        history.reportHistoryInBackground(filePath, null, vcs.getKeyInstanceMethod(), lock, partner, true);
    }

    public static void collectInBackground(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, @NotNull VcsHistorySessionConsumer partner, boolean canUseCache) {
        VcsCachingHistory history = new VcsCachingHistory(vcs, (VcsHistoryProvider)ObjectUtils.notNull((Object)vcs.getVcsHistoryProvider()), vcs.getDiffProvider());
        BackgroundableActionLock lock = VcsCachingHistory.getHistorySessionLock(vcs, filePath, null);
        history.reportHistoryInBackground(filePath, null, vcs.getKeyInstanceMethod(), lock, partner, canUseCache);
    }

    public static void collectInBackground(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, @NotNull VcsRevisionNumber startRevisionNumber, @NotNull VcsHistorySessionConsumer partner) {
        if (!(vcs.getVcsHistoryProvider() instanceof VcsHistoryProviderEx)) {
            throw new UnsupportedOperationException();
        }
        BackgroundableActionLock lock = VcsCachingHistory.getHistorySessionLock(vcs, filePath, startRevisionNumber);
        VcsCachingHistory history = new VcsCachingHistory(vcs, (VcsHistoryProvider)ObjectUtils.notNull((Object)vcs.getVcsHistoryProvider()), vcs.getDiffProvider());
        history.reportHistoryInBackground(filePath, startRevisionNumber, vcs.getKeyInstanceMethod(), lock, partner, false);
    }

    public static boolean collectFromCache(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, @NotNull VcsHistorySessionConsumer partner) {
        VcsAbstractHistorySession session2;
        VcsCachingHistory history = new VcsCachingHistory(vcs, (VcsHistoryProvider)ObjectUtils.notNull((Object)vcs.getVcsHistoryProvider()), vcs.getDiffProvider());
        VcsCacheableHistorySessionFactory<Serializable, VcsAbstractHistorySession> cacheableFactory = history.getCacheableFactory();
        if (cacheableFactory != null && (session2 = history.getHistoryCache().getFull(filePath, vcs.getKeyInstanceMethod(), cacheableFactory)) != null) {
            partner.reportCreatedEmptySession(session2);
            partner.finished();
            return true;
        }
        return false;
    }

    @NotNull
    public static BackgroundableActionLock getHistorySessionLock(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, @Nullable VcsRevisionNumber startRevisionNumber) {
        return VcsCachingHistory.getHistoryLock(vcs, VcsBackgroundableActions.CREATE_HISTORY_SESSION, filePath, startRevisionNumber);
    }

    @NotNull
    public static BackgroundableActionLock getHistoryLock(@NotNull AbstractVcs vcs, @NotNull VcsBackgroundableActions actionKey, @NotNull FilePath filePath, @Nullable VcsRevisionNumber startRevisionNumber) {
        if (startRevisionNumber != null) {
            return BackgroundableActionLock.getLock(vcs.getProject(), new Object[]{actionKey, filePath.getPath(), startRevisionNumber.asString()});
        }
        return BackgroundableActionLock.getLock(vcs.getProject(), new Object[]{actionKey, filePath.getPath()});
    }

    private static class HistoryPartnerProxy
    implements VcsHistorySessionConsumer {
        @NotNull
        private final VcsHistorySessionConsumer myPartner;
        @NotNull
        private final Consumer<? super VcsAbstractHistorySession> myFinish;
        private VcsAbstractHistorySession myCopy;

        private HistoryPartnerProxy(@NotNull VcsHistorySessionConsumer partner, @NotNull Consumer<? super VcsAbstractHistorySession> finish) {
            this.myPartner = partner;
            this.myFinish = finish;
        }

        public void reportCreatedEmptySession(VcsAbstractHistorySession session2) {
            this.myCopy = (VcsAbstractHistorySession)session2.copy();
            this.myPartner.reportCreatedEmptySession(session2);
        }

        public void acceptRevision(VcsFileRevision revision) {
            this.myCopy.appendRevision(revision);
            this.myPartner.acceptRevision(revision);
        }

        public void reportException(VcsException exception) {
            this.myPartner.reportException(exception);
        }

        public void finished() {
            this.myPartner.finished();
            this.myFinish.consume((Object)this.myCopy);
        }
    }

    private static class CollectingHistoryPartner
    implements VcsHistorySessionConsumer {
        @NotNull
        private final Project myProject;
        @NotNull
        private final FilePath myFilePath;
        @NotNull
        private final Consumer<? super VcsHistorySession> myContinuation;
        @NotNull
        private final LimitHistoryCheck myCheck;
        private VcsAbstractHistorySession mySession;

        private CollectingHistoryPartner(@NotNull Project project, @NotNull FilePath path, @NotNull Consumer<? super VcsHistorySession> continuation) {
            this.myProject = project;
            this.myFilePath = path;
            this.myContinuation = continuation;
            this.myCheck = new LimitHistoryCheck(this.myProject, this.myFilePath.getPath());
        }

        public void reportCreatedEmptySession(VcsAbstractHistorySession session2) {
            List revisionList = session2.getRevisionList();
            while (this.myCheck.isOver(revisionList.size())) {
                revisionList.remove(revisionList.size() - 1);
            }
            this.mySession = session2;
        }

        public void acceptRevision(VcsFileRevision revision) {
            this.myCheck.checkNumber();
            this.mySession.appendRevision(revision);
        }

        public void reportException(VcsException exception) {
            AbstractVcsHelper.getInstance((Project)this.myProject).showError(exception, VcsBundle.message((String)"message.title.could.not.load.file.history", (Object[])new Object[0]));
        }

        public void finished() {
            if (this.mySession != null) {
                ApplicationManager.getApplication().invokeLater(() -> this.myContinuation.consume((Object)this.mySession), ModalityState.defaultModalityState());
            }
        }
    }
}

