/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.diff.DiffManager;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.MessageDiffRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffContext;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesBrowser;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDiffUtil {
    public static void showDiffFor(@NotNull Project project, @NotNull Collection<? extends Change> changes2, @NotNull String revNumTitle1, @NotNull String revNumTitle2, @NotNull FilePath filePath) {
        if (filePath.isDirectory()) {
            VcsDiffUtil.showChangesDialog(project, VcsDiffUtil.getDialogTitle(filePath, revNumTitle1, revNumTitle2), ContainerUtil.newArrayList(changes2));
        } else if (changes2.isEmpty()) {
            DiffManager.getInstance().showDiff(project, (DiffRequest)new MessageDiffRequest("No Changes Found"));
        } else {
            final HashMap revTitlesMap = new HashMap(2);
            revTitlesMap.put(DiffUserDataKeysEx.VCS_DIFF_LEFT_CONTENT_TITLE, (Object)revNumTitle1);
            revTitlesMap.put(DiffUserDataKeysEx.VCS_DIFF_RIGHT_CONTENT_TITLE, (Object)revNumTitle2);
            ShowDiffContext showDiffContext = new ShowDiffContext(){

                @Override
                @NotNull
                public Map<Key, Object> getChangeContext(@NotNull Change change) {
                    return revTitlesMap;
                }
            };
            ShowDiffAction.showDiffForChange(project, changes2, 0, showDiffContext);
        }
    }

    @NotNull
    private static String getDialogTitle(@NotNull FilePath filePath, @NotNull String revNumTitle1, @NotNull String revNumTitle2) {
        return String.format("Difference between %s and %s versions in %s", revNumTitle1, revNumTitle2, filePath.getName());
    }

    @NotNull
    public static String getRevisionTitle(@NotNull String revision, boolean localMark) {
        return revision + (localMark ? " (" + VcsBundle.message((String)"diff.title.local", (Object[])new Object[0]) + ")" : "");
    }

    public static void showChangesDialog(@NotNull Project project, @NotNull String title, @NotNull List<? extends Change> changes2) {
        DialogBuilder dialogBuilder = new DialogBuilder(project);
        dialogBuilder.setTitle(title);
        dialogBuilder.setActionDescriptors(new DialogBuilder.ActionDescriptor[]{new DialogBuilder.CloseDialogAction()});
        SimpleChangesBrowser changesBrowser = new SimpleChangesBrowser(project, false, true);
        changesBrowser.setChangesToDisplay(changes2);
        dialogBuilder.setCenterPanel((JComponent)changesBrowser);
        dialogBuilder.setPreferredFocusComponent(changesBrowser.getPreferredFocusedComponent());
        dialogBuilder.setDimensionServiceKey("VcsDiffUtil.ChangesDialog");
        dialogBuilder.showNotModal();
    }

    @NotNull
    public static List<Change> createChangesWithCurrentContentForFile(@NotNull FilePath filePath, @Nullable ContentRevision beforeContentRevision) {
        return Collections.singletonList(new Change(beforeContentRevision, CurrentContentRevision.create((FilePath)filePath)));
    }
}

