/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.actions.CreatePatchFromChangesAction;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class CreatePatchFromDirectoryAction
implements AnActionExtensionProvider {
    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        FilePath filePath = (FilePath)e.getRequiredData(VcsDataKeys.FILE_PATH);
        VcsFileRevision[] revisions = (VcsFileRevision[])e.getRequiredData(VcsDataKeys.VCS_FILE_REVISIONS);
        if (filePath.isDirectory()) {
            if (revisions.length != 1) {
                return;
            }
            AbstractVcs vcs = VcsUtil.findVcsByKey((Project)((Project)e.getRequiredData(CommonDataKeys.PROJECT)), (VcsKey)((VcsKey)e.getRequiredData(VcsDataKeys.VCS)));
            if (vcs == null) {
                return;
            }
            ProgressManager.getInstance().run((Task)new FolderPatchCreationTask(vcs, revisions[0]));
        }
    }

    @Override
    public boolean isActive(@NotNull AnActionEvent e) {
        VcsHistorySession session2 = (VcsHistorySession)e.getData(VcsDataKeys.HISTORY_SESSION);
        FilePath path = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        return session2 != null && path != null && path.isDirectory();
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setVisible(true);
        e.getPresentation().setText(VcsBundle.message((String)"action.name.create.patch.for.selected.revisions", (Object[])new Object[0]));
        e.getPresentation().setDescription(VcsBundle.message((String)"action.description.create.patch.for.selected.revisions", (Object[])new Object[0]));
        VcsFileRevision[] revisions = (VcsFileRevision[])e.getData(VcsDataKeys.VCS_FILE_REVISIONS);
        FilePath filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        VcsHistoryProvider provider = (VcsHistoryProvider)e.getData(VcsDataKeys.HISTORY_PROVIDER);
        Project project = e.getProject();
        VcsKey vcsKey = (VcsKey)e.getData(VcsDataKeys.VCS);
        if (filePath == null || filePath.isNonLocal() || revisions == null || provider == null || project == null || vcsKey == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        if (filePath.isDirectory()) {
            if (!provider.supportsHistoryForDirectories()) {
                e.getPresentation().setEnabled(false);
            } else {
                e.getPresentation().setEnabled(revisions.length == 1 && revisions[0].getChangedRepositoryPath() != null);
            }
        } else {
            e.getPresentation().setEnabled(false);
        }
    }

    private static class FolderPatchCreationTask
    extends Task.Backgroundable {
        @NotNull
        private final AbstractVcs myVcs;
        @NotNull
        private final VcsFileRevision myRevision;
        private CommittedChangeList myList;
        private VcsException myException;

        private FolderPatchCreationTask(@NotNull AbstractVcs vcs, @NotNull VcsFileRevision revision) {
            super(vcs.getProject(), VcsBundle.message((String)"create.patch.loading.content.progress", (Object[])new Object[0]), true);
            this.myVcs = vcs;
            this.myRevision = revision;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            CommittedChangesProvider provider = this.myVcs.getCommittedChangesProvider();
            if (provider == null) {
                return;
            }
            RepositoryLocation changedRepositoryPath = this.myRevision.getChangedRepositoryPath();
            if (changedRepositoryPath == null) {
                return;
            }
            VcsVirtualFile vf = new VcsVirtualFile(changedRepositoryPath.toPresentableString(), this.myRevision, (VirtualFileSystem)VcsFileSystem.getInstance());
            try {
                this.myList = AbstractVcsHelperImpl.getRemoteList(provider, this.myRevision.getRevisionNumber(), vf);
            }
            catch (VcsException e1) {
                this.myException = e1;
            }
        }

        public void onSuccess() {
            AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)this.myProject);
            if (this.myException != null) {
                helper.showError(this.myException, VcsBundle.message((String)"create.patch.error.title", (Object[])new Object[]{this.myException.getMessage()}));
            } else if (this.myList == null) {
                helper.showError(null, "Can not load changelist contents");
            } else {
                CreatePatchFromChangesAction.createPatch(this.myProject, this.myList.getComment(), new ArrayList(this.myList.getChanges()));
            }
        }
    }
}

