/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history.actions;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.ui.ReplaceFileConfirmationDialog;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GetVersionAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(GetVersionAction.class);

    public GetVersionAction() {
        super(VcsBundle.message((String)"action.name.get.file.content.from.repository", (Object[])new Object[0]), VcsBundle.message((String)"action.description.get.file.content.from.repository", (Object[])new Object[0]), AllIcons.Actions.Download);
    }

    public void update(@NotNull AnActionEvent e) {
        FilePath filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        VcsFileRevision revision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
        if (e.getProject() == null || filePath == null || revision == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setEnabledAndVisible(this.isContentAvailable(filePath, revision, e));
        }
    }

    protected boolean isContentAvailable(@NotNull FilePath filePath, @NotNull VcsFileRevision revision, @NotNull AnActionEvent e) {
        VcsHistorySession historySession = (VcsHistorySession)e.getData(VcsDataKeys.HISTORY_SESSION);
        if (historySession == null) {
            return false;
        }
        return historySession.isContentAvailable(revision) && !filePath.isDirectory();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        VcsFileRevision revision = (VcsFileRevision)e.getRequiredData(VcsDataKeys.VCS_FILE_REVISION);
        FilePath filePath = (FilePath)e.getRequiredData(VcsDataKeys.FILE_PATH);
        GetVersionAction.doGet(project, revision, filePath);
    }

    public static void doGet(@NotNull Project project, @NotNull VcsFileRevision revision, @NotNull FilePath filePath) {
        VirtualFile virtualFile = filePath.getVirtualFile();
        if (virtualFile != null) {
            ReplaceFileConfirmationDialog confirmationDialog = new ReplaceFileConfirmationDialog(project, VcsBundle.message((String)"acton.name.get.revision", (Object[])new Object[0]));
            if (!confirmationDialog.confirmFor(new VirtualFile[]{virtualFile})) {
                return;
            }
        }
        new MyWriteVersionTask(project, filePath, revision).queue();
        GetVersionAction.refreshFile(filePath, revision, project);
    }

    private static void refreshFile(@NotNull FilePath filePath, @NotNull VcsFileRevision revision, @NotNull Project project) {
        Runnable refresh2 = null;
        VirtualFile vf = filePath.getVirtualFile();
        if (vf == null) {
            LocalHistoryAction action = GetVersionAction.startLocalHistoryAction(filePath, revision);
            VirtualFile vp = filePath.getVirtualFileParent();
            if (vp != null) {
                refresh2 = () -> vp.refresh(false, true, () -> ((LocalHistoryAction)action).finish());
            }
        } else {
            refresh2 = () -> vf.refresh(false, false);
        }
        if (refresh2 != null) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(refresh2, "Refreshing Files...", false, project);
        }
    }

    private static LocalHistoryAction startLocalHistoryAction(@NotNull FilePath filePath, @NotNull VcsFileRevision revision) {
        return LocalHistory.getInstance().startAction(GetVersionAction.createGetActionTitle(filePath, revision));
    }

    @NotNull
    private static String createGetActionTitle(@NotNull FilePath filePath, @NotNull VcsFileRevision revision) {
        return VcsBundle.message((String)"action.name.for.file.get.version", (Object[])new Object[]{filePath.getPath(), revision.getRevisionNumber()});
    }

    private static void write(@NotNull FilePath filePath, byte[] revision, @NotNull Project project) throws IOException {
        VirtualFile virtualFile = filePath.getVirtualFile();
        if (virtualFile == null) {
            FileUtil.writeToFile((File)filePath.getIOFile(), (byte[])revision);
        } else {
            Document document = !virtualFile.getFileType().isBinary() ? FileDocumentManager.getInstance().getDocument(virtualFile) : null;
            if (document == null) {
                virtualFile.setBinaryContent(revision);
            } else {
                String content = StringUtil.convertLineSeparators((String)new String(revision, filePath.getCharset().name()));
                CommandProcessor.getInstance().executeCommand(project, () -> document.replaceString(0, document.getTextLength(), (CharSequence)content), VcsBundle.message((String)"message.title.get.version", (Object[])new Object[0]), null);
            }
        }
    }

    private static class MyWriteVersionTask
    extends Task.Backgroundable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final FilePath myFilePath;
        @NotNull
        private final VcsFileRevision myRevision;
        @Nullable
        private final VirtualFile myFile;

        MyWriteVersionTask(@NotNull Project project, @NotNull FilePath filePath, @NotNull VcsFileRevision revision) {
            super(project, VcsBundle.message((String)"show.diff.progress.title", (Object[])new Object[0]));
            this.myProject = project;
            this.myFilePath = filePath;
            this.myRevision = revision;
            this.myFile = filePath.getVirtualFile();
        }

        public void run(@NotNull ProgressIndicator indicator) {
            byte[] revisionContent;
            LocalHistoryAction action = this.myFile != null ? GetVersionAction.startLocalHistoryAction(this.myFilePath, this.myRevision) : LocalHistoryAction.NULL;
            try {
                revisionContent = VcsHistoryUtil.loadRevisionContent(this.myRevision);
            }
            catch (VcsException | IOException e) {
                LOG.info(e);
                ApplicationManager.getApplication().invokeLater(() -> MyWriteVersionTask.lambda$run$0((Exception)e));
                return;
            }
            catch (ProcessCanceledException ex) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                try {
                    if (this.myFile != null && !this.myFile.isWritable() && ReadonlyStatusHandler.getInstance((Project)this.myProject).ensureFilesWritable(Collections.singletonList(this.myFile)).hasReadonlyFiles()) {
                        return;
                    }
                    WriteCommandAction.writeCommandAction((Project)this.myProject).run(() -> {
                        try {
                            GetVersionAction.write(this.myFilePath, revisionContent, this.myProject);
                        }
                        catch (IOException e) {
                            Messages.showMessageDialog((String)VcsBundle.message((String)"message.text.cannot.save.content", (Object[])new Object[]{e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.get.revision.content", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                        }
                    });
                    if (this.myFile != null) {
                        VcsDirtyScopeManager.getInstance((Project)this.myProject).fileDirty(this.myFile);
                    }
                }
                finally {
                    action.finish();
                }
            });
        }

        private static /* synthetic */ void lambda$run$0(Exception e) {
            Messages.showMessageDialog((String)VcsBundle.message((String)"message.text.cannot.load.revision", (Object[])new Object[]{e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.get.revision.content", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
        }
    }
}

