/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class BackgroundableActionLock {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Object[] myKeys;

    BackgroundableActionLock(@NotNull Project project, @NotNull Object[] keys) {
        this.myProject = project;
        this.myKeys = keys;
    }

    public boolean isLocked() {
        return BackgroundableActionLock.isLocked(this.myProject, this.myKeys);
    }

    public void lock() {
        BackgroundableActionLock.lock(this.myProject, this.myKeys);
    }

    public void unlock() {
        BackgroundableActionLock.unlock(this.myProject, this.myKeys);
    }

    @NotNull
    public static BackgroundableActionLock getLock(@NotNull Project project, Object ... keys) {
        return new BackgroundableActionLock(project, keys);
    }

    public static boolean isLocked(@NotNull Project project, Object ... keys) {
        return BackgroundableActionLock.getManager(project).isBackgroundTaskRunning(keys);
    }

    public static void lock(@NotNull Project project, Object ... keys) {
        BackgroundableActionLock.getManager(project).startBackgroundTask(keys);
    }

    public static void unlock(@NotNull Project project, Object ... keys) {
        BackgroundableActionLock.getManager(project).stopBackgroundTask(keys);
    }

    @NotNull
    private static ProjectLevelVcsManagerImpl getManager(@NotNull Project project) {
        return (ProjectLevelVcsManagerImpl)ProjectLevelVcsManager.getInstance((Project)project);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackgroundableActionLock lock = (BackgroundableActionLock)o;
        return this.myProject.equals(lock.myProject) && Arrays.equals(this.myKeys, lock.myKeys);
    }

    public int hashCode() {
        int result2 = Objects.hash(this.myProject);
        result2 = 31 * result2 + Arrays.hashCode(this.myKeys);
        return result2;
    }
}

