/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.impl.FileStatusProvider;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FileStatusManagerImpl
extends FileStatusManager
implements ProjectComponent,
Disposable {
    private static final Logger LOG = Logger.getInstance(FileStatusManagerImpl.class);
    private final Map<VirtualFile, FileStatus> myCachedStatuses = Collections.synchronizedMap(new HashMap());
    private final Map<VirtualFile, Boolean> myWhetherExactlyParentToChanged = Collections.synchronizedMap(new HashMap());
    private final Project myProject;
    private final List<FileStatusListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private FileStatusProvider myFileStatusProvider;
    private final NotNullLazyValue<FileStatusProvider[]> myExtensions = new NotNullLazyValue<FileStatusProvider[]>(){

        @NotNull
        protected FileStatusProvider[] compute() {
            return (FileStatusProvider[])FileStatusProvider.EP_NAME.getExtensions((AreaInstance)FileStatusManagerImpl.this.myProject);
        }
    };

    public FileStatusManagerImpl(Project project, StartupManager startupManager, DirectoryIndex makeSureIndexIsInitializedFirst) {
        this.myProject = project;
        project.getMessageBus().connect().subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme2) {
                FileStatusManagerImpl.this.fileStatusesChanged();
            }
        });
        if (project.isDefault()) {
            return;
        }
        startupManager.registerPreStartupActivity(() -> {
            EditorFactory factory = EditorFactory.getInstance();
            if (factory != null) {
                factory.getEventMulticaster().addDocumentListener(new DocumentListener(){

                    public void documentChanged(@NotNull DocumentEvent event) {
                        if (event.getOldLength() == 0 && event.getNewLength() == 0) {
                            return;
                        }
                        VirtualFile file2 = FileDocumentManager.getInstance().getFile(event.getDocument());
                        if (file2 != null) {
                            FileStatusManagerImpl.this.refreshFileStatusFromDocument(file2, event.getDocument());
                        }
                    }
                }, (Disposable)this.myProject);
            }
        });
        startupManager.registerPostStartupActivity((Runnable)((DumbAwareRunnable)() -> this.fileStatusesChanged()));
    }

    public void setFileStatusProvider(FileStatusProvider fileStatusProvider) {
        this.myFileStatusProvider = fileStatusProvider;
    }

    public FileStatus calcStatus(@NotNull VirtualFile virtualFile) {
        for (FileStatusProvider extension : (FileStatusProvider[])this.myExtensions.getValue()) {
            FileStatus status = extension.getFileStatus(virtualFile);
            if (status == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("File status for file [%s] from provider %s: %s", virtualFile, extension.getClass().getName(), status));
            }
            return status;
        }
        if (virtualFile.isInLocalFileSystem() && this.myFileStatusProvider != null) {
            FileStatus status = this.myFileStatusProvider.getFileStatus(virtualFile);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("File status for file [%s] from default provider %s: %s", virtualFile, this.myFileStatusProvider, status));
            }
            return status;
        }
        FileStatus defaultStatus = FileStatusManagerImpl.getDefaultStatus(virtualFile);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Default status for file [%s]: %s", virtualFile, defaultStatus));
        }
        return defaultStatus;
    }

    @NotNull
    public static FileStatus getDefaultStatus(@NotNull VirtualFile file2) {
        return file2.isValid() && file2.is(VFileProperty.SPECIAL) ? FileStatus.IGNORED : FileStatus.NOT_CHANGED;
    }

    public void dispose() {
        this.myCachedStatuses.clear();
    }

    @NotNull
    public String getComponentName() {
        return "FileStatusManager";
    }

    public void addFileStatusListener(@NotNull FileStatusListener listener2) {
        this.myListeners.add(listener2);
    }

    public void addFileStatusListener(final @NotNull FileStatusListener listener2, @NotNull Disposable parentDisposable) {
        this.addFileStatusListener(listener2);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                FileStatusManagerImpl.this.removeFileStatusListener(listener2);
            }
        });
    }

    public void fileStatusesChanged() {
        if (this.myProject.isDisposed()) {
            return;
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().invokeLater((Runnable)((DumbAwareRunnable)() -> this.fileStatusesChanged()), ModalityState.any());
            return;
        }
        this.myCachedStatuses.clear();
        this.myWhetherExactlyParentToChanged.clear();
        for (FileStatusListener listener2 : this.myListeners) {
            listener2.fileStatusesChanged();
        }
    }

    private void cacheChangedFileStatus(VirtualFile virtualFile, FileStatus fs) {
        this.myCachedStatuses.put(virtualFile, fs);
        if (FileStatus.NOT_CHANGED.equals(fs)) {
            ThreeState parentingStatus = this.myFileStatusProvider.getNotChangedDirectoryParentingStatus(virtualFile);
            if (ThreeState.YES.equals((Object)parentingStatus)) {
                this.myWhetherExactlyParentToChanged.put(virtualFile, true);
            } else if (ThreeState.UNSURE.equals((Object)parentingStatus)) {
                this.myWhetherExactlyParentToChanged.put(virtualFile, false);
            }
        } else {
            this.myWhetherExactlyParentToChanged.remove(virtualFile);
        }
    }

    public void fileStatusChanged(VirtualFile file2) {
        Application application = ApplicationManager.getApplication();
        if (!application.isDispatchThread() && !application.isUnitTestMode()) {
            ApplicationManager.getApplication().invokeLater((Runnable)((DumbAwareRunnable)() -> this.fileStatusChanged(file2)));
            return;
        }
        if (file2 == null || !file2.isValid()) {
            return;
        }
        FileStatus cachedStatus = this.getCachedStatus(file2);
        if (cachedStatus == FileStatusNull.INSTANCE) {
            return;
        }
        if (cachedStatus == null) {
            this.cacheChangedFileStatus(file2, FileStatusNull.INSTANCE);
            return;
        }
        FileStatus newStatus = this.calcStatus(file2);
        if (cachedStatus == newStatus) {
            return;
        }
        this.cacheChangedFileStatus(file2, newStatus);
        for (FileStatusListener listener2 : this.myListeners) {
            listener2.fileStatusChanged(file2);
        }
    }

    public FileStatus getStatus(@NotNull VirtualFile file2) {
        if (file2.getFileSystem() instanceof NonPhysicalFileSystem) {
            return FileStatus.SUPPRESSED;
        }
        FileStatus status = this.getCachedStatus(file2);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cached status for file [" + file2 + "] is " + status);
        }
        if (status == null || status == FileStatusNull.INSTANCE) {
            status = this.calcStatus(file2);
            this.cacheChangedFileStatus(file2, status);
        }
        return status;
    }

    public FileStatus getCachedStatus(VirtualFile file2) {
        return this.myCachedStatuses.get(file2);
    }

    public void removeFileStatusListener(@NotNull FileStatusListener listener2) {
        this.myListeners.remove(listener2);
    }

    public Color getNotChangedDirectoryColor(@NotNull VirtualFile file2) {
        return this.getRecursiveStatus(file2).getColor();
    }

    @NotNull
    public FileStatus getRecursiveStatus(@NotNull VirtualFile file2) {
        FileStatus status = super.getRecursiveStatus(file2);
        if (status != FileStatus.NOT_CHANGED || !file2.isValid() || !file2.isDirectory()) {
            return status;
        }
        Boolean immediate = this.myWhetherExactlyParentToChanged.get(file2);
        if (immediate == null) {
            return status;
        }
        return immediate != false ? FileStatus.NOT_CHANGED_IMMEDIATE : FileStatus.NOT_CHANGED_RECURSIVE;
    }

    public void refreshFileStatusFromDocument(VirtualFile file2, Document doc) {
        if (this.myFileStatusProvider != null) {
            this.myFileStatusProvider.refreshFileStatusFromDocument(file2, doc);
        }
    }

    private static class FileStatusNull
    implements FileStatus {
        private static final FileStatus INSTANCE = new FileStatusNull();

        private FileStatusNull() {
        }

        public String getText() {
            throw new AssertionError((Object)"Should not be called");
        }

        public Color getColor() {
            throw new AssertionError((Object)"Should not be called");
        }

        @NotNull
        public ColorKey getColorKey() {
            throw new AssertionError((Object)"Should not be called");
        }

        @NotNull
        public String getId() {
            throw new AssertionError((Object)"Should not be called");
        }
    }
}

