/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.google.common.collect.Multiset;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsFreezingProcess;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictFileStatusProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.ex.ChangelistsLocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.LocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.SimpleLocalLineStatusTracker;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager$restoreTrackersForPartiallyChangedFiles$;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerI;
import com.intellij.openapi.vcs.impl.LineStatusTrackerSettingListener;
import com.intellij.openapi.vcs.impl.Result;
import com.intellij.openapi.vcs.impl.SingleThreadLoader;
import com.intellij.openapi.vcs.impl.VcsBaseContentProvider;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u001a\u0018\u0000 j2\u00020\u00012\u00020\u00022\u00020\u0003:\u0013ijklmnopqrstuvwxyz{B=\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u0003J\u0010\u00102\u001a\u00020&2\u0006\u00103\u001a\u00020 H\u0016J\u0010\u00104\u001a\u00020&2\u0006\u00103\u001a\u00020 H\u0002J\u0012\u00105\u001a\u00020&2\b\u00103\u001a\u0004\u0018\u00010 H\u0002J\u0010\u00106\u001a\u00020/2\u0006\u00107\u001a\u00020\u0019H\u0002J\u0013\u00108\u001a\b\u0012\u0004\u0012\u00020:09H\u0000\u00a2\u0006\u0002\b;J\b\u0010<\u001a\u00020/H\u0016J\u001e\u0010=\u001a\b\u0012\u0002\b\u0003\u0018\u00010>2\u0006\u00103\u001a\u00020 2\u0006\u00107\u001a\u00020\u0019H\u0002J\b\u0010?\u001a\u00020/H\u0002J\u0016\u0010@\u001a\b\u0012\u0002\b\u0003\u0018\u00010>2\u0006\u00107\u001a\u00020\u0019H\u0016J\u0016\u0010@\u001a\b\u0012\u0002\b\u0003\u0018\u00010>2\u0006\u0010A\u001a\u00020 H\u0016J\u0010\u0010B\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030>09J\b\u0010C\u001a\u00020DH\u0002J\b\u0010E\u001a\u00020/H\u0016J\u0018\u0010F\u001a\u00020/2\u0006\u00103\u001a\u00020 2\u0006\u00107\u001a\u00020\u0019H\u0002J\u0010\u0010G\u001a\u00020/2\u0006\u0010H\u001a\u00020IH\u0016J\u001a\u0010J\u001a\u00020/2\u0006\u0010K\u001a\u00020L2\b\u0010A\u001a\u0004\u0018\u00010 H\u0002J\u0015\u0010M\u001a\u00020/2\u0006\u00103\u001a\u00020 H\u0000\u00a2\u0006\u0002\bNJ\b\u0010O\u001a\u00020/H\u0002J\u0010\u0010P\u001a\u00020/2\u0006\u00103\u001a\u00020 H\u0002J\u0014\u0010Q\u001a\u00020/2\n\u0010R\u001a\u0006\u0012\u0002\b\u00030SH\u0002J\u0010\u0010T\u001a\u00020/2\u0006\u0010U\u001a\u00020-H\u0002J\u0006\u0010V\u001a\u00020/J\u0010\u0010W\u001a\u00020/2\u0006\u00107\u001a\u00020\u0019H\u0002J\u0018\u0010X\u001a\u00020/2\u0006\u00107\u001a\u00020\u00192\u0006\u0010Y\u001a\u00020\u0014H\u0016J\u0018\u0010Z\u001a\u00020/2\u0006\u00107\u001a\u00020\u00192\u0006\u0010Y\u001a\u00020\u0014H\u0016J\u0010\u0010[\u001a\u00020/2\u0006\u0010U\u001a\u00020-H\u0002J\u0006\u0010\\\u001a\u00020/J\u001b\u0010]\u001a\u00020/2\f\u0010^\u001a\b\u0012\u0004\u0012\u00020!09H\u0000\u00a2\u0006\u0002\b_J\u001a\u0010`\u001a\u00020&2\b\u0010a\u001a\u0004\u0018\u00010b2\u0006\u0010c\u001a\u00020bH\u0002J\b\u0010d\u001a\u00020/H\u0002J\u0010\u0010e\u001a\u00020/2\u0006\u0010U\u001a\u00020-H\u0002J\b\u0010f\u001a\u00020/H\u0002J\u0006\u0010g\u001a\u00020/J\u001a\u0010h\u001a\u00020/2\u0006\u0010K\u001a\u00020L2\b\u00107\u001a\u0004\u0018\u00010\u0019H\u0002J\u001a\u0010h\u001a\u00020/2\u0006\u0010K\u001a\u00020L2\b\u0010A\u001a\u0004\u0018\u00010 H\u0002R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u0010\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u001c0\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020 0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140$0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020-0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006|"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;", "Lcom/intellij/openapi/components/BaseComponent;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManagerI;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "application", "Lcom/intellij/openapi/application/Application;", "statusProvider", "Lcom/intellij/openapi/vcs/impl/VcsBaseContentProvider;", "changeListManager", "Lcom/intellij/openapi/vcs/changes/ChangeListManagerImpl;", "fileDocumentManager", "Lcom/intellij/openapi/fileEditor/FileDocumentManager;", "fileEditorManager", "Lcom/intellij/openapi/fileEditor/ex/FileEditorManagerEx;", "makeSureIndexIsInitializedFirst", "Lcom/intellij/openapi/roots/impl/DirectoryIndex;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/application/Application;Lcom/intellij/openapi/vcs/impl/VcsBaseContentProvider;Lcom/intellij/openapi/vcs/changes/ChangeListManagerImpl;Lcom/intellij/openapi/fileEditor/FileDocumentManager;Lcom/intellij/openapi/fileEditor/ex/FileEditorManagerEx;Lcom/intellij/openapi/roots/impl/DirectoryIndex;)V", "LOCK", "", "clmFreezeCounter", "", "documentsInDefaultChangeList", "Ljava/util/HashSet;", "Lcom/intellij/openapi/editor/Document;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Listener;", "kotlin.jvm.PlatformType", "fileStatesAwaitingRefresh", "Ljava/util/HashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$State;", "filesWithDamagedInactiveRanges", "forcedDocuments", "Lcom/google/common/collect/Multiset;", "isDisposed", "", "loader", "Lcom/intellij/openapi/vcs/impl/SingleThreadLoader;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshRequest;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshData;", "partialChangeListsEnabled", "trackers", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$TrackerData;", "addTrackerListener", "", "listener", "disposable", "arePartialChangelistsEnabled", "virtualFile", "canCreatePartialTrackerFor", "canGetBaseRevisionFor", "checkIfTrackerCanBeReleased", "document", "collectPartiallyChangedFilesStates", "", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$FullState;", "collectPartiallyChangedFilesStates$intellij_platform_vcs_impl", "dispose", "doInstallTracker", "Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "expireInactiveRangesDamagedNotifications", "getLineStatusTracker", "file", "getTrackers", "getTrackingMode", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$Mode;", "initComponent", "installTracker", "invokeAfterUpdate", "task", "Ljava/lang/Runnable;", "log", "message", "", "notifyInactiveRangesDamaged", "notifyInactiveRangesDamaged$intellij_platform_vcs_impl", "onEverythingChanged", "onFileChanged", "refreshTracker", "tracker", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "registerTrackerInCLM", "data", "releaseAllTrackers", "releaseTracker", "releaseTrackerFor", "requester", "requestTrackerFor", "reregisterTrackerInCLM", "resetExcludedFromCommitMarkers", "restoreTrackersForPartiallyChangedFiles", "trackerStates", "restoreTrackersForPartiallyChangedFiles$intellij_platform_vcs_impl", "shouldBeUpdated", "oldInfo", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;", "newInfo", "showInactiveRangesDamagedNotification", "unregisterTrackerInCLM", "updateTrackingModes", "waitUntilBaseContentsLoaded", "warn", "CheckinFactory", "Companion", "ContentInfo", "InactiveRangesDamagedNotification", "Listener", "ListenerAdapter", "MyApplicationListener", "MyBaseRevisionLoader", "MyChangeListListener", "MyCommandListener", "MyDocumentListener", "MyEditorFactoryListener", "MyFileStatusListener", "MyFreezeListener", "MyLineStatusTrackerSettingListener", "MyVirtualFileListener", "RefreshData", "RefreshRequest", "TrackerData", "intellij.platform.vcs.impl"})
public final class LineStatusTrackerManager
implements BaseComponent,
LineStatusTrackerManagerI,
Disposable {
    private final Object LOCK;
    private boolean isDisposed;
    private final HashMap<Document, TrackerData> trackers;
    private final HashMap<Document, Multiset<Object>> forcedDocuments;
    private final EventDispatcher<Listener> eventDispatcher;
    private boolean partialChangeListsEnabled;
    private final HashSet<Document> documentsInDefaultChangeList;
    private int clmFreezeCounter;
    private final HashSet<VirtualFile> filesWithDamagedInactiveRanges;
    private final HashMap<VirtualFile, ChangelistsLocalLineStatusTracker.State> fileStatesAwaitingRefresh;
    private final SingleThreadLoader<RefreshRequest, RefreshData> loader;
    private final Project project;
    private final Application application;
    private final VcsBaseContentProvider statusProvider;
    private final ChangeListManagerImpl changeListManager;
    private final FileDocumentManager fileDocumentManager;
    private final FileEditorManagerEx fileEditorManager;
    private static final Logger LOG;
    public static final Companion Companion;

    public void initComponent() {
        StartupManager.getInstance((Project)this.project).registerPreStartupActivity(new Runnable(this){
            final /* synthetic */ LineStatusTrackerManager this$0;

            public final void run() {
                if (LineStatusTrackerManager.access$isDisposed$p(this.this$0)) {
                    return;
                }
                LineStatusTrackerManager.access$getApplication$p(this.this$0).addApplicationListener((ApplicationListener)this.this$0.new MyApplicationListener(), (Disposable)this.this$0);
                MessageBusConnection busConnection = LineStatusTrackerManager.access$getProject$p(this.this$0).getMessageBus().connect((Disposable)this.this$0);
                busConnection.subscribe(LineStatusTrackerSettingListener.TOPIC, (Object)this.this$0.new MyLineStatusTrackerSettingListener());
                busConnection.subscribe(VcsFreezingProcess.Listener.TOPIC, (Object)this.this$0.new MyFreezeListener());
                FileStatusManager fsManager = FileStatusManager.getInstance((Project)LineStatusTrackerManager.access$getProject$p(this.this$0));
                fsManager.addFileStatusListener((FileStatusListener)this.this$0.new MyFileStatusListener(), (Disposable)this.this$0);
                EditorFactory editorFactory = EditorFactory.getInstance();
                editorFactory.addEditorFactoryListener((EditorFactoryListener)this.this$0.new MyEditorFactoryListener(), (Disposable)this.this$0);
                editorFactory.getEventMulticaster().addDocumentListener((DocumentListener)this.this$0.new MyDocumentListener(), (Disposable)this.this$0);
                LineStatusTrackerManager.access$getChangeListManager$p(this.this$0).addChangeListListener((ChangeListListener)this.this$0.new MyChangeListListener());
                VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
                virtualFileManager.addVirtualFileListener((VirtualFileListener)this.this$0.new MyVirtualFileListener(), (Disposable)this.this$0);
                busConnection.subscribe(CommandListener.TOPIC, (Object)this.this$0.new MyCommandListener());
            }
            {
                this.this$0 = lineStatusTrackerManager;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.isDisposed = true;
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            Map map2 = this.forcedDocuments;
            Iterator<Object> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                Document document = (Document)entry2.getKey();
                entry2 = entry;
                Multiset multiset2 = (Multiset)entry2.getValue();
                for (Object requester : multiset2.elementSet()) {
                    this.warn("Tracker for is being held on dispose by " + requester, document);
                }
            }
            this.forcedDocuments.clear();
            for (TrackerData data : this.trackers.values()) {
                this.unregisterTrackerInCLM(data);
                data.getTracker().release();
            }
            this.trackers.clear();
            this.loader.dispose();
            map2 = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public LineStatusTracker<?> getLineStatusTracker(@NotNull Document document) {
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            TrackerData trackerData = this.trackers.get(document);
            LineStatusTracker lineStatusTracker = trackerData != null ? trackerData.getTracker() : null;
            return lineStatusTracker;
        }
    }

    @Override
    @Nullable
    public LineStatusTracker<?> getLineStatusTracker(@NotNull VirtualFile file2) {
        Document document = this.fileDocumentManager.getCachedDocument(file2);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        return this.getLineStatusTracker(document2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestTrackerFor(@NotNull Document document, @NotNull Object requester) {
        this.application.assertIsDispatchThread();
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            Multiset<Object> multiset2 = this.forcedDocuments.computeIfAbsent(document, requestTrackerFor.1.multiset.1.INSTANCE);
            multiset2.add(requester);
            if (this.trackers.get(document) == null) {
                VirtualFile virtualFile = this.fileDocumentManager.getFile(document);
                if (virtualFile == null) {
                    return;
                }
                VirtualFile virtualFile2 = virtualFile;
                this.installTracker(virtualFile2, document);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseTrackerFor(@NotNull Document document, @NotNull Object requester) {
        this.application.assertIsDispatchThread();
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            Multiset<Object> multiset2 = this.forcedDocuments.get(document);
            if (multiset2 == null || !multiset2.contains(requester)) {
                this.warn("Tracker release underflow by " + requester, document);
                return;
            }
            multiset2.remove(requester);
            if (multiset2.isEmpty()) {
                this.forcedDocuments.remove(document);
                this.checkIfTrackerCanBeReleased(document);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void invokeAfterUpdate(@NotNull Runnable task2) {
        this.loader.addAfterUpdateRunnable(task2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<LineStatusTracker<?>> getTrackers() {
        Object object = this.LOCK;
        synchronized (object) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            boolean bl = false;
            Iterable iterable = $receiver$iv = (Iterable)this.trackers.values();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                TrackerData trackerData = (TrackerData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                LocalLineStatusTracker<?> localLineStatusTracker = it.getTracker();
                collection.add(localLineStatusTracker);
            }
            List list2 = (List)destination$iv$iv;
            return list2;
        }
    }

    public final void addTrackerListener(@NotNull Listener listener2, @NotNull Disposable disposable) {
        this.eventDispatcher.addListener((EventListener)listener2, disposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkIfTrackerCanBeReleased(Document document) {
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            TrackerData trackerData = this.trackers.get(document);
            if (trackerData == null) {
                return;
            }
            TrackerData data = trackerData;
            if (this.forcedDocuments.containsKey(document)) {
                return;
            }
            if (data.getTracker() instanceof ChangelistsLocalLineStatusTracker) {
                boolean hasPartialChanges = ((ChangelistsLocalLineStatusTracker)data.getTracker()).hasPartialState$intellij_platform_vcs_impl();
                if (hasPartialChanges) {
                    this.log("checkIfTrackerCanBeReleased - hasPartialChanges", data.getTracker().getVirtualFile());
                    return;
                }
                boolean isLoading = this.loader.hasRequest(new RefreshRequest(document));
                if (isLoading) {
                    this.log("checkIfTrackerCanBeReleased - isLoading", data.getTracker().getVirtualFile());
                    return;
                }
            }
            this.releaseTracker(document);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onEverythingChanged() {
        this.application.assertIsDispatchThread();
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            if (this.isDisposed) {
                return;
            }
            this.log("onEverythingChanged", null);
            HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
            for (TrackerData data : this.trackers.values()) {
                files2.add(data.getTracker().getVirtualFile());
            }
            for (Document document : this.forcedDocuments.keySet()) {
                VirtualFile file2 = this.fileDocumentManager.getFile(document);
                if (file2 == null) continue;
                files2.add(file2);
            }
            for (VirtualFile file3 : files2) {
                this.onFileChanged(file3);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onFileChanged(VirtualFile virtualFile) {
        Document document = this.fileDocumentManager.getCachedDocument(virtualFile);
        if (document == null) {
            return;
        }
        Document document2 = document;
        Object object = this.LOCK;
        synchronized (object) {
            LocalLineStatusTracker<?> tracker;
            boolean bl = false;
            if (this.isDisposed) {
                return;
            }
            this.log("onFileChanged", virtualFile);
            TrackerData trackerData = this.trackers.get(document2);
            LocalLineStatusTracker<Object> localLineStatusTracker = tracker = trackerData != null ? trackerData.getTracker() : null;
            if (tracker == null) {
                if (this.forcedDocuments.containsKey(document2)) {
                    this.installTracker(virtualFile, document2);
                }
            } else {
                boolean isPartialTracker;
                boolean isPartialTrackerExpected = this.canCreatePartialTrackerFor(virtualFile);
                if (isPartialTrackerExpected == (isPartialTracker = tracker instanceof ChangelistsLocalLineStatusTracker)) {
                    this.refreshTracker(tracker);
                } else {
                    this.releaseTracker(document2);
                    this.installTracker(virtualFile, document2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void registerTrackerInCLM(TrackerData data) {
        LocalLineStatusTracker<?> tracker = data.getTracker();
        if (!(tracker instanceof ChangelistsLocalLineStatusTracker)) {
            return;
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)tracker.getVirtualFile());
        if (data.getClmFilePath() != null) {
            LOG.error("[registerTrackerInCLM] tracker already registered");
            return;
        }
        this.changeListManager.registerChangeTracker(filePath, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
        data.setClmFilePath(filePath);
    }

    private final void unregisterTrackerInCLM(TrackerData data) {
        LocalLineStatusTracker<?> tracker = data.getTracker();
        if (!(tracker instanceof ChangelistsLocalLineStatusTracker)) {
            return;
        }
        FilePath filePath = data.getClmFilePath();
        if (filePath == null) {
            LOG.error("[unregisterTrackerInCLM] tracker is not registered");
            return;
        }
        this.changeListManager.unregisterChangeTracker(filePath, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
        data.setClmFilePath(null);
        FilePath actualFilePath = VcsUtil.getFilePath((VirtualFile)tracker.getVirtualFile());
        if (Intrinsics.areEqual((Object)filePath, (Object)actualFilePath) ^ true) {
            LOG.error("[unregisterTrackerInCLM] unexpected file path: expected: " + filePath + ", actual: " + actualFilePath);
        }
    }

    private final void reregisterTrackerInCLM(TrackerData data) {
        LocalLineStatusTracker<?> tracker = data.getTracker();
        if (!(tracker instanceof ChangelistsLocalLineStatusTracker)) {
            return;
        }
        FilePath oldFilePath = data.getClmFilePath();
        FilePath newFilePath = VcsUtil.getFilePath((VirtualFile)tracker.getVirtualFile());
        if (oldFilePath == null) {
            LOG.error("[reregisterTrackerInCLM] tracker is not registered");
            return;
        }
        if (Intrinsics.areEqual((Object)oldFilePath, (Object)newFilePath) ^ true) {
            this.changeListManager.unregisterChangeTracker(oldFilePath, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
            this.changeListManager.registerChangeTracker(newFilePath, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
            data.setClmFilePath(newFilePath);
        }
    }

    private final boolean canGetBaseRevisionFor(VirtualFile virtualFile) {
        if (this.isDisposed) {
            return false;
        }
        if (virtualFile == null || virtualFile instanceof LightVirtualFile) {
            return false;
        }
        boolean $i$f$runReadAction = false;
        if (((Boolean)ApplicationManager.getApplication().runReadAction(new Computable<T>(virtualFile){
            final /* synthetic */ VirtualFile $virtualFile$inlined;
            {
                this.$virtualFile$inlined = virtualFile;
            }

            public final T compute() {
                boolean bl = false;
                return (T)Boolean.valueOf(!this.$virtualFile$inlined.isValid() || this.$virtualFile$inlined.getFileType().isBinary() || FileUtilRt.isTooLarge((long)this.$virtualFile$inlined.getLength()));
            }
        })).booleanValue()) {
            return false;
        }
        if (!this.statusProvider.isSupported(virtualFile)) {
            return false;
        }
        FileStatus status = FileStatusManager.getInstance((Project)this.project).getStatus(virtualFile);
        return !Intrinsics.areEqual((Object)status, (Object)FileStatus.ADDED) && !Intrinsics.areEqual((Object)status, (Object)FileStatus.DELETED) && !Intrinsics.areEqual((Object)status, (Object)FileStatus.UNKNOWN) && !Intrinsics.areEqual((Object)status, (Object)FileStatus.IGNORED);
    }

    private final boolean canCreatePartialTrackerFor(VirtualFile virtualFile) {
        if (!this.arePartialChangelistsEnabled(virtualFile)) {
            return false;
        }
        FileStatus status = FileStatusManager.getInstance((Project)this.project).getStatus(virtualFile);
        if (Intrinsics.areEqual((Object)status, (Object)FileStatus.MODIFIED) ^ true && Intrinsics.areEqual((Object)status, (Object)ChangelistConflictFileStatusProvider.MODIFIED_OUTSIDE) ^ true && Intrinsics.areEqual((Object)status, (Object)FileStatus.NOT_CHANGED) ^ true) {
            return false;
        }
        Change change = ChangeListManager.getInstance((Project)this.project).getChange(virtualFile);
        return change != null && Intrinsics.areEqual(change.getClass(), Change.class) && (change.getType() == Change.Type.MODIFICATION || change.getType() == Change.Type.MOVED) && change.getAfterRevision() instanceof CurrentContentRevision;
    }

    @Override
    public boolean arePartialChangelistsEnabled(@NotNull VirtualFile virtualFile) {
        if (!this.partialChangeListsEnabled) {
            return false;
        }
        if (this.getTrackingMode() == LocalLineStatusTracker.Mode.SILENT) {
            return false;
        }
        AbstractVcs vcs = VcsUtil.getVcsFor((Project)this.project, (VirtualFile)virtualFile);
        return vcs != null && vcs.arePartialChangelistsSupported();
    }

    private final void installTracker(VirtualFile virtualFile, Document document) {
        if (!this.canGetBaseRevisionFor(virtualFile)) {
            return;
        }
        this.doInstallTracker(virtualFile, document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LineStatusTracker<?> doInstallTracker(VirtualFile virtualFile, Document document) {
        this.application.assertIsDispatchThread();
        Object object = this.LOCK;
        synchronized (object) {
            block7: {
                block6: {
                    boolean bl = false;
                    if (!this.isDisposed) break block6;
                    LineStatusTracker<?> lineStatusTracker = null;
                    return lineStatusTracker;
                }
                if (this.trackers.get(document) == null) break block7;
                LineStatusTracker<?> lineStatusTracker = null;
                return lineStatusTracker;
            }
            LocalLineStatusTracker tracker = this.canCreatePartialTrackerFor(virtualFile) ? (LocalLineStatusTracker)ChangelistsLocalLineStatusTracker.Companion.createTracker(this.project, document, virtualFile, this.getTrackingMode()) : (LocalLineStatusTracker)SimpleLocalLineStatusTracker.Companion.createTracker(this.project, document, virtualFile, this.getTrackingMode());
            TrackerData data = new TrackerData(tracker, null, null, 6, null);
            this.trackers.put(document, data);
            this.registerTrackerInCLM(data);
            this.refreshTracker(tracker);
            ((Listener)this.eventDispatcher.getMulticaster()).onTrackerAdded(tracker);
            if (this.clmFreezeCounter > 0) {
                tracker.freeze$intellij_platform_vcs_impl();
            }
            this.log("Tracker installed", virtualFile);
            LineStatusTracker lineStatusTracker = tracker;
            return lineStatusTracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void releaseTracker(Document document) {
        this.application.assertIsDispatchThread();
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            if (this.isDisposed) {
                return;
            }
            TrackerData trackerData = this.trackers.remove(document);
            if (trackerData == null) {
                return;
            }
            TrackerData data = trackerData;
            ((Listener)this.eventDispatcher.getMulticaster()).onTrackerRemoved((LineStatusTracker)data.getTracker());
            this.unregisterTrackerInCLM(data);
            data.getTracker().release();
            this.log("Tracker released", data.getTracker().getVirtualFile());
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void updateTrackingModes() {
        Object object = this.LOCK;
        synchronized (object) {
            void $receiver$iv$iv;
            boolean bl = false;
            if (this.isDisposed) {
                return;
            }
            LocalLineStatusTracker.Mode mode = this.getTrackingMode();
            Iterable $receiver$iv = this.trackers.values();
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                TrackerData trackerData = (TrackerData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                LocalLineStatusTracker<?> localLineStatusTracker = it.getTracker();
                collection.add(localLineStatusTracker);
            }
            List trackers = (List)destination$iv$iv;
            for (LocalLineStatusTracker tracker : trackers) {
                boolean isPartialTracker;
                Document document = tracker.getDocument();
                VirtualFile virtualFile = tracker.getVirtualFile();
                boolean isPartialTrackerExpected = this.canCreatePartialTrackerFor(virtualFile);
                if (isPartialTrackerExpected == (isPartialTracker = tracker instanceof ChangelistsLocalLineStatusTracker)) {
                    tracker.setMode(mode);
                    continue;
                }
                this.releaseTracker(document);
                this.installTracker(virtualFile, document);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final LocalLineStatusTracker.Mode getTrackingMode() {
        VcsApplicationSettings settings = VcsApplicationSettings.getInstance();
        if (!settings.SHOW_LST_GUTTER_MARKERS) {
            return LocalLineStatusTracker.Mode.SILENT;
        }
        if (settings.SHOW_WHITESPACES_IN_LST) {
            return LocalLineStatusTracker.Mode.SMART;
        }
        return LocalLineStatusTracker.Mode.DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void refreshTracker(LocalLineStatusTracker<?> tracker) {
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            if (this.isDisposed) {
                return;
            }
            this.loader.scheduleRefresh(new RefreshRequest(tracker.getDocument()));
            this.log("Refresh queued", tracker.getVirtualFile());
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean shouldBeUpdated(ContentInfo oldInfo, ContentInfo newInfo) {
        if (oldInfo == null) {
            return true;
        }
        if (Intrinsics.areEqual((Object)oldInfo.getRevision(), (Object)newInfo.getRevision()) && Intrinsics.areEqual((Object)oldInfo.getRevision(), (Object)VcsRevisionNumber.NULL) ^ true) {
            return Intrinsics.areEqual((Object)oldInfo.getCharset(), (Object)newInfo.getCharset()) ^ true;
        }
        return true;
    }

    private final void log(String message, VirtualFile file2) {
        if (LOG.isDebugEnabled()) {
            if (file2 != null) {
                LOG.debug(message + "; file: " + file2.getPath());
            } else {
                LOG.debug(message);
            }
        }
    }

    private final void warn(String message, Document document) {
        VirtualFile virtualFile;
        Document document2 = document;
        if (document2 != null) {
            Document document3;
            Document it = document3 = document2;
            boolean bl = false;
            virtualFile = this.fileDocumentManager.getFile(it);
        } else {
            virtualFile = null;
        }
        VirtualFile file2 = virtualFile;
        this.warn(message, file2);
    }

    private final void warn(String message, VirtualFile file2) {
        if (file2 != null) {
            LOG.warn(message + "; file: " + file2.getPath());
        } else {
            LOG.warn(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetExcludedFromCommitMarkers() {
        this.application.assertIsDispatchThread();
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            List documents = new ArrayList();
            for (TrackerData data : this.trackers.values()) {
                LocalLineStatusTracker<?> tracker = data.getTracker();
                if (!(tracker instanceof ChangelistsLocalLineStatusTracker)) continue;
                ((ChangelistsLocalLineStatusTracker)tracker).setExcludedFromCommit(false);
                documents.add(tracker.getDocument());
            }
            for (Document document : documents) {
                this.checkIfTrackerCanBeReleased(document);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<ChangelistsLocalLineStatusTracker.FullState> collectPartiallyChangedFilesStates$intellij_platform_vcs_impl() {
        this.application.assertIsDispatchThread();
        List result2 = new ArrayList();
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            for (TrackerData data : this.trackers.values()) {
                boolean hasPartialChanges;
                LocalLineStatusTracker<?> tracker = data.getTracker();
                if (!(tracker instanceof ChangelistsLocalLineStatusTracker) || !(hasPartialChanges = ((ChangelistsLocalLineStatusTracker)tracker).getAffectedChangeListsIds().size() > 1)) continue;
                result2.add(((ChangelistsLocalLineStatusTracker)tracker).storeTrackerState$intellij_platform_vcs_impl());
            }
            Unit unit = Unit.INSTANCE;
        }
        return result2;
    }

    public final void restoreTrackersForPartiallyChangedFiles$intellij_platform_vcs_impl(@NotNull List<? extends ChangelistsLocalLineStatusTracker.State> trackerStates) {
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable<T>(this, trackerStates){
            final /* synthetic */ LineStatusTrackerManager this$0;
            final /* synthetic */ List $trackerStates$inlined;
            {
                this.this$0 = lineStatusTrackerManager;
                this.$trackerStates$inlined = list2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final T compute() {
                boolean bl = false;
                Object object = LineStatusTrackerManager.access$getLOCK$p(this.this$0);
                synchronized (object) {
                    boolean bl2 = false;
                    for (ChangelistsLocalLineStatusTracker.State state : this.$trackerStates$inlined) {
                        boolean stateRestored;
                        LocalLineStatusTracker<?> oldTracker;
                        Document document;
                        TrackerData oldData;
                        VirtualFile virtualFile = state.getVirtualFile();
                        if (LineStatusTrackerManager.access$getFileDocumentManager$p(this.this$0).getDocument(virtualFile) == null) {
                            continue;
                        }
                        if (!LineStatusTrackerManager.access$canCreatePartialTrackerFor(this.this$0, virtualFile)) continue;
                        TrackerData trackerData = oldData = (TrackerData)LineStatusTrackerManager.access$getTrackers$p(this.this$0).get(document);
                        LocalLineStatusTracker<Object> localLineStatusTracker = oldTracker = trackerData != null ? trackerData.getTracker() : null;
                        if (oldTracker instanceof ChangelistsLocalLineStatusTracker) {
                            boolean stateRestored2;
                            boolean bl3 = stateRestored2 = state instanceof ChangelistsLocalLineStatusTracker.FullState && ((ChangelistsLocalLineStatusTracker)oldTracker).restoreState$intellij_platform_vcs_impl(state);
                            if (stateRestored2) {
                                LineStatusTrackerManager.access$log(this.this$0, "Tracker restore: reused, full restored", virtualFile);
                                continue;
                            }
                            boolean isLoading = LineStatusTrackerManager.access$getLoader$p(this.this$0).hasRequest(new RefreshRequest(document));
                            if (isLoading) {
                                LineStatusTrackerManager.access$getFileStatesAwaitingRefresh$p(this.this$0).put(state.getVirtualFile(), state);
                                LineStatusTrackerManager.access$log(this.this$0, "Tracker restore: reused, restore scheduled", virtualFile);
                                continue;
                            }
                            ((ChangelistsLocalLineStatusTracker)oldTracker).restoreState$intellij_platform_vcs_impl(state);
                            LineStatusTrackerManager.access$log(this.this$0, "Tracker restore: reused, restored", virtualFile);
                            continue;
                        }
                        ChangelistsLocalLineStatusTracker tracker = ChangelistsLocalLineStatusTracker.Companion.createTracker(LineStatusTrackerManager.access$getProject$p(this.this$0), document, virtualFile, LineStatusTrackerManager.access$getTrackingMode(this.this$0));
                        TrackerData data = new TrackerData(tracker, null, null, 6, null);
                        LineStatusTrackerManager.access$getTrackers$p(this.this$0).put(document, data);
                        if (oldTracker != null) {
                            ((Listener)LineStatusTrackerManager.access$getEventDispatcher$p(this.this$0).getMulticaster()).onTrackerRemoved(tracker);
                            LineStatusTrackerManager.access$unregisterTrackerInCLM(this.this$0, oldData);
                            oldTracker.release();
                            LineStatusTrackerManager.access$log(this.this$0, "Tracker restore: removed existing", virtualFile);
                        }
                        LineStatusTrackerManager.access$registerTrackerInCLM(this.this$0, data);
                        LineStatusTrackerManager.access$refreshTracker(this.this$0, tracker);
                        ((Listener)LineStatusTrackerManager.access$getEventDispatcher$p(this.this$0).getMulticaster()).onTrackerAdded(tracker);
                        boolean bl4 = stateRestored = state instanceof ChangelistsLocalLineStatusTracker.FullState && tracker.restoreState$intellij_platform_vcs_impl(state);
                        if (stateRestored) {
                            LineStatusTrackerManager.access$log(this.this$0, "Tracker restore: created, full restored", virtualFile);
                            continue;
                        }
                        LineStatusTrackerManager.access$getFileStatesAwaitingRefresh$p(this.this$0).put(state.getVirtualFile(), state);
                        LineStatusTrackerManager.access$log(this.this$0, "Tracker restore: created, restore scheduled", virtualFile);
                    }
                    LineStatusTrackerManager.access$getLoader$p(this.this$0).addAfterUpdateRunnable(new Runnable(this){
                        final /* synthetic */ restoreTrackersForPartiallyChangedFiles$$inlined$runWriteAction$1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void run() {
                            Object object = LineStatusTrackerManager.access$getLOCK$p(this.this$0.this$0);
                            synchronized (object) {
                                boolean bl = false;
                                LineStatusTrackerManager.access$log(this.this$0.this$0, "Tracker restore: finished", null);
                                LineStatusTrackerManager.access$getFileStatesAwaitingRefresh$p(this.this$0.this$0).clear();
                                Unit unit = Unit.INSTANCE;
                            }
                        }
                    });
                    Unit unit = Unit.INSTANCE;
                }
                return (T)Unit.INSTANCE;
            }
        });
    }

    public final void notifyInactiveRangesDamaged$intellij_platform_vcs_impl(@NotNull VirtualFile virtualFile) {
        this.application.assertIsDispatchThread();
        if (this.filesWithDamagedInactiveRanges.contains(virtualFile)) {
            return;
        }
        if (Intrinsics.areEqual((Object)virtualFile, (Object)this.fileEditorManager.getCurrentFile())) {
            return;
        }
        this.filesWithDamagedInactiveRanges.add(virtualFile);
    }

    private final void showInactiveRangesDamagedNotification() {
        InactiveRangesDamagedNotification lastNotification;
        InactiveRangesDamagedNotification[] inactiveRangesDamagedNotificationArray;
        InactiveRangesDamagedNotification[] $receiver$iv;
        InactiveRangesDamagedNotification[] currentNotifications;
        block3: {
            InactiveRangesDamagedNotification inactiveRangesDamagedNotification;
            $receiver$iv = currentNotifications = (InactiveRangesDamagedNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(InactiveRangesDamagedNotification.class, this.project);
            inactiveRangesDamagedNotificationArray = CollectionsKt.reversed((Iterable)((Iterable)ArraysKt.getIndices((Object[])$receiver$iv))).iterator();
            while (inactiveRangesDamagedNotificationArray.hasNext()) {
                InactiveRangesDamagedNotification element$iv;
                int index$iv = ((Number)inactiveRangesDamagedNotificationArray.next()).intValue();
                InactiveRangesDamagedNotification it = element$iv = $receiver$iv[index$iv];
                boolean bl = false;
                if (!(!it.isExpired())) continue;
                inactiveRangesDamagedNotification = element$iv;
                break block3;
            }
            inactiveRangesDamagedNotification = lastNotification = null;
        }
        if (lastNotification != null) {
            this.filesWithDamagedInactiveRanges.addAll((Collection<VirtualFile>)lastNotification.getVirtualFiles());
        }
        inactiveRangesDamagedNotificationArray = $receiver$iv = currentNotifications;
        int n = inactiveRangesDamagedNotificationArray.length;
        for (int i = 0; i < n; ++i) {
            InactiveRangesDamagedNotification element$iv;
            InactiveRangesDamagedNotification it = element$iv = inactiveRangesDamagedNotificationArray[i];
            boolean bl = false;
            it.expire();
        }
        Set files2 = CollectionsKt.toSet((Iterable)this.filesWithDamagedInactiveRanges);
        this.filesWithDamagedInactiveRanges.clear();
        new InactiveRangesDamagedNotification(this.project, files2).notify(this.project);
    }

    private final void expireInactiveRangesDamagedNotifications() {
        InactiveRangesDamagedNotification[] currentNotifications;
        InactiveRangesDamagedNotification[] $receiver$iv;
        this.filesWithDamagedInactiveRanges.clear();
        InactiveRangesDamagedNotification[] inactiveRangesDamagedNotificationArray = $receiver$iv = (currentNotifications = (InactiveRangesDamagedNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(InactiveRangesDamagedNotification.class, this.project));
        int n = inactiveRangesDamagedNotificationArray.length;
        for (int i = 0; i < n; ++i) {
            InactiveRangesDamagedNotification element$iv;
            InactiveRangesDamagedNotification it = element$iv = inactiveRangesDamagedNotificationArray[i];
            boolean bl = false;
            it.expire();
        }
    }

    public final void waitUntilBaseContentsLoaded() {
        boolean bl = ApplicationManager.getApplication().isUnitTestMode();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            UIUtil.dispatchAllInvocationEvents();
        }
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.loader.addAfterUpdateRunnable(new Runnable(semaphore){
            final /* synthetic */ Semaphore $semaphore;

            public final void run() {
                this.$semaphore.up();
            }
            {
                this.$semaphore = semaphore;
            }
        });
        long start2 = System.currentTimeMillis();
        do {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                UIUtil.dispatchAllInvocationEvents();
            }
            if (!semaphore.waitFor(10L)) continue;
            return;
        } while (System.currentTimeMillis() - start2 <= (long)10000);
        this.loader.dumpInternalState();
        System.err.println(ThreadDumper.dumpThreadsToString());
        throw (Throwable)new IllegalStateException("Couldn't await base contents");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseAllTrackers() {
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            this.forcedDocuments.clear();
            for (TrackerData data : this.trackers.values()) {
                this.unregisterTrackerInCLM(data);
                data.getTracker().release();
            }
            this.trackers.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    public LineStatusTrackerManager(@NotNull Project project, @NotNull Application application, @NotNull VcsBaseContentProvider statusProvider, @NotNull ChangeListManagerImpl changeListManager, @NotNull FileDocumentManager fileDocumentManager, @NotNull FileEditorManagerEx fileEditorManager, @NotNull DirectoryIndex makeSureIndexIsInitializedFirst) {
        this.project = project;
        this.application = application;
        this.statusProvider = statusProvider;
        this.changeListManager = changeListManager;
        this.fileDocumentManager = fileDocumentManager;
        this.fileEditorManager = fileEditorManager;
        this.LOCK = new Object();
        this.trackers = new HashMap();
        this.forcedDocuments = new HashMap();
        this.eventDispatcher = EventDispatcher.create(Listener.class);
        this.partialChangeListsEnabled = VcsApplicationSettings.getInstance().ENABLE_PARTIAL_CHANGELISTS && Registry.is((String)"vcs.enable.partial.changelists");
        this.documentsInDefaultChangeList = new HashSet();
        this.filesWithDamagedInactiveRanges = new HashSet();
        this.fileStatesAwaitingRefresh = new HashMap();
        this.loader = new MyBaseRevisionLoader();
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(LineStatusTrackerManager.class);
    }

    public static final /* synthetic */ void access$setDisposed$p(LineStatusTrackerManager $this, boolean bl) {
        $this.isDisposed = bl;
    }

    public static final /* synthetic */ void access$reregisterTrackerInCLM(LineStatusTrackerManager $this, TrackerData data) {
        $this.reregisterTrackerInCLM(data);
    }

    public static final /* synthetic */ void access$releaseTracker(LineStatusTrackerManager $this, Document document) {
        $this.releaseTracker(document);
    }

    public static final /* synthetic */ Application access$getApplication$p(LineStatusTrackerManager $this) {
        return $this.application;
    }

    public static final /* synthetic */ SingleThreadLoader access$getLoader$p(LineStatusTrackerManager $this) {
        return $this.loader;
    }

    public static final /* synthetic */ LocalLineStatusTracker.Mode access$getTrackingMode(LineStatusTrackerManager $this) {
        return $this.getTrackingMode();
    }

    public static final /* synthetic */ EventDispatcher access$getEventDispatcher$p(LineStatusTrackerManager $this) {
        return $this.eventDispatcher;
    }

    public static final /* synthetic */ void access$unregisterTrackerInCLM(LineStatusTrackerManager $this, TrackerData data) {
        $this.unregisterTrackerInCLM(data);
    }

    public static final /* synthetic */ void access$registerTrackerInCLM(LineStatusTrackerManager $this, TrackerData data) {
        $this.registerTrackerInCLM(data);
    }

    public static final /* synthetic */ void access$refreshTracker(LineStatusTrackerManager $this, LocalLineStatusTracker tracker) {
        $this.refreshTracker(tracker);
    }

    @JvmStatic
    @NotNull
    public static final LineStatusTrackerManagerI getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    @NotNull
    public static final LineStatusTrackerManager getInstanceImpl(@NotNull Project project) {
        return Companion.getInstanceImpl(project);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ListenerAdapter;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Listener;", "()V", "intellij.platform.vcs.impl"})
    public static class ListenerAdapter
    implements Listener {
        @Override
        public void onTrackerAdded(@NotNull LineStatusTracker<?> tracker) {
            Listener.DefaultImpls.onTrackerAdded(this, tracker);
        }

        @Override
        public void onTrackerRemoved(@NotNull LineStatusTracker<?> tracker) {
            Listener.DefaultImpls.onTrackerRemoved(this, tracker);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016J\u0014\u0010\u0006\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Listener;", "Ljava/util/EventListener;", "onTrackerAdded", "", "tracker", "Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "onTrackerRemoved", "intellij.platform.vcs.impl"})
    public static interface Listener
    extends EventListener {
        public void onTrackerAdded(@NotNull LineStatusTracker<?> var1);

        public void onTrackerRemoved(@NotNull LineStatusTracker<?> var1);

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static void onTrackerAdded(Listener $this, @NotNull LineStatusTracker<?> tracker) {
            }

            public static void onTrackerRemoved(Listener $this, @NotNull LineStatusTracker<?> tracker) {
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00022\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0014J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\n\u001a\u00020\u0002H\u0014J\u0014\u0010\u000e\u001a\u00020\u0006*\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u0010\u001a\u00020\u0006*\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0003H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyBaseRevisionLoader;", "Lcom/intellij/openapi/vcs/impl/SingleThreadLoader;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshRequest;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshData;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "handleError", "", "document", "Lcom/intellij/openapi/editor/Document;", "handleResult", "request", "result", "Lcom/intellij/openapi/vcs/impl/Result;", "loadRequest", "handleCanceled", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;", "handleSuccess", "refreshData", "intellij.platform.vcs.impl"})
    private final class MyBaseRevisionLoader
    extends SingleThreadLoader<RefreshRequest, RefreshData> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        protected Result<RefreshData> loadRequest(@NotNull RefreshRequest request) {
            if (LineStatusTrackerManager.this.isDisposed) {
                return new Result.Canceled();
            }
            Document document = request.getDocument();
            VirtualFile virtualFile = LineStatusTrackerManager.this.fileDocumentManager.getFile(document);
            LineStatusTrackerManager.this.log("Loading started", virtualFile);
            if (virtualFile == null || !virtualFile.isValid()) {
                LineStatusTrackerManager.this.log("Loading error: virtual file is not valid", virtualFile);
                return new Result.Error();
            }
            if (!LineStatusTrackerManager.this.canGetBaseRevisionFor(virtualFile)) {
                LineStatusTrackerManager.this.log("Loading error: cant get base revision", virtualFile);
                return new Result.Error();
            }
            VcsBaseContentProvider.BaseContent baseContent = LineStatusTrackerManager.this.statusProvider.getBaseRevision(virtualFile);
            if (baseContent == null) {
                LineStatusTrackerManager.this.log("Loading error: base revision not found", virtualFile);
                return new Result.Error();
            }
            ContentInfo newContentInfo = new ContentInfo(baseContent.getRevisionNumber(), virtualFile.getCharset());
            Object object = LineStatusTrackerManager.this.LOCK;
            synchronized (object) {
                block11: {
                    TrackerData data;
                    block10: {
                        boolean bl = false;
                        data = (TrackerData)LineStatusTrackerManager.this.trackers.get(document);
                        if (data != null) break block10;
                        LineStatusTrackerManager.this.log("Loading cancelled: tracker not found", virtualFile);
                        Result result2 = new Result.Canceled();
                        return result2;
                    }
                    if (LineStatusTrackerManager.this.shouldBeUpdated(data.getContentInfo(), newContentInfo)) break block11;
                    LineStatusTrackerManager.this.log("Loading cancelled: no need to update", virtualFile);
                    Result result3 = new Result.Canceled();
                    return result3;
                }
                Unit unit = Unit.INSTANCE;
            }
            String lastUpToDateContent = baseContent.loadContent();
            if (lastUpToDateContent == null) {
                LineStatusTrackerManager.this.log("Loading error: provider failure", virtualFile);
                return new Result.Error();
            }
            String converted = StringUtil.convertLineSeparators((String)lastUpToDateContent);
            LineStatusTrackerManager.this.log("Loading successful", virtualFile);
            return new Result.Success<RefreshData>(new RefreshData(converted, newContentInfo));
        }

        @Override
        protected void handleResult(@NotNull RefreshRequest request, @NotNull Result<RefreshData> result2) {
            Document document = request.getDocument();
            Result<RefreshData> result3 = result2;
            if (result3 instanceof Result.Canceled) {
                this.handleCanceled(LineStatusTrackerManager.this, document);
            } else if (result3 instanceof Result.Error) {
                this.handleError(document);
            } else if (result3 instanceof Result.Success) {
                this.handleSuccess(LineStatusTrackerManager.this, document, (RefreshData)((Result.Success)result2).getData());
            }
            LineStatusTrackerManager.this.checkIfTrackerCanBeReleased(document);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handleCanceled(@NotNull LineStatusTrackerManager $receiver, Document document) {
            ChangelistsLocalLineStatusTracker.State state;
            VirtualFile virtualFile = $receiver.fileDocumentManager.getFile(document);
            if (virtualFile == null) {
                return;
            }
            VirtualFile virtualFile2 = virtualFile;
            Object object = $receiver.LOCK;
            synchronized (object) {
                boolean bl = false;
                ChangelistsLocalLineStatusTracker.State state2 = (ChangelistsLocalLineStatusTracker.State)$receiver.fileStatesAwaitingRefresh.remove(virtualFile2);
                if (state2 == null) {
                    return;
                }
                state = state2;
            }
            ChangelistsLocalLineStatusTracker.State state3 = state;
            LineStatusTracker<?> tracker = $receiver.getLineStatusTracker(document);
            if (tracker instanceof ChangelistsLocalLineStatusTracker) {
                ((ChangelistsLocalLineStatusTracker)tracker).restoreState$intellij_platform_vcs_impl(state3);
                $receiver.log("Loading canceled: state restored", virtualFile2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handleError(Document document) {
            Object object = LineStatusTrackerManager.this.LOCK;
            synchronized (object) {
                boolean bl = false;
                TrackerData trackerData = (TrackerData)LineStatusTrackerManager.this.trackers.get(document);
                if (trackerData == null) {
                    return;
                }
                TrackerData data = trackerData;
                data.getTracker().dropBaseRevision();
                data.setContentInfo(null);
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handleSuccess(@NotNull LineStatusTrackerManager $receiver, Document document, RefreshData refreshData) {
            ChangelistsLocalLineStatusTracker.State state;
            VirtualFile virtualFile = $receiver.fileDocumentManager.getFile(document);
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            VirtualFile virtualFile2 = virtualFile;
            Object object = $receiver.LOCK;
            synchronized (object) {
                boolean bl = false;
                TrackerData data = (TrackerData)$receiver.trackers.get(document);
                if (data == null) {
                    $receiver.log("Loading finished: tracker already released", virtualFile2);
                    return;
                }
                if (!$receiver.shouldBeUpdated(data.getContentInfo(), refreshData.getInfo())) {
                    $receiver.log("Loading finished: no need to update", virtualFile2);
                    return;
                }
                data.setContentInfo(refreshData.getInfo());
                Unit unit = Unit.INSTANCE;
            }
            LineStatusTracker<?> lineStatusTracker = $receiver.getLineStatusTracker(document);
            if (lineStatusTracker == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vcs.ex.LocalLineStatusTracker<*>");
            }
            LocalLineStatusTracker tracker = (LocalLineStatusTracker)lineStatusTracker;
            tracker.setBaseRevision(refreshData.getText());
            $receiver.log("Loading finished: success", virtualFile2);
            if (tracker instanceof ChangelistsLocalLineStatusTracker && (state = (ChangelistsLocalLineStatusTracker.State)$receiver.fileStatesAwaitingRefresh.remove(tracker.getVirtualFile())) != null) {
                ((ChangelistsLocalLineStatusTracker)tracker).restoreState$intellij_platform_vcs_impl(state);
                $receiver.log("Loading finished: state restored", virtualFile2);
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyFileStatusListener;", "Lcom/intellij/openapi/vcs/FileStatusListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "fileStatusChanged", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileStatusesChanged", "intellij.platform.vcs.impl"})
    private final class MyFileStatusListener
    implements FileStatusListener {
        public void fileStatusesChanged() {
            LineStatusTrackerManager.this.onEverythingChanged();
        }

        public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
            LineStatusTrackerManager.this.onFileChanged(virtualFile);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyEditorFactoryListener;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "editorCreated", "", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "editorReleased", "isTrackedEditor", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.vcs.impl"})
    private final class MyEditorFactoryListener
    implements EditorFactoryListener {
        public void editorCreated(@NotNull EditorFactoryEvent event) {
            Editor editor = event.getEditor();
            if (this.isTrackedEditor(editor)) {
                LineStatusTrackerManager.this.requestTrackerFor(editor.getDocument(), editor);
            }
        }

        public void editorReleased(@NotNull EditorFactoryEvent event) {
            Editor editor = event.getEditor();
            if (this.isTrackedEditor(editor)) {
                LineStatusTrackerManager.this.releaseTrackerFor(editor.getDocument(), editor);
            }
        }

        private final boolean isTrackedEditor(Editor editor) {
            if (editor.getProject() != null && Intrinsics.areEqual((Object)editor.getProject(), (Object)LineStatusTrackerManager.this.project) ^ true) {
                return false;
            }
            return editor.getEditorKind() != EditorKind.PREVIEW_UNDER_READ_ACTION;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0016J$\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00040\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyVirtualFileListener;", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "beforePropertyChange", "", "event", "Lcom/intellij/openapi/vfs/VirtualFilePropertyEvent;", "fileDeleted", "Lcom/intellij/openapi/vfs/VirtualFileEvent;", "fileMoved", "Lcom/intellij/openapi/vfs/VirtualFileMoveEvent;", "forEachTrackerUnder", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "action", "Lkotlin/Function1;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$TrackerData;", "handleFileMovement", "propertyChanged", "intellij.platform.vcs.impl"})
    private final class MyVirtualFileListener
    implements VirtualFileListener {
        public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
            if (Intrinsics.areEqual((Object)"encoding", (Object)event.getPropertyName())) {
                LineStatusTrackerManager.this.onFileChanged(event.getFile());
            }
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (Intrinsics.areEqual((Object)"name", (Object)event.getPropertyName())) {
                this.handleFileMovement(event.getFile());
            }
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            this.handleFileMovement(event.getFile());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handleFileMovement(VirtualFile file2) {
            if (!LineStatusTrackerManager.this.partialChangeListsEnabled) {
                return;
            }
            Object object = LineStatusTrackerManager.this.LOCK;
            synchronized (object) {
                boolean bl = false;
                this.forEachTrackerUnder(file2, (Function1<? super TrackerData, Unit>)((Function1)new Function1<TrackerData, Unit>(this, file2){
                    final /* synthetic */ MyVirtualFileListener this$0;
                    final /* synthetic */ VirtualFile $file$inlined;
                    {
                        this.this$0 = myVirtualFileListener;
                        this.$file$inlined = virtualFile;
                        super(1);
                    }

                    public final void invoke(@NotNull TrackerData data) {
                        LineStatusTrackerManager.access$reregisterTrackerInCLM(this.this$0.LineStatusTrackerManager.this, data);
                    }
                }));
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (!LineStatusTrackerManager.this.partialChangeListsEnabled) {
                return;
            }
            Object object = LineStatusTrackerManager.this.LOCK;
            synchronized (object) {
                boolean bl = false;
                this.forEachTrackerUnder(event.getFile(), (Function1<? super TrackerData, Unit>)((Function1)new Function1<TrackerData, Unit>(this, event){
                    final /* synthetic */ MyVirtualFileListener this$0;
                    final /* synthetic */ VirtualFileEvent $event$inlined;
                    {
                        this.this$0 = myVirtualFileListener;
                        this.$event$inlined = virtualFileEvent;
                        super(1);
                    }

                    public final void invoke(@NotNull TrackerData data) {
                        LineStatusTrackerManager.access$releaseTracker(this.this$0.LineStatusTrackerManager.this, data.getTracker().getDocument());
                    }
                }));
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void forEachTrackerUnder(VirtualFile file2, Function1<? super TrackerData, Unit> action) {
            if (file2.isDirectory()) {
                void $receiver$iv$iv;
                Iterable $receiver$iv = LineStatusTrackerManager.this.trackers.values();
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    TrackerData it = (TrackerData)element$iv$iv;
                    boolean bl = false;
                    if (!VfsUtil.isAncestor((VirtualFile)file2, (VirtualFile)it.getTracker().getVirtualFile(), (boolean)false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List affected = (List)destination$iv$iv;
                for (TrackerData data : affected) {
                    action.invoke((Object)data);
                }
            } else {
                Document document = LineStatusTrackerManager.this.fileDocumentManager.getCachedDocument(file2);
                if (document == null) {
                    return;
                }
                Document document2 = document;
                TrackerData trackerData = (TrackerData)LineStatusTrackerManager.this.trackers.get(document2);
                if (trackerData == null) {
                    return;
                }
                TrackerData data = trackerData;
                action.invoke((Object)data);
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyDocumentListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "intellij.platform.vcs.impl"})
    private final class MyDocumentListener
    implements DocumentListener {
        public void documentChanged(@NotNull DocumentEvent event) {
            if (!ApplicationManager.getApplication().isDispatchThread()) {
                return;
            }
            if (!LineStatusTrackerManager.this.partialChangeListsEnabled) {
                return;
            }
            Document document = event.getDocument();
            if (LineStatusTrackerManager.this.documentsInDefaultChangeList.contains(document)) {
                return;
            }
            VirtualFile virtualFile = LineStatusTrackerManager.this.fileDocumentManager.getFile(document);
            if (virtualFile == null) {
                return;
            }
            VirtualFile virtualFile2 = virtualFile;
            if (LineStatusTrackerManager.this.getLineStatusTracker(document) != null) {
                return;
            }
            if (!LineStatusTrackerManager.this.canGetBaseRevisionFor(virtualFile2)) {
                return;
            }
            if (!LineStatusTrackerManager.this.canCreatePartialTrackerFor(virtualFile2)) {
                return;
            }
            LocalChangeList changeList = LineStatusTrackerManager.this.changeListManager.getChangeList(virtualFile2);
            if (changeList != null && !changeList.isDefault()) {
                LineStatusTrackerManager.this.log("Tracker install from DocumentListener: ", virtualFile2);
                LineStatusTracker tracker = LineStatusTrackerManager.this.doInstallTracker(virtualFile2, document);
                if (tracker instanceof ChangelistsLocalLineStatusTracker) {
                    ((ChangelistsLocalLineStatusTracker)tracker).replayChangesFromDocumentEvents(CollectionsKt.listOf((Object)event));
                }
                return;
            }
            LineStatusTrackerManager.this.documentsInDefaultChangeList.add(document);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyApplicationListener;", "Lcom/intellij/openapi/application/ApplicationListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "afterWriteActionFinished", "", "action", "", "intellij.platform.vcs.impl"})
    private final class MyApplicationListener
    implements ApplicationListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void afterWriteActionFinished(@NotNull Object action) {
            LineStatusTrackerManager.this.documentsInDefaultChangeList.clear();
            Object object = LineStatusTrackerManager.this.LOCK;
            synchronized (object) {
                void $receiver$iv$iv;
                boolean bl = false;
                Iterable $receiver$iv = LineStatusTrackerManager.this.trackers.values();
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    TrackerData trackerData = (TrackerData)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    Document document = it.getTracker().getDocument();
                    collection.add(document);
                }
                List documents = (List)destination$iv$iv;
                for (Document document : documents) {
                    LineStatusTrackerManager.this.checkIfTrackerCanBeReleased(document);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyLineStatusTrackerSettingListener;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerSettingListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "settingsUpdated", "", "intellij.platform.vcs.impl"})
    private final class MyLineStatusTrackerSettingListener
    implements LineStatusTrackerSettingListener {
        @Override
        public void settingsUpdated() {
            LineStatusTrackerManager.this.partialChangeListsEnabled = VcsApplicationSettings.getInstance().ENABLE_PARTIAL_CHANGELISTS && Registry.is((String)"vcs.enable.partial.changelists");
            LineStatusTrackerManager.this.updateTrackingModes();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyChangeListListener;", "Lcom/intellij/openapi/vcs/changes/ChangeListAdapter;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "defaultListChanged", "", "oldDefaultList", "Lcom/intellij/openapi/vcs/changes/ChangeList;", "newDefaultList", "intellij.platform.vcs.impl"})
    private final class MyChangeListListener
    extends ChangeListAdapter {
        /*
         * WARNING - void declaration
         */
        public void defaultListChanged(@Nullable ChangeList oldDefaultList, @Nullable ChangeList newDefaultList) {
            ModalityState modalityState$iv = ModalityState.any();
            boolean $i$f$runInEdt = false;
            Application app$iv = ApplicationManager.getApplication();
            if (app$iv.isDispatchThread()) {
                void $receiver$iv;
                boolean bl = false;
                LineStatusTrackerManager.this.expireInactiveRangesDamagedNotifications();
                Iterable iterable = ArraysKt.filterIsInstance((Object[])EditorFactory.getInstance().getAllEditors(), EditorEx.class);
                for (Object element$iv : $receiver$iv) {
                    EditorEx it = (EditorEx)element$iv;
                    boolean bl2 = false;
                    it.getGutterComponentEx().repaint();
                }
            } else {
                Runnable runnable2 = new Runnable(this){
                    final /* synthetic */ MyChangeListListener this$0;
                    {
                        this.this$0 = myChangeListListener;
                    }

                    public final void run() {
                        boolean bl = false;
                        LineStatusTrackerManager.access$expireInactiveRangesDamagedNotifications(this.this$0.LineStatusTrackerManager.this);
                        Iterable $receiver$iv = ArraysKt.filterIsInstance((Object[])EditorFactory.getInstance().getAllEditors(), EditorEx.class);
                        for (T element$iv : $receiver$iv) {
                            EditorEx it = (EditorEx)element$iv;
                            boolean bl2 = false;
                            it.getGutterComponentEx().repaint();
                        }
                    }
                };
                ModalityState modalityState = modalityState$iv;
                if (modalityState == null) {
                    modalityState = ModalityState.defaultModalityState();
                }
                app$iv.invokeLater(runnable2, modalityState);
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyCommandListener;", "Lcom/intellij/openapi/command/CommandListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "commandFinished", "", "event", "Lcom/intellij/openapi/command/CommandEvent;", "intellij.platform.vcs.impl"})
    private final class MyCommandListener
    implements CommandListener {
        public void commandFinished(@NotNull CommandEvent event) {
            if (!LineStatusTrackerManager.this.partialChangeListsEnabled) {
                return;
            }
            if (CommandProcessor.getInstance().getCurrentCommand() == null && !LineStatusTrackerManager.this.filesWithDamagedInactiveRanges.isEmpty()) {
                LineStatusTrackerManager.this.showInactiveRangesDamagedNotification();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$CheckinFactory;", "Lcom/intellij/openapi/vcs/checkin/CheckinHandlerFactory;", "()V", "createHandler", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "panel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "intellij.platform.vcs.impl"})
    public static final class CheckinFactory
    extends CheckinHandlerFactory {
        @NotNull
        public CheckinHandler createHandler(@NotNull CheckinProjectPanel panel2, @NotNull CommitContext commitContext) {
            return new CheckinHandler(panel2){
                final /* synthetic */ CheckinProjectPanel $panel;

                public void checkinSuccessful() {
                    ModalityState modalityState$iv = null;
                    boolean $i$f$runInEdt = false;
                    Application app$iv = ApplicationManager.getApplication();
                    if (app$iv.isDispatchThread()) {
                        boolean bl = false;
                        LineStatusTrackerManager.Companion.getInstanceImpl(this.$panel.getProject()).resetExcludedFromCommitMarkers();
                    } else {
                        app$iv.invokeLater(new Runnable(this){
                            final /* synthetic */ createHandler.1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final void run() {
                                boolean bl = false;
                                LineStatusTrackerManager.Companion.getInstanceImpl(this.this$0.$panel.getProject()).resetExcludedFromCommitMarkers();
                            }
                        }, ModalityState.defaultModalityState());
                    }
                }

                public void checkinFailed(@Nullable List<VcsException> exception) {
                    ModalityState modalityState$iv = null;
                    boolean $i$f$runInEdt = false;
                    Application app$iv = ApplicationManager.getApplication();
                    if (app$iv.isDispatchThread()) {
                        boolean bl = false;
                        LineStatusTrackerManager.Companion.getInstanceImpl(this.$panel.getProject()).resetExcludedFromCommitMarkers();
                    } else {
                        app$iv.invokeLater(new Runnable(this){
                            final /* synthetic */ createHandler.1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final void run() {
                                boolean bl = false;
                                LineStatusTrackerManager.Companion.getInstanceImpl(this.this$0.$panel.getProject()).resetExcludedFromCommitMarkers();
                            }
                        }, ModalityState.defaultModalityState());
                    }
                }
                {
                    this.$panel = $captured_local_variable$0;
                }
            };
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyFreezeListener;", "Lcom/intellij/openapi/vcs/changes/VcsFreezingProcess$Listener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "onFreeze", "", "onUnfreeze", "intellij.platform.vcs.impl"})
    private final class MyFreezeListener
    implements VcsFreezingProcess.Listener {
        @Override
        public void onFreeze() {
            boolean $i$f$runReadAction = false;
            ApplicationManager.getApplication().runReadAction(new Computable<T>(this){
                final /* synthetic */ MyFreezeListener this$0;
                {
                    this.this$0 = myFreezeListener;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final T compute() {
                    int n;
                    boolean bl = false;
                    Object object = LineStatusTrackerManager.access$getLOCK$p(this.this$0.LineStatusTrackerManager.this);
                    synchronized (object) {
                        boolean bl2 = false;
                        if (LineStatusTrackerManager.access$getClmFreezeCounter$p(this.this$0.LineStatusTrackerManager.this) == 0) {
                            for (TrackerData data : LineStatusTrackerManager.access$getTrackers$p(this.this$0.LineStatusTrackerManager.this).values()) {
                                try {
                                    data.getTracker().freeze$intellij_platform_vcs_impl();
                                }
                                catch (Throwable e) {
                                    LineStatusTrackerManager.access$getLOG$cp().error(e);
                                }
                            }
                        }
                        LineStatusTrackerManager lineStatusTrackerManager = this.this$0.LineStatusTrackerManager.this;
                        int n2 = LineStatusTrackerManager.access$getClmFreezeCounter$p(lineStatusTrackerManager);
                        LineStatusTrackerManager.access$setClmFreezeCounter$p(lineStatusTrackerManager, n2 + 1);
                        n = n2;
                    }
                    return (T)Integer.valueOf(n);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUnfreeze() {
            ModalityState modalityState$iv = ModalityState.any();
            boolean $i$f$runInEdt = false;
            Application app$iv = ApplicationManager.getApplication();
            if (app$iv.isDispatchThread()) {
                boolean bl = false;
                Object object = LineStatusTrackerManager.this.LOCK;
                synchronized (object) {
                    boolean bl2 = false;
                    LineStatusTrackerManager lineStatusTrackerManager = LineStatusTrackerManager.this;
                    int n = lineStatusTrackerManager.clmFreezeCounter;
                    lineStatusTrackerManager.clmFreezeCounter = n + -1;
                    if (LineStatusTrackerManager.this.clmFreezeCounter == 0) {
                        for (TrackerData data : LineStatusTrackerManager.this.trackers.values()) {
                            try {
                                data.getTracker().unfreeze$intellij_platform_vcs_impl();
                            }
                            catch (Throwable e) {
                                LOG.error(e);
                            }
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
            } else {
                Runnable runnable2 = new Runnable(this){
                    final /* synthetic */ MyFreezeListener this$0;
                    {
                        this.this$0 = myFreezeListener;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void run() {
                        boolean bl = false;
                        Object object = LineStatusTrackerManager.access$getLOCK$p(this.this$0.LineStatusTrackerManager.this);
                        synchronized (object) {
                            boolean bl2 = false;
                            LineStatusTrackerManager lineStatusTrackerManager = this.this$0.LineStatusTrackerManager.this;
                            int n = LineStatusTrackerManager.access$getClmFreezeCounter$p(lineStatusTrackerManager);
                            LineStatusTrackerManager.access$setClmFreezeCounter$p(lineStatusTrackerManager, n + -1);
                            if (LineStatusTrackerManager.access$getClmFreezeCounter$p(this.this$0.LineStatusTrackerManager.this) == 0) {
                                for (TrackerData data : LineStatusTrackerManager.access$getTrackers$p(this.this$0.LineStatusTrackerManager.this).values()) {
                                    try {
                                        data.getTracker().unfreeze$intellij_platform_vcs_impl();
                                    }
                                    catch (Throwable e) {
                                        LineStatusTrackerManager.access$getLOG$cp().error(e);
                                    }
                                }
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                };
                ModalityState modalityState = modalityState$iv;
                if (modalityState == null) {
                    modalityState = ModalityState.defaultModalityState();
                }
                app$iv.invokeLater(runnable2, modalityState);
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B)\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$TrackerData;", "", "tracker", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "contentInfo", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;", "clmFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "(Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;Lcom/intellij/openapi/vcs/FilePath;)V", "getClmFilePath", "()Lcom/intellij/openapi/vcs/FilePath;", "setClmFilePath", "(Lcom/intellij/openapi/vcs/FilePath;)V", "getContentInfo", "()Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;", "setContentInfo", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;)V", "getTracker", "()Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "intellij.platform.vcs.impl"})
    private static final class TrackerData {
        @NotNull
        private final LocalLineStatusTracker<?> tracker;
        @Nullable
        private ContentInfo contentInfo;
        @Nullable
        private FilePath clmFilePath;

        @NotNull
        public final LocalLineStatusTracker<?> getTracker() {
            return this.tracker;
        }

        @Nullable
        public final ContentInfo getContentInfo() {
            return this.contentInfo;
        }

        public final void setContentInfo(@Nullable ContentInfo contentInfo) {
            this.contentInfo = contentInfo;
        }

        @Nullable
        public final FilePath getClmFilePath() {
            return this.clmFilePath;
        }

        public final void setClmFilePath(@Nullable FilePath filePath) {
            this.clmFilePath = filePath;
        }

        public TrackerData(@NotNull LocalLineStatusTracker<?> tracker, @Nullable ContentInfo contentInfo, @Nullable FilePath clmFilePath) {
            this.tracker = tracker;
            this.contentInfo = contentInfo;
            this.clmFilePath = clmFilePath;
        }

        public /* synthetic */ TrackerData(LocalLineStatusTracker localLineStatusTracker, ContentInfo contentInfo, FilePath filePath, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                contentInfo = null;
            }
            if ((n & 4) != 0) {
                filePath = null;
            }
            this(localLineStatusTracker, contentInfo, filePath);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;", "", "revision", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "charset", "Ljava/nio/charset/Charset;", "(Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;Ljava/nio/charset/Charset;)V", "getCharset", "()Ljava/nio/charset/Charset;", "getRevision", "()Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "intellij.platform.vcs.impl"})
    private static final class ContentInfo {
        @NotNull
        private final VcsRevisionNumber revision;
        @NotNull
        private final Charset charset;

        @NotNull
        public final VcsRevisionNumber getRevision() {
            return this.revision;
        }

        @NotNull
        public final Charset getCharset() {
            return this.charset;
        }

        public ContentInfo(@NotNull VcsRevisionNumber revision, @NotNull Charset charset) {
            this.revision = revision;
            this.charset = charset;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshRequest;", "", "document", "Lcom/intellij/openapi/editor/Document;", "(Lcom/intellij/openapi/editor/Document;)V", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.vcs.impl"})
    private static final class RefreshRequest {
        @NotNull
        private final Document document;

        public boolean equals(@Nullable Object other) {
            return other instanceof RefreshRequest && Intrinsics.areEqual((Object)this.document, (Object)((RefreshRequest)other).document);
        }

        public int hashCode() {
            return this.document.hashCode();
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("RefreshRequest: ");
            Object object = FileDocumentManager.getInstance().getFile(this.document);
            if (object == null || (object = object.getPath()) == null) {
                object = "unknown";
            }
            return stringBuilder.append(object).toString();
        }

        @NotNull
        public final Document getDocument() {
            return this.document;
        }

        public RefreshRequest(@NotNull Document document) {
            this.document = document;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshData;", "", "text", "", "info", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;", "(Ljava/lang/String;Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;)V", "getInfo", "()Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;", "getText", "()Ljava/lang/String;", "intellij.platform.vcs.impl"})
    private static final class RefreshData {
        @NotNull
        private final String text;
        @NotNull
        private final ContentInfo info;

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final ContentInfo getInfo() {
            return this.info;
        }

        public RefreshData(@NotNull String text, @NotNull ContentInfo info) {
            this.text = text;
            this.info = info;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$InactiveRangesDamagedNotification;", "Lcom/intellij/notification/Notification;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;)V", "getVirtualFiles", "()Ljava/util/Set;", "intellij.platform.vcs.impl"})
    private static final class InactiveRangesDamagedNotification
    extends Notification {
        @NotNull
        private final Set<VirtualFile> virtualFiles;

        @NotNull
        public final Set<VirtualFile> getVirtualFiles() {
            return this.virtualFiles;
        }

        public InactiveRangesDamagedNotification(final @NotNull Project project, @NotNull Set<? extends VirtualFile> virtualFiles) {
            super(VcsNotifier.STANDARD_NOTIFICATION.getDisplayId(), AllIcons.Toolwindows.ToolWindowChanges, null, null, VcsBundle.getString((String)"lst.inactive.ranges.damaged.notification"), NotificationType.INFORMATION, null);
            this.virtualFiles = virtualFiles;
            this.addAction((AnAction)NotificationAction.createSimple((String)"View Changes...", (Runnable)new Runnable(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final void run() {
                    void $receiver$iv$iv;
                    Iterable $receiver$iv;
                    LocalChangeList defaultList = ChangeListManager.getInstance((Project)project).getDefaultChangeList();
                    Iterable iterable = $receiver$iv = (Iterable)defaultList.getChanges();
                    Collection destination$iv$iv = new ArrayList();
                    for (Object element$iv$iv : $receiver$iv$iv) {
                        Change it = (Change)element$iv$iv;
                        boolean bl = false;
                        if (!CollectionsKt.contains((Iterable)this.getVirtualFiles(), (Object)it.getVirtualFile())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    final List changes2 = (List)destination$iv$iv;
                    ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
                    window.activate(new Runnable(){

                        @Override
                        public final void run() {
                            ChangesViewManager.getInstance(project).selectChanges(changes2);
                        }
                    });
                    this.expire();
                }
            }));
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManagerI;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceImpl", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final LineStatusTrackerManagerI getInstance(@NotNull Project project) {
            return (LineStatusTrackerManagerI)project.getComponent(LineStatusTrackerManagerI.class);
        }

        @JvmStatic
        @NotNull
        public final LineStatusTrackerManager getInstanceImpl(@NotNull Project project) {
            LineStatusTrackerManagerI lineStatusTrackerManagerI = this.getInstance(project);
            if (lineStatusTrackerManagerI == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vcs.impl.LineStatusTrackerManager");
            }
            return (LineStatusTrackerManager)lineStatusTrackerManagerI;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

