/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalChangesUnderRoots {
    private final ChangeListManager myChangeManager;
    private final ProjectLevelVcsManager myVcsManager;
    private VcsRoot[] myRoots;

    public LocalChangesUnderRoots(@NotNull ChangeListManager changeListManager, @NotNull ProjectLevelVcsManager projectLevelVcsManager) {
        this.myChangeManager = changeListManager;
        this.myVcsManager = projectLevelVcsManager;
    }

    public Map<String, Map<VirtualFile, Collection<Change>>> getChangesByLists(@NotNull Collection<VirtualFile> rootsToSave) {
        HashMap<String, Map<VirtualFile, Collection<Change>>> result2 = new HashMap<String, Map<VirtualFile, Collection<Change>>>();
        this.myRoots = this.myVcsManager.getAllVcsRoots();
        List changeLists = this.myChangeManager.getChangeListsCopy();
        for (LocalChangeList list2 : changeLists) {
            HashMap<VirtualFile, Collection<Change>> subMap = new HashMap<VirtualFile, Collection<Change>>();
            this.addChangesToMap(rootsToSave, subMap, list2.getChanges());
            result2.put(list2.getName(), subMap);
        }
        return result2;
    }

    @NotNull
    public Map<VirtualFile, Collection<Change>> getChangesUnderRoots(@NotNull Collection<VirtualFile> rootsToSave) {
        HashMap<VirtualFile, Collection<Change>> result2 = new HashMap<VirtualFile, Collection<Change>>();
        Collection allChanges = this.myChangeManager.getAllChanges();
        this.myRoots = this.myVcsManager.getAllVcsRoots();
        this.addChangesToMap(rootsToSave, result2, allChanges);
        return result2;
    }

    private void addChangesToMap(Collection<VirtualFile> rootsToSave, Map<VirtualFile, Collection<Change>> result2, Collection<? extends Change> allChanges) {
        for (Change change : allChanges) {
            if (change.getBeforeRevision() != null) {
                this.addChangeToMap(result2, change, change.getBeforeRevision(), rootsToSave);
            }
            if (change.getAfterRevision() == null) continue;
            this.addChangeToMap(result2, change, change.getAfterRevision(), rootsToSave);
        }
    }

    private void addChangeToMap(@NotNull Map<VirtualFile, Collection<Change>> result2, @NotNull Change change, @NotNull ContentRevision revision, @NotNull Collection<VirtualFile> rootsToSave) {
        VirtualFile root = this.getRootForPath(revision.getFile(), rootsToSave);
        LocalChangesUnderRoots.addChangeToMap(result2, root, change);
    }

    @Nullable
    private VirtualFile getRootForPath(@NotNull FilePath file2, @NotNull Collection<VirtualFile> rootsToSave) {
        VirtualFile vf = ChangesUtil.findValidParentUnderReadAction((FilePath)file2);
        if (vf == null) {
            return null;
        }
        VirtualFile rootCandidate = null;
        for (VcsRoot root : this.myRoots) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root.getPath(), (VirtualFile)vf, (boolean)false) || rootCandidate != null && !VfsUtil.isAncestor((VirtualFile)rootCandidate, (VirtualFile)root.getPath(), (boolean)true)) continue;
            rootCandidate = root.getPath();
        }
        if (!rootsToSave.contains(rootCandidate)) {
            return null;
        }
        return rootCandidate;
    }

    private static void addChangeToMap(@NotNull Map<VirtualFile, Collection<Change>> result2, @Nullable VirtualFile root, @NotNull Change change) {
        if (root == null) {
            return;
        }
        Collection<Change> changes2 = result2.get(root);
        if (changes2 == null) {
            changes2 = new HashSet<Change>();
            result2.put(root, changes2);
        }
        changes2.add(change);
    }
}

