/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.VcsRootSettings;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowConfirmationOptionImpl;
import com.intellij.openapi.vcs.VcsShowOptionsSettingImpl;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.VirtualFileFilter;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsAnnotationLocalChangesListener;
import com.intellij.openapi.vcs.changes.VcsAnnotationLocalChangesListenerImpl;
import com.intellij.openapi.vcs.checkout.CompositeCheckoutListener;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.impl.BackgroundableActionEnabledHandler;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsInitialization;
import com.intellij.openapi.vcs.impl.VcsRootIterator;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcses;
import com.intellij.openapi.vcs.impl.projectlevelman.MappingsToRoots;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vcs.impl.projectlevelman.OptionsAndConfirmations;
import com.intellij.openapi.vcs.impl.projectlevelman.ProjectLevelVcsManagerSerialization;
import com.intellij.openapi.vcs.roots.VcsRootScanner;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vcs.update.UpdatedFilesListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.project.ProjectKt;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.ViewUpdateInfoNotification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ProjectLevelVcsManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ProjectLevelVcsManagerImpl
extends ProjectLevelVcsManagerEx
implements ProjectComponent,
PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl");
    @NonNls
    private static final String SETTINGS_EDITED_MANUALLY = "settingsEditedManually";
    private final ProjectLevelVcsManagerSerialization mySerialization;
    private final OptionsAndConfirmations myOptionsAndConfirmations;
    private final NewMappings myMappings;
    private final Project myProject;
    private final MappingsToRoots myMappingsToRoots;
    private ConsoleView myConsole;
    @Nullable
    private final VcsInitialization myInitialization;
    @NonNls
    private static final String ELEMENT_MAPPING = "mapping";
    @NonNls
    private static final String ATTRIBUTE_DIRECTORY = "directory";
    @NonNls
    private static final String ATTRIBUTE_VCS = "vcs";
    @NonNls
    private static final String ATTRIBUTE_DEFAULT_PROJECT = "defaultProject";
    @NonNls
    private static final String ELEMENT_ROOT_SETTINGS = "rootSettings";
    @NonNls
    private static final String ATTRIBUTE_CLASS = "class";
    private boolean myMappingsLoaded;
    private boolean myHaveLegacyVcsConfiguration;
    private final DefaultVcsRootPolicy myDefaultVcsRootPolicy;
    @NotNull
    private final AtomicInteger myBackgroundOperationCounter = new AtomicInteger();
    private final Set<ActionKey> myBackgroundRunningTasks = ContainerUtil.newHashSet();
    private final List<Pair<String, ConsoleViewContentType>> myPendingOutput = ContainerUtil.newArrayList();
    private final VcsHistoryCache myVcsHistoryCache;
    private final ContentRevisionCache myContentRevisionCache;
    private final FileIndexFacade myExcludedIndex;
    private final VcsAnnotationLocalChangesListenerImpl myAnnotationLocalChangesListener;
    private final Map<VcsListener, MessageBusConnection> myAdapters = new HashMap<VcsListener, MessageBusConnection>();

    public ProjectLevelVcsManagerImpl(Project project, FileStatusManager manager, FileIndexFacade excludedFileIndex, ProjectManager projectManager, DefaultVcsRootPolicy defaultVcsRootPolicy) {
        this.myProject = project;
        this.mySerialization = new ProjectLevelVcsManagerSerialization();
        this.myOptionsAndConfirmations = new OptionsAndConfirmations();
        this.myDefaultVcsRootPolicy = defaultVcsRootPolicy;
        if (!project.isDefault()) {
            this.myInitialization = new VcsInitialization(this.myProject);
            Disposer.register((Disposable)project, (Disposable)this.myInitialization);
            projectManager.addProjectManagerListener(project, new ProjectManagerListener(){

                public void projectClosing(@NotNull Project project) {
                    Disposer.dispose((Disposable)ProjectLevelVcsManagerImpl.this.myInitialization);
                }
            });
        } else {
            this.myInitialization = null;
        }
        this.myMappings = new NewMappings(this.myProject, this, manager);
        this.myMappingsToRoots = new MappingsToRoots(this.myMappings, this.myProject);
        this.myVcsHistoryCache = new VcsHistoryCache();
        this.myContentRevisionCache = new ContentRevisionCache();
        VcsListener vcsListener = () -> this.myVcsHistoryCache.clearHistory();
        this.myExcludedIndex = excludedFileIndex;
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)vcsListener);
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED_IN_PLUGIN, (Object)vcsListener);
        connection.subscribe(UpdatedFilesListener.UPDATED_FILES, arg_0 -> ((ContentRevisionCache)this.myContentRevisionCache).clearCurrent(arg_0));
        this.myAnnotationLocalChangesListener = new VcsAnnotationLocalChangesListenerImpl(this.myProject, this);
    }

    public void registerVcs(AbstractVcs vcs) {
        AllVcses.getInstance(this.myProject).registerManually(vcs);
    }

    @Nullable
    public AbstractVcs findVcsByName(String name) {
        if (name == null) {
            return null;
        }
        AbstractVcs result2 = this.myProject.isDisposed() ? null : AllVcses.getInstance(this.myProject).getByName(name);
        ProgressManager.checkCanceled();
        return result2;
    }

    @Nullable
    public VcsDescriptor getDescriptor(String name) {
        if (name == null) {
            return null;
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        return AllVcses.getInstance(this.myProject).getDescriptor(name);
    }

    public void iterateVfUnderVcsRoot(VirtualFile file2, Processor<? super VirtualFile> processor2) {
        VcsRootIterator.iterateVfUnderVcsRoot(this.myProject, file2, processor2);
    }

    public VcsDescriptor[] getAllVcss() {
        return AllVcses.getInstance(this.myProject).getAll();
    }

    public boolean haveVcses() {
        return !AllVcses.getInstance(this.myProject).isEmpty();
    }

    public void dispose() {
        this.releaseConsole();
        this.myMappings.disposeMe();
        Disposer.dispose((Disposable)this.myAnnotationLocalChangesListener);
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        if (toolWindowManager != null && toolWindowManager.getToolWindow(ToolWindowId.VCS) != null) {
            toolWindowManager.unregisterToolWindow(ToolWindowId.VCS);
        }
    }

    @NotNull
    public VcsAnnotationLocalChangesListener getAnnotationLocalChangesListener() {
        return this.myAnnotationLocalChangesListener;
    }

    public void projectOpened() {
        this.addInitializationRequest(VcsInitObject.AFTER_COMMON, () -> {
            List checkers;
            if (!ApplicationManager.getApplication().isUnitTestMode() && (checkers = VcsRootChecker.EXTENSION_POINT_NAME.getExtensionList()).size() != 0) {
                VcsRootScanner.start(this.myProject, checkers);
            }
        });
    }

    public void projectClosed() {
        this.releaseConsole();
    }

    @NotNull
    public String getComponentName() {
        return "ProjectLevelVcsManager";
    }

    public boolean checkAllFilesAreUnder(AbstractVcs abstractVcs, VirtualFile[] files2) {
        if (files2 == null) {
            return false;
        }
        for (VirtualFile file2 : files2) {
            if (this.getVcsFor(file2) == abstractVcs) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public AbstractVcs getVcsFor(@NotNull VirtualFile file2) {
        String vcsName = this.myMappings.getVcsFor(file2);
        if (vcsName == null || vcsName.isEmpty()) {
            return null;
        }
        return AllVcses.getInstance(this.myProject).getByName(vcsName);
    }

    AbstractVcs<?> getVcsFor(@NotNull VirtualFile file2, @Nullable Object matchContext) {
        VcsDirectoryMapping mapping = this.myMappings.getMappingFor(file2, matchContext);
        String vcsName = mapping != null ? StringUtil.nullize((String)mapping.getVcs()) : null;
        return vcsName != null ? AllVcses.getInstance(this.myProject).getByName(vcsName) : null;
    }

    @Nullable
    public AbstractVcs getVcsFor(@NotNull FilePath file2) {
        VirtualFile vFile = ChangesUtil.findValidParentAccurately((FilePath)file2);
        return (AbstractVcs)ReadAction.compute(() -> {
            if (!ApplicationManager.getApplication().isUnitTestMode() && !this.myProject.isInitialized()) {
                return null;
            }
            if (this.myProject.isDisposed()) {
                throw new ProcessCanceledException();
            }
            if (vFile != null) {
                return this.getVcsFor(vFile);
            }
            return null;
        });
    }

    @Nullable
    public VirtualFile getVcsRootFor(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        VcsDirectoryMapping mapping = this.myMappings.getMappingFor(file2);
        if (mapping == null) {
            return null;
        }
        String directory = mapping.getDirectory();
        if (directory.isEmpty()) {
            return this.myDefaultVcsRootPolicy.getVcsRootFor(file2);
        }
        return LocalFileSystem.getInstance().findFileByPath(directory);
    }

    @Nullable
    public VcsRoot getVcsRootObjectFor(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        VcsDirectoryMapping mapping = this.myMappings.getMappingFor(file2);
        if (mapping == null) {
            return null;
        }
        String directory = mapping.getDirectory();
        AbstractVcs vcs = this.findVcsByName(mapping.getVcs());
        if (directory.isEmpty()) {
            return new VcsRoot(vcs, this.myDefaultVcsRootPolicy.getVcsRootFor(file2));
        }
        return new VcsRoot(vcs, LocalFileSystem.getInstance().findFileByPath(directory));
    }

    @Nullable
    public VirtualFile getVcsRootFor(@Nullable FilePath file2) {
        if (file2 == null || this.myProject.isDisposed()) {
            return null;
        }
        VirtualFile vFile = ChangesUtil.findValidParentAccurately((FilePath)file2);
        return vFile != null ? this.getVcsRootFor(vFile) : null;
    }

    public VcsRoot getVcsRootObjectFor(@Nullable FilePath file2) {
        if (file2 == null) {
            return null;
        }
        VirtualFile vFile = ChangesUtil.findValidParentAccurately((FilePath)file2);
        return vFile != null ? this.getVcsRootObjectFor(vFile) : null;
    }

    public void unregisterVcs(@NotNull AbstractVcs vcs) {
        if (!ApplicationManager.getApplication().isUnitTestMode() && this.myMappings.haveActiveVcs(vcs.getName())) {
            LOG.warn("Active vcs '" + vcs.getName() + "' is being unregistered. Remove from mappings first.");
        }
        this.myMappings.beingUnregistered(vcs.getName());
        AllVcses.getInstance(this.myProject).unregisterManually(vcs);
    }

    @Override
    @Nullable
    public ContentManager getContentManager() {
        ToolWindow changes2 = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.VCS);
        return changes2 == null ? null : changes2.getContentManager();
    }

    public boolean checkVcsIsActive(AbstractVcs vcs) {
        return this.checkVcsIsActive(vcs.getName());
    }

    public boolean checkVcsIsActive(String vcsName) {
        return this.myMappings.haveActiveVcs(vcsName);
    }

    public AbstractVcs[] getAllActiveVcss() {
        return this.myMappings.getActiveVcses();
    }

    public boolean hasActiveVcss() {
        return this.myMappings.hasActiveVcss();
    }

    public boolean hasAnyMappings() {
        return !this.myMappings.isEmpty();
    }

    @Deprecated
    public void addMessageToConsoleWindow(String message, TextAttributes attributes) {
        this.addMessageToConsoleWindow(message, new ConsoleViewContentType("", attributes));
    }

    public void addMessageToConsoleWindow(@Nullable String message, @NotNull ConsoleViewContentType contentType) {
        if (!Registry.is((String)"vcs.showConsole")) {
            return;
        }
        if (StringUtil.isEmptyOrSpaces((String)message)) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed() || this.myProject.isDefault()) {
                return;
            }
            ContentManager contentManager = this.getContentManager();
            if (contentManager == null) {
                this.myPendingOutput.add((Pair<String, ConsoleViewContentType>)Pair.create((Object)message, (Object)contentType));
            } else {
                this.getOrCreateConsoleContent(contentManager);
                this.printToConsole(message, contentType);
            }
        }, ModalityState.defaultModalityState());
    }

    private void getOrCreateConsoleContent(ContentManager contentManager) {
        String displayName = VcsBundle.message((String)"vcs.console.toolwindow.display.name", (Object[])new Object[0]);
        Content content = contentManager.findContent(displayName);
        if (content == null) {
            ConsoleView console;
            this.releaseConsole();
            this.myConsole = console = TextConsoleBuilderFactory.getInstance().createBuilder(this.myProject).getConsole();
            SimpleToolWindowPanel panel2 = new SimpleToolWindowPanel(false, true);
            panel2.setContent(console.getComponent());
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("VcsManager", (ActionGroup)new DefaultActionGroup(console.createConsoleActions()), false);
            panel2.setToolbar(toolbar.getComponent());
            content = ContentFactory.SERVICE.getInstance().createContent((JComponent)panel2, displayName, true);
            content.setDisposer(() -> this.releaseConsole());
            content.setPreferredFocusedComponent(() -> console.getPreferredFocusableComponent());
            contentManager.addContent(content);
            for (Pair<String, ConsoleViewContentType> pair : this.myPendingOutput) {
                this.printToConsole((String)pair.first, (ConsoleViewContentType)pair.second);
            }
            this.myPendingOutput.clear();
        }
    }

    private void printToConsole(@NotNull String message, @NotNull ConsoleViewContentType contentType) {
        this.myConsole.print(message + "\n", contentType);
    }

    private void releaseConsole() {
        if (this.myConsole != null) {
            Disposer.dispose((Disposable)this.myConsole);
            this.myConsole = null;
        }
    }

    @Override
    @NotNull
    public VcsShowSettingOption getOptions(VcsConfiguration.StandardOption option2) {
        return this.myOptionsAndConfirmations.getOptions(option2);
    }

    @Override
    public List<VcsShowOptionsSettingImpl> getAllOptions() {
        return this.myOptionsAndConfirmations.getAllOptions();
    }

    @NotNull
    public VcsShowSettingOption getStandardOption(@NotNull VcsConfiguration.StandardOption option2, @NotNull AbstractVcs vcs) {
        VcsShowOptionsSettingImpl options = (VcsShowOptionsSettingImpl)this.getOptions(option2);
        options.addApplicableVcs(vcs);
        return options;
    }

    @NotNull
    public VcsShowSettingOption getOrCreateCustomOption(@NotNull String vcsActionName, @NotNull AbstractVcs vcs) {
        return this.myOptionsAndConfirmations.getOrCreateCustomOption(vcsActionName, vcs);
    }

    public void showProjectOperationInfo(UpdatedFiles updatedFiles, String displayActionName) {
        UpdateInfoTree tree = this.showUpdateProjectInfo(updatedFiles, displayActionName, ActionInfo.STATUS, false);
        if (tree != null) {
            ViewUpdateInfoNotification.focusUpdateInfoTree(this.myProject, tree);
        }
    }

    @Override
    @Nullable
    public UpdateInfoTree showUpdateProjectInfo(UpdatedFiles updatedFiles, String displayActionName, ActionInfo actionInfo, boolean canceled) {
        if (!this.myProject.isOpen() || this.myProject.isDisposed()) {
            return null;
        }
        ContentManager contentManager = this.getContentManager();
        if (contentManager == null) {
            return null;
        }
        UpdateInfoTree updateInfoTree = new UpdateInfoTree(contentManager, this.myProject, updatedFiles, displayActionName, actionInfo);
        ContentUtilEx.addTabbedContent(contentManager, (JComponent)((Object)updateInfoTree), "Update Info", DateFormatUtil.formatDateTime((long)System.currentTimeMillis()), false, (Disposable)updateInfoTree);
        updateInfoTree.expandRootChildren();
        return updateInfoTree;
    }

    public void cleanupMappings() {
        this.myMappings.cleanupMappings();
    }

    public List<VcsDirectoryMapping> getDirectoryMappings() {
        return this.myMappings.getDirectoryMappings();
    }

    public List<VcsDirectoryMapping> getDirectoryMappings(AbstractVcs vcs) {
        return this.myMappings.getDirectoryMappings(vcs.getName());
    }

    @Nullable
    public VcsDirectoryMapping getDirectoryMappingFor(FilePath path) {
        VirtualFile vFile = ChangesUtil.findValidParentAccurately((FilePath)path);
        if (vFile != null) {
            return this.myMappings.getMappingFor(vFile);
        }
        return null;
    }

    public void setDirectoryMapping(String path, String activeVcsName) {
        if (this.myMappingsLoaded) {
            return;
        }
        this.myHaveLegacyVcsConfiguration = true;
        this.myMappings.setMapping(FileUtil.toSystemIndependentName((String)path), activeVcsName);
    }

    public void setAutoDirectoryMapping(String path, String activeVcsName) {
        List<VirtualFile> defaultRoots = this.myMappings.getDefaultRoots();
        if (defaultRoots.size() == 1 && StringUtil.isEmpty((String)this.myMappings.haveDefaultMapping())) {
            this.myMappings.removeDirectoryMapping(new VcsDirectoryMapping("", ""));
        }
        this.myMappings.setMapping(path, activeVcsName);
    }

    public void removeDirectoryMapping(VcsDirectoryMapping mapping) {
        this.myMappings.removeDirectoryMapping(mapping);
    }

    public void setDirectoryMappings(List<VcsDirectoryMapping> items) {
        this.myHaveLegacyVcsConfiguration = true;
        this.myMappings.setDirectoryMappings(items);
    }

    public void iterateVcsRoot(VirtualFile root, Processor<? super FilePath> iterator) {
        VcsRootIterator.iterateVcsRoot(this.myProject, root, iterator);
    }

    public void iterateVcsRoot(VirtualFile root, Processor<? super FilePath> iterator, @Nullable VirtualFileFilter directoryFilter) {
        VcsRootIterator.iterateVcsRoot(this.myProject, root, iterator, directoryFilter);
    }

    @Nullable
    public Element getState() {
        Element element = new Element("state");
        this.mySerialization.writeExternalUtil(element, this.myOptionsAndConfirmations);
        if (this.myHaveLegacyVcsConfiguration) {
            element.setAttribute(SETTINGS_EDITED_MANUALLY, "true");
        }
        return element;
    }

    public void loadState(@NotNull Element state) {
        this.mySerialization.readExternalUtil(state, this.myOptionsAndConfirmations);
        Attribute attribute = state.getAttribute(SETTINGS_EDITED_MANUALLY);
        if (attribute != null) {
            try {
                this.myHaveLegacyVcsConfiguration = attribute.getBooleanValue();
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
    }

    @NotNull
    public VcsShowConfirmationOption getStandardConfirmation(@NotNull VcsConfiguration.StandardConfirmation option2, AbstractVcs vcs) {
        VcsShowConfirmationOptionImpl result2 = this.getConfirmation(option2);
        if (vcs != null) {
            result2.addApplicableVcs(vcs);
        }
        return result2;
    }

    @Override
    public List<VcsShowConfirmationOptionImpl> getAllConfirmations() {
        return this.myOptionsAndConfirmations.getAllConfirmations();
    }

    @Override
    @NotNull
    public VcsShowConfirmationOptionImpl getConfirmation(VcsConfiguration.StandardConfirmation option2) {
        return this.myOptionsAndConfirmations.getConfirmation(option2);
    }

    public void addVcsListener(VcsListener listener2) {
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(VCS_CONFIGURATION_CHANGED, (Object)listener2);
        this.myAdapters.put(listener2, connection);
    }

    public void removeVcsListener(VcsListener listener2) {
        MessageBusConnection connection = this.myAdapters.remove(listener2);
        if (connection != null) {
            connection.disconnect();
        }
    }

    public void startBackgroundVcsOperation() {
        this.myBackgroundOperationCounter.incrementAndGet();
    }

    public void stopBackgroundVcsOperation() {
        assert (!ApplicationManager.getApplication().isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode());
        int counter = this.myBackgroundOperationCounter.getAndDecrement();
        LOG.assertTrue(counter > 0, (Object)("myBackgroundOperationCounter was " + counter + " while should have been > 0"));
    }

    public boolean isBackgroundVcsOperationRunning() {
        return this.myBackgroundOperationCounter.get() > 0;
    }

    public List<VirtualFile> getRootsUnderVcsWithoutFiltering(AbstractVcs vcs) {
        return this.myMappings.getMappingsAsFilesUnderVcs(vcs);
    }

    @NotNull
    public VirtualFile[] getRootsUnderVcs(@NotNull AbstractVcs vcs) {
        return this.myMappingsToRoots.getRootsUnderVcs(vcs);
    }

    public List<VirtualFile> getDetailedVcsMappings(AbstractVcs vcs) {
        return this.myMappingsToRoots.getDetailedVcsMappings(vcs);
    }

    public VirtualFile[] getAllVersionedRoots() {
        AbstractVcs[] vcses;
        ArrayList vFiles = new ArrayList();
        for (AbstractVcs vcs : vcses = this.myMappings.getActiveVcses()) {
            Collections.addAll(vFiles, this.getRootsUnderVcs(vcs));
        }
        return VfsUtilCore.toVirtualFileArray(vFiles);
    }

    @NotNull
    public VcsRoot[] getAllVcsRoots() {
        AbstractVcs[] vcses;
        ArrayList<VcsRoot> vcsRoots = new ArrayList<VcsRoot>();
        for (AbstractVcs vcs : vcses = this.myMappings.getActiveVcses()) {
            VirtualFile[] roots;
            for (VirtualFile root : roots = this.getRootsUnderVcs(vcs)) {
                vcsRoots.add(new VcsRoot(vcs, root));
            }
        }
        return vcsRoots.toArray(new VcsRoot[0]);
    }

    @Override
    public void notifyDirectoryMappingChanged() {
        ((VcsListener)BackgroundTaskUtil.syncPublisher(this.myProject, VCS_CONFIGURATION_CHANGED)).directoryMappingChanged();
    }

    void readDirectoryMappings(Element element) {
        this.myMappings.clear();
        ArrayList<VcsDirectoryMapping> mappingsList = new ArrayList<VcsDirectoryMapping>();
        boolean haveNonEmptyMappings = false;
        for (Element child2 : element.getChildren(ELEMENT_MAPPING)) {
            VcsRootSettings rootSettings;
            String vcs = child2.getAttributeValue(ATTRIBUTE_VCS);
            if (vcs != null && !vcs.isEmpty()) {
                haveNonEmptyMappings = true;
            }
            VcsDirectoryMapping mapping = new VcsDirectoryMapping(child2.getAttributeValue(ATTRIBUTE_DIRECTORY), vcs);
            mappingsList.add(mapping);
            Element rootSettingsElement = child2.getChild(ELEMENT_ROOT_SETTINGS);
            if (rootSettingsElement == null) continue;
            String className = rootSettingsElement.getAttributeValue(ATTRIBUTE_CLASS);
            AbstractVcs vcsInstance = this.findVcsByName(mapping.getVcs());
            if (vcsInstance == null || className == null || (rootSettings = vcsInstance.createEmptyVcsRootSettings()) == null) continue;
            try {
                rootSettings.readExternal(rootSettingsElement);
                mapping.setRootSettings(rootSettings);
            }
            catch (InvalidDataException e) {
                LOG.error("Failed to load VCS root settings class " + className + " for VCS " + vcsInstance.getClass().getName(), (Throwable)e);
            }
        }
        boolean defaultProject = Boolean.TRUE.toString().equals(element.getAttributeValue(ATTRIBUTE_DEFAULT_PROJECT));
        if (haveNonEmptyMappings || !defaultProject) {
            this.myMappingsLoaded = true;
        }
        this.myMappings.setDirectoryMappings(mappingsList);
    }

    void writeDirectoryMappings(@NotNull Element element) {
        if (this.myProject.isDefault()) {
            element.setAttribute(ATTRIBUTE_DEFAULT_PROJECT, Boolean.TRUE.toString());
        }
        for (VcsDirectoryMapping mapping : this.getDirectoryMappings()) {
            VcsRootSettings rootSettings = mapping.getRootSettings();
            if (rootSettings == null && StringUtil.isEmpty((String)mapping.getDirectory()) && StringUtil.isEmpty((String)mapping.getVcs())) continue;
            Element child2 = new Element(ELEMENT_MAPPING);
            child2.setAttribute(ATTRIBUTE_DIRECTORY, mapping.getDirectory());
            child2.setAttribute(ATTRIBUTE_VCS, mapping.getVcs());
            if (rootSettings != null) {
                Element rootSettingsElement = new Element(ELEMENT_ROOT_SETTINGS);
                rootSettingsElement.setAttribute(ATTRIBUTE_CLASS, rootSettings.getClass().getName());
                try {
                    rootSettings.writeExternal(rootSettingsElement);
                    child2.addContent(rootSettingsElement);
                }
                catch (WriteExternalException writeExternalException) {
                    // empty catch block
                }
            }
            element.addContent(child2);
        }
    }

    public boolean needAutodetectMappings() {
        return !this.myHaveLegacyVcsConfiguration && !this.myMappingsLoaded;
    }

    @Nullable
    public AbstractVcs findVersioningVcs(VirtualFile file2) {
        VcsDescriptor[] vcsDescriptors = this.getAllVcss();
        VcsDescriptor probableVcs = null;
        for (VcsDescriptor vcsDescriptor : vcsDescriptors) {
            if (!vcsDescriptor.probablyUnderVcs(file2)) continue;
            if (probableVcs != null) {
                return null;
            }
            probableVcs = vcsDescriptor;
        }
        return probableVcs == null ? null : this.findVcsByName(probableVcs.getName());
    }

    public CheckoutProvider.Listener getCompositeCheckoutListener() {
        return new CompositeCheckoutListener(this.myProject);
    }

    @Override
    public void fireDirectoryMappingsChanged() {
        if (this.myProject.isOpen() && !this.myProject.isDisposed()) {
            this.myMappings.mappingsChanged();
        }
    }

    @Override
    public String haveDefaultMapping() {
        return this.myMappings.haveDefaultMapping();
    }

    @Deprecated
    public BackgroundableActionEnabledHandler getBackgroundableActionHandler(VcsBackgroundableActions action) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return new BackgroundableActionEnabledHandler(this.myProject, action);
    }

    boolean isBackgroundTaskRunning(Object ... keys) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myBackgroundRunningTasks.contains(new ActionKey(keys));
    }

    void startBackgroundTask(Object ... keys) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        LOG.assertTrue(this.myBackgroundRunningTasks.add(new ActionKey(keys)));
    }

    void stopBackgroundTask(Object ... keys) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        LOG.assertTrue(this.myBackgroundRunningTasks.remove(new ActionKey(keys)));
    }

    public void addInitializationRequest(VcsInitObject vcsInitObject, Runnable runnable2) {
        if (this.myInitialization != null) {
            ApplicationManager.getApplication().runReadAction(() -> this.myInitialization.add(vcsInitObject, runnable2));
        }
    }

    public boolean isFileInContent(@Nullable VirtualFile vf) {
        if (vf == null) {
            return false;
        }
        return (Boolean)ReadAction.compute(() -> {
            boolean isUnderProject = this.isFileInBaseDir(vf) || this.isInDirectoryBasedRoot(vf) || this.hasExplicitMapping(vf) || this.myExcludedIndex.isInContent(vf) || !Registry.is((String)"ide.hide.excluded.files") && this.myExcludedIndex.isExcludedFile(vf);
            return isUnderProject && !this.isIgnored(vf);
        });
    }

    public boolean isIgnored(@NotNull VirtualFile vf) {
        return (Boolean)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                return false;
            }
            if (Registry.is((String)"ide.hide.excluded.files")) {
                return this.myExcludedIndex.isExcludedFile(vf);
            }
            return this.myExcludedIndex.isUnderIgnored(vf);
        });
    }

    private boolean isInDirectoryBasedRoot(@NotNull VirtualFile file2) {
        if (ProjectKt.isDirectoryBased(this.myProject)) {
            return ProjectKt.getStateStore(this.myProject).isProjectFile(file2);
        }
        return false;
    }

    private boolean isFileInBaseDir(@NotNull VirtualFile file2) {
        VirtualFile baseDir = this.myProject.getBaseDir();
        if (baseDir == null) {
            return false;
        }
        if (file2.isDirectory()) {
            return baseDir.equals(file2);
        }
        return baseDir.equals(file2.getParent());
    }

    private boolean hasExplicitMapping(@NotNull VirtualFile vFile) {
        VcsDirectoryMapping mapping = this.myMappings.getMappingFor(vFile);
        return mapping != null && !mapping.isDefaultMapping();
    }

    public VcsHistoryCache getVcsHistoryCache() {
        return this.myVcsHistoryCache;
    }

    public ContentRevisionCache getContentRevisionCache() {
        return this.myContentRevisionCache;
    }

    public void waitForInitialized() {
        if (this.myInitialization != null) {
            this.myInitialization.waitFinished();
        }
    }

    private static class ActionKey {
        private final Object[] myObjects;

        ActionKey(Object ... objects) {
            this.myObjects = objects;
        }

        public final boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return Arrays.equals(this.myObjects, ((ActionKey)o).myObjects);
        }

        public final int hashCode() {
            return Arrays.hashCode(this.myObjects);
        }

        public String toString() {
            return this.getClass() + " - " + Arrays.toString(this.myObjects);
        }
    }
}

