/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.impl.RepositoryBrowserKt;
import com.intellij.openapi.vcs.impl.RepositoryBrowserPanel;
import com.intellij.openapi.vcs.impl.VcsVirtualFileContentRevision;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.PlatformIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/vcs/impl/RepositoryBrowserPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile;", "localRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;)V", "fileSystemTree", "Lcom/intellij/openapi/fileChooser/ex/FileSystemTreeImpl;", "getLocalRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRoot", "()Lcom/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile;", "createChangeVsLocal", "Lcom/intellij/openapi/vcs/changes/Change;", "file", "Lcom/intellij/openapi/vcs/vfs/VcsVirtualFile;", "getData", "", "dataId", "", "getSelectionAsChanges", "", "hasSelectedFiles", "", "intellij.platform.vcs.impl"})
public final class RepositoryBrowserPanel
extends JPanel
implements DataProvider {
    private final FileSystemTreeImpl fileSystemTree;
    @NotNull
    private final Project project;
    @NotNull
    private final AbstractVcsVirtualFile root;
    @NotNull
    private final VirtualFile localRoot;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object getData(@NotNull String dataId) {
        Serializable serializable;
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            serializable = (Serializable)this.fileSystemTree.getSelectedFiles();
        } else if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            Object $receiver$iv$iv;
            Object $receiver$iv = this.fileSystemTree.getSelectedFiles();
            VirtualFile[] virtualFileArray = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            Iterator iterator = $receiver$iv$iv;
            int n = ((void)iterator).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = iterator[i];
                boolean bl = false;
                if (!(!it.isDirectory())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv = iterator.next();
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(this.project, (VirtualFile)it);
                collection.add(openFileDescriptor);
            }
            $receiver$iv = (List)destination$iv$iv;
            Object thisCollection$iv = $receiver$iv;
            OpenFileDescriptor[] openFileDescriptorArray = thisCollection$iv.toArray(new OpenFileDescriptor[0]);
            if (openFileDescriptorArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            serializable = (Serializable)openFileDescriptorArray;
        } else {
            serializable = RepositoryBrowserKt.getREPOSITORY_BROWSER_DATA_KEY().is(dataId) ? (Serializable)this : null;
        }
        return serializable;
    }

    public final boolean hasSelectedFiles() {
        boolean bl;
        block1: {
            VirtualFile[] $receiver$iv;
            VirtualFile[] virtualFileArray = $receiver$iv = this.fileSystemTree.getSelectedFiles();
            int n = virtualFileArray.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile element$iv;
                VirtualFile it = element$iv = virtualFileArray[i];
                boolean bl2 = false;
                if (!(it instanceof VcsVirtualFile)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Change> getSelectionAsChanges() {
        void var3_3;
        Object $receiver$iv$iv;
        Object $receiver$iv = this.fileSystemTree.getSelectedFiles();
        VirtualFile[] virtualFileArray = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (void element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof VcsVirtualFile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            VcsVirtualFile vcsVirtualFile = (VcsVirtualFile)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Change change = this.createChangeVsLocal((VcsVirtualFile)it);
            collection.add(change);
        }
        return (List)var3_3;
    }

    private final Change createChangeVsLocal(VcsVirtualFile file2) {
        VcsVirtualFileContentRevision repoRevision = new VcsVirtualFileContentRevision(file2);
        File localPath = new File(this.localRoot.getPath(), file2.getPath());
        CurrentContentRevision localRevision = new CurrentContentRevision(VcsContextFactory.SERVICE.getInstance().createFilePathOn(localPath));
        return new Change((ContentRevision)repoRevision, (ContentRevision)localRevision);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final AbstractVcsVirtualFile getRoot() {
        return this.root;
    }

    @NotNull
    public final VirtualFile getLocalRoot() {
        return this.localRoot;
    }

    public RepositoryBrowserPanel(@NotNull Project project, @NotNull AbstractVcsVirtualFile root, @NotNull VirtualFile localRoot) {
        super(new BorderLayout());
        this.project = project;
        this.root = root;
        this.localRoot = localRoot;
        FileChooserDescriptor fileChooserDescriptor2 = new FileChooserDescriptor(this, true, false, false, false, false, true){
            final /* synthetic */ RepositoryBrowserPanel this$0;

            @NotNull
            public List<VirtualFile> getRoots() {
                return CollectionsKt.listOf((Object)((Object)this.this$0.getRoot()));
            }

            @Nullable
            public Icon getIcon(@NotNull VirtualFile file2) {
                if (file2.isDirectory()) {
                    return PlatformIcons.FOLDER_ICON;
                }
                return FileTypeManager.getInstance().getFileTypeByFileName(file2.getNameSequence()).getIcon();
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        };
        this.fileSystemTree = new FileSystemTreeImpl(fileChooserDescriptor2, this.project, fileChooserDescriptor2){
            final /* synthetic */ fileChooserDescriptor.1 $fileChooserDescriptor;

            @Override
            protected boolean useNewAsyncModel() {
                return true;
            }
            {
                this.$fileChooserDescriptor = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }
        };
        this.fileSystemTree.addOkAction(new Runnable(){

            @Override
            public final void run() {
                VirtualFile[] files2;
                for (VirtualFile file2 : files2 = (fileSystemTree).getSelectedFiles()) {
                    FileEditorManager.getInstance((Project)this.getProject()).openFile(file2, true);
                }
            }
        });
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(ActionManager.getInstance().getAction("EditSource"));
        actionGroup.add(ActionManager.getInstance().getAction("Vcs.ShowDiffWithLocal"));
        this.fileSystemTree.registerMouseListener((ActionGroup)actionGroup);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)(this.fileSystemTree).getTree());
        this.add((Component)scrollPane, "Center");
    }
}

