/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.diff.DiffContentFactoryImpl;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.FileStatusManagerImpl;
import com.intellij.openapi.vcs.impl.FileStatusProvider;
import com.intellij.openapi.vcs.impl.VcsBaseContentProvider;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsFileStatusProvider
implements FileStatusProvider,
VcsBaseContentProvider {
    private final Project myProject;
    private final FileStatusManagerImpl myFileStatusManager;
    private final ProjectLevelVcsManager myVcsManager;
    private final ChangeListManager myChangeListManager;
    private final VcsDirtyScopeManager myDirtyScopeManager;
    private final VcsConfiguration myConfiguration;
    private final VcsBaseContentProvider[] myAdditionalProviders;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.VcsFileStatusProvider");

    public VcsFileStatusProvider(Project project, FileStatusManagerImpl fileStatusManager, ProjectLevelVcsManager vcsManager, ChangeListManager changeListManager, VcsDirtyScopeManager dirtyScopeManager, VcsConfiguration configuration2) {
        this.myProject = project;
        this.myFileStatusManager = fileStatusManager;
        this.myVcsManager = vcsManager;
        this.myChangeListManager = changeListManager;
        this.myDirtyScopeManager = dirtyScopeManager;
        this.myConfiguration = configuration2;
        this.myFileStatusManager.setFileStatusProvider(this);
        this.myAdditionalProviders = (VcsBaseContentProvider[])VcsBaseContentProvider.EP_NAME.getExtensions((AreaInstance)project);
        changeListManager.addChangeListListener((ChangeListListener)new ChangeListAdapter(){

            public void changeListAdded(ChangeList list2) {
                VcsFileStatusProvider.this.fileStatusesChanged();
            }

            public void changeListRemoved(ChangeList list2) {
                VcsFileStatusProvider.this.fileStatusesChanged();
            }

            public void changeListUpdateDone() {
                VcsFileStatusProvider.this.fileStatusesChanged();
            }
        });
    }

    private void fileStatusesChanged() {
        this.myFileStatusManager.fileStatusesChanged();
    }

    @Override
    @NotNull
    public FileStatus getFileStatus(@NotNull VirtualFile virtualFile) {
        AbstractVcs vcs = this.myVcsManager.getVcsFor(virtualFile);
        if (vcs == null) {
            if (ScratchUtil.isScratch(virtualFile)) {
                return FileStatus.SUPPRESSED;
            }
            return FileStatusManagerImpl.getDefaultStatus(virtualFile);
        }
        FileStatus status = this.myChangeListManager.getStatus(virtualFile);
        if (status == FileStatus.NOT_CHANGED && VcsFileStatusProvider.isDocumentModified(virtualFile)) {
            return FileStatus.MODIFIED;
        }
        if (status == FileStatus.NOT_CHANGED) {
            return FileStatusManagerImpl.getDefaultStatus(virtualFile);
        }
        return status;
    }

    private static boolean isDocumentModified(VirtualFile virtualFile) {
        if (virtualFile.isDirectory()) {
            return false;
        }
        return FileDocumentManager.getInstance().isFileModified(virtualFile);
    }

    @Override
    public void refreshFileStatusFromDocument(@NotNull VirtualFile virtualFile, @NotNull Document doc) {
        FileStatus cachedStatus;
        if (LOG.isDebugEnabled()) {
            LOG.debug("refreshFileStatusFromDocument: file.getModificationStamp()=" + virtualFile.getModificationStamp() + ", document.getModificationStamp()=" + doc.getModificationStamp());
        }
        if ((cachedStatus = this.myFileStatusManager.getCachedStatus(virtualFile)) == null || cachedStatus == FileStatus.NOT_CHANGED || !VcsFileStatusProvider.isDocumentModified(virtualFile)) {
            RollbackEnvironment rollbackEnvironment;
            AbstractVcs vcs = this.myVcsManager.getVcsFor(virtualFile);
            if (vcs == null) {
                return;
            }
            if (cachedStatus == FileStatus.MODIFIED && !VcsFileStatusProvider.isDocumentModified(virtualFile) && !((ReadonlyStatusHandlerImpl)ReadonlyStatusHandlerImpl.getInstance((Project)this.myProject)).getState().SHOW_DIALOG && (rollbackEnvironment = vcs.getRollbackEnvironment()) != null) {
                rollbackEnvironment.rollbackIfUnchanged(virtualFile);
            }
            this.myFileStatusManager.fileStatusChanged(virtualFile);
            ChangeProvider cp = vcs.getChangeProvider();
            if (cp != null && cp.isModifiedDocumentTrackingRequired()) {
                this.myDirtyScopeManager.fileDirty(virtualFile);
            }
        }
    }

    @Override
    @NotNull
    public ThreeState getNotChangedDirectoryParentingStatus(@NotNull VirtualFile virtualFile) {
        return this.myConfiguration.SHOW_DIRTY_RECURSIVELY ? this.myChangeListManager.haveChangesUnder(virtualFile) : ThreeState.NO;
    }

    @Override
    @Nullable
    public VcsBaseContentProvider.BaseContent getBaseRevision(@NotNull VirtualFile file2) {
        if (!this.isHandledByVcs(file2)) {
            VcsBaseContentProvider provider = this.findProviderFor(file2);
            return provider == null ? null : provider.getBaseRevision(file2);
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        Change change = changeListManager.getChange(file2);
        if (change != null) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            return beforeRevision == null ? null : new BaseContentImpl(beforeRevision);
        }
        FileStatus status = changeListManager.getStatus(file2);
        if (status == FileStatus.HIJACKED) {
            DiffProvider diffProvider;
            AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(file2);
            DiffProvider diffProvider2 = diffProvider = vcs != null ? vcs.getDiffProvider() : null;
            if (diffProvider != null) {
                VcsRevisionNumber currentRevision = diffProvider.getCurrentRevision(file2);
                return currentRevision == null ? null : new HijackedBaseContent(diffProvider, file2, currentRevision);
            }
        }
        return null;
    }

    @Nullable
    private VcsBaseContentProvider findProviderFor(@NotNull VirtualFile file2) {
        for (VcsBaseContentProvider support : this.myAdditionalProviders) {
            if (!support.isSupported(file2)) continue;
            return support;
        }
        return null;
    }

    @Override
    public boolean isSupported(@NotNull VirtualFile file2) {
        return this.isHandledByVcs(file2) || this.findProviderFor(file2) != null;
    }

    private boolean isHandledByVcs(@NotNull VirtualFile file2) {
        return file2.isInLocalFileSystem() && this.myVcsManager.getVcsFor(file2) != null;
    }

    @Nullable
    private static String loadContentRevision(@NotNull ContentRevision contentRevision) {
        try {
            if (contentRevision instanceof ByteBackedContentRevision) {
                byte[] revisionContent = ((ByteBackedContentRevision)contentRevision).getContentAsBytes();
                FilePath filePath = contentRevision.getFile();
                if (revisionContent != null) {
                    Charset charset = DiffContentFactoryImpl.guessCharset(revisionContent, filePath);
                    return CharsetToolkit.decodeString((byte[])revisionContent, (Charset)charset);
                }
                return null;
            }
            return contentRevision.getContent();
        }
        catch (VcsException ex) {
            return null;
        }
    }

    private static class HijackedBaseContent
    implements VcsBaseContentProvider.BaseContent {
        @NotNull
        private final DiffProvider myDiffProvider;
        @NotNull
        private final VirtualFile myFile;
        @NotNull
        private final VcsRevisionNumber myRevision;

        HijackedBaseContent(@NotNull DiffProvider diffProvider, @NotNull VirtualFile file2, @NotNull VcsRevisionNumber revision) {
            this.myDiffProvider = diffProvider;
            this.myFile = file2;
            this.myRevision = revision;
        }

        @Override
        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            return this.myRevision;
        }

        @Override
        @Nullable
        public String loadContent() {
            ContentRevision contentRevision = this.myDiffProvider.createFileContent(this.myRevision, this.myFile);
            if (contentRevision == null) {
                return null;
            }
            return VcsFileStatusProvider.loadContentRevision(contentRevision);
        }
    }

    private static class BaseContentImpl
    implements VcsBaseContentProvider.BaseContent {
        @NotNull
        private final ContentRevision myContentRevision;

        BaseContentImpl(@NotNull ContentRevision contentRevision) {
            this.myContentRevision = contentRevision;
        }

        @Override
        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            return this.myContentRevision.getRevisionNumber();
        }

        @Override
        @Nullable
        public String loadContent() {
            return VcsFileStatusProvider.loadContentRevision(this.myContentRevision);
        }
    }
}

