/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vcs.impl.VcsEP;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcsesI;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AllVcses
implements AllVcsesI,
Disposable {
    private final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.projectlevelman.AllVcses");
    private final Map<String, AbstractVcs> myVcses;
    private final Object myLock;
    private final Project myProject;
    private final Map<String, VcsEP> myExtensions;
    private final AtomicBoolean unbundledVcsNotificationShown = new AtomicBoolean();

    private AllVcses(Project project) {
        this.myProject = project;
        this.myVcses = new HashMap<String, AbstractVcs>();
        this.myLock = new Object();
        VcsEP[] vcsEPs = (VcsEP[])VcsEP.EP_NAME.getExtensions((AreaInstance)this.myProject);
        HashMap<String, VcsEP> map2 = new HashMap<String, VcsEP>();
        for (VcsEP vcsEP : vcsEPs) {
            map2.put(vcsEP.name, vcsEP);
        }
        this.myExtensions = Collections.unmodifiableMap(map2);
    }

    public static AllVcsesI getInstance(Project project) {
        return (AllVcsesI)ServiceManager.getService((Project)project, AllVcsesI.class);
    }

    private void addVcs(AbstractVcs vcs) {
        this.registerVcs(vcs);
        this.myVcses.put(vcs.getName(), vcs);
    }

    private void registerVcs(AbstractVcs vcs) {
        try {
            vcs.loadSettings();
            vcs.doStart();
        }
        catch (VcsException e) {
            this.LOG.debug((Throwable)e);
        }
        vcs.getProvidedStatuses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerManually(@NotNull AbstractVcs vcs) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myVcses.containsKey(vcs.getName())) {
                return;
            }
            this.addVcs(vcs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterManually(@NotNull AbstractVcs vcs) {
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myVcses.containsKey(vcs.getName())) {
                return;
            }
            this.unregisterVcs(vcs);
            this.myVcses.remove(vcs.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractVcs getByName(String name) {
        Object object = this.myLock;
        synchronized (object) {
            AbstractVcs vcs = this.myVcses.get(name);
            if (vcs != null) {
                return vcs;
            }
        }
        VcsEP ep = this.myExtensions.get(name);
        if (ep == null) {
            ObsoleteVcs obsoleteVcs = ObsoleteVcs.findByName(name);
            if (obsoleteVcs != null && this.unbundledVcsNotificationShown.compareAndSet(false, true)) {
                this.proposeToInstallPlugin(obsoleteVcs);
            }
            return null;
        }
        AbstractVcs vcs1 = ep.getVcs(this.myProject);
        this.LOG.assertTrue(vcs1 != null, (Object)name);
        Object object2 = this.myLock;
        synchronized (object2) {
            if (!this.myVcses.containsKey(name)) {
                this.addVcs(vcs1);
            }
            return vcs1;
        }
    }

    @Override
    @Nullable
    public VcsDescriptor getDescriptor(String name) {
        VcsEP ep = this.myExtensions.get(name);
        return ep == null ? null : ep.createDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            for (AbstractVcs vcs : this.myVcses.values()) {
                this.unregisterVcs(vcs);
            }
        }
    }

    private void unregisterVcs(AbstractVcs vcs) {
        try {
            vcs.doShutdown();
        }
        catch (VcsException e) {
            this.LOG.info((Throwable)e);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.myExtensions.isEmpty();
    }

    @Override
    public VcsDescriptor[] getAll() {
        ArrayList<VcsDescriptor> result2 = new ArrayList<VcsDescriptor>(this.myExtensions.size());
        for (VcsEP vcsEP : this.myExtensions.values()) {
            result2.add(vcsEP.createDescriptor());
        }
        Collections.sort(result2);
        return result2.toArray(new VcsDescriptor[0]);
    }

    private void proposeToInstallPlugin(@NotNull ObsoleteVcs vcs) {
        String message = "The " + (Object)((Object)vcs) + " plugin was unbundled and needs to be installed manually";
        Notification notification = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification("", message, NotificationType.WARNING, null);
        notification.addAction((AnAction)NotificationAction.createSimple((String)"Install", () -> {
            notification.expire();
            this.installPlugin(vcs);
        }));
        notification.addAction((AnAction)NotificationAction.createSimple((String)"Read more", () -> BrowserUtil.browse((String)"https://blog.jetbrains.com/idea/2019/02/unbundling-tfs-and-cvs-integration-plugins/")));
        VcsNotifier.getInstance(this.myProject).notify(notification);
    }

    private void installPlugin(final @NotNull ObsoleteVcs vcs) {
        new Task.Backgroundable(this.myProject, "Installing Plugin"){

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    List<IdeaPluginDescriptor> plugins2 = RepositoryHelper.loadPlugins(indicator);
                    IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)ContainerUtil.find(plugins2, d -> d.getPluginId().getIdString().equalsIgnoreCase(vcs.pluginId));
                    if (descriptor != null) {
                        PluginDownloader downloader = PluginDownloader.createDownloader(descriptor);
                        if (downloader.prepareToInstall(indicator)) {
                            downloader.install();
                            PluginManagerCore.enablePlugin(vcs.pluginId);
                            PluginManagerMain.notifyPluginsUpdated(this.myProject);
                        }
                    } else {
                        this.showErrorNotification(vcs, "Couldn't find the plugin " + vcs.pluginId);
                    }
                }
                catch (IOException e) {
                    AllVcses.this.LOG.warn((Throwable)e);
                    this.showErrorNotification(vcs, e.getMessage());
                }
            }

            private void showErrorNotification(@NotNull ObsoleteVcs vcs2, @NotNull String message) {
                String title = "Failed to Install Plugin";
                Notification notification = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification(title, message, NotificationType.ERROR, null);
                notification.addAction((AnAction)NotificationAction.createSimple((String)"Open Plugin Page", () -> BrowserUtil.browse((String)vcs2.pluginUrl)));
                VcsNotifier.getInstance(this.myProject).notify(notification);
            }
        }.queue();
    }

    private static enum ObsoleteVcs {
        CVS("CVS", "CVS", "https://plugins.jetbrains.com/plugin/10746-cvs-integration"),
        TFS("TFS", "TFS", "https://plugins.jetbrains.com/plugin/4578-tfs");

        @NotNull
        private final String vcsName;
        @NotNull
        private final String pluginId;
        @NotNull
        private final String pluginUrl;

        private ObsoleteVcs(@NotNull String vcsName, String pluginId, String pluginUrl) {
            this.vcsName = vcsName;
            this.pluginId = pluginId;
            this.pluginUrl = pluginUrl;
        }

        @Nullable
        public static ObsoleteVcs findByName(@NotNull String name) {
            return (ObsoleteVcs)((Object)ContainerUtil.find((Object[])ObsoleteVcs.values(), vcs -> vcs.vcsName.equals(name)));
        }
    }
}

