/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MappingsToRoots {
    private final NewMappings myMappings;
    private final Project myProject;

    public MappingsToRoots(NewMappings mappings, Project project) {
        this.myMappings = mappings;
        this.myProject = project;
    }

    @NotNull
    public VirtualFile[] getRootsUnderVcs(@NotNull AbstractVcs vcs) {
        List result2 = this.myMappings.getMappingsAsFilesUnderVcs(vcs);
        AbstractVcs.RootsConvertor convertor = vcs.getCustomConvertor();
        if (convertor != null) {
            result2 = convertor.convertRoots(result2);
        }
        Collections.sort(result2, FilePathComparator.getInstance());
        if (!vcs.allowsNestedRoots()) {
            FileIndexFacade facade = (FileIndexFacade)ServiceManager.getService((Project)this.myProject, FileIndexFacade.class);
            List finalResult = result2;
            ApplicationManager.getApplication().runReadAction(() -> {
                int i = 1;
                while (i < finalResult.size()) {
                    VirtualFile current;
                    VirtualFile previous = (VirtualFile)finalResult.get(i - 1);
                    if (facade.isValidAncestor(previous, current = (VirtualFile)finalResult.get(i))) {
                        finalResult.remove(i);
                        continue;
                    }
                    ++i;
                }
            });
        }
        result2.removeIf(file2 -> !file2.isDirectory());
        return VfsUtilCore.toVirtualFileArray((Collection)result2);
    }

    public List<VirtualFile> getDetailedVcsMappings(AbstractVcs vcs) {
        List<VirtualFile> result2 = this.myMappings.getMappingsAsFilesUnderVcs(vcs);
        boolean addInnerModules = true;
        String vcsName = vcs.getName();
        List<VcsDirectoryMapping> directoryMappings = this.myMappings.getDirectoryMappings(vcsName);
        for (VcsDirectoryMapping directoryMapping : directoryMappings) {
            if (!directoryMapping.isDefaultMapping()) continue;
            addInnerModules = false;
            break;
        }
        Collections.sort(result2, FilePathComparator.getInstance());
        if (addInnerModules) {
            FileIndexFacade facade = (FileIndexFacade)ServiceManager.getService((Project)this.myProject, FileIndexFacade.class);
            Collection<VirtualFile> modules = DefaultVcsRootPolicy.getInstance(this.myProject).getDefaultVcsRoots(this.myMappings, vcsName);
            ApplicationManager.getApplication().runReadAction(() -> {
                Iterator iterator = modules.iterator();
                while (iterator.hasNext()) {
                    VirtualFile module = (VirtualFile)iterator.next();
                    boolean included = false;
                    for (VirtualFile root : result2) {
                        if (!facade.isValidAncestor(root, module)) continue;
                        included = true;
                        break;
                    }
                    if (included) continue;
                    iterator.remove();
                }
            });
            result2.addAll(modules);
        }
        result2.removeIf(file2 -> !file2.isDirectory());
        return result2;
    }
}

