/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.merge;

import com.intellij.CommonBundle;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.mergeTool.MergeVersion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.NoneChangesGroupingFactory;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.merge.MergeProvider2;
import com.intellij.openapi.vcs.merge.MergeSession;
import com.intellij.openapi.vcs.merge.MergeSessionEx;
import com.intellij.openapi.vcs.merge.MultipleFileMergeDialog;
import com.intellij.openapi.vcs.merge.MultipleFileMergeDialog$WhenMappings;
import com.intellij.openapi.vcs.merge.MultipleFileMergeDialog$sam$com_intellij_util_Consumer$0;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.BooleanPropertyUiManager;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmSuppressWildcards;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a1\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e*\u0001&\b\u0016\u0018\u0000 L2\u00020\u0001:\u0003KLMB-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u0016\u0010,\u001a\u00020\u00102\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060-H\u0015J\u0010\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u00020\u0006H\u0002J\u0013\u00100\u001a\b\u0012\u0004\u0012\u00020201H\u0014\u00a2\u0006\u0002\u00103J\b\u00104\u001a\u000205H\u0014J\u001b\u00106\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030701H\u0002\u00a2\u0006\u0002\u00108J\b\u00109\u001a\u00020)H\u0014J\b\u0010:\u001a\u00020;H\u0015J\n\u0010<\u001a\u0004\u0018\u000105H\u0016J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0010\u0010>\u001a\u00020+2\u0006\u0010?\u001a\u00020@H\u0002J\u0018\u0010A\u001a\u00020)2\u0006\u0010/\u001a\u00020\u00062\u0006\u0010*\u001a\u00020+H\u0002J\u001e\u0010B\u001a\u00020)2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010*\u001a\u00020+H\u0002J\u0018\u0010C\u001a\u00020)2\u0006\u0010/\u001a\u00020\u00062\u0006\u0010*\u001a\u00020+H\u0002J\b\u0010D\u001a\u00020)H\u0002J\b\u0010E\u001a\u00020)H\u0002J\u0010\u0010F\u001a\u00020)2\u0006\u0010G\u001a\u00020\u0010H\u0002J\b\u0010H\u001a\u00020)H\u0002J\b\u0010I\u001a\u00020)H\u0002J\b\u0010J\u001a\u00020)H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R&\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108B@BX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010'\u00a8\u0006N"}, d2={"Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "mergeProvider", "Lcom/intellij/openapi/vcs/merge/MergeProvider;", "mergeDialogCustomizer", "Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/openapi/vcs/merge/MergeProvider;Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer;)V", "acceptTheirsButton", "Ljavax/swing/JButton;", "acceptYoursButton", "value", "", "groupByDirectory", "getGroupByDirectory", "()Z", "setGroupByDirectory", "(Z)V", "mergeButton", "mergeSession", "Lcom/intellij/openapi/vcs/merge/MergeSession;", "processedFiles", "", "getProcessedFiles", "()Ljava/util/List;", "projectManager", "Lcom/intellij/openapi/project/ex/ProjectManagerEx;", "kotlin.jvm.PlatformType", "table", "Lcom/intellij/ui/treeStructure/treetable/TreeTable;", "tableModel", "Lcom/intellij/ui/treeStructure/treetable/ListTreeTableModelOnColumns;", "unresolvedFiles", "virtualFileRenderer", "com/intellij/openapi/vcs/merge/MultipleFileMergeDialog$virtualFileRenderer$1", "Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$virtualFileRenderer$1;", "acceptRevision", "", "resolution", "Lcom/intellij/openapi/vcs/merge/MergeSession$Resolution;", "beforeResolve", "", "checkMarkModifiedProject", "file", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "Ljavax/swing/JComponent;", "createColumns", "Lcom/intellij/util/ui/ColumnInfo;", "()[Lcom/intellij/util/ui/ColumnInfo;", "dispose", "getDimensionServiceKey", "", "getPreferredFocusedComponent", "getSelectedFiles", "getSessionResolution", "result", "Lcom/intellij/diff/merge/MergeResult;", "markFileProcessed", "markFilesProcessed", "resolveFileViaContent", "selectFirstFile", "showMergeDialog", "toggleGroupByDirectory", "state", "updateButtonState", "updateModelFromFiles", "updateTree", "ColumnInfoAdapter", "Companion", "MyTable", "intellij.platform.vcs.impl"})
public class MultipleFileMergeDialog
extends DialogWrapper {
    private List<VirtualFile> unresolvedFiles;
    private final MergeSession mergeSession;
    @NotNull
    private final List<VirtualFile> processedFiles;
    private TreeTable table;
    private JButton acceptYoursButton;
    private JButton acceptTheirsButton;
    private JButton mergeButton;
    private final ListTreeTableModelOnColumns tableModel;
    private final ProjectManagerEx projectManager;
    private boolean groupByDirectory;
    private final virtualFileRenderer.1 virtualFileRenderer;
    private final Project project;
    private final MergeProvider mergeProvider;
    private final MergeDialogCustomizer mergeDialogCustomizer;
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public final List<VirtualFile> getProcessedFiles() {
        return this.processedFiles;
    }

    private final boolean getGroupByDirectory() {
        return this.project != null ? VcsConfiguration.getInstance((Project)this.project).GROUP_MULTIFILE_MERGE_BY_DIRECTORY : this.groupByDirectory;
    }

    private final void setGroupByDirectory(boolean value) {
        if (this.project != null) {
            VcsConfiguration.getInstance((Project)this.project).GROUP_MULTIFILE_MERGE_BY_DIRECTORY = value;
        } else {
            this.groupByDirectory = value;
        }
    }

    private final void selectFirstFile() {
        if (!this.getGroupByDirectory()) {
            TreeTable treeTable = this.table;
            if (treeTable == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            }
            treeTable.getSelectionModel().setSelectionInterval(0, 0);
        } else {
            TreeTable treeTable = this.table;
            if (treeTable == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            }
            TreeTableTree treeTableTree = treeTable.getTree();
            TreeTable treeTable2 = this.table;
            if (treeTable2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            }
            treeTableTree.setSelectionPath(TreeUtil.getFirstLeafNodePath((JTree)((JTree)treeTable2.getTree())));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected JComponent createCenterPanel() {
        Row this_$iv;
        Row $receiver;
        Row row$iv;
        boolean $i$f$row;
        boolean separated$iv;
        JLabel label$iv;
        LayoutBuilder this_$iv2;
        LayoutBuilder builder$iv;
        LCFlags[] constraints$iv = new LCFlags[]{LCFlags.disableMagic};
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder $receiver2 = builder$iv = LayoutImplKt.createLayoutBuilder(!ArraysKt.contains((Object[])constraints$iv, (Object)((Object)LCFlags.disableMagic)));
        boolean bl = false;
        String description = this.mergeDialogCustomizer.getMultipleFileMergeDescription((Collection)this.unresolvedFiles);
        if (!StringsKt.isBlank((CharSequence)description)) {
            this_$iv2 = $receiver2;
            label$iv = null;
            separated$iv = false;
            $i$f$row = false;
            $receiver = row$iv = this_$iv2.getBuilder().newRow(label$iv, this_$iv2.getButtonGroup(), separated$iv);
            boolean bl2 = false;
            Row.label$default($receiver, description, 0, null, null, false, 30, null);
        }
        this_$iv2 = $receiver2;
        label$iv = null;
        separated$iv = false;
        $i$f$row = false;
        $receiver = row$iv = this_$iv2.getBuilder().newRow(label$iv, this_$iv2.getButtonGroup(), separated$iv);
        boolean bl3 = false;
        Object object = new MyTable(this.tableModel);
        Object object2 = $receiver;
        MyTable it = object;
        boolean bl4 = false;
        this.table = it;
        it.getTree().setRootVisible(false);
        it.setTreeCellRenderer((TreeCellRenderer)((Object)this.virtualFileRenderer));
        if (this.tableModel.getColumnCount() > 1) {
            it.setShowColumns(true);
        }
        it.setRowHeight(this.virtualFileRenderer.getPreferredSize().height);
        MyTable myTable = object;
        ((Cell)object2).scrollPane((Component)((Object)myTable), $receiver.getGrowX(), $receiver.getGrowY(), $receiver.getPushX(), $receiver.getPushY());
        object = $receiver;
        boolean isVerticalFlow$iv = true;
        boolean $i$f$cell = false;
        this_$iv.setCellMode(true, isVerticalFlow$iv);
        Cell $receiver3 = this_$iv;
        boolean bl5 = false;
        JButton jButton = new JButton("Accept Yours");
        Cell cell = $receiver3;
        JButton it2 = jButton;
        boolean bl6 = false;
        it2.addActionListener(new ActionListener(this){
            final /* synthetic */ MultipleFileMergeDialog this$0;
            {
                this.this$0 = multipleFileMergeDialog;
            }

            public final void actionPerformed(ActionEvent it) {
                MultipleFileMergeDialog.access$acceptRevision(this.this$0, MergeSession.Resolution.AcceptedYours);
            }
        });
        this.acceptYoursButton = it2;
        JButton jButton2 = jButton;
        Cell.invoke$default(cell, jButton2, new CCFlags[]{$receiver3.getGrowX()}, 0, null, null, 14, null);
        jButton = new JButton("Accept Theirs");
        cell = $receiver3;
        it2 = jButton;
        boolean bl7 = false;
        it2.addActionListener(new ActionListener(this){
            final /* synthetic */ MultipleFileMergeDialog this$0;
            {
                this.this$0 = multipleFileMergeDialog;
            }

            public final void actionPerformed(ActionEvent it) {
                MultipleFileMergeDialog.access$acceptRevision(this.this$0, MergeSession.Resolution.AcceptedTheirs);
            }
        });
        this.acceptTheirsButton = it2;
        jButton2 = jButton;
        Cell.invoke$default(cell, jButton2, new CCFlags[]{$receiver3.getGrowX()}, 0, null, null, 14, null);
        AbstractAction mergeAction = new AbstractAction(this){
            final /* synthetic */ MultipleFileMergeDialog this$0;
            {
                this.this$0 = multipleFileMergeDialog;
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                MultipleFileMergeDialog.access$showMergeDialog(this.this$0);
            }
        };
        mergeAction.putValue("DefaultAction", Boolean.TRUE);
        JButton jButton3 = this.createJButtonForAction(mergeAction);
        cell = $receiver3;
        JButton it3 = jButton3;
        boolean bl8 = false;
        it3.setText("Merge...");
        this.mergeButton = it3;
        jButton2 = jButton3;
        Cell.invoke$default(cell, jButton2, new CCFlags[]{$receiver3.getGrowX()}, 0, null, null, 14, null);
        this_$iv.setCellMode(false, isVerticalFlow$iv);
        if (this.project != null) {
            void isSelected$iv;
            void text$iv;
            this_$iv2 = $receiver2;
            label$iv = null;
            separated$iv = false;
            $i$f$row = false;
            $receiver = row$iv = this_$iv2.getBuilder().newRow(label$iv, this_$iv2.getButtonGroup(), separated$iv);
            boolean bl9 = false;
            this_$iv = $receiver;
            object2 = "Group files by directory";
            isVerticalFlow$iv = this.getGroupByDirectory();
            CCFlags[] constraints$iv2 = new CCFlags[]{};
            String comment$iv = null;
            BooleanPropertyUiManager propertyUiManager$iv = null;
            boolean $i$f$checkBox = false;
            JCheckBox component$iv = this_$iv.checkBox((String)text$iv, (boolean)isSelected$iv, comment$iv, propertyUiManager$iv, Arrays.copyOf(constraints$iv2, constraints$iv2.length));
            component$iv.addActionListener(new ActionListener(component$iv, this){
                final /* synthetic */ JCheckBox $component;
                final /* synthetic */ MultipleFileMergeDialog this$0;
                {
                    this.$component = jCheckBox;
                    this.this$0 = multipleFileMergeDialog;
                }

                public final void actionPerformed(ActionEvent it) {
                    JCheckBox component = this.$component;
                    ActionEvent $noName_0 = it;
                    boolean bl = false;
                    MultipleFileMergeDialog.access$toggleGroupByDirectory(this.this$0, component.isSelected());
                }
            });
        }
        JPanel panel$iv = ComponentsKt.Panel(title$iv, null);
        builder$iv.getBuilder().build(panel$iv, constraints$iv);
        return panel$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final ColumnInfo<?, ?>[] createColumns() {
        Collection $receiver$iv;
        ColumnInfo[] mergeInfoColumns;
        ArrayList<createColumns.1> columns = new ArrayList<createColumns.1>();
        columns.add(new ColumnInfo<DefaultMutableTreeNode, Object>(VcsBundle.message((String)"multiple.file.merge.column.name", (Object[])new Object[0])){

            public Object valueOf(@NotNull DefaultMutableTreeNode node) {
                return node.getUserObject();
            }

            @NotNull
            public Class<?> getColumnClass() {
                return TreeTableModel.class;
            }
        });
        MergeSession mergeSession = this.mergeSession;
        Object object = mergeInfoColumns = mergeSession != null ? mergeSession.getMergeInfoColumns() : null;
        if (mergeInfoColumns != null) {
            List customColumnNames = this.mergeDialogCustomizer.getColumnNames();
            if (customColumnNames != null && customColumnNames.size() != mergeInfoColumns.length) {
                LOG.error("Custom column names (" + customColumnNames + ") don't match default columns (" + mergeInfoColumns + ')');
                customColumnNames = null;
            }
            ColumnInfo[] $receiver$iv2 = mergeInfoColumns;
            int index$iv = 0;
            for (ColumnInfo item$iv : $receiver$iv2) {
                void columnInfo;
                void index;
                int n = index$iv++;
                ColumnInfo columnInfo2 = item$iv;
                int n2 = n;
                Collection collection = columns;
                boolean bl = false;
                Object object2 = customColumnNames;
                if (object2 == null || (object2 = (String)object2.get((int)index)) == null) {
                    object2 = columnInfo.getName();
                }
                ColumnInfoAdapter columnInfoAdapter = new ColumnInfoAdapter((ColumnInfo<Object, Object>)columnInfo, (String)object2);
                collection.add(columnInfoAdapter);
            }
        }
        Collection thisCollection$iv = $receiver$iv = (Collection)columns;
        ColumnInfo[] columnInfoArray = thisCollection$iv.toArray(new ColumnInfo[0]);
        if (columnInfoArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return columnInfoArray;
    }

    private final void toggleGroupByDirectory(boolean state) {
        block3: {
            DefaultMutableTreeNode node;
            this.setGroupByDirectory(state);
            VirtualFile firstSelectedFile = (VirtualFile)CollectionsKt.firstOrNull(this.getSelectedFiles());
            this.updateTree();
            if (firstSelectedFile == null) break block3;
            Object object = this.tableModel.getRoot();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            }
            DefaultMutableTreeNode defaultMutableTreeNode = node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)((DefaultMutableTreeNode)object), (Object)firstSelectedFile);
            if (defaultMutableTreeNode != null) {
                DefaultMutableTreeNode defaultMutableTreeNode2;
                DefaultMutableTreeNode it = defaultMutableTreeNode2 = defaultMutableTreeNode;
                boolean bl = false;
                TreeTable treeTable = this.table;
                if (treeTable == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"table");
                }
                TreeUtil.selectNode((JTree)((JTree)treeTable.getTree()), (TreeNode)node);
            }
        }
    }

    private final void updateTree() {
        ChangesGroupingPolicyFactory factory = this.project != null && this.getGroupByDirectory() ? ChangesGroupingSupport.Companion.getFactory(this.project, "directory") : (ChangesGroupingPolicyFactory)NoneChangesGroupingFactory.INSTANCE;
        DefaultTreeModel model = TreeModelBuilder.buildFromVirtualFiles(this.project, factory, (Collection<? extends VirtualFile>)this.unresolvedFiles);
        Object object = model.getRoot();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.swing.tree.TreeNode");
        }
        this.tableModel.setRoot((TreeNode)object);
        TreeTable treeTable = this.table;
        if (treeTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
        }
        TreeUtil.expandAll((JTree)((JTree)treeTable.getTree()));
    }

    private final void updateButtonState() {
        boolean bl;
        boolean haveUnmergeableFiles;
        boolean haveSelection;
        block10: {
            boolean bl2;
            List<VirtualFile> selectedFiles;
            block9: {
                selectedFiles = this.getSelectedFiles();
                haveSelection = CollectionsKt.any((Iterable)selectedFiles);
                Iterable $receiver$iv = selectedFiles;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        VirtualFile it = (VirtualFile)element$iv;
                        boolean bl3 = false;
                        MergeSession mergeSession = this.mergeSession;
                        if (!(mergeSession != null && !mergeSession.canMerge(it))) continue;
                        bl2 = true;
                        break block9;
                    }
                    bl2 = false;
                }
            }
            haveUnmergeableFiles = bl2;
            Iterable $receiver$iv = selectedFiles;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl4 = false;
                    if (!(this.mergeSession != null && !(this.mergeSession instanceof MergeSessionEx) && !this.mergeSession.canMerge(it))) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        boolean haveUnacceptableFiles = bl;
        JButton jButton = this.acceptYoursButton;
        if (jButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"acceptYoursButton");
        }
        jButton.setEnabled(haveSelection && !haveUnacceptableFiles);
        JButton jButton2 = this.acceptTheirsButton;
        if (jButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"acceptTheirsButton");
        }
        jButton2.setEnabled(haveSelection && !haveUnacceptableFiles);
        JButton jButton3 = this.mergeButton;
        if (jButton3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mergeButton");
        }
        jButton3.setEnabled(haveSelection && !haveUnmergeableFiles);
    }

    private final List<VirtualFile> getSelectedFiles() {
        TreeTable treeTable = this.table;
        if (treeTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
        }
        return TreeUtil.collectSelectedObjectsOfType((JTree)((JTree)treeTable.getTree()), VirtualFile.class);
    }

    @NotNull
    protected Action[] createActions() {
        this.getCancelAction().putValue("Name", CommonBundle.getCloseButtonText());
        return new Action[]{this.getCancelAction()};
    }

    protected void dispose() {
        this.projectManager.unblockReloadingProjectOnExternalChanges();
        super.dispose();
    }

    @NonNls
    @NotNull
    protected String getDimensionServiceKey() {
        return "MultipleFileMergeDialog";
    }

    @JvmSuppressWildcards
    protected boolean beforeResolve(@NotNull Collection<VirtualFile> files2) {
        return true;
    }

    private final void acceptRevision(MergeSession.Resolution resolution) {
        boolean bl;
        boolean bl2 = bl = resolution == MergeSession.Resolution.AcceptedYours || resolution == MergeSession.Resolution.AcceptedTheirs;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        List<VirtualFile> files2 = this.getSelectedFiles();
        if (!this.beforeResolve((Collection<VirtualFile>)files2)) {
            return;
        }
        try {
            if (this.mergeSession instanceof MergeSessionEx) {
                ((MergeSessionEx)this.mergeSession).acceptFilesRevisions(files2, resolution);
                for (VirtualFile file2 : files2) {
                    this.checkMarkModifiedProject(file2);
                }
                this.markFilesProcessed(files2, resolution);
            } else {
                for (VirtualFile file3 : files2) {
                    this.resolveFileViaContent(file3, resolution);
                    this.checkMarkModifiedProject(file3);
                    this.markFileProcessed(file3, resolution);
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            Messages.showErrorDialog((Component)this.getContentPanel(), (String)("Error saving merged data: " + e.getMessage()));
        }
        this.updateModelFromFiles();
    }

    private final void resolveFileViaContent(VirtualFile file2, MergeSession.Resolution resolution) {
        if (!DiffUtil.makeWritable(this.project, file2)) {
            throw (Throwable)new IOException("File is read-only: " + file2.getPresentableName());
        }
        boolean isCurrent = resolution == MergeSession.Resolution.AcceptedYours;
        MergeData data = this.mergeProvider.loadRevisions(file2);
        WriteCommandAction.writeCommandAction((Project)this.project).withName("Accept " + (isCurrent ? "Yours" : "Theirs")).run((ThrowableRunnable)new ThrowableRunnable<Exception>(isCurrent, file2, data){
            final /* synthetic */ boolean $isCurrent;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ MergeData $data;

            public final void run() {
                if (this.$isCurrent) {
                    this.$file.setBinaryContent(this.$data.CURRENT);
                } else {
                    this.$file.setBinaryContent(this.$data.LAST);
                }
            }
            {
                this.$isCurrent = bl;
                this.$file = virtualFile;
                this.$data = mergeData;
            }
        });
    }

    private final void markFilesProcessed(List<? extends VirtualFile> files2, MergeSession.Resolution resolution) {
        this.unresolvedFiles.removeAll((Collection)files2);
        if (this.mergeSession instanceof MergeSessionEx) {
            ((MergeSessionEx)this.mergeSession).conflictResolvedForFiles(files2, resolution);
        } else if (this.mergeSession != null) {
            Iterable $receiver$iv = files2;
            for (Object element$iv : $receiver$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                this.mergeSession.conflictResolvedForFile(it, resolution);
            }
        } else {
            Iterable $receiver$iv = files2;
            for (Object element$iv : $receiver$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                this.mergeProvider.conflictResolvedForFile(it);
            }
        }
        this.processedFiles.addAll((Collection<VirtualFile>)files2);
        if (this.project != null) {
            VcsDirtyScopeManager.getInstance((Project)this.project).filesDirty((Collection)files2, (Collection)CollectionsKt.emptyList());
        }
    }

    private final void markFileProcessed(VirtualFile file2, MergeSession.Resolution resolution) {
        this.markFilesProcessed(CollectionsKt.listOf((Object)file2), resolution);
    }

    private final void updateModelFromFiles() {
        if (this.unresolvedFiles.isEmpty()) {
            this.doCancelAction();
        } else {
            TreeTable treeTable = this.table;
            if (treeTable == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            }
            int selIndex = treeTable.getSelectionModel().getMinSelectionIndex();
            this.updateTree();
            TreeTable treeTable2 = this.table;
            if (treeTable2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            }
            if (selIndex >= treeTable2.getRowCount()) {
                TreeTable treeTable3 = this.table;
                if (treeTable3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"table");
                }
                selIndex = treeTable3.getRowCount() - 1;
            }
            TreeTable treeTable4 = this.table;
            if (treeTable4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"table");
            }
            treeTable4.getSelectionModel().setSelectionInterval(selIndex, selIndex);
        }
    }

    private final void showMergeDialog() {
        DiffRequestFactory requestFactory = DiffRequestFactory.getInstance();
        List<VirtualFile> files2 = this.getSelectedFiles();
        if (files2.isEmpty()) {
            return;
        }
        if (!this.beforeResolve((Collection<VirtualFile>)files2)) {
            return;
        }
        for (VirtualFile file2 : files2) {
            MergeData mergeData = null;
            try {
                mergeData = this.mergeProvider.loadRevisions(file2);
            }
            catch (VcsException ex) {
                Messages.showErrorDialog((Component)this.getContentPanel(), (String)("Error loading revisions to merge: " + ex.getMessage()));
                break;
            }
            if (mergeData.CURRENT == null || mergeData.LAST == null || mergeData.ORIGINAL == null) {
                Messages.showErrorDialog((Component)this.getContentPanel(), (String)"Error loading revisions to merge");
                break;
            }
            String leftTitle = this.mergeDialogCustomizer.getLeftPanelTitle(file2);
            String baseTitle = this.mergeDialogCustomizer.getCenterPanelTitle(file2);
            String rightTitle = this.mergeDialogCustomizer.getRightPanelTitle(file2, mergeData.LAST_REVISION_NUMBER);
            String title = this.mergeDialogCustomizer.getMergeWindowTitle(file2);
            List byteContents = CollectionsKt.listOf((Object[])new byte[][]{mergeData.CURRENT, mergeData.ORIGINAL, mergeData.LAST});
            List contentTitles = CollectionsKt.listOf((Object[])new String[]{leftTitle, baseTitle, rightTitle});
            Function1 callback2 = (Function1)new Function1<MergeResult, Unit>(this, file2){
                final /* synthetic */ MultipleFileMergeDialog this$0;
                final /* synthetic */ VirtualFile $file;

                public final void invoke(@NotNull MergeResult result2) {
                    Document document = FileDocumentManager.getInstance().getCachedDocument(this.$file);
                    if (document != null) {
                        FileDocumentManager.getInstance().saveDocument(document);
                    }
                    MultipleFileMergeDialog.access$checkMarkModifiedProject(this.this$0, this.$file);
                    if (result2 != MergeResult.CANCEL) {
                        MultipleFileMergeDialog.access$markFileProcessed(this.this$0, this.$file, MultipleFileMergeDialog.access$getSessionResolution(this.this$0, result2));
                    }
                }
                {
                    this.this$0 = multipleFileMergeDialog;
                    this.$file = virtualFile;
                    super(1);
                }
            };
            MergeRequest request = null;
            try {
                Function1 function1;
                if (this.mergeProvider.isBinary(file2)) {
                    function1 = callback2;
                    request = requestFactory.createBinaryMergeRequest(this.project, file2, byteContents, title, contentTitles, (Consumer)new MultipleFileMergeDialog$sam$com_intellij_util_Consumer$0(function1));
                } else {
                    function1 = callback2;
                    request = requestFactory.createMergeRequest(this.project, file2, byteContents, title, contentTitles, (Consumer)new MultipleFileMergeDialog$sam$com_intellij_util_Consumer$0(function1));
                }
                MergeUtil.putRevisionInfos(request, mergeData);
            }
            catch (InvalidDiffRequestException e) {
                if (e.getCause() instanceof FileTooBigException) {
                    Messages.showErrorDialog((Component)this.getContentPanel(), (String)"File is too big to be loaded.", (String)"Can't Show Merge Dialog");
                    break;
                }
                LOG.error((Throwable)e);
                Messages.showErrorDialog((Component)this.getContentPanel(), (String)e.getMessage(), (String)"Can't Show Merge Dialog");
                break;
            }
            DiffManager.getInstance().showMerge(this.project, request);
        }
        this.updateModelFromFiles();
        IdeFocusManager ideFocusManager = IdeFocusManager.getInstance((Project)this.project);
        TreeTable treeTable = this.table;
        if (treeTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
        }
        ideFocusManager.requestFocus((Component)treeTable, false);
    }

    private final MergeSession.Resolution getSessionResolution(MergeResult result2) {
        MergeSession.Resolution resolution;
        switch (MultipleFileMergeDialog$WhenMappings.$EnumSwitchMapping$0[result2.ordinal()]) {
            case 1: {
                resolution = MergeSession.Resolution.AcceptedYours;
                break;
            }
            case 2: {
                resolution = MergeSession.Resolution.AcceptedTheirs;
                break;
            }
            case 3: {
                resolution = MergeSession.Resolution.Merged;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException(result2.name());
            }
        }
        return resolution;
    }

    private final void checkMarkModifiedProject(VirtualFile file2) {
        MergeVersion.MergeDocumentVersion.reportProjectFileChangeIfNeeded(this.project, file2);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        TreeTable treeTable = this.table;
        if (treeTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
        }
        return (JComponent)treeTable;
    }

    public MultipleFileMergeDialog(@Nullable Project project, @NotNull List<? extends VirtualFile> files2, @NotNull MergeProvider mergeProvider, @NotNull MergeDialogCustomizer mergeDialogCustomizer) {
        super(project);
        List list2;
        this.project = project;
        this.mergeProvider = mergeProvider;
        this.mergeDialogCustomizer = mergeDialogCustomizer;
        this.unresolvedFiles = CollectionsKt.toMutableList((Collection)files2);
        MergeProvider mergeProvider2 = this.mergeProvider;
        if (!(mergeProvider2 instanceof MergeProvider2)) {
            mergeProvider2 = null;
        }
        MergeProvider2 mergeProvider22 = (MergeProvider2)mergeProvider2;
        this.mergeSession = mergeProvider22 != null ? mergeProvider22.createMergeSession(files2) : null;
        MultipleFileMergeDialog multipleFileMergeDialog = this;
        multipleFileMergeDialog.processedFiles = list2 = (List)new ArrayList();
        this.tableModel = new ListTreeTableModelOnColumns((TreeNode)new DefaultMutableTreeNode(), this.createColumns());
        this.projectManager = ProjectManagerEx.getInstanceEx();
        this.virtualFileRenderer = new ChangesBrowserNodeRenderer(this, this.project, new BooleanGetter(this){
            final /* synthetic */ MultipleFileMergeDialog this$0;

            public final boolean get() {
                return !MultipleFileMergeDialog.access$getGroupByDirectory$p(this.this$0);
            }
            {
                this.this$0 = multipleFileMergeDialog;
            }
        }, false){
            final /* synthetic */ MultipleFileMergeDialog this$0;

            protected boolean calcFocusedState() {
                return UIUtil.isAncestor((Component)this.this$0.getPeer().getWindow(), (Component)IdeFocusManager.getInstance((Project)MultipleFileMergeDialog.access$getProject$p(this.this$0)).getFocusOwner());
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        };
        this.projectManager.blockReloadingProjectOnExternalChanges();
        this.setTitle(this.mergeDialogCustomizer.getMultipleFileDialogTitle());
        this.virtualFileRenderer.setFont(UIUtil.getListFont());
        this.init();
        this.updateTree();
        TreeTable treeTable = this.table;
        if (treeTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
        }
        treeTable.getTree().getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public final void valueChanged(TreeSelectionEvent it) {
                this.updateButtonState();
            }
        });
        this.selectFirstFile();
        DoubleClickListener doubleClickListener = new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                this.showMergeDialog();
                return true;
            }
        };
        TreeTable treeTable2 = this.table;
        if (treeTable2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
        }
        doubleClickListener.installOn((Component)treeTable2);
        TreeTable treeTable3 = this.table;
        if (treeTable3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
        }
        new TableSpeedSearch((JTable)treeTable3, (Convertor<Object, String>)((Convertor)3.INSTANCE));
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(MultipleFileMergeDialog.class);
    }

    public static final /* synthetic */ void access$acceptRevision(MultipleFileMergeDialog $this, MergeSession.Resolution resolution) {
        $this.acceptRevision(resolution);
    }

    public static final /* synthetic */ void access$toggleGroupByDirectory(MultipleFileMergeDialog $this, boolean state) {
        $this.toggleGroupByDirectory(state);
    }

    public static final /* synthetic */ void access$checkMarkModifiedProject(MultipleFileMergeDialog $this, VirtualFile file2) {
        $this.checkMarkModifiedProject(file2);
    }

    public static final /* synthetic */ void access$markFileProcessed(MultipleFileMergeDialog $this, VirtualFile file2, MergeSession.Resolution resolution) {
        $this.markFileProcessed(file2, resolution);
    }

    public static final /* synthetic */ MergeSession.Resolution access$getSessionResolution(MultipleFileMergeDialog $this, MergeResult result2) {
        return $this.getSessionResolution(result2);
    }

    public static final /* synthetic */ Project access$getProject$p(MultipleFileMergeDialog $this) {
        return $this.project;
    }

    public static final /* synthetic */ boolean access$getGroupByDirectory$p(MultipleFileMergeDialog $this) {
        return $this.getGroupByDirectory();
    }

    public static final /* synthetic */ void access$setGroupByDirectory$p(MultipleFileMergeDialog $this, boolean bl) {
        $this.setGroupByDirectory(bl);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B!\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u000b\u001a\u00020\u0006H\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$ColumnInfoAdapter;", "Lcom/intellij/util/ui/ColumnInfo;", "Ljavax/swing/tree/DefaultMutableTreeNode;", "", "base", "columnName", "", "(Lcom/intellij/util/ui/ColumnInfo;Ljava/lang/String;)V", "getAdditionalWidth", "", "getMaxStringValue", "getTooltipText", "valueOf", "node", "intellij.platform.vcs.impl"})
    private static final class ColumnInfoAdapter
    extends ColumnInfo<DefaultMutableTreeNode, Object> {
        private final ColumnInfo<Object, Object> base;
        private final String columnName;

        @Nullable
        public Object valueOf(@NotNull DefaultMutableTreeNode node) {
            Object object;
            Object object2 = node.getUserObject();
            if (!(object2 instanceof VirtualFile)) {
                object2 = null;
            }
            VirtualFile virtualFile = (VirtualFile)object2;
            if (virtualFile != null) {
                VirtualFile virtualFile2;
                VirtualFile it = virtualFile2 = virtualFile;
                boolean bl = false;
                object = this.base.valueOf((Object)it);
            } else {
                object = null;
            }
            return object;
        }

        @Nullable
        public String getMaxStringValue() {
            return this.base.getMaxStringValue();
        }

        public int getAdditionalWidth() {
            return this.base.getAdditionalWidth();
        }

        @NotNull
        public String getTooltipText() {
            String string = this.base.getTooltipText();
            if (string == null) {
                string = this.columnName;
            }
            return string;
        }

        public ColumnInfoAdapter(@NotNull ColumnInfo<Object, Object> base, @NotNull String columnName) {
            super(columnName);
            this.base = base;
            this.columnName = columnName;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$MyTable;", "Lcom/intellij/ui/treeStructure/treetable/TreeTable;", "tableModel", "Lcom/intellij/ui/treeStructure/treetable/ListTreeTableModelOnColumns;", "(Lcom/intellij/ui/treeStructure/treetable/ListTreeTableModelOnColumns;)V", "calcColumnWidth", "", "maxStringValue", "", "columnInfo", "Lcom/intellij/util/ui/ColumnInfo;", "", "doLayout", "", "updateColumnSizes", "intellij.platform.vcs.impl"})
    private static final class MyTable
    extends TreeTable {
        private final ListTreeTableModelOnColumns tableModel;

        public void doLayout() {
            if (this.getTableHeader().getResizingColumn() == null) {
                this.updateColumnSizes();
            }
            super.doLayout();
        }

        /*
         * WARNING - void declaration
         */
        private final void updateColumnSizes() {
            ColumnInfo[] columnInfoArray = this.tableModel.getColumns();
            int n = columnInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                void index;
                ColumnInfo columnInfo = columnInfoArray[n2];
                TableColumn column = this.columnModel.getColumn((int)index);
                if (columnInfo.getMaxStringValue() != null) {
                    String string;
                    String it = string;
                    boolean bl = false;
                    int width = this.calcColumnWidth(it, (ColumnInfo<Object, Object>)columnInfo);
                    column.setPreferredWidth(width);
                }
                ++index;
            }
            int size = this.getWidth();
            int fileColumn = 0;
            int n3 = 0;
            n = this.tableModel.getColumns().length;
            while (n3 < n) {
                void i;
                if (i != false) {
                    size -= this.columnModel.getColumn((int)i).getPreferredWidth();
                }
                ++i;
            }
            this.columnModel.getColumn(fileColumn).setPreferredWidth(Math.max(size, JBUI.scale((int)200)));
        }

        private final int calcColumnWidth(String maxStringValue, ColumnInfo<Object, Object> columnInfo) {
            String columnName = StringUtil.shortenTextWithEllipsis((String)columnInfo.getName(), (int)15, (int)7, (boolean)true);
            return Math.max(this.getFontMetrics(this.getFont()).stringWidth(maxStringValue), this.getFontMetrics(this.tableHeader.getFont()).stringWidth(columnName)) + columnInfo.getAdditionalWidth();
        }

        public MyTable(@NotNull ListTreeTableModelOnColumns tableModel) {
            super((TreeTableModel)tableModel);
            this.tableModel = tableModel;
            this.getTableHeader().setReorderingAllowed(false);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/vcs/merge/MultipleFileMergeDialog$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

