/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.roots.VcsRootDetector;
import com.intellij.openapi.vcs.roots.VcsRootScanner;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRootDetectorImpl
implements VcsRootDetector {
    private static final Logger LOG = Logger.getInstance(VcsRootDetectorImpl.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectRootManager myProjectManager;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final List<VcsRootChecker> myCheckers;
    @Nullable
    private Collection<VcsRoot> myDetectedRoots;
    @NotNull
    private final Object LOCK = new Object();

    public VcsRootDetectorImpl(@NotNull Project project, @NotNull ProjectRootManager projectRootManager, @NotNull ProjectLevelVcsManager projectLevelVcsManager) {
        this.myProject = project;
        this.myProjectManager = projectRootManager;
        this.myVcsManager = projectLevelVcsManager;
        this.myCheckers = VcsRootChecker.EXTENSION_POINT_NAME.getExtensionList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<VcsRoot> detect() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myDetectedRoots = this.detect(this.myProject.getBaseDir());
            return this.myDetectedRoots;
        }
    }

    @NotNull
    public Collection<VcsRoot> detect(@Nullable VirtualFile startDir) {
        return this.doDetect(startDir);
    }

    @NotNull
    private Collection<VcsRoot> doDetect(@Nullable VirtualFile startDir) {
        VcsRoot rootAbove;
        if (startDir == null || this.myCheckers.size() == 0) {
            return Collections.emptyList();
        }
        Set<VcsRoot> roots = this.scanForRootsInsideDir(startDir);
        if (VcsRootDetectorImpl.shouldScanAbove(startDir, roots) && (rootAbove = this.scanForSingleRootAboveDir(startDir)) != null) {
            roots.add(rootAbove);
        }
        roots.addAll(this.scanForRootsInContentRoots());
        return Collections.unmodifiableSet(roots);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<VcsRoot> getOrDetect() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myDetectedRoots == null) {
                this.detect();
            }
            return this.myDetectedRoots;
        }
    }

    @NotNull
    private Set<VcsRoot> scanForRootsInContentRoots() {
        HashSet<VcsRoot> vcsRoots = new HashSet<VcsRoot>();
        if (this.myProject.isDisposed()) {
            return vcsRoots;
        }
        for (VirtualFile contentRoot : this.myProjectManager.getContentRoots()) {
            VcsRoot rootAbove;
            if (this.myProject.getBaseDir() != null && VfsUtilCore.isAncestor((VirtualFile)this.myProject.getBaseDir(), (VirtualFile)contentRoot, (boolean)false)) continue;
            Set<VcsRoot> vcsRootsInContentRoot = this.scanForRootsInsideDir(contentRoot);
            if (VcsRootDetectorImpl.shouldScanAbove(contentRoot, vcsRootsInContentRoot) && (rootAbove = this.scanForSingleRootAboveDir(contentRoot)) != null) {
                vcsRootsInContentRoot.add(rootAbove);
            }
            vcsRoots.addAll(vcsRootsInContentRoot);
        }
        return vcsRoots;
    }

    private Set<VcsRoot> scanForRootsInsideDir(@NotNull VirtualFile root) {
        HashSet<VcsRoot> roots = new HashSet<VcsRoot>();
        VcsRootScanner.visitDirsRecursivelyWithoutExcluded(this.myProject, this.myProjectManager, root, dir -> {
            if (Registry.is((String)"vcs.root.detector.skip.vendor") && dir.getName().equalsIgnoreCase("vendor")) {
                return VirtualFileVisitor.SKIP_CHILDREN;
            }
            AbstractVcs vcs = this.getVcsFor((VirtualFile)dir);
            if (vcs != null) {
                LOG.debug("Found VCS " + vcs + " in " + dir);
                roots.add(new VcsRoot(vcs, dir));
            }
            return VirtualFileVisitor.CONTINUE;
        });
        return roots;
    }

    private static boolean shouldScanAbove(@NotNull VirtualFile startDir, @NotNull Set<VcsRoot> rootsInsideDir) {
        return rootsInsideDir.stream().noneMatch(it -> startDir.equals(it.getPath()));
    }

    @Nullable
    private VcsRoot scanForSingleRootAboveDir(@NotNull VirtualFile dir) {
        if (this.myProject.isDisposed()) {
            return null;
        }
        ProgressManager.checkCanceled();
        for (VirtualFile par = dir.getParent(); par != null && !par.equals(VfsUtil.getUserHomeDir()); par = par.getParent()) {
            AbstractVcs vcs = this.getVcsFor(par, dir);
            if (vcs == null) continue;
            return new VcsRoot(vcs, par);
        }
        return null;
    }

    @Nullable
    private AbstractVcs getVcsFor(@NotNull VirtualFile dir) {
        return this.getVcsFor(dir, null);
    }

    @Nullable
    private AbstractVcs getVcsFor(@NotNull VirtualFile maybeRoot, @Nullable VirtualFile dirToCheckForIgnore) {
        String path = maybeRoot.getPath();
        for (VcsRootChecker checker : this.myCheckers) {
            if (!checker.isRoot(path) || dirToCheckForIgnore != null && checker.isIgnored(maybeRoot, dirToCheckForIgnore)) continue;
            return this.myVcsManager.findVcsByName(checker.getSupportedVcs().getName());
        }
        return null;
    }
}

