/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.roots.VcsRootProblemNotifier;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Alarm;
import com.intellij.vfs.AsyncVfsEventsListener;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class VcsRootScanner
implements AsyncVfsEventsListener {
    @NotNull
    private final VcsRootProblemNotifier myRootProblemNotifier;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectRootManager myProjectManager;
    @NotNull
    private final List<? extends VcsRootChecker> myCheckers;
    @NotNull
    private final Alarm myAlarm;
    private static final long WAIT_BEFORE_SCAN = TimeUnit.SECONDS.toMillis(1L);

    public static void start(@NotNull Project project, @NotNull List<? extends VcsRootChecker> checkers) {
        new VcsRootScanner(project, checkers).scheduleScan();
    }

    private VcsRootScanner(@NotNull Project project, @NotNull List<? extends VcsRootChecker> checkers) {
        this.myProject = project;
        this.myProjectManager = ProjectRootManager.getInstance((Project)project);
        this.myRootProblemNotifier = VcsRootProblemNotifier.getInstance(project);
        this.myCheckers = checkers;
        AsyncVfsEventsPostProcessor.getInstance().addListener((AsyncVfsEventsListener)this, (Disposable)project);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project);
    }

    public void filesChanged(@NotNull List<? extends VFileEvent> events) {
        for (VFileEvent vFileEvent : events) {
            VirtualFile file2 = vFileEvent.getFile();
            if (file2 == null || !file2.isDirectory()) continue;
            VcsRootScanner.visitDirsRecursivelyWithoutExcluded(this.myProject, this.myProjectManager, file2, dir -> {
                if (this.isVcsDir(dir.getName())) {
                    this.scheduleScan();
                    return VirtualFileVisitor.skipTo((VirtualFile)file2);
                }
                return VirtualFileVisitor.CONTINUE;
            });
        }
    }

    static void visitDirsRecursivelyWithoutExcluded(final @NotNull Project project, @NotNull ProjectRootManager projectRootManager, @NotNull VirtualFile root, final @NotNull Function<? super VirtualFile, ? extends VirtualFileVisitor.Result> dirFound) {
        final ProjectFileIndex fileIndex = projectRootManager.getFileIndex();
        VirtualFileVisitor.Option depthLimit = VirtualFileVisitor.limit((int)Registry.intValue((String)"vcs.root.detector.folder.depth"));
        VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS, depthLimit}){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file2) {
                ProgressManager.checkCanceled();
                if (!file2.isDirectory()) {
                    return CONTINUE;
                }
                VirtualFileVisitor.Result result2 = (VirtualFileVisitor.Result)dirFound.apply(file2);
                if (result2 != CONTINUE) {
                    return result2;
                }
                if (((Boolean)ReadAction.compute(() -> project.isDisposed() || !file2.equals(project.getBaseDir()) && !fileIndex.isInContent(file2))).booleanValue()) {
                    return SKIP_CHILDREN;
                }
                return CONTINUE;
            }
        });
    }

    private boolean isVcsDir(@NotNull String filePath) {
        return this.myCheckers.stream().anyMatch(it -> it.isVcsDir(filePath));
    }

    private void scheduleScan() {
        if (this.myAlarm.isDisposed()) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.myAlarm, () -> this.myRootProblemNotifier.rescanAndNotifyIfNeeded()), WAIT_BEFORE_SCAN);
    }
}

