/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.statistics;

import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.ide.actions.BackAction;
import com.intellij.ide.actions.ForwardAction;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.log.VcsLogDataKeys;
import org.jetbrains.annotations.NotNull;

public class VcsBackForwardUsageTriggerCollector {
    @NotNull
    private static String getContextName(AnActionEvent e) {
        ToolWindowImpl toolWindow = (ToolWindowImpl)ObjectUtils.tryCast((Object)e.getData(PlatformDataKeys.TOOL_WINDOW), ToolWindowImpl.class);
        if (e.getData(VcsLogDataKeys.VCS_LOG) != null) {
            return "vcs.log";
        }
        if (e.getData(ChangesListView.DATA_KEY) != null) {
            return "local.changes";
        }
        if (toolWindow != null && toolWindow.getId().equals("Project")) {
            return "project.view";
        }
        if (e.getData(DiffDataKeys.DIFF_VIEWER) != null) {
            return "diff.viewer";
        }
        if (e.getData(CommonDataKeys.EDITOR) != null) {
            return "editor";
        }
        return "unknown";
    }

    public static class Trigger
    implements ApplicationInitializedListener {
        public void componentsInitialized() {
            ApplicationManager.getApplication().getMessageBus().connect().subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

                public void beforeActionPerformed(@NotNull AnAction action, @NotNull DataContext dataContext, @NotNull AnActionEvent e) {
                    if (action instanceof BackAction || action instanceof ForwardAction) {
                        FUCounterUsageLogger.getInstance().logEvent("vcs.back.forward.trigger", VcsBackForwardUsageTriggerCollector.getContextName(e));
                    }
                }
            });
        }
    }
}

