/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.statistics;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsNamesUsagesCollector
extends ProjectUsagesCollector {
    @Override
    @NotNull
    public String getGroupId() {
        return "vcs.names";
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        return VcsNamesUsagesCollector.getDescriptors(project);
    }

    @NotNull
    public static Set<UsageDescriptor> getDescriptors(@NotNull Project project) {
        HashSet<UsageDescriptor> usages = new HashSet<UsageDescriptor>();
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        Object[] activeVcss = vcsManager.getAllActiveVcss();
        List vcsNames = ContainerUtil.map((Object[])activeVcss, vcs -> {
            PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfo(vcs.getClass());
            if (pluginInfo.isDevelopedByJetBrains()) {
                return vcs.getName();
            }
            if (pluginInfo.isSafeToReport()) {
                return "third.party." + pluginInfo.getId();
            }
            return "third.party.other";
        });
        for (String vcs2 : vcsNames) {
            usages.add(new UsageDescriptor(vcs2, 1));
        }
        return usages;
    }
}

