/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.statistics;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsStatsUsagesCollector
extends ProjectUsagesCollector {
    @Override
    @NotNull
    public String getGroupId() {
        return "vcs.metrics";
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        return VcsStatsUsagesCollector.getDescriptors(project);
    }

    @NotNull
    public static Set<UsageDescriptor> getDescriptors(@NotNull Project project) {
        HashSet<UsageDescriptor> usages = new HashSet<UsageDescriptor>();
        ChangeListManagerImpl clm = ChangeListManagerImpl.getInstanceImpl(project);
        ProjectLevelVcsManagerEx vcsManager = ProjectLevelVcsManagerEx.getInstanceEx(project);
        usages.add(StatisticsUtilKt.getCountingUsage("active.changelists.count", clm.getChangeListsNumber()));
        usages.add(StatisticsUtilKt.getCountingUsage("unversioned.files.count", clm.getUnversionedFiles().size()));
        usages.add(StatisticsUtilKt.getCountingUsage("ignored.files.count", clm.getIgnoredFiles().size()));
        usages.add(StatisticsUtilKt.getCountingUsage("vcs.roots.count", vcsManager.getAllVcsRoots().length));
        usages.add(StatisticsUtilKt.getBooleanUsage("has.default.vcs.root.mapping", vcsManager.haveDefaultMapping() != null));
        return usages;
    }
}

