/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ui;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.impl.FontFallbackIterator;
import com.intellij.util.ui.UIUtil;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import org.jetbrains.annotations.NotNull;

public class FontUtil {
    @NotNull
    public static String getHtmlWithFonts(@NotNull String input) {
        Font font = UIUtil.getLabelFont();
        return FontUtil.getHtmlWithFonts(input, font.getStyle(), font);
    }

    @NotNull
    public static String getHtmlWithFonts(@NotNull String input, int style, @NotNull Font baseFont) {
        int start2 = baseFont.canDisplayUpTo(input);
        if (start2 == -1) {
            return input;
        }
        StringBuilder result2 = new StringBuilder();
        FontFallbackIterator it = new FontFallbackIterator();
        it.setPreferredFont(baseFont.getFamily(), baseFont.getSize());
        it.setFontStyle(style);
        it.start(input, 0, input.length());
        while (!it.atEnd()) {
            boolean insideFallbackBlock;
            Font font = it.getFont();
            boolean bl = insideFallbackBlock = !font.getFamily().equals(baseFont.getFamily());
            if (insideFallbackBlock) {
                result2.append("<font face=\"").append(font.getFamily()).append("\">");
            }
            result2.append(input, it.getStart(), it.getEnd());
            if (insideFallbackBlock) {
                result2.append("</font>");
            }
            it.advance();
        }
        return result2.toString();
    }

    @NotNull
    public static Font getEditorFont() {
        return EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN);
    }

    @NotNull
    public static Font getCommitMessageFont() {
        return FontUtil.getEditorFont();
    }

    public static Font getCommitMetadataFont() {
        return UIUtil.getLabelFont();
    }

    public static int getStandardAscent(@NotNull Font font, @NotNull Graphics g) {
        FontRenderContext context = ((Graphics2D)g).getFontRenderContext();
        char[] chars = new char[]{'G', 'l', 'd', 'h', 'f'};
        double y = font.layoutGlyphVector(context, chars, 0, chars.length, 0).getVisualBounds().getY();
        return Math.toIntExact(Math.round(Math.ceil(-y)));
    }
}

