/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.update.FileOrDirectoryTreeNode;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTreeNode
extends FileOrDirectoryTreeNode {
    private static final Collection<VirtualFile> EMPTY_VIRTUAL_FILE_ARRAY = new ArrayList<VirtualFile>();

    public FileTreeNode(@NotNull String path, @NotNull SimpleTextAttributes invalidAttributes, @NotNull Project project, String parentPath) {
        super(path, invalidAttributes, project, parentPath);
    }

    @Override
    public Icon getIcon(boolean expanded) {
        if (this.myFile.isDirectory()) {
            return PlatformIcons.FOLDER_ICON;
        }
        return FileTypeManager.getInstance().getFileTypeByFileName(this.myFile.getName()).getIcon();
    }

    @Override
    protected boolean acceptFilter(@Nullable Pair<PackageSetBase, NamedScopesHolder> filter, boolean showOnlyFilteredItems) {
        try {
            VirtualFilePointer filePointer = this.getFilePointer();
            if (!filePointer.isValid()) {
                return false;
            }
            VirtualFile file2 = filePointer.getFile();
            if (file2 != null && file2.isValid() && filter != null && ((PackageSetBase)filter.first).contains(file2, this.getProject(), (NamedScopesHolder)filter.second)) {
                this.applyFilter(true);
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getVirtualFiles() {
        VirtualFile virtualFile = this.getFilePointer().getFile();
        if (virtualFile == null) {
            return EMPTY_VIRTUAL_FILE_ARRAY;
        }
        return Collections.singleton(virtualFile);
    }

    @Override
    @NotNull
    public Collection<File> getFiles() {
        if (this.getFilePointer().getFile() == null) {
            return Collections.singleton(this.myFile);
        }
        return EMPTY_FILE_ARRAY;
    }

    @Override
    protected int getItemsCount() {
        return 1;
    }

    @Override
    protected boolean showStatistics() {
        return false;
    }
}

