/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.update.UpdateFilesHelper;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefreshVFsSynchronously {
    private static final Logger LOG = Logger.getInstance(RefreshVFsSynchronously.class);

    private RefreshVFsSynchronously() {
    }

    public static void updateAllChanged(@NotNull UpdatedFiles updatedFiles) {
        FilesToRefreshCollector callback2 = new FilesToRefreshCollector();
        UpdateFilesHelper.iterateFileGroupFilesDeletedOnServerFirst(updatedFiles, callback2);
        RefreshVFsSynchronously.refreshDeletedOrReplaced(callback2.getToRefreshDeletedOrReplaced());
        RefreshVFsSynchronously.refreshFiles(callback2.getToRefresh());
    }

    public static void refreshFiles(@NotNull Collection<? extends File> files2) {
        HashSet filesToRefresh = ContainerUtil.newHashSet();
        for (File file2 : files2) {
            VirtualFile vf = RefreshVFsSynchronously.findFirstValidVirtualParent(file2);
            if (vf == null) continue;
            filesToRefresh.add(vf);
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])filesToRefresh.toArray(VirtualFile.EMPTY_ARRAY));
    }

    private static void refreshDeletedOrReplaced(@NotNull Collection<? extends File> deletedOrReplaced) {
        HashSet filesToRefresh = ContainerUtil.newHashSet();
        for (File file2 : deletedOrReplaced) {
            File parent = file2.getParentFile();
            VirtualFile vf = RefreshVFsSynchronously.findFirstValidVirtualParent(parent);
            if (vf == null) continue;
            filesToRefresh.add(vf);
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])filesToRefresh.toArray(VirtualFile.EMPTY_ARRAY));
    }

    @Nullable
    private static VirtualFile findFirstValidVirtualParent(@Nullable File file2) {
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile vf = null;
        while (!(file2 == null || vf != null && vf.isValid())) {
            vf = lfs.findFileByIoFile(file2);
            file2 = file2.getParentFile();
        }
        return vf == null || !vf.isValid() ? null : vf;
    }

    public static void updateChangesForRollback(List<? extends Change> changes2) {
        RefreshVFsSynchronously.updateChangesImpl(changes2, RollbackChangeWrapper.ourInstance);
    }

    public static void updateChanges(Collection<? extends Change> changes2) {
        RefreshVFsSynchronously.updateChangesImpl(changes2, DirectChangeWrapper.ourInstance);
    }

    private static void updateChangesImpl(Collection<? extends Change> changes2, ChangeWrapper wrapper2) {
        HashSet deletedOrReplaced = ContainerUtil.newHashSet();
        HashSet toRefresh = ContainerUtil.newHashSet();
        for (Change change : changes2) {
            if (!wrapper2.beforeNull(change) && (wrapper2.movedOrRenamedOrReplaced(change) || wrapper2.afterNull(change))) {
                deletedOrReplaced.add(wrapper2.getBeforeFile(change));
            } else if (!wrapper2.beforeNull(change)) {
                toRefresh.add(wrapper2.getBeforeFile(change));
            }
            if (wrapper2.afterNull(change) || !wrapper2.beforeNull(change) && Comparing.equal((Object)change.getAfterRevision().getFile(), (Object)change.getBeforeRevision().getFile())) continue;
            toRefresh.add(wrapper2.getAfterFile(change));
        }
        RefreshVFsSynchronously.refreshFiles(toRefresh);
        RefreshVFsSynchronously.refreshDeletedOrReplaced(deletedOrReplaced);
    }

    private static class FilesToRefreshCollector
    implements UpdateFilesHelper.Callback {
        private final Collection<File> myToRefresh = new THashSet();
        private final Collection<File> myToRefreshDeletedOrReplaced = new THashSet();

        private FilesToRefreshCollector() {
        }

        @Override
        public void onFile(String filePath, String groupId) {
            File file2 = new File(filePath);
            if ("REMOVED_FROM_REPOSITORY".equals(groupId) || "MERGED_WITH_TREE_CONFLICT".endsWith(groupId)) {
                this.myToRefreshDeletedOrReplaced.add(file2);
            } else {
                this.myToRefresh.add(file2);
            }
        }

        @NotNull
        public Collection<File> getToRefresh() {
            return this.myToRefresh;
        }

        @NotNull
        public Collection<File> getToRefreshDeletedOrReplaced() {
            return this.myToRefreshDeletedOrReplaced;
        }
    }

    private static interface ChangeWrapper {
        public boolean beforeNull(Change var1);

        public boolean afterNull(Change var1);

        @Nullable
        public File getBeforeFile(Change var1);

        @Nullable
        public File getAfterFile(Change var1);

        public boolean movedOrRenamedOrReplaced(Change var1);
    }

    private static class DirectChangeWrapper
    implements ChangeWrapper {
        private static final DirectChangeWrapper ourInstance = new DirectChangeWrapper();

        private DirectChangeWrapper() {
        }

        @Override
        public boolean beforeNull(Change change) {
            return change.getBeforeRevision() == null;
        }

        @Override
        public boolean afterNull(Change change) {
            return change.getAfterRevision() == null;
        }

        @Override
        @Nullable
        public File getBeforeFile(Change change) {
            return this.beforeNull(change) ? null : change.getBeforeRevision().getFile().getIOFile();
        }

        @Override
        @Nullable
        public File getAfterFile(Change change) {
            return this.afterNull(change) ? null : change.getAfterRevision().getFile().getIOFile();
        }

        @Override
        public boolean movedOrRenamedOrReplaced(Change change) {
            return change.isMoved() || change.isRenamed() || change.isIsReplaced();
        }
    }

    private static class RollbackChangeWrapper
    implements ChangeWrapper {
        private static final RollbackChangeWrapper ourInstance = new RollbackChangeWrapper();

        private RollbackChangeWrapper() {
        }

        @Override
        public boolean beforeNull(Change change) {
            return change.getAfterRevision() == null;
        }

        @Override
        public boolean afterNull(Change change) {
            return change.getBeforeRevision() == null;
        }

        @Override
        public File getBeforeFile(Change change) {
            return this.beforeNull(change) ? null : change.getAfterRevision().getFile().getIOFile();
        }

        @Override
        public File getAfterFile(Change change) {
            return this.afterNull(change) ? null : change.getBeforeRevision().getFile().getIOFile();
        }

        @Override
        public boolean movedOrRenamedOrReplaced(Change change) {
            return change.isMoved() || change.isRenamed() || change.isIsReplaced();
        }
    }
}

