/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectReloadState;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.UpdateInfo;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="RestoreUpdateTree", storages={@Storage(value="$CACHE_FILE$"), @Storage(value="$WORKSPACE_FILE$", deprecated=true)})
public class RestoreUpdateTree
implements PersistentStateComponent<Element> {
    private UpdateInfo myUpdateInfo;

    public RestoreUpdateTree(@NotNull Project project, @NotNull StartupManager startupManager) {
        startupManager.registerPostStartupActivity((Runnable)((DumbAwareRunnable)() -> {
            ActionInfo actionInfo;
            if (this.myUpdateInfo != null && !this.myUpdateInfo.isEmpty() && ProjectReloadState.getInstance((Project)project).isAfterAutomaticReload() && (actionInfo = this.myUpdateInfo.getActionInfo()) != null) {
                ProjectLevelVcsManagerEx.getInstanceEx(project).showUpdateProjectInfo(this.myUpdateInfo.getFileInformation(), VcsBundle.message((String)"action.display.name.update", (Object[])new Object[0]), actionInfo, false);
                CommittedChangesCache.getInstance(project).refreshIncomingChangesAsync();
            }
            this.myUpdateInfo = null;
        }));
    }

    public static RestoreUpdateTree getInstance(Project project) {
        return (RestoreUpdateTree)project.getComponent(RestoreUpdateTree.class);
    }

    @Nullable
    public Element getState() {
        Element element = new Element("state");
        if (this.myUpdateInfo != null && !this.myUpdateInfo.isEmpty()) {
            this.myUpdateInfo.writeExternal(element);
        }
        return element;
    }

    public void loadState(@NotNull Element state) {
        UpdateInfo updateInfo = new UpdateInfo();
        updateInfo.readExternal(state);
        this.myUpdateInfo = updateInfo.isEmpty() ? null : updateInfo;
    }

    public void registerUpdateInformation(UpdatedFiles updatedFiles, ActionInfo actionInfo) {
        this.myUpdateInfo = new UpdateInfo(updatedFiles, actionInfo);
    }
}

