/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.VirtualFileManagerImpl;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.util.messages.MessageBus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformVirtualFileManager
extends VirtualFileManagerImpl {
    @NotNull
    private final ManagingFS myManagingFS;

    public PlatformVirtualFileManager(@NotNull VirtualFileSystem[] fileSystems, @NotNull MessageBus bus, @NotNull ManagingFS managingFS) {
        super(fileSystems, bus);
        this.myManagingFS = managingFS;
    }

    @Override
    protected long doRefresh(boolean asynchronous, @Nullable Runnable postAction) {
        if (!asynchronous) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        RefreshSession session2 = RefreshQueue.getInstance().createSession(asynchronous, true, postAction);
        session2.addAllFiles(this.myManagingFS.getRoots());
        session2.launch();
        super.doRefresh(asynchronous, postAction);
        return session2.getId();
    }

    @Override
    public long getModificationCount() {
        return this.myManagingFS.getModificationCount();
    }

    @Override
    public long getStructureModificationCount() {
        return this.myManagingFS.getStructureModificationCount();
    }

    public VirtualFile findFileById(int id) {
        return this.myManagingFS.findFileById(id);
    }
}

