/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.AppTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EncodingUtil {
    @NotNull
    static Magic8 isSafeToReloadIn(@NotNull VirtualFile virtualFile, @NotNull CharSequence text, @NotNull byte[] bytes, @NotNull Charset charset) {
        byte[] bytesToSave;
        byte[] bom = virtualFile.getBOM();
        if (bom != null && !CharsetToolkit.canHaveBom((Charset)charset, (byte[])bom)) {
            return Magic8.NO_WAY;
        }
        byte[] mandatoryBom = CharsetToolkit.getMandatoryBom((Charset)charset);
        if (mandatoryBom != null && !ArrayUtil.startsWith((byte[])bytes, (byte[])mandatoryBom)) {
            return Magic8.NO_WAY;
        }
        String loaded = LoadTextUtil.getTextByBinaryPresentation(bytes, charset).toString();
        String separator = FileDocumentManager.getInstance().getLineSeparator(virtualFile, null);
        String toSave = StringUtil.convertLineSeparators((String)loaded, (String)separator);
        LoadTextUtil.AutoDetectionReason failReason = LoadTextUtil.getCharsetAutoDetectionReason(virtualFile);
        if (failReason != null && CharsetToolkit.UTF8_CHARSET.equals(virtualFile.getCharset()) && !CharsetToolkit.UTF8_CHARSET.equals(charset)) {
            return Magic8.NO_WAY;
        }
        try {
            bytesToSave = toSave.getBytes(charset);
        }
        catch (NullPointerException | UnsupportedOperationException e) {
            return Magic8.NO_WAY;
        }
        if (bom != null && !ArrayUtil.startsWith((byte[])bytesToSave, (byte[])bom)) {
            bytesToSave = ArrayUtil.mergeArrays((byte[])bom, (byte[])bytesToSave);
        }
        return !Arrays.equals(bytesToSave, bytes) ? Magic8.NO_WAY : (StringUtil.equals((CharSequence)loaded, (CharSequence)text) ? Magic8.ABSOLUTELY : Magic8.WELL_IF_YOU_INSIST);
    }

    @NotNull
    static Magic8 isSafeToConvertTo(@NotNull VirtualFile virtualFile, @NotNull CharSequence text, @NotNull byte[] bytesOnDisk, @NotNull Charset charset) {
        try {
            String lineSeparator = FileDocumentManager.getInstance().getLineSeparator(virtualFile, null);
            CharSequence textToSave = lineSeparator.equals("\n") ? text : StringUtilRt.convertLineSeparators((CharSequence)text, (String)lineSeparator);
            Pair.NonNull<Charset, byte[]> chosen = LoadTextUtil.chooseMostlyHarmlessCharset(virtualFile.getCharset(), charset, textToSave.toString());
            byte[] saved = (byte[])chosen.second;
            CharSequence textLoadedBack = LoadTextUtil.getTextByBinaryPresentation(saved, charset);
            return !StringUtil.equals((CharSequence)text, (CharSequence)textLoadedBack) ? Magic8.NO_WAY : (Arrays.equals(saved, bytesOnDisk) ? Magic8.ABSOLUTELY : Magic8.WELL_IF_YOU_INSIST);
        }
        catch (UnsupportedOperationException e) {
            return Magic8.NO_WAY;
        }
    }

    static void saveIn(@NotNull Document document, Editor editor, @NotNull VirtualFile virtualFile, @NotNull Charset charset) {
        boolean writable;
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        documentManager.saveDocument(document);
        Project project = ProjectLocator.getInstance().guessProjectForFile(virtualFile);
        boolean bl = writable = project == null ? virtualFile.isWritable() : ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{virtualFile});
        if (!writable) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)("Cannot save the file " + virtualFile.getPresentableUrl()), (String)"Unable to Save", null);
            return;
        }
        EncodingProjectManagerImpl.suppressReloadDuring(() -> {
            EncodingManager.getInstance().setEncoding(virtualFile, charset);
            try {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    virtualFile.setCharset(charset);
                    LoadTextUtil.write(project, virtualFile, virtualFile, document.getText(), document.getModificationStamp());
                    return null;
                });
            }
            catch (IOException io) {
                Messages.showErrorDialog((Project)project, (String)io.getMessage(), (String)"Error Writing File");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reloadIn(final @NotNull VirtualFile virtualFile, @NotNull Charset charset, Project project) {
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        final Consumer<VirtualFile> setEncoding = file2 -> {
            if (project == null) {
                EncodingManager.getInstance().setEncoding(file2, charset);
            } else {
                EncodingProjectManager.getInstance((Project)project).setEncoding(file2, charset);
            }
        };
        if (documentManager.getCachedDocument(virtualFile) == null) {
            setEncoding.accept(virtualFile);
            return;
        }
        final Disposable disposable = Disposer.newDisposable();
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(disposable);
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerListener(){

            public void beforeFileContentReload(@NotNull VirtualFile file2, @NotNull Document document) {
                if (!file2.equals(virtualFile)) {
                    return;
                }
                Disposer.dispose((Disposable)disposable);
                setEncoding.accept(file2);
                LoadTextUtil.clearCharsetAutoDetectionReason(file2);
            }
        });
        try {
            EncodingProjectManagerImpl.suppressReloadDuring(() -> ((VirtualFileListener)documentManager).contentsChanged(new VirtualFileEvent(null, virtualFile, virtualFile.getName(), virtualFile.getParent())));
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
    }

    private static String checkHardcodedCharsetFileType(@NotNull VirtualFile virtualFile) {
        FileType fileType = virtualFile.getFileType();
        if (fileType == FileTypes.PLAIN_TEXT) {
            return null;
        }
        if (fileType == StdFileTypes.GUI_DESIGNER_FORM) {
            return "IDEA GUI Designer form";
        }
        if (fileType == StdFileTypes.IDEA_MODULE) {
            return "IDEA module file";
        }
        if (fileType == StdFileTypes.IDEA_PROJECT) {
            return "IDEA project file";
        }
        if (fileType == StdFileTypes.IDEA_WORKSPACE) {
            return "IDEA workspace file";
        }
        if (fileType == StdFileTypes.PROPERTIES) {
            return ".properties file\n(see Settings|Editor|File Encodings|Properties Files)";
        }
        if (fileType == StdFileTypes.XML) {
            return "XML file";
        }
        if (fileType == StdFileTypes.JSPX) {
            return "JSPX file";
        }
        return null;
    }

    public static boolean canReload(@NotNull VirtualFile virtualFile) {
        return EncodingUtil.checkCanReload(virtualFile, null) == null;
    }

    @Nullable
    static FailReason checkCanReload(@NotNull VirtualFile virtualFile, @Nullable Ref<? super Charset> current) {
        FailReason result2;
        if (virtualFile.isDirectory()) {
            return FailReason.IS_DIRECTORY;
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(virtualFile);
        if (document == null) {
            return FailReason.IS_BINARY;
        }
        Charset charsetFromContent = ((EncodingManagerImpl)EncodingManager.getInstance()).computeCharsetFromContent(virtualFile);
        Charset existing = virtualFile.getCharset();
        LoadTextUtil.AutoDetectionReason autoDetectedFrom = LoadTextUtil.getCharsetAutoDetectionReason(virtualFile);
        if (autoDetectedFrom != null) {
            result2 = autoDetectedFrom == LoadTextUtil.AutoDetectionReason.FROM_BOM ? FailReason.BY_BOM : FailReason.BY_BYTES;
        } else if (charsetFromContent != null) {
            result2 = FailReason.BY_FILE;
            existing = charsetFromContent;
        } else {
            result2 = EncodingUtil.fileTypeDescriptionError(virtualFile);
        }
        if (current != null) {
            current.set((Object)existing);
        }
        return result2;
    }

    @Nullable
    private static FailReason fileTypeDescriptionError(@NotNull VirtualFile virtualFile) {
        if (virtualFile.getFileType().isBinary()) {
            return FailReason.IS_BINARY;
        }
        String fileTypeDescription = EncodingUtil.checkHardcodedCharsetFileType(virtualFile);
        return fileTypeDescription == null ? null : FailReason.BY_FILETYPE;
    }

    @Nullable(value="null means enabled, notnull means disabled and contains error message")
    static FailReason checkCanConvert(@NotNull VirtualFile virtualFile) {
        if (virtualFile.isDirectory()) {
            return FailReason.IS_DIRECTORY;
        }
        Charset charsetFromContent = ((EncodingManagerImpl)EncodingManager.getInstance()).computeCharsetFromContent(virtualFile);
        return charsetFromContent != null ? FailReason.BY_FILE : EncodingUtil.fileTypeDescriptionError(virtualFile);
    }

    @Nullable
    static FailReason checkCanConvertAndReload(@NotNull VirtualFile selectedFile) {
        FailReason result2 = EncodingUtil.checkCanConvert(selectedFile);
        if (result2 == null) {
            return null;
        }
        return EncodingUtil.checkCanReload(selectedFile, null);
    }

    @Nullable
    public static Pair<Charset, String> getCharsetAndTheReasonTooltip(@NotNull VirtualFile file2) {
        FailReason r1 = EncodingUtil.checkCanConvert(file2);
        if (r1 == null) {
            return null;
        }
        Ref current = Ref.create();
        FailReason r2 = EncodingUtil.checkCanReload(file2, (Ref<? super Charset>)current);
        if (r2 == null) {
            return null;
        }
        String errorDescription = r1 == r2 ? EncodingUtil.reasonToString(r1, file2) : EncodingUtil.reasonToString(r1, file2) + ", " + EncodingUtil.reasonToString(r2, file2);
        return Pair.create((Object)current.get(), (Object)errorDescription);
    }

    static String reasonToString(@NotNull FailReason reason, VirtualFile file2) {
        switch (reason) {
            case IS_DIRECTORY: {
                return "disabled for a directory";
            }
            case IS_BINARY: {
                return "disabled for a binary file";
            }
            case BY_FILE: {
                return "charset is hard-coded in the file";
            }
            case BY_BOM: {
                return "charset is auto-detected by BOM";
            }
            case BY_BYTES: {
                return "charset is auto-detected from content";
            }
            case BY_FILETYPE: {
                return "disabled for " + file2.getFileType().getDescription();
            }
        }
        throw new AssertionError((Object)reason);
    }

    public static enum Magic8 {
        ABSOLUTELY,
        WELL_IF_YOU_INSIST,
        NO_WAY;

    }

    static enum FailReason {
        IS_DIRECTORY,
        IS_BINARY,
        BY_FILE,
        BY_BOM,
        BY_BYTES,
        BY_FILETYPE;

    }
}

